<?php
/**
* Plugin Name: Software License Lite for WooCommerce
* Plugin URI: https://wpsoftwarelicense.com/
* Description: Software License Lite for WooCommerce helps with license keys management, autoupdates and code protection
* Author: Nsp Code
* Author URI: https://nsp-code.com/
* Version: 1.2.5
* Text Domain: software-license-lite
* License: GPLv2 or later
* Domain Path: /languages/
* WC requires at least: 3.0.0
* WC tested up to: 10.5.2
* Requires PHP: 8.0
* Requires at least: 3.0
* Tested up to: 6.9
* Requires Plugins: woocommerce
*/

    defined( 'ABSPATH' ) || exit;

    define('SOLIW_PATH',   plugin_dir_path(__FILE__));
    define('SOLIW_URL',    plugins_url('', __FILE__));
    
    define('SOLIW_VERSION',   '1.2.5');
    define('SOLIW_DB_VERSION',   '1.1');
    
    define('SOLIW_PRODUCT_ID',          'woosl');
    define('SOLIW_INSTANCE',            str_replace(array ("https://" , "http://"), "", trim(network_site_url(), '/')));
    define('SOLIW_UPDATE_API_URL',      'https://api.wpsoftwarelicense.com/index.php');
            
    if ( ! SOLIW_is_woocommerce_active() || version_compare( get_option( 'woocommerce_db_version' ), '2.1', '<' ) ) 
        {
            add_action('admin_notices', 'SOLIW_admin_inactive_notice');
            return;
        }
        
    function SOLIW_admin_inactive_notice() 
        {
            $wc_url = 'http://www.woothemes.com/woocommerce/';
            printf('<div class="updated"><p>' . esc_html__( 'Software License requires', 'software-license-lite' ) .' <a href="%s">WooCommerce</a> '. esc_html__( 'to be installed', 'software-license-lite' ) .'</p></div>', esc_html ( $wc_url ) );
        }
        
    function SOLIW_is_woocommerce_active()
        {
            $active_plugins = (array) get_option( 'active_plugins', array() );

            if ( is_multisite() )
                $active_plugins = array_merge( $active_plugins, get_site_option( 'active_sitewide_plugins', array() ) );    
            
            return in_array( 'woocommerce/woocommerce.php', $active_plugins ) || array_key_exists( 'woocommerce/woocommerce.php', $active_plugins );
        }
   
    //load language files
    add_action( 'plugins_loaded', 'SOLIW_load_textdomain', 99); 
    function SOLIW_load_textdomain() 
        {
            $locale             =   get_locale();
            $plugin_textdomain  =   'software-license-lite';

            // Check if the specific translation file exists
            if (file_exists( SOLIW_PATH . "/languages/$plugin_textdomain-$locale.mo")) {
                load_textdomain( $plugin_textdomain, SOLIW_PATH . "/languages/$plugin_textdomain-$locale.mo" );
            } else {
                $general_locale = substr($locale, 0, 2);
                $general_mofile = SOLIW_PATH . "/languages/$plugin_textdomain-$general_locale.mo";
                
                if (file_exists($general_mofile))
                    load_textdomain( $plugin_textdomain, $general_mofile );
            }
        }
        
    //load API
    add_action( 'woocommerce_after_register_post_type', 'SOLIW_load_API', 99); 
    function SOLIW_load_API() 
        {            
            global $SOLIW_API;
            $SOLIW_API    =   WooSLApiFactory::createApiInstance();
        }

    include(SOLIW_PATH . '/include/class.sl.functions.php');
    include(SOLIW_PATH . '/include/class.sl.php');
    include(SOLIW_PATH . '/api/class.sl.api-loader.php');
             
    register_deactivation_hook(__FILE__, 'SOLIW_deactivated');
    register_activation_hook(__FILE__, 'SOLIW_activated');
    
    function SOLIW_activated() 
        {
            $SOLIW_functions = new SOLIW_functions(); 
            $SOLIW_functions->create_tables();
            $SOLIW_functions->add_rewrite_entries();            
        }

    function SOLIW_deactivated() 
        {
            
        }
    
    if ( ! function_exists ( 'is_plugin_active' ) )
        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

    if ( is_plugin_active( 'wp-meteor/wp-meteor.php' ) )
        include_once( dirname(__FILE__) . '/compatibility/wp-meteor.php' );
    if ( is_plugin_active( 'woocommerce-give-products/woocommerce-give-products.php' ) )
        include_once( dirname(__FILE__) . '/compatibility/woocommerce-give-products.php' );
    
    $GLOBALS['SOLIW']    =   new SOLIW();
             
    if( is_admin() )
            {
                
                if(defined('DOING_AJAX'))
                    {
                        //AJAX calls 
                        include(SOLIW_PATH . '/include/class.sl.ajax.php');
                        
                        //front side   
                        include(SOLIW_PATH . '/include/class.sl.front.php');
                    }
                
                //trigger on update
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended 
                if ( !isset($_GET['action']) ||  (isset($_GET['action'])  &&  $_GET['action'] !=  'activate'))
                    {
                        include(SOLIW_PATH . '/include/class.sl.on-update.php');
                        new SOLIW_on_update();
                    }
                
                //admin
                include(SOLIW_PATH . '/include/class.admin.php');
                include(SOLIW_PATH . '/include/class.sl.admin.product.php');
                include(SOLIW_PATH . '/include/class.sl.admin.order.php');
                new SOLIW_admin();   
            }
        else
        {
            //front side   
            include(SOLIW_PATH . '/include/class.sl.front.php');
            
        }
    
    
    add_action( 'before_woocommerce_init', function() {
        if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
        }
    } );