


    jQuery(document).ready(function()
        {
            sl_tab_visibility_change();
            
            jQuery( document ).on( 'change', 'input#_sl_enabled', function() {
                sl_tab_visibility_change();
            }).trigger( 'change' );

            /* Searchable pull-down menus */
            jQuery( 'select.wc_sl_chosen' ).select2({
                allow_single_deselect: true,
                width: '60%'
            });

            // Tooltips
            jQuery( '.tips, .help_tip' ).tipTip({
                attribute : 'data-tip',
                fadeIn : 50,
                fadeOut : 50,
                delay : 200
            });
            
            
            jQuery('#soliw_keys_menu').on('click', 'a', function(){
                
                    if  ( jQuery(this).attr('id')   ==  'add_license_group_type' )
                        return false;
                    
                    jQuery('#soliw_keys_menu a').removeClass('nav-tab-active');
                    var el_index    =   jQuery('#soliw_keys_menu a').index( this );
                    jQuery('#soliw_keys_menu a').eq(el_index).addClass('nav-tab-active');
                    jQuery('#soliw_keys_root .soliw_keys_box').hide().eq(  el_index  ).show();
                })
                
            jQuery('#add_license_group_type').click(function(){
                    jQuery('#soliw_keys_root .soliw_keys_groups .soliw_keys_box').hide();
                    var html   =   jQuery('#soliw_group_root').html();
                    jQuery('#soliw_keys_root .soliw_keys_groups').append(html);
                    jQuery('#soliw_keys_root .soliw_keys_groups').last().show();
                    
                    jQuery('#soliw_keys_menu a').removeClass('nav-tab-active');
                    jQuery('#soliw_keys_menu a#add_license_group_type').before('<a href="javascript: void(0);" class="nav-tab nav-tab-active"></a>')
                })
                
            jQuery('#soliw_keys_root').on('click', 'button', function(){
                    var group_index =   jQuery('#soliw_keys_root .soliw_keys_groups .soliw_keys_box').index ( jQuery(this).closest('.soliw_keys_box') );
                    jQuery(this).closest('.soliw_keys_box').remove();
                    jQuery('#soliw_keys_menu a').eq( group_index ).remove();
                    
                    //go to previous
                    var previous_index  =   ( group_index - 1 ) >= 0 ?  group_index - 1 :   0;  
                    jQuery('#soliw_keys_menu a').eq( previous_index ).addClass('nav-tab-active');
                    jQuery('#soliw_keys_root .soliw_keys_groups .soliw_keys_box').eq( previous_index ).show();
                    
                })
                
            jQuery("#soliw_keys_root").on("keyup", "#_sl_group_title", function() {
                var group_index =   jQuery('#soliw_keys_root .soliw_keys_groups .soliw_keys_box').index ( jQuery(this).closest('.soliw_keys_box') );
                jQuery('#soliw_keys_menu a').eq( group_index ).html( jQuery(this).val() ); 
            });
            jQuery("body").on("change", ".sl_use_predefined_keys", function() {
                sl_predefined_keys_toggle(jQuery(this));
            });
            jQuery("body").on("change", ".sl_use_expire", function() {
                sl_use_expire_toggle(jQuery(this));
            });
            
            jQuery('#soliw_keys_root').find('select.sl_use_predefined_keys').each(function() {
                        sl_predefined_keys_toggle(jQuery(this));        
                    })            
            
            soliw_flatpickr_init();
 
    });
    
    function sl_tab_visibility_change()
        {
            jQuery( '.show_if_sl' ).hide();

            if ( jQuery( '#_sl_enabled' ).is( ':checked' ) ) {
                jQuery( '.show_if_sl' ).show();
            } else {
                if ( jQuery( '.sl_tab' ).is( '.active' ) ) {
                    jQuery( 'ul.tabs li:visible' ).eq(0).find( 'a' ).click();
                }
            }   
        }
    
    function sl_predefined_keys_toggle(element)
        {
            var el_value    =   jQuery(element).val();
                
            var el_box_wrapper  =   jQuery(element).closest('.soliw_keys_box');
            if(el_value ==  'yes')
                {
                    jQuery(el_box_wrapper).find('.form-field._sl_licence_generate').slideUp();
                    jQuery(el_box_wrapper).find('.form-field._sl_licence_predefined').slideDown();
                }
                else
                {
                    jQuery(el_box_wrapper).find('.form-field._sl_licence_generate').slideDown();
                    jQuery(el_box_wrapper).find('.form-field._sl_licence_predefined').slideUp();
                }   
            
        }
        
    function sl_use_expire_toggle( element )
        {
      
        }
        
        
    function soliw_flatpickr_init()
        {
            var fp_items = document.querySelectorAll(".flatpickr");

            var configs = {
                datetime: {
                    enableTime: true,
                    dateFormat: "Y-m-d H:i",
                    minuteIncrement :   1
                }
            }

            for (var i = 0; i < fp_items.length; i++) {
                flatpickr(fp_items[i], configs[fp_items[i].getAttribute("data-id")] || {});
            }
        }
    