<?php

    defined( 'ABSPATH' ) || exit;    
    
    if ( ! function_exists( 'woocommerce_order_again_button' ) ) 
        {

            /**
             * Display an 'order again' button on the view order page.
             *
             * @param object $order Order.
             */
            function woocommerce_order_again_button( $order ) {
                
                $order_products =   $order->get_items();
                
                $found_extend   =   FALSE;
                foreach ( $order_products as $key   =>  $order_product ) 
                    {
                        $_soliw_extend     =   wc_get_order_item_meta($key, '_woo_sl_extend', TRUE);
                        if  ( ! empty ($_soliw_extend ) )
                            $found_extend   =   TRUE;
                    }

                
                if ( $found_extend  ||  ! $order || ! $order->has_status( apply_filters( 'woocommerce_valid_order_statuses_for_order_again', array( 'completed' ) ) ) || ! is_user_logged_in() ) {
                    return;
                }

                wc_get_template( 'order/order-again.php', array(
                    'order' => $order,
                    'order_again_url' => wp_nonce_url( add_query_arg( 'order_again', $order->get_id(), wc_get_cart_url() ), 'woocommerce-order_again' ),
                ) );
            }
        }
        
?>