<?php

    defined( 'ABSPATH' ) || exit;

    if ( ! class_exists( 'SOLIW_Email_Customer_Licence_Expire' ) ) :

    /**
     * Customer Licence Expire Email.
     *
     * Customer note emails are sent when you add a note to an order.
     *
     * @class       WC_Email_Customer_Licence_Expire
     * @version     2.3.0
     * @package     WooCommerce/Classes/Emails
     * @author      WooThemes
     * @extends     WC_Email
     */
    class SOLIW_Email_Customer_Licence_Expire extends WC_Email {

        public static $_template_html   =   'emails/licence-expire.php';
        
        public static $_template_plain  =   'emails/plain/licence-expire.php';
        
	    /**
	     * Customer note.
	     *
	     * @var string
	     */

	    /**
	     * Constructor.
	     */
	    public function __construct() 
            {

		        $this->id             = 'licence_expire';
		        $this->customer_email = true;
		        $this->title          = __( 'Licence about to expire', 'software-license-lite' );
		        $this->description    = __( 'Licence expire emails are sent before licence expiration.', 'software-license-lite' );

                $this->template_html  =     self::$_template_html;
                $this->template_plain =     self::$_template_plain;
                
		        $this->subject        = __( 'Your Licence is about to expire', 'software-license-lite');
		        $this->heading        = __( 'Licence is about to expire', 'software-license-lite');

		        // Triggers
		        add_action( 'woocommerce_licence_pre_expire_notification', array( $this, 'trigger' ) );

		        // Call parent constructor
		        parent::__construct();
	        }
        
        static function get_templates()
            {
                
                return array(
                                self::$_template_html,
                                self::$_template_plain,
                                );    
                
            }

	    /**
	     * Trigger.
	     *
	     * @param array $args
	     */
	    public function trigger( $args ) 
            {
                            
		        if ( ! empty( $args ) ) 
                    {

			            $defaults = array(
				            'order_item_id'         =>  '',
                            'expire_days'           =>  ''
			            );

			            $args = wp_parse_args( $args, $defaults );

			            extract( $args );
                        
                        $this->order_item_id    =   $order_item_id;
                        $this->expire_days      =   $expire_days;
                         
                        $order_id              =   SOLIW_functions::get_order_by_item_id( $this->order_item_id );

			            if ( $order_id && ( $this->order = wc_get_order( $order_id ) ) ) 
                            {
				                $this->recipient               = $this->order->get_billing_email();

				                $this->find['order-date']      = '{order_date}';
				                $this->find['order-number']    = '{order_number}';

				                $this->replace['order-date']   = date_i18n( wc_date_format(), strtotime( $this->order->get_date_created() ) );
				                $this->replace['order-number'] = $this->order->get_order_number();
                                
                                $order_items                   =   $this->order->get_items(); 
                                $this->order_item     =   $order_items[ $this->order_item_id ];
                                
                                $this->extend_link  =   $GLOBALS['SOLIW']->functions->get_licence_manage_url( $order_id );
                                
			                }
		            }

		        if ( ! $this->is_enabled() || ! $this->get_recipient() ) 
                    {
			            return;
		            }

                $this->placeholders['{order_item}'] =   $this->order_item['name'];
                    
		        $this->send( $this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments() );
	        }

	    /**
	     * Get content html.
	     *
	     * @access public
	     * @return string
	     */
	    public function get_content_html() {
		    return wc_get_template_html( $this->template_html, array(
			    'order'                     =>  $this->order,
                'order_item'                =>  $this->order_item,
                'order_item_id'             =>  $this->order_item_id,
			    'expire_days'               =>  $this->expire_days,
                'extend_link'               =>  $this->extend_link,
                'email_heading'             => $this->get_heading(),
                'additional_content'        => $this->get_additional_content(),
			    'sent_to_admin'             => false,
			    'plain_text'                => false,
			    'email'			            => $this
		    ) );
	    }

	    /**
	     * Get content plain.
	     *
	     * @access public
	     * @return string
	     */
	    public function get_content_plain() {
		    return wc_get_template_html( $this->template_plain, array(
			    'order'                     =>  $this->order,
                'order_item'                =>  $this->order_item,
                'order_item_id'             =>  $this->order_item_id,
                'expire_days'               =>  $this->expire_days,
                'extend_link'               =>  $this->extend_link,
			    'email_heading'             => $this->get_heading(),
                'additional_content'        => $this->get_additional_content(),
			    'sent_to_admin'             => false,
			    'plain_text'                => true,
			    'email'			            => $this
		    ) );
	    }
    }

    endif;

    return new SOLIW_Email_Customer_Licence_Expire();
    
    
?>