<?php
    
    defined( 'ABSPATH' ) || exit;
       
    class SOLIW
        {                        
            
            var $functions;
                        
            var $order_status_changed;
            
            
            /**
            * 
            * Run on class construct
            * 
            */
            function __construct( ) 
                {
                    
                    $this->functions    =   new SOLIW_functions();
                                        
                    include_once(SOLIW_PATH . '/include/wc-template-functions.php');
                    
                    add_action( 'init',             array($this->functions, 'add_endpoints' ));
                    add_filter( 'query_vars',       array($this->functions, 'add_query_vars'));
                    add_action( 'parse_request',    array($this->functions, 'parse_request'), 0 );  
                    
                    //add_action('woocommerce_account_settings', array($this, 'woocommerce_account_settings')); 
                    add_action('woocommerce_get_settings_advanced', array($this->functions, 'woocommerce_account_settings')); 
                    
                    //reload the endpoint slug to allow rewrite rules to save corect data
                    add_action('woocommerce_update_options_account', array($this->functions, 'woocommerce_update_options_account'));  
                    
                    add_action( 'woocommerce_order_status_completed', array($this->functions,'complete_order_licensing_setup') );
                    
                    //on refund make the licence inactive
                    add_action( 'woocommerce_order_fully_refunded', array($this->functions, 'woocommerce_order_fully_refunded'), 99, 2 );
                    
                    add_action( 'woocommerce_grant_product_download_permissions' ,  array($this->functions, 'woocommerce_grant_product_download_permissions')); 
                    
                    //trigger low predefined keys
                    add_action('woo_sl/generate_license_key/predefined_keys', array($this->functions, 'on_predefined_key' ), 10, 2 );
    
                    //load the new settings
                    include_once(SOLIW_PATH . '/include/admin/settings/class.sl-settings-licence.php');
                    new SOLIW_Settings_licence();
                    
                    add_action( 'plugins_loaded',             array($this, 'compatibility' ));
                    
                    add_filter( 'woocommerce_email_order_items_table', array ( $this->functions, 'woocommerce_email_order_items_table' ), 99, 2 );
                       
                }
                
                
            function compatibility()
                {
                    if ( ! function_exists ( 'is_plugin_active' ) )
                        include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
                    
                           
                }    
    
        }
        
?>