<?php

    defined( 'ABSPATH' ) || exit;
    
    class SOLIW_on_update
        {
            var $functions;
            
            var $options;
                                  
            function __construct()
                {
                    global $SOLIW;
                    
                    $this->functions            =   $SOLIW->functions;
                    
                    $this->options              =   SOLIW_functions::get_options();
                    
                    add_action('init', array( $this, '_run_code_update'));
                    add_action('init', array( $this, '_run_db_update'));

                }
                
                
            public function _run_code_update()
                {                    
                    global $wpdb;
                    
                    $version        =   isset($this->options['version']) ?   $this->options['version'] :   SOLIW_VERSION;
      
                    if (version_compare($version, SOLIW_VERSION, '>='))
                        return;
     
                         
                    //save the last code version
                    $this->options['version'] =   SOLIW_VERSION;

                    SOLIW_functions::update_options( $this->options );

                }
                
            public function _run_db_update()
                {                    
                    $db_version        =   isset($this->options['db_version']) ?   $this->options['db_version'] :   1;
                    
                    if (version_compare($db_version, SOLIW_DB_VERSION, '<')  === FALSE)
                        return;
                    
                    global $wpdb;
                    
                    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
                                                    
                    if( version_compare($db_version, '1.1', '<') )
                        {
                            
                            //update the table structure
                            $charset_collate = $wpdb->get_charset_collate();

                            $sql = "CREATE TABLE ". $wpdb->prefix ."woocommerce_software_licence (
                                          `id` int(11) NOT NULL AUTO_INCREMENT,
                                          `order_id` int(11) NOT NULL,
                                          `order_item_id` int(11) NOT NULL,
                                          `group_id` int(11) NOT NULL,
                                          `licence` varchar(256) NOT NULL,
                                          `created` datetime NOT NULL,
                                          `active_domain` varchar(256) DEFAULT NULL,
                                          PRIMARY KEY (`id`)
                                        ) $charset_collate;";

                            dbDelta( $sql );
                            
                            $version =   '1.1';
                        }
          
                                       
                    //save the last code version
                    $this->options['db_version'] =   SOLIW_DB_VERSION;
                    
                    SOLIW_functions::update_options( $this->options );

                }
          
        }
        
        
?>