<?php
    
    defined( 'ABSPATH' ) || exit;
       
    class SOLIW_functions 
        {   
            var $query_vars;
            
            protected static $_instance = null;
                                  
            /**
            * 
            * Run on class construct
            * 
            */
            function __construct( ) 
                {                    
                    
                    $this->init_query_vars();
                           
                }
                
            public static function instance() 
                {
                    if ( is_null( self::$_instance ) ) 
                        {
                            self::$_instance = new self();
                        }
                    return self::$_instance;
                }
      
                        
            public function init_query_vars() 
                {
                    // Query vars to add to WP
                    $this->query_vars = array(
                                                // My account actions
                                                'license-manage'            => get_option( 'woocommerce_myaccount_license_manage_endpoint', 'license-manage' ),
                                                'software_license'          => get_option( 'woocommerce_myaccount_software_license_endpoint', 'view-license' )
                                            );
                }
            
            
            function woocommerce_get_query_vars( $query_vars )
                {
                    
                    $query_vars['license-manage']   =   get_option( 'woocommerce_myaccount_license_manage_endpoint', 'license-manage' );
                    $query_vars['software_license'] =   get_option( 'woocommerce_myaccount_software_license_endpoint', 'view-license' );
                    
                    return $query_vars;   
                }
            
            
            /**
             * Endpoint mask describing the places the endpoint should be added.
             *
             * @since 2.6.2
             * @return int
             */
            public function get_endpoints_mask() 
                {
                    if ( 'page' === get_option( 'show_on_front' ) ) {
                        $page_on_front     = get_option( 'page_on_front' );
                        $myaccount_page_id = get_option( 'woocommerce_myaccount_page_id' );
                        $checkout_page_id  = get_option( 'woocommerce_checkout_page_id' );

                        if ( in_array( $page_on_front, array( $myaccount_page_id, $checkout_page_id ), true ) ) {
                            return EP_ROOT | EP_PAGES;
                        }
                    }

                    return EP_PAGES;
                }
            
                 
            /**
             * Add endpoints for query vars
             */
            public function add_endpoints() 
                {
                    $mask = $this->get_endpoints_mask(); 
                    
                    foreach ( $this->query_vars as $key => $var )
                        add_rewrite_endpoint( $var, $mask );
                        
                }

            /**
             * add_query_vars function.
             *
             * @access public
             * @param array $vars
             * @return array
             */
            public function add_query_vars( $vars ) 
                {
                     foreach ( $this->query_vars as $key => $var )
                        $vars[] = $var; 
                                            
                    return $vars;
                }
      
            
            /**
             * Parse the request and look for query vars - endpoints may not be supported
             */
            public function parse_request() 
                {
                    global $wp;

                    // Map query vars to their keys, or get them if endpoints are not supported
                    foreach ( $this->query_vars as $key => $var ) {
                        // phpcs:ignore  WordPress.Security.NonceVerification.Recommended
                        if ( isset( $_GET[ $var ] ) ) {
                            // phpcs:ignore  WordPress.Security.NonceVerification.Recommended
                            $wp->query_vars[ $key ] = sanitize_key ( $_GET[ $var ] );
                        }

                        elseif ( isset( $wp->query_vars[ $var ] ) ) {
                            $wp->query_vars[ $key ] = $wp->query_vars[ $var ];
                        }
                    }
                }   
                
            function woocommerce_account_settings($settings)
                {
                    //find out the "My Account Endpoints"
                    $_settings      = array();
                    $item_inserted  =   FALSE;
                    foreach($settings as $data)
                        {
                            $_settings[]    =   $data;
                            
                            if( $data['id']  ==  'account_endpoint_options'  && $item_inserted   ===  FALSE )
                                {
                                    $_settings[]    =   array(
                                                            'title'    => __( 'License Manage', 'software-license-lite' ),
                                                            'desc'     => __( 'Endpoint for the My Account &rarr; License Manage page', 'software-license-lite' ),
                                                            'id'       => 'woocommerce_myaccount_license_manage_endpoint',
                                                            'type'     => 'text',
                                                            'default'  => 'license-manage',
                                                            'desc_tip' => true   
                                                            );
                                                            
                                    $_settings[]    =   array(
                                                            'title'    => __( 'License View', 'software-license-lite' ),
                                                            'desc'     => __( 'Endpoint for the My Account &rarr; single License View page', 'software-license-lite' ),
                                                            'id'       => 'woocommerce_myaccount_software_license_endpoint',
                                                            'type'     => 'text',
                                                            'default'  => 'view-license',
                                                            'desc_tip' => true   
                                                            );
                                    $item_inserted          =   TRUE;
                                }
                        }
                       
                    return $_settings;   
                }
                
                
            function woocommerce_update_options_account()
                {
                    $this->init_query_vars();
                    $this->add_endpoints();
                       
                }
                
            function add_rewrite_entries()
                {
                    $this->init_query_vars();
                    $this->add_endpoints();
                    flush_rewrite_rules();   
                }
        
            
            static function get_current_url ( $include_GET = FALSE )
                {
                    $pageURL = 'http';
                    
                    if (isset($_SERVER["HTTPS"])  && $_SERVER["HTTPS"] == "on") 
                        {
                            $pageURL .= "s";
                        }
                    
                    $pageURL .= "://";
                    
                    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated
                    $request_uri        =   esc_url_raw( wp_unslash( $_SERVER["REQUEST_URI"] ) );
                    $request_uri_parts  =   explode("?", $request_uri);
                    
                    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated                
                    if ($_SERVER["SERVER_PORT"] != "80") 
                        {
                            if($include_GET === FALSE)
                                $request_uri    =   $request_uri_parts[0];   
                            
                            // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated
                            $pageURL .= esc_url_raw( wp_unslash( $_SERVER["SERVER_NAME"] ) ) .   ":" .   esc_url_raw( wp_unslash( $_SERVER["SERVER_PORT"] ) ) .   $request_uri;
                        } 
                        else 
                        {
                            if($include_GET === FALSE)
                                $request_uri    =   $request_uri_parts[0];
                            
                            // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotValidated       
                            $pageURL .= esc_url_raw( wp_unslash( $_SERVER["SERVER_NAME"] ) ) .   $request_uri;
                        }
                    
                    return $pageURL;   
                }
        
            /**
            * Check if order contain any licensed product
            * 
            * @param mixed $order_id
            */
            static function order_contain_licensed_item($order_id)
                {
                    $order_data     = new WC_Order($order_id);
    
                    $order_products =   $order_data->get_items();
                    
                    foreach( $order_products as  $order_item_id    =>  $order_item )
                        {
                            if ( self::is_order_item_licensed( $order_id, $order_item_id ) )
                                return TRUE;
                        }
                        
                    return FALSE;       
                }
                
                
            /**
            * Check if the license is active for a product id
            * 
            * @param mixed $product_id
            */
            static function is_product_licensed($product_id)
                {
                       
                    $_sl_enabled    =   get_post_meta($product_id,  '_sl_enabled',  TRUE);
                    if($_sl_enabled ==  'yes')
                        return TRUE;
                                            
                    return FALSE;   
                }
            
            /**
            * Check if order item use licensing
            *     
            * @param mixed $order_id
            * @param mixed $order_item_id
            */
            static function is_order_item_licensed($order_id, $order_item_id )
                {
                    $_soliw    =   self::get_order_item_meta($order_item_id,  '_woo_sl',  TRUE);
                    if(!    is_array($_soliw))
                        return FALSE;
                        
                    //check if the item object is still licence 
                    $order_product_data = self::get_order_product_data($order_id, $order_item_id);
                    if (! self::is_product_licensed($order_product_data['product_id']))
                        return FALSE;
                                            
                    return TRUE;   
                }
                
                
                
            /**
            * Remove the order item licensing data
            *     
            * @param mixed $order_id
            * @param mixed $order_item_id
            */
            static function remove_order_item_licensing_data ( $order_item_id )
                {
                    global $wpdb;
                    
                    //search all meta keys stat stars with _soliw
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $item_meta  = $wpdb->get_results( $wpdb->prepare( "SELECT meta_key FROM {$wpdb->prefix}woocommerce_order_itemmeta 
                                                                WHERE order_item_id = %d AND meta_key LIKE %s", $order_item_id, '_woo_sl%' ) );
                    
                    foreach ( $item_meta as $item_meta_row )
                        {
                            wc_delete_order_item_meta ( $order_item_id, $item_meta_row->meta_key );   
                        }
                        
                    //remove the license keys
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $item_meta  = $wpdb->get_results( $wpdb->prepare( "DELETE FROM {$wpdb->prefix}woocommerce_software_licence 
                                                                WHERE order_item_id = %d", $order_item_id ) );
                                            
                    return TRUE;   
                }
                
            
            /**
            * Migrate the _soliw ordr itemmeta from an order_item_id to a different
            * Used when WooCommerce Subscription order Switch 
            *     
            * @param mixed $order_item_id
            */
            static function migrate_order_item_licensing_data ( $old_order_item_id, $new_order_item_id )
                {
                    global $wpdb;
                    
                    //search all meta keys stat stars with _soliw
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $item_meta  = $wpdb->get_results( $wpdb->prepare( "SELECT meta_key, meta_value FROM {$wpdb->prefix}woocommerce_order_itemmeta 
                                                                WHERE order_item_id = %d AND meta_key LIKE %s", $old_order_item_id, '_woo_sl%' ) );
                    
                    foreach ( $item_meta as $item_meta_row )
                        {
                            wc_add_order_item_meta( $new_order_item_id, $item_meta_row->meta_key, maybe_unserialize ( $item_meta_row->meta_value ) );   
                        }
                                            
                    return TRUE;   
                }
                
                
            /**
            * Update the software_license with the new data
            * 
            * @param mixed $order_id
            * @param mixed $order_item_id
            * @param mixed $update_data
            */
            static function update_software_license_data ( $order_id, $order_item_id, $update_data )
                {
                    global $wpdb;
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $results                                =   $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `" . $wpdb->prefix ."woocommerce_software_licence`
                                                            WHERE order_id = %d AND order_item_id = %d", $order_id, $order_item_id ) );
                    
                    foreach ( $results  as  $result )
                        {
                            foreach ( $update_data  as  $update_key =>  $update_value )
                                {
                                    $result->$update_key  =   $update_value;
                                }
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $wpdb->query( $wpdb->prepare(  "UPDATE `" . $wpdb->prefix ."woocommerce_software_licence`
                                                                SET `order_id`    =   %d, `order_item_id`   =   %d, `group_id`  =   %d, `licence`   =   %s, `active_domain` =   %s
                                                                WHERE id = %d",
                                                                $result->order_id, $result->order_item_id, $result->group_id, $result->licence, $result->active_domain,
                                                                $result->id ) );
                        }
                                            
                    return TRUE;   
                }
                
            
            static function get_order_item_expiration_status (  ) 
                {
                    
                    
                }
                
            
            
            function get_licence_statuses()
                {
                    
                    $licence_statuses   =   array(
                                                        'active'        =>  __( 'Active', 'software-license-lite' ),
                                                        'inactive'      =>  __( 'Inactive', 'software-license-lite' ),
                                                        'expired'       =>  __( 'Expired', 'software-license-lite' ),
                                                        
                                                        //used when using expire 
                                                        'not-activated' =>  __( 'Not Activated', 'software-license-lite' ),
                                                        //cancelled when using custom subscriptions plugins
                                                        'cancelled'      =>  __( 'Cancelled', 'software-license-lite' ),
                                                        );   
                    
                    return $licence_statuses;
                    
                }
            
            
            
            /**
            * Return a list with a specified user licences
            * 
            * @param mixed $user_id
            */
            function get_user_licences( $user_id )
                {
                    
                    global $wpdb;
                    
                    if ( ! $this->is_HPOS_active() )
                        {
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $results    =   $wpdb->get_results( $wpdb->prepare ( "SELECT
                                                                            woooitems.order_id,
                                                                            woooi.*
                                                                        FROM
                                                                            `{$wpdb->prefix}woocommerce_order_itemmeta` AS woooi
                                                                        JOIN {$wpdb->prefix}woocommerce_order_items AS woooitems
                                                                        ON
                                                                            woooitems.order_item_id = woooi.order_item_id
                                                                        JOIN {$wpdb->prefix}woocommerce_order_items AS woooitems2
                                                                        ON
                                                                            woooitems2.order_item_id = woooi.order_item_id
                                                                        JOIN {$wpdb->postmeta} AS woopm
                                                                        ON
                                                                            woopm.post_id = woooitems.order_id
                                                                            
                                                                        WHERE
                                                                            woooitems2.order_item_type = 'line_item' AND  woooi.meta_key = '_woo_sl' AND woopm.meta_key = '_customer_user' AND woopm.meta_value = %d
                                                                        GROUP BY
                                                                            woooitems.order_id
                                                                        ORDER BY
                                                                            woooitems.order_id
                                                                        DESC", $user_id ) );
                        }
                        else
                        {
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $results    =   $wpdb->get_results( $wpdb->prepare ( "SELECT
                                                                            woooitems.order_id,
                                                                            woooi.*
                                                                        FROM
                                                                            `{$wpdb->prefix}woocommerce_order_itemmeta` AS woooi
                                                                        JOIN {$wpdb->prefix}woocommerce_order_items AS woooitems
                                                                        ON
                                                                            woooitems.order_item_id = woooi.order_item_id
                                                                        JOIN {$wpdb->prefix}woocommerce_order_items AS woooitems2
                                                                        ON
                                                                            woooitems2.order_item_id = woooi.order_item_id
                                                                        JOIN ". $wpdb->prefix ."wc_orders AS wco
                                                                        ON
                                                                            wco.id = woooitems.order_id
                                                                            
                                                                        WHERE
                                                                            woooitems2.order_item_type = 'line_item' AND  woooi.meta_key = '_woo_sl' AND wco.customer_id = %d
                                                                        GROUP BY
                                                                            woooitems.order_id
                                                                        ORDER BY
                                                                            woooitems.order_id
                                                                        DESC", $user_id ) );
                        }    
                    
                    return $results;
                    
                }
                
                
            /**
            * Check if the license is active for a product id
            * 
            * @param mixed $product_id
            */
            static function product_using_licence_expire( $product_id )
                {
                    
                    if( self::is_product_licensed($product_id) !==  TRUE )
                        return FALSE;
                        
                    $product_sl_groups =   SOLIW_functions::get_product_licensing_groups( $product_id );
                    
                    $using_licence_expire   =   FALSE;
                    
                    if ( count ( $product_sl_groups ) < 1 )
                        return $using_licence_expire;
                    
                    foreach ( $product_sl_groups    as  $key    =>  $data )
                        {
                            if ( $data['product_use_expire']    !=  'no' )
                                $using_licence_expire   =   TRUE;
                        }
                    
                    return $using_licence_expire;   
                }
                
                
            /**
            * Return licensing expire details for a product
            *     
            * @param mixed $product_id
            */
            static function get_product_licence_expire_details( $product_id )
                {
                    
                    if( self::is_product_licensed($product_id) !==  TRUE )
                        return FALSE;
                        
                    $product_sl_groups =   SOLIW_functions::get_product_licensing_groups( $product_id );
                    
                    if ( count ( $product_sl_groups ) < 1 )
                        return FALSE;
                        
                    $product_licence_expire_details =   array();
                        
                    foreach ( $product_sl_groups    as  $key    =>  $data )
                        {
                            if ( $data['product_use_expire']    ==  'no' )
                                continue;
                                
                            $block  =   array();
                            $block['product_expire_renew_price']            =   $data['product_expire_renew_price'];
                            $block['product_expire_units']                  =   $data['product_expire_units'];
                            $block['product_expire_time']                   =   $data['product_expire_time'];
                            $block['product_expire_starts_on_activate']     =   $data['product_expire_starts_on_activate'];
                            $block['product_expire_disable_update_link']    =   $data['product_expire_disable_update_link'];
                            $block['product_expire_limit_api_usage']        =   $data['product_expire_limit_api_usage'];
                            $block['product_expire_notice']                 =   $data['product_expire_notice'];
                            
                            $product_licence_expire_details[]   =   $block;
                        }
                    
                    return $product_licence_expire_details;   
                }
                
            
            
            /**
            * Return product licence expire
            * Return product_expire_units and product_expire_time  
            * 
            * @param mixed $product_id
            */
            static function get_product_licence_expire( $product_id )
                {
                    
                    $product_expire_details     =   self::get_product_licence_expire_details( $product_id );   
                    
                    //the product expire details might include multiple licences block, loop all and use the latest
                    $product_expire_units   =   '';
                    $product_expire_time    =   '';
                    
                    $_loop_items    =   array(
                                                'years',
                                                'months',
                                                'days'
                                                );
                    $_loop_items                =   array_flip( $_loop_items );
                    foreach  ( $_loop_items as  $key    =>  $value )
                        {
                            $_loop_items[$key]  =   FALSE;
                        }
                    
                    foreach ($product_expire_details    as  $data)
                        {
                            $_loop_items[ $data['product_expire_time'] ]    =   TRUE;
                        }
                        
                    foreach  ( $_loop_items as  $key    =>  $value )
                        {
                            if ( $value === TRUE )
                                {
                                    $product_expire_time    =   $key;
                                    break;
                                }    
                        }
                        
                    $product_expire_units  =   0;
                    foreach ($product_expire_details    as  $data)
                        {
                            if  ( $data['product_expire_time']    !=  $product_expire_time )
                                continue;
                                
                            if ( $data['product_expire_units'] >    $product_expire_units )
                                $product_expire_units   =   $data['product_expire_units'];
                        }
                        
                    $return =    array(
                                       'product_expire_units'   =>  $product_expire_units,
                                       'product_expire_time'    =>  $product_expire_time 
                                       );
                                       
                    return $return;
                    
                }
                
                
            /**
            * Check if the license is active for an order product id
            * 
            * @param mixed $product_id
            */
            static function order_item_using_licence_expire($order_id, $order_item_id)
                {
                    $_soliw_licensing_using_expire   =   self::get_order_item_meta($order_item_id,  '_woo_sl_licensing_using_expire',  TRUE);
                    
                    if(self::is_order_item_licensed( $order_id, $order_item_id ) ===  TRUE  &&   !empty($_soliw_licensing_using_expire))
                        return TRUE;
                                            
                    return FALSE;   
                }
                
                
            static function order_item_is_woocommerce_subscription ( $order_item_id )
                {
                    if ( ! is_plugin_active( 'woocommerce-subscriptions/woocommerce-subscriptions.php' ) )
                        return FALSE;
                    
                    $order_item =   new WC_Order_Item_Product( $order_item_id );
                    $order_id   =   $order_item->get_order_id();
                    $product_id =   $order_item->get_product_id();
                    
                    global $wpdb;
                    
                    if ( self::is_HPOS_active() )
                        {
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $check_order_id     =   $wpdb->get_var( $wpdb->prepare ( "SELECT id FROM {$wpdb->prefix}wc_orders WHERE parent_order_id = %d AND type = 'shop_subscription'", $order_id ) );
                        }
                        else
                        {
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $check_order_id     =   $wpdb->get_var( $wpdb->prepare ( "SELECT ID FROM {$wpdb->posts} WHERE post_parent = %d AND post_type = 'shop_subscription'", $order_id ) );
                        }
                    
                    //check if is a renewal
                    if ( empty ( $check_order_id ) )
                        {
                            if ( self::is_HPOS_active() )
                                $_subscription_renewal  =   self::get_order_meta( $order_id, '_subscription_renewal' );
                                else
                                $_subscription_renewal  =   get_post_meta( $order_id, '_subscription_renewal', TRUE );
                            if ( $_subscription_renewal > 0 )
                                $check_order_id   =   $_subscription_renewal;
                        }
                    
                    //check if is a switch
                    if ( empty ( $check_order_id ) )
                        {
                            if ( self::is_HPOS_active() )
                                $_subscription_switch  =   self::get_order_meta( $order_id, '_subscription_switch' );
                                else
                                $_subscription_switch  =   get_post_meta( $order_id, '_subscription_switch', TRUE );
                            if ( $_subscription_switch > 0 )
                                $check_order_id   =   $_subscription_switch;
                        }
                    
                    if ( empty ( $check_order_id ) )
                        return FALSE;
                        
                    $check_order        =   new wc_order( $check_order_id );
                    $check_order_items  =   $check_order->get_items();
                    reset ( $check_order_items );
                    $check_order_item   =   current ( $check_order_items );
                    $check_order_item_product_id    =   $check_order_item->get_product_id();
                    
                    if ( $check_order_item_product_id   ==  $product_id )
                        return TRUE;
                        
                    return FALSE; 
                       
                }
                
               
            static function get_order_product_data($order_id, $order_item_id)
                {
                    $order_data     = new WC_Order($order_id);
    
                    $order_products =   $order_data->get_items();
                    
                    foreach($order_products as  $key    =>  $order_product)
                        {
                            if ($order_item_id  ==  $key )
                                return $order_product;
                        }
                        
                    return FALSE;   
                    
                }
                
                
            static function get_order_product_generated_keys_count($order_id, $order_item_id, $license_group_id)
                {
                    
                    $generated_keys =   self::get_order_product_generated_keys($order_id, $order_item_id, $license_group_id);
                    
                    $count = count($generated_keys);
                    
                    return $count;
                    
                }
                
            static function get_order_product_generated_keys($order_id, $order_item_id, $license_group_id)
                {
                    global $wpdb;
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $results = $wpdb->get_results( $wpdb->prepare("SELECT * FROM " . $wpdb->prefix ."woocommerce_software_licence 
                                    WHERE order_item_id = %d AND order_id = %d AND group_id = %d
                                    GROUP BY licence
                                    ORDER BY id DESC", $order_item_id, $order_id, $license_group_id) );
                    
                    return $results;
                    
                }
            
            static public function get_licence_manage_url($order_id) 
                {

                    $view_order_url = wc_get_endpoint_url( self::instance()->query_vars['software_license'], $order_id, get_permalink( wc_get_page_id( 'myaccount' ) ) );

                    return apply_filters( 'woocommerce_sl_get_view_order_url', $view_order_url, self::instance() );
                } 
     
            
            /**
            * Return the order id by specified order_itme_id
            * 
            * @param mixed $order_item_id
            */
            static public function get_order_by_item_id(    $order_item_id  )
                {
                    
                    global $wpdb;
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $order_id       =   $wpdb->get_var( $wpdb->prepare( "SELECT order_id FROM {$wpdb->prefix}woocommerce_order_items WHERE order_item_id = %d", $order_item_id ) );
                    
                    return $order_id;
                       
                }
     
            
            /**
            * 
            * Create licence details for a product order
            * 
            */
            static function get_order_licence_details($order_id)
                {
                    $order_licence_details =   array();
                    
                    if( ! self::order_contain_licensed_item($order_id))
                        return $order_licence_details;
                    
                    $order_data     = new WC_Order($order_id);
    
                    $order_items =   $order_data->get_items();
                    
                    foreach( $order_items as  $order_item_id => $order_item_data )
                        {
                            //ensure the item is not a subscription
                            $order_item_product =   $order_item_data->get_product();
                            if ( $order_item_data->get_type() == 'shop_order'    &&  in_array ( $order_item_product->get_type(), array ( 'subscription', 'variable-subscription' ) ) )
                                continue;
                            
                            if (    !   self::is_order_item_licensed($order_id, $order_item_id))
                                continue;
                            
                            $_soliw    =   self::get_order_item_meta($order_item_id,  '_woo_sl',  TRUE);
                            
                            $group_count  =   is_array($_soliw['max_keys']) ?   count($_soliw['max_keys']) : 1;
                            for($i = 0; $i< $group_count;  $i++) 
                                {
                                    $license_details                        =   new stdClass();    
                                    
                                    $license_details->order_id            =   $order_id;
                                    $license_details->order_item_id       =   $order_item_id;
                                    $license_details->license_data        =   array(
                                                                                        'group_title'                       =>  $_soliw['group_title'][$i],
                                                                                        'licence_prefix'                    =>  $_soliw['licence_prefix'][$i],
                                                                                        'max_keys'                          =>  $_soliw['max_keys'][$i],
                                                                                        'max_instances_per_key'             =>  $_soliw['max_instances_per_key'][$i],
                                                                                        'use_predefined_keys'               =>  $_soliw['use_predefined_keys'][$i],
                                                                                        
                                                                                        'product_use_expire'                    =>  $_soliw['product_use_expire'][$i],
                                                                                        
                                                                                        );
                                    $license_details->group_id            =   $i;
                                    $license_details->generated_keys      =   self::get_order_product_generated_keys_count($order_id, $order_item_id, $i);
                                    
                                    $order_licence_details[$order_item_id][]    =   $license_details;                                    
                                }

                        }
                    
                    
                    $order_licence_details  =   apply_filters( 'woo_sl/get_order_licence_details', $order_licence_details, $order_id );
                    
                    return $order_licence_details;

                }
                            
                
            static function get_order_product_licence_details($order_id, $order_item_id, $license_group_id)
                {
                    $order_licence_details  =   self::get_order_licence_details($order_id);
                    $order_item_licence_details =   isset($order_licence_details[$order_item_id])   ?   $order_licence_details[$order_item_id]  :   array();
                    foreach ($order_item_licence_details as $licence_group_id   =>  $product_licence_data)

                        {
                            if($product_licence_data->order_item_id !=  $order_item_id)
                                continue;
                                
                            if($product_licence_data->group_id !=  $license_group_id)
                                continue;
                                
                            return  $product_licence_data;
                            
                        }
                        
                        
                    return FALSE;                    
                }
       
            static function get_product_licensing_groups( $product_id )
                {
                    $_sl_groups                         =   get_post_meta( $product_id, '_sl_groups', true );
                    
                    //old version fallback versions under 2.0
                    if(!is_array($_sl_groups)    ||  count($_sl_groups)  <   1)
                        {
                            $_sl_group_title                        =   (array)get_post_meta( $product_id, '_sl_group_title', true );
                            $_sl_licence_prefix                     =   (array)get_post_meta( $product_id, '_sl_licence_prefix', true );
                            $_sl_max_keys                           =   (array)get_post_meta( $product_id, '_sl_max_keys', true );
                            $_sl_max_instances_per_key              =   (array)get_post_meta( $product_id, '_sl_max_instances_per_key', true );
                            $_sl_allow_instances_per_key_change     =   (array)get_post_meta( $product_id, '_sl_allow_instances_per_key_change', true );
                            
                            $_sl_product_use_expire                 =   (array)get_post_meta( $product_id, '_sl_product_use_expire', true );
                            $_sl_product_expire_renew_price         =   (array)get_post_meta( $product_id, '_sl_product_expire_renew_price', true );
                            $_sl_product_expire_units               =   (array)get_post_meta( $product_id, '_sl_product_expire_units', true );
                            $_sl_product_expire_time                =   (array)get_post_meta( $product_id, '_sl_product_expire_time', true );
                            $_sl_product_expire_starts_on_activate  =   (array)get_post_meta( $product_id, '_sl_product_expire_starts_on_activate', true );
                            $_sl_product_expire_disable_update_link =   (array)get_post_meta( $product_id, '_sl_product_expire_disable_update_link', true );
                            $_sl_product_expire_limit_api_usage     =   (array)get_post_meta( $product_id, '_sl_product_expire_limit_api_usage', true );
                            $_sl_product_expire_notice              =   (array)get_post_meta( $product_id, '_sl_product_expire_notice', true );
                            
                            $_sl_groups =   array();
                            
                            $group_count  =   is_array($_sl_max_keys) ?   count($_sl_max_keys) : 1;
                            if($group_count < 1)
                                {
                                    $_sl_groups[]   =   array(
                                                                'group_title'                           =>   '',      
                                                                'licence_prefix'                        =>   '',
                                                                'max_keys'                              =>   '',
                                                                'max_instances_per_key'                 =>   '',
                                                                'use_predefined_keys'                   =>   'no',
                                                                'predefined_keys'                       =>   '',
                                                                
                                                                'product_use_expire'                    =>  'no',
                                                                'product_expire_renew_price'              =>  '',
                                                                'product_expire_units'                  =>  '',
                                                                'product_expire_time'                   =>  '',
                                                                'product_expire_starts_on_activate'     =>  'no',
                                                                'product_expire_disable_update_link'    =>  'no',
                                                                'product_expire_limit_api_usage'        =>  'no',
                                                                'product_expire_notice'                 =>  ''
                                                                );                                    
                                    $group_count = 1;
                                }
                                else
                                    {
                                        for($i = 0; $i< $group_count;  $i++) 
                                            {  
                                                $_sl_groups[]   =   array(
                                                                            'group_title'                      =>   $_sl_group_title[$i],      
                                                                            'licence_prefix'                   =>   $_sl_licence_prefix[$i],
                                                                            'max_keys'                         =>   $_sl_max_keys[$i],
                                                                            'max_instances_per_key'            =>   $_sl_max_instances_per_key[$i],
                                                                            'use_predefined_keys'              =>   'no',
                                                                            'predefined_keys'                  =>   '',
                                                                            
                                                                            'product_use_expire'                    =>  'no',
                                                                            'product_expire_renew_price'            =>  '',
                                                                            'product_expire_units'                  =>  '',
                                                                            'product_expire_time'                   =>  '',
                                                                            'product_expire_starts_on_activate'     =>  'no',
                                                                            'product_expire_disable_update_link'    =>  'no',
                                                                            'product_expire_limit_api_usage'        =>  'no',
                                                                            'product_expire_notice'                 =>  ''
                                                                            );
                                            }
                               
                                    }
                        }
                        
                    return $_sl_groups;   
                    
                }
                
            static function get_order_item_licensing_groups( $order_item_id )
                {
                    $_soliw        =   self::get_order_item_meta($order_item_id,  '_woo_sl',  TRUE);   
                    
                    if ( ! is_array ( $_soliw ) )
                        return FALSE;
                    
                    $group_count    =   count($_soliw['group_title']);
                    
                    //backwards compatibility for use_predefined_keys
                    if(!isset($_soliw['use_predefined_keys']))
                        {
                            for($i  =   0;  $i  <   $group_count;   $i++)
                                {
                                    $_soliw['use_predefined_keys'][$i] =   'no';
                                }
                        }
                    
                    return $_soliw;
                }

            
            static function get_product_licensing_group_matching_order_group_title($product_id, $group_title)
                {
                    $_sl_groups =   self::get_product_licensing_groups($product_id);   
                    
                    if(!is_array($_sl_groups)   ||  count($_sl_groups) < 1)
                        return FALSE;
                    
                    foreach($_sl_groups as  $_sl_group)
                        {
                            if($_sl_group['group_title']    ==  $group_title)
                                return  $_sl_group;
                        }
                        
                    return FALSE;
                }
                
            
            /**
            * Generate License Keys for product order
            * 
            * @param mixed $order_id
            * @param mixed $order_item_id
            * @param mixed $license_group_id 
            * @param $generate_keys_count : the number of keys to be generated
            * 
            */
            static function generate_license_key( $order_id, $order_item_id, $license_group_id,  $generate_keys_count = 1, $SystemInternal = FALSE )
                {
                    
                    $options    =   self::get_options();
                    
                    //check if the order is completed
                    $woocommerce_licensing_grant_access_after_payment   =   get_option('woocommerce_licensing_grant_access_after_payment');
                    if( $woocommerce_licensing_grant_access_after_payment ==  'yes' && ! self::is_order_completed($order_id))
                        return FALSE;
                        
                        
                    //allow a way bypass a default key creation
                    if (    $SystemInternal  &&   apply_filters( 'woo_sl/new-order/generate_license_key/bypass', FALSE, $order_id, $order_item_id, $license_group_id  ) )
                        return;
                    
                    $order_product_licence_data   =   self::get_order_product_licence_details($order_id, $order_item_id, $license_group_id);
                    
                    $license_keys   =   array();
                    
                    for($i = 1; $i  <=  $generate_keys_count; $i++)
                        {
                            $license_key    =   '';
                            
                            //check if use predefined keys
                            if($order_product_licence_data->license_data['use_predefined_keys']   ==  'yes')
                                {
                                    //get keys from original product
                                    $order_product_data = self::get_order_product_data($order_id, $order_item_id); 
                                    
                                    $actual_product_license_group =   self::get_product_licensing_group_matching_order_group_title($order_product_data->get_product_id(), $order_product_licence_data->license_data['group_title']);
                                    
                                    if(is_array($actual_product_license_group))
                                        {
                                            $predefined_keys    =   $actual_product_license_group['predefined_keys'];
                                            //create an array out of key list
                                            
                                            $key_list = preg_split ("/\r\n|\n|\r/", $predefined_keys);
                                            
                                            $key_list   =   array_filter($key_list);
                                            
                                            if(count($key_list) >   0)
                                                {
                                                    $key_list_index = 0;
                                                    
                                                    while( $license_key  ==  ''  &&  $key_list_index <  count($key_list) )
                                                        {
                                                            $list_next_key    =   $key_list[ $key_list_index ];
                                                            
                                                            //check if using dynamic counter for multiple usage e.g. {2}232AFEF84
                                                            preg_match('/\{([^\]]*)\}/', $list_next_key, $dynamic_matches);
                                                            if(count($dynamic_matches) > 0)
                                                                {
                                                                    $dynamic_string =   $dynamic_matches[0];
                                                                    $try_license_key    =   str_replace($dynamic_string, "", $list_next_key);
                                                                    
                                                                    if( self::key_exists_within_customer_keys( $order_id, $order_item_id, $license_group_id, $try_license_key ) === TRUE )
                                                                        {
                                                                            $key_list_index++;
                                                                            continue;   
                                                                        }
                                                                    
                                                                    $license_key    =   $try_license_key;
                                                                    $counter        =   (int)$dynamic_matches[1];   
                                                                    $counter--;
                                                                    
                                                                    if($counter >  0)
                                                                        {
                                                                            $list_next_key      =   str_replace($dynamic_string, "{" . $counter . "}", $list_next_key);
                                                                            $key_list[$key_list_index]        =   $list_next_key;
                                                                        }
                                                                        else
                                                                        unset($key_list[$key_list_index]);
                                                                }
                                                                else
                                                                    {
                                                                        $try_license_key    =   $list_next_key;
                                                                        if( self::key_exists_within_customer_keys( $order_id, $order_item_id, $license_group_id, $try_license_key ) === TRUE )
                                                                            {
                                                                                $key_list_index++;
                                                                                continue;   
                                                                            }
                                                                            
                                                                        $license_key    =   $try_license_key;
                                                                        unset($key_list[$key_list_index]);
                                                                    }
                                                            
                                                            $key_list_index++;
                                                    
                                                        }

                                                }
                                                
                                            //remove the key from the list
                                            if( $license_key !=  '' )
                                                {
                                                    $_sl_groups =   self::get_product_licensing_groups($order_product_data->get_product_id());   
                                                                                     
                                                    foreach($_sl_groups as  $key     => $_sl_group)
                                                        {
                                                            if($_sl_group['group_title']    !=  $order_product_licence_data->license_data['group_title'])
                                                                continue;
                                                            
                                                            if(count($key_list) >   0)    
                                                                $_sl_groups[$key]['predefined_keys']    =   implode("\n", $key_list);
                                                                else
                                                                $_sl_groups[$key]['predefined_keys']    =   '';
                                                                
                                                            break;
                                                        }
                                                        
                                                    //save the data
                                                    update_post_meta( $order_product_data->get_product_id(), '_sl_groups', $_sl_groups );
                                                    
                                                    do_action( 'woo_sl/generate_license_key/predefined_keys',  $order_product_data->get_product_id(), $order_product_licence_data->license_data['group_title'] );
                                                }
                                                else
                                                {
                                                    //there were no predefined keys   
                                                    do_action( 'woo_sl/generate_license_key/predefined_keys',  $order_product_data->get_product_id(), $order_product_licence_data->license_data['group_title'] );
                                                }
                                        }
                                    
                                }
                                else
                                {
                                    //check if there is any prefix to be used
                                    $product_licence_key_prefix = $order_product_licence_data->license_data['licence_prefix'];
                                    
                                    $license_key_raw            = md5( wp_rand(1,999999) . microtime() . $order_id . $order_item_id . $license_group_id);
                                    $license_key_raw_chunks     = str_split($license_key_raw, 8);
                                    unset($license_key_raw_chunks[ count($license_key_raw_chunks) - 1  ]);
                                    
                                    if($product_licence_key_prefix != '')
                                        array_unshift($license_key_raw_chunks, $product_licence_key_prefix);
                                    
                                    //use chunks
                                    $license_key = implode("-", $license_key_raw_chunks);        
                                }

                            $license_key  =   apply_filters( 'woo_sl/generate_license_key', $license_key, $order_id, $order_item_id, $license_group_id );
                            
                            if(empty($license_key))
                                break;
                                
                            do_action( 'woo_sl/generate_license_key/generated_key',  $license_key, $order_id, $order_item_id, $license_group_id );
                            
                            self::set_license_key( $order_id, $order_item_id, $license_group_id, $license_key );
                            
                            $license_keys[] =   $license_key;
                        }
                    
                    if(count($license_keys) >   0)
                        return $license_keys;
                        else
                        return FALSE;
                }
                
                
            /**
            * Send a message to admin when the list of pre-generated keys is less than 10 items
            *     
            * @param mixed $product_id
            * @param mixed $license_group_title
            */
            function on_predefined_key( $product_id, $license_group_title )
                {
                    $_sl_groups =   SOLIW_functions::get_product_licensing_groups( $product_id );   
                                                                                  
                    foreach($_sl_groups as  $key     => $_sl_group )
                        {
                            if($_sl_group['group_title']    !=  $license_group_title )
                                continue;
                            
                            $key_list   = preg_split ("/\r\n|\n|\r/", $_sl_group['predefined_keys']);               
                            $key_list   =   array_filter($key_list);
                             
                            if(count($key_list) <   apply_filters ( 'woo_sl/generate_license_key/low_predefined_keys/email/trigger_if_lower' , 10, $product_id, $license_group_title ))    
                                {
                                    $product_post   =   get_post($product_id);
                                     
                                    //send a notice to admin
                                    $to             =   apply_filters ( 'woo_sl/generate_license_key/low_predefined_keys/email/to' , get_option( 'admin_email' ), $product_id, $license_group_title );
                                    $subject        =   apply_filters ( 'woo_sl/generate_license_key/low_predefined_keys/email/subject' , __( 'Predefined List is getting low on keys', 'software-license-lite' ), $product_id, $license_group_title );
                                    $body           =   apply_filters ( 'woo_sl/generate_license_key/low_predefined_keys/email/content' , __( 'The product ', 'software-license-lite' ) .$product_post->post_title .' ( ID ' . $product_id . ' ) '. __( 'contain only', 'software-license-lite' ) .' ' . count( $key_list ) . ' ' . __( 'keys', 'software-license-lite' ) , $product_id, $license_group_title );
                                    $headers        =   array('Content-Type: text/html; charset=UTF-8');
                                      
                                    wp_mail( $to, $subject, $body, $headers );   
                                     
                                }
                                 
                            break;
                        }    

                }
            
            
            
            /**
            * Save a license key in the licensing table
            * 
            * @param mixed $order_id
            * @param mixed $order_item_id
            * @param mixed $license_group_id
            * @param mixed $license_key
            */
            static public function set_license_key ( $order_id, $order_item_id, $license_group_id, $license_key )
                {
                    
                    global $wpdb;

                    $time           = gmdate("Y-m-d H:i:s", time());
                            
                    //save the license
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $results = $wpdb->get_results( $wpdb->prepare("INSERT INTO `" . $wpdb->prefix ."woocommerce_software_licence` 
                                    (`id`, `order_id`, `order_item_id`, `group_id`, `licence`, `created`, `active_domain`) 
                                    VALUES (NULL, %d, %d, %d, %s, %s, NULL);", $order_id, $order_item_id, $license_group_id, $license_key, $time) );
                    
                }
            
            
                
            /**
            * 
            * Return the licence data using the licence key
            *     
            */
            static public function get_licence_key_data_by_licence_key( $licence_key, $args =   array() )
                {
                    $defaults   =   array(
                                            'domain'                    =>  '',
                                            'product_unique_id'         =>  ''
                                            );
                    
                    $args   =   wp_parse_args( $args, $defaults );
                    extract($args);
                    
                    global $wpdb;
                    $mysql_query    =   '';
                    
                    $mysql_query    = "SELECT wsi.id, wsi.order_id, wsi.id, wsi.order_item_id, wsi.group_id, wsi.licence, wsi.created, wsi.active_domain  FROM `" . $wpdb->prefix ."woocommerce_software_licence` AS wsi ";
                    
                    if( ! empty ( $product_unique_id ) )
                        {
                            $mysql_query .= " JOIN `" . $wpdb->prefix . "woocommerce_order_itemmeta` AS woi ON wsi.order_item_id    =   woi.order_item_id";
                            $mysql_query .= " JOIN `" . $wpdb->postmeta . "` AS pm ";
                        }
                        
                    $mysql_query .= $wpdb->prepare("WHERE licence = %s", $licence_key);
                    
                    
                    if( ! empty ( $domain ) )
                        {
                            $mysql_query .= $wpdb->prepare(" AND active_domain = %s",
                                                $domain);  
                        }
                        
                    if( ! empty ( $product_unique_id ) )
                        {
                            $mysql_query .= $wpdb->prepare(" AND pm.meta_key = '_sl_software_unique_title' AND pm.meta_value = %s AND woi.meta_key = '_product_id' AND woi.meta_value = pm.post_id;", $product_unique_id );  
                        }
                    
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $result = $wpdb->get_row( $wpdb->prepare( $mysql_query . '/* %s */', '' ) );
                    
                    if ( ! $result )
                        return FALSE;
                    
                    return $result;
                }
                
            
            static function get_licence_key_data_by_licence_id($licence_id)
                {
                    global $wpdb;
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $result = $wpdb->get_row( $wpdb->prepare("SELECT * FROM `" . $wpdb->prefix ."woocommerce_software_licence` 
                                                WHERE id = %d",
                                                $licence_id) );
                    
                    return $result;
                }
                
                
            
            /**
            * Return the status of a licence
            * Licence meaning all existing keys
            *     
            * @param mixed $order_item_id
            */
            static public function get_licence_status( $order_item_id )
                {
                    
                    global $wpdb;
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $_soliw_licensing_status  = $wpdb->get_var( $wpdb->prepare( 
                                                            "SELECT meta_value FROM {$wpdb->prefix}woocommerce_order_itemmeta 
                                                                WHERE order_item_id = %d AND meta_key = '_woo_sl_licensing_status'"
                                                            , $order_item_id) );
                    
                    //for compatibilit with old systems, return as being valid
                    if(empty( $_soliw_licensing_status ))
                        $_soliw_licensing_status   =   'active';
                        
                    
                    $_soliw_licensing_status   =   apply_filters('woo_sl/get_licence_status', $_soliw_licensing_status, $order_item_id);     
                        
                    return $_soliw_licensing_status;
                }
            
                
                
            static function get_product_id_from_order_item_id($order_item_id)
                {
                    global $wpdb;
                    
                    //retirve the actual product id from order_item data
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $product_id     =   $wpdb->get_var( $wpdb->prepare("SELECT meta_value FROM ".  $wpdb->prefix ."woocommerce_order_itemmeta
                                                WHERE `order_item_id`   =   %d AND `meta_key` = '_product_id'", $order_item_id) );   
                    
                    return $product_id;    
                }
                
            
            /**
            * Return the status active / inactive of a licence id
            * 
            * @param mixed $licence_id
            * @return boolean True or False
            */
            static function licence_key_is_active($licence_id)
                {
                    $licence_data   =   self::get_licence_key_data_by_licence_id($licence_id);
                    if(!isset($licence_data->id))
                        return FALSE;
                    
                    $is_active =  empty($licence_data->active_domain)   ?   FALSE    :   TRUE;
                    
                    return $is_active;
                    
                }
                
            
            static function get_licence_key_status($licence_id)
                {
                    $licence_data   =   self::get_licence_key_data_by_licence_id($licence_id);
                    if(!isset($licence_data->id))
                        return FALSE;
                    
                    $is_active =  self::licence_key_is_active($licence_id);
                    if($is_active)
                        {
                            $is_active_html =   __('Assigned', 'software-license-lite');
                        }
                        else
                        {
                            $is_active_html =   __('Unassigned', 'software-license-lite');
                        }
                    
                    return $is_active_html;
                }
    
    
            static function domains_hash($domains_raw_text)
                {
                    $domains_hash   =   array();
                    
                    $domains_raw    =   explode(",", $domains_raw_text);
                    $domains_raw    =   array_map("trim", $domains_raw);
                    $domains_raw    =   array_filter($domains_raw);
                    
                    if (count($domains_raw) > 0)
                        {
                            foreach($domains_raw as $domain)
                                {
                                    $domains_hash[$domain]  =   md5($domain);
                                }   
                        }
                        
                    return $domains_hash;
                }
          
          
            /**
            * Return licence key instance
            * 
            * @param mixed $licence_key
            * @param mixed $order_id
            * @param mixed $order_item_id
            */
            static function get_license_key_instances($licence_key, $order_id, $order_item_id )
                {
                    global $wpdb;    
                    
                    //retirve the actual product id from order_item data
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $key_instances     = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `" . $wpdb->prefix ."woocommerce_software_licence`
                                                WHERE `order_id`    =   %d AND `order_item_id`    =   %d AND `licence`   =   %s
                                                ORDER BY id ASC", $order_id, $order_item_id, $licence_key) );   
                    
                    return $key_instances;
                }
                
            static function get_license_key_active_instances( $licence_key, $order_item_id )
                {
                    global $wpdb;    
                    
                    //retirve the actual product id from order_item data
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $key_instances     = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `" . $wpdb->prefix ."woocommerce_software_licence`
                                                WHERE `licence`   =   %s AND `order_item_id`    =   %d AND `active_domain` !=  ''
                                                ORDER BY id ASC", $licence_key, $order_item_id ) );   
                    
                    return $key_instances;
                }
                
                
            static function key_domain_remove($licence_data)
                {
                    global $wpdb; 
                    
                    $key_instances      =   self::get_license_key_instances($licence_data->licence, $licence_data->order_id, $licence_data->order_item_id);
                    
                    if(count($key_instances) < 2)
                        {
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $result = $wpdb->get_results( $wpdb->prepare("UPDATE `" . $wpdb->prefix ."woocommerce_software_licence`
                                            SET `active_domain`    =   ''
                                            WHERE id = %d",
                                            $licence_data->id) );
                        }
                        else
                        {
                            //remove this key instance
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching    
                            $result = $wpdb->get_results( $wpdb->prepare("DELETE FROM `" . $wpdb->prefix ."woocommerce_software_licence`
                                            WHERE id = %d", $licence_data->id) );
                        }   
                    
                }
            
            /**
            * Check if a key is already in the customer key list for a specific order item id
            * 
            * @param mixed $order_id
            * @param mixed $order_item_id
            * @param mixed $license_group_id
            * @param mixed $licence_key
            */
            static public function key_exists_within_customer_keys($order_id, $order_item_id, $license_group_id, $licence_key)
                {
                    
                    $customer_license_keys    =   self::get_order_product_generated_keys($order_id, $order_item_id, $license_group_id);    
                    
                    foreach($customer_license_keys   as  $customer_license_keys)
                        {
                            if($customer_license_keys->licence  ==  $licence_key)
                                {
                                    return TRUE;
                                }
                        }
                    
                    return FALSE;
                    
                }
                
                
            static function interface_get_licence_actions( $licence_id, $domain  =   '', $disabled_buttons =   array() )
                {
                    $is_active  =  self::licence_key_is_active($licence_id);
                    $status     =  self::get_licence_key_status($licence_id);
                    

                    ob_start();
                    
                    do_action('woo_sl/before_interface_licence_actions', $licence_id);
                    
                    if ($is_active   &&  ( ! isset ( $disabled_buttons['deactivate'] )    ||  $disabled_buttons['deactivate']   === FALSE))
                        {
                            ?>
                                <a href="#" onClick="soliw.keyDeactivate(<?php echo esc_attr ( $licence_id ) ?>, '<?php echo esc_html ( wp_create_nonce( 'woo_sl/actions/deactivate/'.$licence_id ) ) ?>');return false;" class="button"><?php esc_html_e("Deactivate", 'software-license-lite') ?></a>   
                            <?php
                        }
                    
                    if ( ! isset($disabled_buttons['delete'])    ||  $disabled_buttons['delete']   === FALSE )
                        {
                    ?>
                    <a href="#" onClick="soliw.keyDelete(<?php echo esc_attr ( $licence_id ) ?>, '<?php echo esc_html ( wp_create_nonce( 'woo_sl/actions/delete/'.$licence_id ) ) ?>');return false;" class="button"><?php esc_html_e("Delete", 'software-license-lite') ?></a>   
                    <?php
                        }
                        
                    do_action('woo_sl/after_interface_licence_actions', $licence_id);
                    
                    $html = ob_get_contents();
                    ob_end_clean();
                    
                    return $html; 
                
                }
            
            static function interface_licence_block($license_keys)
                {
                    
                    if(count($license_keys)     <   1)
                        {
                            ?>
                                <tr class="no_key">
                                    <td colspan="4"><?php esc_html_e("No keys", 'software-license-lite') ?></td>
                                </tr>   
                             <?php
                        }
                        else
                        {
                            ?>
                                <tr class="no_key" style="display: none">
                                    <td colspan="4"><?php esc_html_e("No keys", 'software-license-lite') ?></td>
                                </tr>   
                             <?php
                            
                            foreach($license_keys   as  $license_data)
                                {
                                    
                                    //check for key active on multiple domains
                                    $key_instances      =   self::get_license_key_instances($license_data->licence, $license_data->order_id, $license_data->order_item_id );
                                                       
                                    $args =     array();
                                    foreach($key_instances as  $key    =>  $key_instance)
                                        {
                                            $show_key   =   ($key < 1)  ?   TRUE    :   FALSE;
                                            
                                            $args['show_key']       =   $show_key;
                                            $args['domain']         =   $key_instance->active_domain;
                                            
                                            $allowed_tags = array(
                                                                'tr'     => array(
                                                                    'data-licence_id' => array(),
                                                                ),
                                                                'td'   => array(
                                                                    'class' => array(),
                                                                    'id'    => array(),
                                                                ),
                                                                'b'      => array(),
                                                                'a' => array(
                                                                    'href' => array(),
                                                                    'onclick' => array(),
                                                                    'class' => array(),
                                                                ),
                                                            );
                                            
                                            echo wp_kses ( self::interface_get_licence_row($key_instance->id, $args), $allowed_tags );
                                        }
                         
                                }
                                
                        }
    
                }
                
            static function interface_get_licence_row( $licence_id, $args = array())
                {
                    $defaults   =   array(
                                            'show_key'      =>  true,
                                            'domain'        =>  ''
                                            );
                    
                    $args   =   wp_parse_args( $args, $defaults );
                    extract($args);
                    
                    $licence_data   =   self::get_licence_key_data_by_licence_id($licence_id);
                    if(!isset($licence_data->id))
                        return '';
                    
                    $is_active  =  self::licence_key_is_active($licence_id);
                    $status     =  self::get_licence_key_status($licence_id);
                    
                    ob_start();
                    
                    ?>
                        <tr data-licence_id="<?php echo esc_attr ( $licence_id ) ?>">
                            <td class="woo-sl-key"><?php if($show_key) {    echo esc_attr ( $licence_data->licence ); }   ?></td>
                            <td class="woo-sl-status"><?php echo esc_html ( $status ) ?></td>
                            <td class="woo-sl-domain"><?php echo esc_html ( $domain ) ?></td>
                            <td class="woo-sl-action"><?php 
                            
                                $disabled_buttons =   array();
                                if($show_key    === FALSE)
                                    $disabled_buttons['delete']   =   TRUE;
                                                                    
                                $disabled_buttons =   apply_filters('woo_sl/license_manage/disabled_buttons', $disabled_buttons, $licence_data->id, $domain);     
                                
                                $allowed_tags = array(
                                                                'b'      => array(),
                                                                'a' => array(
                                                                    'href' => array(),
                                                                    'onclick' => array(),
                                                                    'class' => array(),
                                                                ),
                                                            );
                                
                                echo wp_kses ( self::interface_get_licence_actions( $licence_data->id, $domain, $disabled_buttons ), $allowed_tags ); 
                                
                                ?></td>
                
                            <?php 
                            
                                //Deprecated, use the next action
                                do_action( 'woo_sl/admin_order/license_keys_meta_box/td',  $licence_id, $args );
                                
                                do_action( 'woo_sl/interface/license_keys_meta_box/td',  $licence_id, $args ) 
                                
                            ?>
                
                        </tr>
                    <?php
                    
                    $html = ob_get_contents();
                    ob_end_clean();
                    
                    return $html;   
                    
                }
                
                
            static function interface_get_sl_product_select($order_licence_details)
                {
                    ob_start();
                    
                    ?><select onChange="soliw.select_description_update()" name="sl_product" id="sl_product_id">
                    <?php
                                                    
                        if ( count ( $order_licence_details ) > 0 )
                            {
                                foreach($order_licence_details  as  $order_item_id  =>  $order_item_licence_details)
                                    {
                                        foreach ($order_item_licence_details as $licence_group_id   =>  $product_licence_data)
                                            {
                                                $available = FALSE;
                                                $remaining = '0';
                                                
                                                $order_product_data = SOLIW_functions::get_order_product_data($product_licence_data->order_id, $product_licence_data->order_item_id);
                                                
                                                $max_keys   =   $product_licence_data->license_data['max_keys'];
                                                
                                                if( $max_keys == ''    ||  $max_keys  < 0 )
                                                    {
                                                        $available = TRUE;
                                                        $remaining = __('Unlimited', 'software-license-lite');
                                                    }
                                                    else
                                                    {
                                                        $max_keys   =   $max_keys   *      $order_product_data->get_quantity();
                                                        $max_keys   =   apply_filters( 'woo_sl/max_keys/applied_order_quantity', $max_keys, $order_product_data );
                                                        if( $max_keys >    0 && $product_licence_data->generated_keys < $max_keys)
                                                            {
                                                                $available = TRUE;
                                                                $remaining = $max_keys - $product_licence_data->generated_keys;    
                                                            }        
                                                    }
                                                
                                                $title  = '<b>'. esc_html ( $order_product_data['name'] ) .'</b> &rarr; '. esc_html ( $product_licence_data->license_data['group_title'] )  .' (' . esc_html('Licence Keys Left', 'software-license-lite') . ' '.  esc_html ( $remaining ) .')';
                                                                                        
                                                ?><option data-description-group="<?php echo esc_attr ( $product_licence_data->license_data['group_title'] ) ?>" data-description-max-keys="<?php echo esc_attr ( $max_keys ) ?>" data-description-instances-per-keys="<?php echo esc_attr ( $product_licence_data->license_data['max_instances_per_key'] ) ?>" data-description-in-use-keys="<?php echo esc_attr ( $product_licence_data->generated_keys ) ?>" <?php if ( $available === FALSE ) {echo 'disabled="disabled" ';} ?>value="<?php echo esc_attr ( $product_licence_data->order_id ) ?>,<?php echo esc_attr ( $product_licence_data->order_item_id ) ?>,<?php echo esc_attr ( $product_licence_data->group_id ) ?>"><?php 
                                                    
                                                    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                    echo $title;
                                                    
                                                ?></option><?php
                                                
                                            }
                                    }
                            }   
                    
                        do_action( 'woo_sl/interface/sl_product_id_select_option' );
                        
                    ?>
                    </select><?php
                    
                    $html   =   ob_get_contents();
                    ob_end_clean();
                    
                    return $html;   
                    
                }

                
            static function is_order_completed( $order_id )
                {
                    //check if not a woocommerce subscription 
                    if ( self::is_woocommerce_subscription ( $order_id ) )
                        return TRUE;
                        
                    $order     = new WC_Order($order_id);
                    
                    if($order->get_status()  !=  "completed")
                        return FALSE;
                        
                    return TRUE;
                }
                
            
            /**
            * Check if the Order ID is a WooCommerce Subscription
            *     
            * @param mixed $order_id
            */
            static public function is_woocommerce_subscription ( $order_id )
                {
                    if ( self::is_HPOS_active() )
                        {
                            global $wpdb;
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $type           =   $wpdb->get_var( $wpdb->prepare ( "SELECT type FROM {$wpdb->prefix}wc_orders WHERE id = %d", $order_id ) );
                            if ( $type == 'shop_subscription' )
                                return TRUE;
                            
                        }
                        else
                        {
                            $order_post  =   get_post( $order_id );
                            if ( $order_post->post_type ==  'shop_subscription' )
                                return TRUE;
                        }
                        
                    return FALSE;   
                }
            
            /**
            * HPOS
            * Return the meta for the order id
            * 
            * @param mixed $order_id
            * @param mixed $meta_key
            */
            static function get_order_meta( $order_id, $meta_key, $unique = TRUE )
                {
                    global $wpdb;
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $item_meta_value  = $wpdb->get_var( $wpdb->prepare( "SELECT meta_value FROM {$wpdb->prefix}wc_orders_meta 
                                                                WHERE order_id = %d AND meta_key = %s", $order_id, $meta_key) );
                    
                    $item_meta_value    =   maybe_unserialize($item_meta_value);
                    
                    if ( is_null ( $item_meta_value ) )
                        $item_meta_value    =   '';
                    
                    return $item_meta_value;
                }
                
            static function get_order_item_meta($order_id, $meta_key)
                {
                    global $wpdb;
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $item_meta_value  = $wpdb->get_var( $wpdb->prepare( "SELECT meta_value FROM {$wpdb->prefix}woocommerce_order_itemmeta 
                                                                WHERE order_item_id = %d AND meta_key = %s", $order_id, $meta_key) );
                    
                    $item_meta_value    =   maybe_unserialize($item_meta_value);
                    
                    if ( is_null ( $item_meta_value ) )
                        $item_meta_value    =   '';
                    
                    return $item_meta_value;
                }
                
            
            /**
            * Use alternative method to wc_update_order_item_meta when default functin not available
            *     
            * @param mixed $order_id
            * @param mixed $meta_key
            */
            static function update_order_item_meta( $order_item_id, $meta_key, $meta_value )
                {
                    global $wpdb;
                    
                    //check if the entry exists
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $meta_id                                =   $wpdb->get_var( $wpdb->prepare( 
                                                            "SELECT meta_id FROM {$wpdb->prefix}woocommerce_order_itemmeta
                                                                WHERE order_item_id = %d AND meta_key = %s"
                                                            , $order_item_id, $meta_key ) );
                    
                    $meta_value =   maybe_serialize( $meta_value );
                    
                    if  (  $meta_id > 0 ) 
                        {
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $results  = $wpdb->get_results( $wpdb->prepare( 
                                                                    "UPDATE {$wpdb->prefix}woocommerce_order_itemmeta
                                                                        SET meta_value  =   %s 
                                                                        WHERE meta_id   =   %d"
                                                                    , $meta_value, $meta_id ) );   
                        }
                        else
                        {
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $results  = $wpdb->get_results( $wpdb->prepare( 
                                                                    "INSERT INTO {$wpdb->prefix}woocommerce_order_itemmeta
                                                                        (order_item_id, meta_key, meta_value) 
                                                                        VALUES( %d, %s, %s)"
                                                                    , $order_item_id, $meta_key, $meta_value ) );   
                            
                        }
    
                }
            
            
            /**
            * 
            * This will create the required tables and run the necesarelly updates for existing
            *     
            */
            function create_tables()
                {
                    global $wpdb;
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange  
                    $results = $wpdb->get_results( $wpdb->prepare( "CREATE TABLE IF NOT EXISTS `". $wpdb->prefix ."woocommerce_software_licence` (
                                  `id` int(11) NOT NULL AUTO_INCREMENT,
                                  `order_id` int(11) NOT NULL,
                                  `order_item_id` int(11) NOT NULL,
                                  `group_id` int(11) NOT NULL,
                                  `licence` varchar(256) NOT NULL,
                                  `created` datetime NOT NULL,
                                  `active_domain` varchar(256) DEFAULT NULL,
                                  PRIMARY KEY  (`id`)
                                ) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ; "  . '/* %s */', '' ) );
                          
                }
            
            
            /**
            * Add licence data to the order items
            * 
            * @param mixed $order_id
            * @param mixed $posted
            * @_setup_for_order_items
            * 
            * If $_setup_for_order_items include order items ids, the set-up occours only for those
            */
            function order_setup_licensing( $order, $posted = array(), $_setup_for_order_items   =   array() )
                {
                    
                    // phpcs:ignore WordPress.Security.NonceVerification.Missing 
                    if  ( isset( $_POST['wc_order_action'] ) && ! empty ( $_POST['wc_order_action']  ) )
                        return;
                    
                    if ( is_object ( $order ) )
                        $order_id   =   $order->get_ID();
                        else
                        $order_id   =   $order;
                         
                    //allow other plugins to intract e.g. woocommerce subscriptions
                    if (  apply_filters( 'woo_sl/order_setup_licensing/ignore', FALSE, $order_id ) )
                        return;
                    
                    //check if order contain any licensed product
                    $order_data     = new WC_Order($order_id);
    
                    //if is within the admin interface, continue only if is draft, as order is being created through admin
                    //if ( is_admin()   &&  $order_data->get_status()   !=  'draft' )
                        //return;
    
                    $order_items =   $order_data->get_items();
                         
                    $_soliw    =   array();
                    
                    //get the order items
                    foreach ( $order_items as $key   =>  $order_item ) 
                        {
                                
                            if ( count ( $_setup_for_order_items ) > 0  &&  ! in_array ( $key, $_setup_for_order_items ) )
                                continue;   
                            
                            if( ! $this->is_product_licensed( $order_item->get_product_id() ))
                                continue;
                            
                            $is_licence_extend  =   FALSE;
                            $_soliw_extend     =   wc_get_order_item_meta($key, '_woo_sl_extend', TRUE);
                            if(!empty($_soliw_extend))
                                $is_licence_extend  =   TRUE;
                                
                            //no need to process if is an licence extend
                            if (    $is_licence_extend  )
                                continue;
                                
                            //check against the variation, if assigned a licence group
                            if( $order_item->get_variation_id()   > 0)
                                {
                                    $variation_license_group_id =   get_post_meta( $order_item->get_variation_id(), '_sl_license_group_id', TRUE);
                                    if($variation_license_group_id  ==  "")
                                        continue;                                                                                                                                                
                                }

                            //get product licensing details
                            $product_sl_groups     =   self::get_product_licensing_groups( $order_item->get_product_id() );
                            
                            //if variation, filter out the licence groups
                            if( $order_item->get_variation_id()   >   0)
                                {
                                    if(isset($product_sl_groups[$variation_license_group_id]))
                                        {
                                            $_product_sl_groups  =   $product_sl_groups;
                                            $product_sl_groups  =   array();   
                                            $product_sl_groups[$variation_license_group_id]  =   $_product_sl_groups[$variation_license_group_id];
                                        }
                                        else
                                        $product_sl_groups  =   array();
                                }    
                            
                            $_group_title                       =   array();
                            $_licence_prefix                    =   array();
                            $_max_keys                          =   array();
                            $_max_instances_per_key             =   array();
                            $_use_predefined_keys               =   array();
                            $_product_use_expire                =   array();
                            $_product_expire_renew_price        =   array();
                            $_product_expire_units              =   array();
                            $_product_expire_time               =   array();
                            $_product_expire_starts_on_activate =   array();
                            $_product_expire_disable_update_link=   array();
                            $_product_expire_limit_api_usage    =   array();
                            $_product_expire_notice             =   array();
                            
                            foreach($product_sl_groups  as  $product_sl_group)
                                {
                                    $_group_title[]                     =   $product_sl_group['group_title'];
                                    $_licence_prefix[]                  =   $product_sl_group['licence_prefix'];
                                    //$_max_keys[]                =   $product_sl_group['max_keys']   *   intval($order_product['qty']);
                                    $_max_keys[]                        =   $product_sl_group['max_keys'];
                                    $_max_instances_per_key[]           =   $product_sl_group['max_instances_per_key'];
                                    $_use_predefined_keys[]             =   $product_sl_group['use_predefined_keys'];
                                    
                                    $_product_use_expire[]                =   $product_sl_group['product_use_expire'];
                                    $_product_expire_renew_price[]        =   wc_format_decimal ( $product_sl_group['product_expire_renew_price'] );
                                    $_product_expire_units[]              =   $product_sl_group['product_expire_units'];
                                    $_product_expire_time[]               =   $product_sl_group['product_expire_time'];
                                    $_product_expire_starts_on_activate[] =   $product_sl_group['product_expire_starts_on_activate'];
                                    $_product_expire_disable_update_link[]=   $product_sl_group['product_expire_disable_update_link'];
                                    $_product_expire_limit_api_usage[]    =   $product_sl_group['product_expire_limit_api_usage'];
                                    $_product_expire_notice[]             =   $product_sl_group['product_expire_notice'];
                                }
                            
                            $data   =   array();
                            $data['group_title']                            =   $_group_title;
                            $data['licence_prefix']                         =   $_licence_prefix;
                            $data['max_keys']                               =   $_max_keys;
                            $data['max_instances_per_key']                  =   $_max_instances_per_key;
                            $data['use_predefined_keys']                    =   $_use_predefined_keys;
                            $data['product_use_expire']                     =   $_product_use_expire;
                            $data['product_expire_renew_price']             =   $_product_expire_renew_price;
                            $data['product_expire_units']                   =   $_product_expire_units;
                            $data['product_expire_time']                    =   $_product_expire_time;
                            $data['product_expire_starts_on_activate']      =   $_product_expire_starts_on_activate;
                            $data['product_expire_disable_update_link']     =   $_product_expire_disable_update_link;
                            $data['product_expire_limit_api_usage']         =   $_product_expire_limit_api_usage;
                            $data['product_expire_notice']                  =   $_product_expire_notice;
                            
                            
                            $data   =   apply_filters('woo_sl/order_processed/product_sl', $data, $order_item, $order_id);
                            
                            wc_update_order_item_meta($key, '_woo_sl', $data);
                            
                            //set currently as inactive
                            wc_update_order_item_meta($key, '_woo_sl_licensing_status', 'inactive');
                                
                            foreach ( $data['product_use_expire']    as  $data_key    =>  $data_block_value )
                                {
                                    if ( $data_block_value    !=  'no' )
                                        {
                                            wc_update_order_item_meta($key, '_woo_sl_licensing_using_expire', $data_block_value );
                                    
                                            //continue only if expire_starts_on_activate is not set to yes
                                            $expire_starts_on_activate  =   $data['product_expire_starts_on_activate'][$data_key];
                                            if ( $expire_starts_on_activate ==  'yes' )
                                                {
                                                    //set currently as not-activated
                                                    wc_update_order_item_meta($key, '_woo_sl_licensing_status', 'not-activated');
                                                    continue;
                                                }
                                    
                                            if ( $data_block_value    ==  'yes' )
                                                {
                                                    $start_at   =   time();
                                                    wc_update_order_item_meta($key, '_woo_sl_licensing_start', $start_at);
                                                                                                
                                                    $_sl_product_expire_units   =   $data['product_expire_units'][$data_key];
                                                    $_sl_product_expire_time    =   $data['product_expire_time'][$data_key];
                                                    
                                                    $expire_at  =   strtotime( " + " . $_sl_product_expire_units . " " . $_sl_product_expire_time,  $start_at );
                                                      
                                                    wc_update_order_item_meta( $key, '_woo_sl_licensing_expire_at', $expire_at );
                                                    
                                                    wc_delete_order_item_meta( $key, '_woo_sl_licensing_expired_at' );
                                                }
                                        }
                                }
                            
                        }

                }
            
                            
                
            /**
            * Order status changed to completed
            *     
            * @param mixed $order_id
            */
            function complete_order_licensing_setup( $order_id )
                {
                    
                    if (  apply_filters( 'woo_sl/order_setup_licensing/ignore', FALSE, $order_id ) )
                        return;
                    
                    $order_data     = new WC_Order($order_id);
                    
                    $order_items =   $order_data->get_items();
                               
                    //get the order items
                    foreach ( $order_items as $order_item_id   =>  $order_item_data ) 
                        {
                            //ensure the item is not a subscription
                            $order_item_product =   $order_item_data->get_product();
                            if ( $order_item_data->get_type() == 'shop_order'    &&  in_array ( $order_item_product->get_type(), array ( 'subscription', 'variable-subscription' ) ) )
                                continue;
                            
                            if (    !   self::is_order_item_licensed ( $order_id, $order_item_id )  &&  empty ( $order_item_data->get_meta( '_woo_sl_extend') ) )
                                continue;
                            
                            $this->setup_licensing_for_order_item( $order_item_id, $order_item_data->get_product_id() );

                        }
                    
                }
                
            
            
            /**
            * Setup licensing data for Order Item
            *     
            * @param mixed $order_item_id
            * @param mixed $order_product
            */
            function setup_licensing_for_order_item( $order_item_id,  $product_id )
                {
                    
                    //check if is an extend
                    $_soliw_extend     =   wc_get_order_item_meta($order_item_id, '_woo_sl_extend', TRUE);
                    
                    if( empty($_soliw_extend) &&    $this->is_product_licensed( $product_id ))
                        {
                            $_soliw                    =   self::get_order_item_meta( $order_item_id ,  '_woo_sl',  TRUE);
                            
                            if ( empty  ( $_soliw ) )
                                return;
                            
                            $found_product_expire_starts_on_activate    =   FALSE;
                            foreach ( $_soliw['product_use_expire']    as  $key    =>  $data_block )
                                {
                                    if ( $data_block    ==  'yes' )
                                        {
                                            //continue only if expire_starts_on_activate is not set to yes
                                            $expire_starts_on_activate  =   $_soliw['product_expire_starts_on_activate'][$key];
                                            if ( $expire_starts_on_activate ==  'yes' )
                                                {
                                                    $found_product_expire_starts_on_activate    =   TRUE; 
                                                    wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_status', 'not-activated');   
                                                }
                                        }
                                }
                            
                            //mark the licensing status as active as the order is completed    
                            if ( $found_product_expire_starts_on_activate   === FALSE )
                                wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_status', 'active');  
                        }
                        
                    //check if is extend
                    $is_licence_extend  =   FALSE;
                    if(!empty($_soliw_extend))
                        {
                            $_soliw_extend_for    =   wc_get_order_item_meta($order_item_id, '_woo_sl_extend_for', TRUE);
                            
                            //$order_id              =   self::get_order_by_item_id( $_soliw_extend_for );
                            //$order_data            =   new WC_Order($order_id);
                            
                            //change licensing status
                            wc_update_order_item_meta($_soliw_extend_for, '_woo_sl_licensing_status', 'active');
                            
                            //retrieve licence expire details
                            $_soliw                    =   self::get_order_item_meta( $_soliw_extend_for ,  '_woo_sl',  TRUE);
                            reset($_soliw['product_expire_units']);
                            $_sl_product_expire_units   =   current($_soliw['product_expire_units']);
                            reset($_soliw['product_expire_time']);
                            $_sl_product_expire_time    =   current($_soliw['product_expire_time']);

                            //increase the expiration date
                            
                            $today  =   strtotime( gmdate("Y-m-d H:i:s"), time() );
                            $current_expiration         =   wc_get_order_item_meta($_soliw_extend_for, '_woo_sl_licensing_expire_at', TRUE);
                            
                            $woocommerce_licensing_extend_start_at_default   =   $this->get_option('woocommerce_licensing_extend_start_at_default');
                                                
                            if ( $woocommerce_licensing_extend_start_at_default == 'yes' )
                                {
                                    if ( empty ( $current_expiration ) )
                                        $current_expiration =   wc_get_order_item_meta ( $_soliw_extend_for, '_woo_sl_licensing_expired_at', TRUE );
                                           
                                    $expire_at  =   strtotime( " + " . $_sl_product_expire_units . " " . $_sl_product_expire_time,  $current_expiration);    
                                }
                                else
                                {
                                    if( $current_expiration  <   $today  )
                                        {
                                            //if expired use today
                                            
                                            $expire_at  =   strtotime( " + " . $_sl_product_expire_units . " " . $_sl_product_expire_time, $today );
                                                    
                                        }
                                        else
                                        {
                                            //if not expired extend the date                                            
                                            $expire_at  =   strtotime( " + " . $_sl_product_expire_units . " " . $_sl_product_expire_time,  $current_expiration);
                                        }
                                }
                                
                            $expire_at_date =   gmdate("Y-m-d H:i:s", $expire_at);
                            $expire_at      =   strtotime( $expire_at_date );

                            wc_update_order_item_meta( $_soliw_extend_for, '_woo_sl_licensing_expire_at', $expire_at);
                            
                            wc_delete_order_item_meta( $_soliw_extend_for, '_woo_sl_licensing_expired_at' );
                            
                            //remove any triggered reminder expire emails
                            wc_delete_order_item_meta($_soliw_extend_for, '_woo_sl_expire_triggered_emails');
                            
                            //remove any donwload access limitation
                            $extend_for_order_id            =   $this->get_order_by_item_id( $_soliw_extend_for );
                            
                            $order_item_product      =   new WC_Order_Item_Product ( $order_item_id );
                            $order_item_product_id   =  $order_item_product->get_variation_id() > 0 ?   $order_item_product->get_variation_id() :   $order_item_product->get_product_id(); 
                            
                            $permission_id                  =   $this->get_permission_id_from_order_id_product_id( $extend_for_order_id, $order_item_product_id );
                            if ( ! empty ($permission_id ) )
                                {
                                    //use the first group
                                    reset( $_soliw['group_title'] );
                                    $use_key    =   key( $_soliw['group_title'] );
                                    
                                    $expire_disable_update_link =   $_soliw['product_expire_disable_update_link'][$use_key];
                                    
                                    if ( $expire_disable_update_link == 'yes' )
                                        $this->update_expiration_for_permission($permission_id, gmdate ( "Y-m-d H:i:s", $expire_at ) );
                                        else
                                        $this->update_expiration_for_permission($permission_id, '');
                                }
                            
                        }    
                    
                    
                }
                
                
            
            /**
            * Generate a key for each products within the order
            * 
            * @param mixed $order_id
            */
            function generate_license_keys( $order_id )
                {
                    //check if order contain any licensed product
                    $order_data     = new WC_Order( $order_id );
    
                    $order_products =   $order_data->get_items();
                    
                    $found_licensed_product =   FALSE;
                    foreach($order_products as  $key    =>  $order_product)
                        {
                            if (SOLIW_functions::is_product_licensed($order_product->get_product_id()))
                                {
                                    $found_licensed_product =   TRUE;
                                    break;   
                                }
                        }
                        
                    if(!$found_licensed_product)
                        return;
                    
                    //get the order items
                    foreach ( $order_products as $order_item_id   =>  $order_product ) 
                        {
                            if(! $this->is_product_licensed($order_product->get_product_id()))
                                continue;
                                
                            $_soliw    =   self::get_order_item_meta($order_item_id,  '_woo_sl',  TRUE);
                            if(!    is_array($_soliw))
                                continue;
                            
                            foreach($_soliw['group_title']    as  $key    =>  $_group_title)
                                {
                                    $license_keys   =   (array)SOLIW_functions::get_order_product_generated_keys($order_id, $order_item_id, $key);
                                    if(count($license_keys) > 0)
                                        continue;
                                    
                                    //allow to change the number of keys to be generated; default is 1
                                    $generate_keys_count  =   apply_filters( 'woo_sl/generate_licence_keys_count', 1, $order_id, $order_item_id, $key );
                                        
                                    $new_licence_keys = SOLIW_functions::generate_license_key($order_id, $order_item_id, $key, $generate_keys_count, TRUE );
                                }

                        }

                }
                
                
            /**
            * Trigger whenever an order status changed
            * 
            * @param mixed $order_id
            * @param mixed $old_status
            * @param mixed $new_status
            */
            function woocommerce_order_status_changed( $order_id, $old_status, $new_status)
                {
                    global $SOLIW;
                    
                    //ignore if WooCOmmerce Subscription renewal
                    if ( self::is_HPOS_active() )
                        $_subscription_renewal  =   self::get_order_meta( $order_id, '_subscription_renewal' );
                        else
                        $_subscription_renewal  =   get_post_meta( $order_id, '_subscription_renewal', TRUE );
                    if ( ! empty ( $_subscription_renewal ) )
                        return;
                    
                    $SOLIW->order_status_changed   =   TRUE;
                             
                    $order_data     = new WC_Order($order_id);
                    
                    $order_items =   $order_data->get_items();
                    
                    $license_active_for_status  =   apply_filters( 'woo_sl/active_for_status', array ( 'completed' ) );
                    
                    $woocommerce_licensing_grant_access_after_payment   =   $this->get_option('woocommerce_licensing_grant_access_after_payment');
                    if( $woocommerce_licensing_grant_access_after_payment !=  'yes' )
                        $license_active_for_status[]    =   'processing';
                    
                    //iterate all order items and check for any licence
                    foreach( $order_items    as  $order_item_id  =>  $order_item )
                        {
                            if ( self::is_order_item_licensed ( $order_id , $order_item_id ) )
                                {
                                    if( in_array ( $new_status, $license_active_for_status ) !==  FALSE )
                                        {
                                            //not if item status is not-activated
                                            $current_status =   wc_get_order_item_meta( $order_item_id, '_woo_sl_licensing_status', TRUE );
                                            if ( $current_status    ==  'not-activated' )
                                                continue;
                                            
                                            wc_update_order_item_meta( $order_item_id, '_woo_sl_licensing_status', 'active' );
                                            
                                            //if using default expire, update the download permission expiry
                                            $soliw_licensing_using_expire  =   $this->get_order_item_meta( $order_item_id,  '_woo_sl_licensing_using_expire',  TRUE);
                                            if ( $soliw_licensing_using_expire == 'yes' )
                                                $this->woocommerce_grant_product_download_permissions( $order_id );
                                                
                                            wc_delete_order_item_meta( $order_item_id, '_woo_sl_licensing_expired_at');
                                            
                                            //generate a key if not already 
                                            $_soliw    =   self::get_order_item_meta( $order_item_id,  '_woo_sl',  TRUE);
                                            if( is_array($_soliw ) )
                                                {
                                                    foreach($_soliw['group_title']    as  $key    =>  $_group_title)
                                                        {
                                                            $license_keys   =   (array)SOLIW_functions::get_order_product_generated_keys($order_id, $order_item_id, $key);
                                                            if(count($license_keys) > 0)
                                                                continue;
                                                            
                                                            //allow to change the number of keys to be generated; default is 1
                                                            $generate_keys_count  =   apply_filters( 'woo_sl/generate_licence_keys_count', 1, $order_id, $order_item_id, $key);
                                                                
                                                            $new_licence_keys = SOLIW_functions::generate_license_key($order_id, $order_item_id, $key, $generate_keys_count, TRUE );
                                                        }
                                                }
                                            
                                        }
                                        else
                                        {
                                            wc_update_order_item_meta( $order_item_id, '_woo_sl_licensing_status', 'inactive');
                                            
                                            if ( in_array ( $new_status, array ( 'refunded', 'failed', 'cancelled'  ) )) 
                                                {
                                                    $expire_at    =   $this->get_order_item_meta( $order_item_id,  '_woo_sl_licensing_expire_at',  TRUE );
                                                    if ( ! empty ( $expire_at ) )
                                                        {
                                                            wc_delete_order_item_meta( $order_item_id, '_woo_sl_licensing_expire_at');
                                                            
                                                            wc_update_order_item_meta( $order_item_id, '_woo_sl_licensing_expired_at', $expire_at);
                                                        }
                                                        
                                                    //restrict the downloads
                                                    $order_item_product     =   new WC_Order_Item_Product( $order_item_id );
                                                    $product                =   $order_item_product->get_product();
                                                    $product_id             =   $product->get_ID();
                                                    
                                                    $permission_id                  =   $this->get_permission_id_from_order_id_product_id( $order_id, $product_id );
                                                    
                                                    if ( $permission_id > 0 )
                                                        {
                                                            $this->update_expiration_for_permission( $permission_id, gmdate("Y-m-d H:i:s",  time() ) );
                                                        }
                                                }
                                                                          
                                            
                                        }
                                }     
                            
                        }
                    
                }
         
         
            
            function woocommerce_order_fully_refunded( $order_id, $refund_id)
                {
                    
                    $order_data     = new WC_Order($order_id);
                    
                    $order_products =   $order_data->get_items();
                    
                    //iterate all order items and check for any licence
                    foreach( $order_products    as  $order_item_id  =>  $order_data )
                        {
                            
                            if ( self::is_order_item_licensed ( $order_id , $order_item_id ) )
                                {
                                    wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_status', 'inactive');
                                }     
                            
                            
                        }
                    
                }
                
                
            
            /**
            * set the expiration for downloadable items
            * 
            * @param mixed $order_id
            */
            function woocommerce_grant_product_download_permissions( $order_id )
                {
                    
                    $order_data     = new WC_Order( $order_id );
    
                    $order_items =   $order_data->get_items();
                                                
                    foreach ( $order_items as $order_item_id     =>  $order_item )    
                        {
                            if(! SOLIW_functions::is_product_licensed( $order_item->get_product_id()))
                                continue;
                                
                            if( ! SOLIW_functions::order_item_using_licence_expire( $order_id, $order_item_id ) )
                                continue;
               
                            $_order_item_licence_status =   wc_get_order_item_meta( $order_item_id, '_woo_sl_licensing_status', TRUE );
                              
                            $order_item_product     =   new WC_Order_Item_Product( $order_item_id );
                            $product                =   $order_item_product->get_product();
                            $product_id             =   $product->get_ID();
                            
                            $permission_id                  =   $this->get_permission_id_from_order_id_product_id( $order_id, $product_id );
                            
                            if ( $permission_id > 0 )
                                {
                                    $permission_expire_at           =   wc_get_order_item_meta($order_item_id, '_woo_sl_licensing_expire_at', TRUE );
                                    $permission_expire_at           =   ( $permission_expire_at > 0 ) ?     gmdate ( "Y-m-d H:i:s", $permission_expire_at ) :   '';
                                    
                                    switch (strtolower( $_order_item_licence_status) )
                                        {
                                            case 'active'   :
                                                                $this->update_expiration_for_permission($permission_id, $permission_expire_at);
                                                                break;   
                                            
                                            case 'not-activated'   :
                                                                //nothing to do
                                                                break;
                                            
                                            default:
                                                                
                                                                break;
                                            
                                        }
                                }
                                                
                        }    
                    
                }
         
            
            function woocommerce_order_item_meta_end ( $order_item_id, $order_item, $order, $plain_text, $args  =   array() )
                {
                    $order_status   =   $order->get_status();
                    
                    $_include_statuses      =   isset ( $args['include_statuses'] ) ?   $args['include_statuses']   :   array ();   
                    $_hide_inactive_status  =   isset ( $args['hide_inactive_status'] ) ?   $args['hide_inactive_status']   :   FALSE;
                                        
                    $generate_license_for_status    =   array ( 'completed' );
                    $woocommerce_licensing_grant_access_after_payment   =   $this->get_option('woocommerce_licensing_grant_access_after_payment');
                    if( $woocommerce_licensing_grant_access_after_payment !=  'yes' )
                        $generate_license_for_status[]    =   'processing';
                    
                    $generate_license_for_status    =   apply_filters( 'woo_sl/generate_license_for_status', array_merge ( $generate_license_for_status, $_include_statuses ), $order_item_id, $order_item, $order ) ;
                    
                    //if( $woocommerce_licensing_grant_access_after_payment ==  'yes' && $order_status    !=  'completed' )
                    if( $woocommerce_licensing_grant_access_after_payment ==  'yes' && array_search ( $order_status, $generate_license_for_status ) === FALSE )
                        {
                            return;   
                        }
                    /*
                    if( $woocommerce_licensing_grant_access_after_payment ==  'yes' && array_search ( 'processing',  $generate_license_for_status )  !==  FALSE )
                        {
                            unset ( $generate_license_for_status [ array_search ( 'processing',  $generate_license_for_status ) ] );
                            unset ( $generate_license_for_status [ array_search ( 'on-hold',  $generate_license_for_status ) ] );
                        }
                        
                    if ( array_search ( $order_status,  $generate_license_for_status )  ===  FALSE )
                        return;
                    */
                                        
                    $order_products =   $order->get_items();
                    
                    $_product       =   $order_item->get_product();
                    
                    if ( $_product && $_product->exists() ) 
                        {
                            if(! $this->is_product_licensed( $order_item->get_product_id() ))
                                return;        
                            
                            $is_licence_extend  =   FALSE;
                            $_soliw_extend     =   wc_get_order_item_meta( $order_item_id, '_woo_sl_extend', TRUE);
                            if(!empty($_soliw_extend))
                                $is_licence_extend  =   TRUE;
                            
                            if( $is_licence_extend)
                                {
                                    ob_start(); 
                                    
                                    $_soliw_extend_for    =   wc_get_order_item_meta( $order_item_id, '_woo_sl_extend_for', TRUE);
                                    $order_id              =   self::get_order_by_item_id( $_soliw_extend_for );
                                    $order_data            =   new WC_Order($order_id);
                                    
                                    //show only if order is completed
                                    if( $order->get_status() ==  'completed' ) {
                                    ?>
                                         <p class="woo-sl-info"><small><?php esc_html_e ( 'Expiration date is', 'software-license-lite') ?> <time><b><?php   
                                         
                                            $expiration_timestamp   =   self::get_order_item_meta($_soliw_extend_for,  '_woo_sl_licensing_expire_at',  TRUE);
                                            echo esc_html ( date_i18n( get_option( 'date_format' ), $expiration_timestamp ) );
                                         
                                         ?></b></time></small></p>
                                    <?php } ?>
                                         <p class="woo-sl-info"><small><?php esc_html_e (  'View related', 'software-license-lite' ) ?> <a href="<?php
                                         
                                         
                                         $view_order_url        =   wc_get_endpoint_url( 'view-order', $order_data->get_id(), wc_get_page_permalink( 'myaccount' ) );

                                         echo esc_url ( apply_filters( 'woocommerce_get_view_order_url', $view_order_url, $order_data ) );
                                         
                                         
                                         ?>" class="button small"><?php esc_html_e (  'Order', 'software-license-lite' ) ?></a></small></p>
                                    <?php
                                    
                                    $html   =   ob_get_clean();
                                    
                                    $html   =   apply_filters('woo_sl/html/licensing_details', $html, $order_item_id, $order_item, $order );
                                    
                                    $allowed_tags = array(
                                                                'p'   => array(
                                                                    'class' => array(),
                                                                    'id'    => array(),
                                                                ),
                                                                'small'      => array(),
                                                                'b'      => array(),
                                                                'time'      => array(),
                                                                'a' => array(
                                                                    'href' => array(),
                                                                    'class' => array(),
                                                                ),
                                                            );
                                    
                                    echo wp_kses ( $html, $allowed_tags ); 
                                                                        
                                    return;
                                }
                        
                            ob_start();
                            
                            $found_keys =   FALSE;        
                            $order_licence_details =   SOLIW_functions::get_order_licence_details( $order->get_id() );
                            $order_licence_details  =   isset($order_licence_details[ $order_item_id ]) ?   $order_licence_details[ $order_item_id ]    :   array();
                            foreach ($order_licence_details as $licence_group_id   =>   $product_licence_data)
                                {
                                    if( $order_item_id   !=  $product_licence_data->order_item_id)
                                        continue;
                                                                        
                                    $found_key         =   FALSE;
                                                                                            
                                    $license_keys   =   (array)SOLIW_functions::get_order_product_generated_keys( $order->get_id(), $order_item_id, $product_licence_data->group_id );
                                    if(count($license_keys) < 1)
                                        {
                                            $this->generate_license_keys( $order->get_id() );
                                            $license_keys   =   (array)SOLIW_functions::get_order_product_generated_keys( $order->get_id(), $order_item_id, $product_licence_data->group_id );
                                        }
                                    foreach ( $license_keys   as  $license_data )
                                        {
                                            $found_key  =   TRUE;
                                            $found_keys =   TRUE;
                                        }
                                    
                                    if ( $found_key  === TRUE )
                                        {
                                            ?>
                                            <p class="woo-sl-label"><?php echo esc_attr ( $product_licence_data->license_data['group_title'] ); 
                                            
                                            $max_instances_per_key =   $product_licence_data->license_data['max_instances_per_key'];
                                            
                                            if ( $max_instances_per_key < 0 )
                                                $max_instances_per_key  =   __( 'Unlimited', 'software-license-lite' );
                                                else
                                                $max_instances_per_key  =   (int)$max_instances_per_key;
                                            
                                            $instances      =   ' - ';
                                            
                                            if ( is_int( $max_instances_per_key ) )
                                                {
                                                    $instances .= sprintf(
                                                        /* translators: %s: The number of domains. */
                                                        _n(
                                                            '%s domain',
                                                            '%s domains',
                                                            $max_instances_per_key,
                                                            'software-license-lite'
                                                        ),
                                                        $max_instances_per_key
                                                    );
                                                };
                                                
                                            $instances     .=   ' ' . __('per key', 'software-license-lite');
                                            
                                            
                                            echo esc_html ( apply_filters('woo_sl/html/max_instances_per_key', $instances, $product_licence_data->order_item_id, $licence_group_id) );
                                            
                                            ?></p>
                                            <?php
                                            
                                            foreach ( $license_keys   as  $license_data )
                                                {
                                                    ?><p class="woo-sl-key"><?php echo esc_html ( $license_data->licence ) ?></p><?php
                                                } 
                                        }
                                }
                                
                                
                            if( $found_keys  === TRUE )
                                {
                                    ?>
                                    <p class="woo-sl-info"><small><?php 
                                        
                                        $text   =   apply_filters('woo_sl/html/manage_keys', __('You can manage your keys from My Account', 'software-license-lite'));
                                        echo esc_html ( $text );
                                        
                                    ?></small></p>
                                    <?php
                                }
                            
                            
                            //output expire informations if apply
                            if($this->order_item_using_licence_expire( $order->get_id(), $order_item_id ) )
                                {
                                    
                                    $expiration_timestamp   =   self::get_order_item_meta( $order_item_id,  '_woo_sl_licensing_expire_at',  TRUE);
                                    $status    =   $this->get_order_item_meta( $order_item_id,  '_woo_sl_licensing_status',  TRUE);
                                    
                                    if ( empty ( $expiration_timestamp )    &&  $status == 'not-activated' )
                                        {
                                            ?>
                                            <p class="woo-sl-info"><small><?php esc_html_e ( 'Licence Expiration not set, as the key has not activated.', 'software-license-lite') ?></small></p>
                                            <?php   
                                        }
                                        else if ( ! empty ( $expiration_timestamp ) )
                                        {
                                        
                                            ?>
                                                 <p class="woo-sl-info"><small><?php esc_html_e ( 'Expiration date is', 'software-license-lite') ?> <b><time id="exp_local_time" data-timestamp="<?php echo esc_html ( $expiration_timestamp ) ?>"><?php

                                                    $date_format = get_option('date_format');
                                                    $time_format = get_option('time_format');
                                                    echo esc_html ( date_i18n( $date_format . ' ' . $time_format, $expiration_timestamp ) );
                                                 
                                                 ?></time></b></small></p>
                                            <?php
                                        }
                                
                                    if ( ( $status !== 'active'   &&  ! $_hide_inactive_status )    ||  $status === 'active'  )
                                        {
                                            ?>
                                                 <p class="woo-sl-info"><small><?php esc_html_e ( 'Status is', 'software-license-lite') ?> <mark>&nbsp;<?php 
                                                 // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText
                                                 echo esc_html (  $status ) ?>&nbsp;</mark></small></p>
                                            <?php
                                        }
                                }
                            
                            //output Extend button
                            $_soliw_licensing_using_expire     =   self::get_order_item_meta( $order_item_id,  '_woo_sl_licensing_using_expire',  TRUE);
                            if( $_soliw_licensing_using_expire == 'yes' && !in_array($order->get_status(), array('refunded', 'cancelled', 'failed')))
                                {    
                                    $allowed_tags = array(
                                                                'p'             => array(
                                                                                        'class' => array(),
                                                                                        'id'    => array(),
                                                                                    ),
                                                                'small'         => array(),
                                                                'b'             => array(),
                                                                'bdi'           => array(),
                                                                'mark'          => array(),
                                                                'time'          => array(
                                                                                            'id' => array(),
                                                                                        ),
                                                                'a' => array(
                                                                    'href' => array(),
                                                                    'class' => array(),
                                                                    'onclick' => array(),
                                                                    'target'    =>  array(),
                                                                ),
                                                                'span'   => array(
                                                                    'class' => array(),
                                                                ),
                                                            );
                                    
                                    echo wp_kses ( self::show_extend_button( $order->get_id(), $order_item_id ), $allowed_tags );
                                }
                            
                            $html   =   ob_get_clean();
                            
                            $html   =   apply_filters('woo_sl/html/licensing_details', $html, $order_item_id, $order_item, $order );
                            
                            $allowed_tags = array(
                                                                'p'             => array(
                                                                                        'class' => array(),
                                                                                        'id'    => array(),
                                                                                    ),
                                                                'small'         => array(),
                                                                'b'             => array(),
                                                                'bdi'           => array(),
                                                                'mark'          => array(),
                                                                'time'          => array(
                                                                                            'id' => array(),
                                                                                        ),
                                                                'a' => array(
                                                                    'href' => array(),
                                                                    'class' => array(),
                                                                    'onclick' => array(),
                                                                ),
                                                                'script' => array(
                                                                    'type' => array()
                                                                ),
                                                                'span'   => array(
                                                                    'class' => array(),
                                                                ),
                                                            );
                                    
                            echo wp_kses ( $html, $allowed_tags ); 
                        }
                }
                
                
            /**
            * Remove the JavaScript content, to avoid e-mails set as SPAM
            *     
            * @param mixed $email_content
            * @param mixed $order
            */
            function woocommerce_email_order_items_table( $email_content, $order )
                {
                    $regex  =   '/<script\s+type=["\']text\/javascript["\'][^>]*>([\s\S]*?timestampInMilliseconds[\s\S]*?)<\/script>/m';
                    
                    $email_content  =   preg_replace( $regex, '', $email_content );
                       
                    return $email_content;
                }   
            
               
            
            /**
            * Return whenever the order incldue an extend item
            * 
            * @param mixed $order_id
            */
            function order_is_extend( $order_id )  
                {
                    
                    try {
                        $order     = new WC_Order($order_id);
                    } catch (Exception $e) {
                        return FALSE;
                    }
                    
                    $order_products =   $order->get_items();
                         
                    $found_extend   =   FALSE;
                    foreach ( $order_products as $key   =>  $order_product ) 
                        {
                            $_soliw_extend     =   wc_get_order_item_meta($key, '_woo_sl_extend', TRUE);
                            if  ( ! empty ($_soliw_extend ) )
                                $found_extend   =   TRUE;
                        }   
                        
                        
                    return $found_extend;
                    
                }
            
                
            
            /**
            * Show the extend button
            * 
            * @param mixed $order_id
            * @param mixed $order_item_id
            */
            static function show_extend_button( $order_id, $order_item_id, $force_to_show   =   FALSE )
                {
                                        
                    //check if need to show the Extend button
                    $woocommerce_licensing_show_extend_button_days_ahead    =   get_option('woocommerce_licensing_show_extend_button_days_ahead', 10);
                    //check if the extend can be show up to a date
                    $woocommerce_licensing_show_extend_button_days_after    =   get_option('woocommerce_licensing_show_extend_button_days_after', 0);
                    
                    $today              =   time();
                    $expire_at          =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_expire_at',  TRUE);
                    $expired_at         =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_expired_at',  TRUE);
                    
                    $soliw_licensing_using_expire  =   SOLIW_functions::get_order_item_meta( $order_item_id,  '_woo_sl_licensing_using_expire',  TRUE);
                    $soliw_licensing_status        =   SOLIW_functions::get_order_item_meta( $order_item_id,  '_woo_sl_licensing_status',  TRUE);
                    
                    $button_show        =   FALSE;
                    
                    if ( $soliw_licensing_using_expire == 'yes' && empty ( $expire_at )    &&  ! empty ( $expired_at )  )
                        {
                            //only if the extend is not disabled
                            if ( $woocommerce_licensing_show_extend_button_days_after > -1 )
                                {
                                    if( $woocommerce_licensing_show_extend_button_days_after < 1    )
                                        $button_show    =   TRUE;
                                        else
                                        {
                                            $reference_time     =   strtotime("+ " . (int)$woocommerce_licensing_show_extend_button_days_after ." days", $expired_at);
                                            if ( $reference_time    >=  $today )
                                                $button_show    =   TRUE;   
                                        }
                                }   
                        }
                    
                    if  ( ! empty ( $expire_at )     &&  $expire_at    >=   $today )
                        {   
                            if ( $woocommerce_licensing_show_extend_button_days_ahead > -1 )
                                {
                                    if( $woocommerce_licensing_show_extend_button_days_ahead < 1    )
                                        $button_show    =   TRUE;
                                        else
                                        {
                                            $reference_time     =   strtotime("+ " . (int)$woocommerce_licensing_show_extend_button_days_ahead ." days", $today);
                                            if ( $reference_time    >=  $expire_at )
                                                $button_show    =   TRUE;   
                                        }
                                }
                        }
                    
                    if  ( ! empty ( $expire_at )     &&  $expire_at    <   $today )
                        {     
                            if ( $woocommerce_licensing_show_extend_button_days_after > -1 )
                                {
                                    if( $woocommerce_licensing_show_extend_button_days_after < 1    )
                                        $button_show    =   TRUE;
                                        else
                                        {
                                            $reference_time     =   strtotime("+ " . (int)$woocommerce_licensing_show_extend_button_days_after ." days", $expire_at);
                                            if ( $reference_time    >=  $today )
                                                $button_show    =   TRUE;   
                                        }
                                }
                        }
      
                        
                    if  ( $force_to_show ===    TRUE )
                        $button_show    =   TRUE;
                    
                    $button_show    =   apply_filters( 'woo_sl/show_extend_button', $button_show, $order_id, $order_item_id );
                             
                    $html   =   '';
                    
                    if( $button_show ) 
                        { 
                            ob_start();
                            
                            $_sender_is_email   =   self::_check_app_point_sender('email-order-items');
                            
                            $order_data     = new WC_Order($order_id);
                            
                            ?>
                        
                            <a <?php  
                            
                            if ( $_sender_is_email )
                                {
                                    ?>href="<?php echo esc_url ( self::get_licence_manage_url( $order_data->get_id() ) ) ?>" target="_blank"<?php    
                                }
                                else
                                {
                                    ?>href="#" onClick="soliw.licenceExtend(<?php echo esc_attr ( $order_item_id ) ?>, '<?php echo esc_html (  wp_create_nonce( 'woo_sl/actions/extend/'.$order_item_id ) ) ?>'); return false;"<?php
                                }
                            
                            ?> class="button button-extend"><?php
                            
                            
                            $order_products =   $order_data->get_items();
                            $oorder_item_data   =   $order_products[$order_item_id];
                            
                            //retrieve licence expire details
                            $_soliw    =   self::get_order_item_meta($order_item_id,  '_woo_sl',  TRUE);
                            
                            $_sl_product_expire_units   =   '';
                            $_sl_product_expire_time    =   '';
                            
                            reset($_soliw['product_expire_units']);
                            $_sl_product_expire_units   =   current($_soliw['product_expire_units']);
                            reset($_soliw['product_expire_time']);
                            $_sl_product_expire_time    =   current($_soliw['product_expire_time']);
                            
                            $product_expire_time_i18n    =   array(
                                                                'days'      =>  array ( __('Day', 'software-license-lite'), __('Days', 'software-license-lite') ),
                                                                'months'    =>  array ( __('Month', 'software-license-lite'), __('Months', 'software-license-lite') ),
                                                                'years'     =>  array ( __('Year', 'software-license-lite'), __('Years', 'software-license-lite') )
                                                                );
                            
                            
                            $_sl_product_expire_time_HTML   =   $_sl_product_expire_units > 1 ?  $product_expire_time_i18n[$_sl_product_expire_time][1] : $product_expire_time_i18n[$_sl_product_expire_time][0];
                            
                            
                            reset($_soliw['product_expire_renew_price']);
                            $new_price  =   wc_format_decimal ( current($_soliw['product_expire_renew_price']) );

                            if  ( $new_price == '' )
                                {
                                    
                                    $product    =   $oorder_item_data->get_product();   
                                    $new_price  =   $product->get_price();
                                }
                            
                            $button_html   =  apply_filters( 'woo_sl/show_extend_button/label', sprintf(
                                                    /* translators: %1$s: The starting date, %2$s: The extension period. */
                                                    $expire_at > time() ?  __( 'Extend %1$s (starting expiration date) for %2$s', 'software-license-lite' )   :   __( 'Extend %1$s (starting from today) for %2$s', 'software-license-lite' ),
                                                    sprintf (
                                                        '%1$s %2$s',
                                                        esc_attr ( $_sl_product_expire_units ),
                                                        esc_attr ( $_sl_product_expire_time_HTML )
                                                    ),
                                                    wc_price( $new_price )
                                            ), esc_attr ( $order_id ), esc_attr ( $order_item_id ), esc_html ( $new_price ), esc_attr ( $_sl_product_expire_units ), esc_attr ( $_sl_product_expire_time_HTML ) );
                                            
                            $allowed_tags = array(
                                                                'p'             => array(
                                                                                        'class' => array(),
                                                                                        'id'    => array(),
                                                                                    ),
                                                                'small'         => array(),
                                                                'b'             => array(),
                                                                'bdi'           => array(),
                                                                'mark'          => array(),
                                                                'time'          => array(
                                                                                            'id' => array(),
                                                                                        ),
                                                                'a' => array(
                                                                    'href' => array(),
                                                                    'class' => array(),
                                                                    'onclick' => array(),
                                                                ),
                                                                'span'   => array(
                                                                    'class' => array(),
                                                                ),
                                                            );
                                        
                            echo wp_kses ( $button_html, $allowed_tags );
                                        
                            ?>
                            </a>
                            <?php
                            
                            $html   =   ob_get_contents();
                            ob_end_clean();
                        
                        }
                    
                    return $html;   
                    
                }
            
            
            static public function get_option( $option_name )
                {
                    global $wpdb; 
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $option_value       =       $wpdb->get_var( $wpdb->prepare( "SELECT option_value FROM ".  $wpdb->options ."
                                                WHERE `option_name`   =   %s", $option_name) );
                        
                    return $option_value;   
                    
                }
            
            
            /**
            * return the plugin options
            *     
            */
            static public function get_options()
                {
                    $options = get_option('woo_sl_options');
                    $defaults = array (
                                             
                                        );
                    
                    // Parse incoming $args into an array and merge it with $defaults
                    $options = wp_parse_args( $options, $defaults );
                    
                    return $options;
                    
                }
                
            
            /**
            * Update the plugin options
            * 
            * @param mixed $options
            */
            static public function update_options( $options )
                {
                    update_option( 'woo_sl_options', $options );                    
                }
            
            
            
            static public function is_HPOS_active()
                {
                    $woocommerce_custom_orders_table_enabled    =   self::get_option( 'woocommerce_custom_orders_table_enabled' ) == 'yes' ?    TRUE :  FALSE;
                    
                    return $woocommerce_custom_orders_table_enabled;
                }
                
                     
            function wp_timezone_override_offset() 
                {
                    $timezone_string = get_option( 'timezone_string' );
                    if ( ! $timezone_string ) {
                        return 0;
                    }

                    $timezone_object = timezone_open( $timezone_string );
                    $datetime_object = date_create();
                    if ( false === $timezone_object || false === $datetime_object ) {
                        return 0;
                    }
                    return round( timezone_offset_get( $timezone_object, $datetime_object ) / HOUR_IN_SECONDS, 2 );
                }
            
            
            /**\
            * Return permission id
            * 
            * @param mixed $order_id
            * @param mixed $product_id
            */
            function get_permission_id_from_order_id_product_id( $order_id, $product_id )
                {
                    
                    global $wpdb;
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $permission_id                  =   $wpdb->get_var( $wpdb->prepare("SELECT permission_id FROM " . $wpdb->prefix ."woocommerce_downloadable_product_permissions
                                                    WHERE `order_id`    =   %d    AND `product_id`    =   %d", $order_id, $product_id ) );   
                    
                    return $permission_id;
                }
                
                
            function update_expiration_for_permission( $permission_id, $expiration_date_time )
                {
                    
                    global $wpdb;
                    
                    if  ( empty ( $expiration_date_time ) )
                        {
                            $expiration_date_time   =   NULL;
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $results                    =   $wpdb->get_results( $wpdb->prepare("UPDATE " . $wpdb->prefix ."woocommerce_downloadable_product_permissions
                                                        SET `access_expires`    =   NULL
                                                        WHERE `permission_id`   =   %s", $permission_id) );
                        }
                        else
                        {
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $results                    =   $wpdb->get_results( $wpdb->prepare("UPDATE " . $wpdb->prefix ."woocommerce_downloadable_product_permissions
                                                        SET `access_expires`    =   %s
                                                        WHERE `permission_id`   =   %s", $expiration_date_time, $permission_id) );
                        }
                                                
                    
                    
                }
                           
                
            /**
            * Identify if the specified file is a sender in hierarchy at arbitrary application point 
            * 
            * @param mixed $file
            */
            static public function _check_app_point_sender( $file )
                {
                    // phpcs:ignore WordPress.PHP.DevelopmentFunctions.error_log_debug_backtrace, QITStandard.PHP.DebugCode.DebugFunctionFound 
                    $traces =   debug_backtrace();
                    foreach ( $traces   as  $key    =>  $data )
                        {
                            if ( isset( $data['file'] ) &&  strpos($data['file'], $file ) !==   FALSE )
                                return TRUE;
                        }
                        
                    return FALSE;
                    
                }
                
                
                
                
            /**
            * Create a Lock functionality using the MySql 
            * 
            * @param mixed $lock_name
            * @param mixed $release_timeout
            * 
            * @return bool False if a lock couldn't be created or if the lock is still valid. True otherwise.
            */
            function create_lock( $lock_name, $release_timeout = null ) 
                {
                
                    global $wpdb, $blog_id;
                    
                    if ( ! $release_timeout ) {
                        $release_timeout = 10;
                    }
                    $lock_option = $lock_name . '.lock';
                    
                    if (    is_multisite()  )
                        {
                            // Try to lock.
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $lock_result = $wpdb->query( $wpdb->prepare( "INSERT INTO `". $wpdb->sitemeta ."` (`site_id`, `meta_key`, `meta_value`) 
                                                                            SELECT %s, %s, %s FROM DUAL
                                                                            WHERE NOT EXISTS (SELECT * FROM `". $wpdb->sitemeta ."` 
                                                                                  WHERE `meta_key` = %s AND `meta_value` != '') 
                                                                            LIMIT 1", $blog_id, $lock_option, time(), $lock_option) );
                        }
                        else
                        {
                            // Try to lock.
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $lock_result = $wpdb->query( $wpdb->prepare( "INSERT IGNORE INTO `". $wpdb->options ."` (`option_name`, `option_value`, `autoload`) 
                                                                            VALUES (%s, %s, 'no') /* LOCK */", $lock_option, time() ));   
                        }
                    
                                        
                    if ( ! $lock_result ) 
                        {
                            $lock_result    =   $this->get_lock( $lock_option );

                            // If a lock couldn't be created, and there isn't a lock, bail.
                            if ( ! $lock_result ) {
                                return false;
                            }

                            // Check to see if the lock is still valid. If it is, bail.
                            if ( $lock_result > ( time() - $release_timeout ) ) {
                                return false;
                            }

                            // There must exist an expired lock, clear it and re-gain it.
                            $this->release_lock( $lock_name );

                            return $this->create_lock( $lock_name, $release_timeout );
                        }

                    // Update the lock, as by this point we've definitely got a lock, just need to fire the actions.
                    $this->update_lock( $lock_option, time() );

                    return true;
                
                }


            /**
            * Retrieve a lock value
            * 
            * @param mixed $lock_name
            * @param mixed $return_full_row
            */
            private function get_lock( $lock_name, $return_full_row =   FALSE )
                {
                
                    global $wpdb;
                    
                    if (    is_multisite()  )
                        {
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $mysq_query =   $wpdb->get_row( $wpdb->prepare("SELECT `site_id`, `meta_key`, `meta_value` FROM  `". $wpdb->sitemeta ."`
                                                                            WHERE `meta_key`    =   %s", $lock_name ) );

                            if ( $return_full_row   === TRUE )
                                return $mysq_query;
                                
                            if ( is_object($mysq_query) && isset ( $mysq_query->meta_value ) )
                                return $mysq_query->meta_value;
                        }
                        else
                        {
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $mysq_query =   $wpdb->get_row( $wpdb->prepare("SELECT `option_name`, `option_value` FROM  `". $wpdb->options ."`
                                                                            WHERE `option_name`    =   %s", $lock_name ) );

                            if ( $return_full_row   === TRUE )
                                return $mysq_query;
                                
                            if ( is_object($mysq_query) && isset ( $mysq_query->option_value ) )
                                return $mysq_query->option_value;   
                            
                        }
                        
                    return FALSE;
                
                }


            /**
            * Update lock value
            *     
            * @param mixed $lock_name
            * @param mixed $lock_value
            */
            private function update_lock( $lock_name, $lock_value )
                {
                
                    global $wpdb;
                    
                    if (    is_multisite()  )
                        {
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $mysq_query =   $wpdb->query( $wpdb->prepare("UPDATE `". $wpdb->sitemeta ."` 
                                                                            SET meta_value = %s
                                                                            WHERE meta_key = %s", $lock_value, $lock_name) );
                        }
                        else
                        {
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $mysq_query =   $wpdb->query( $wpdb->prepare("UPDATE `". $wpdb->options ."` 
                                                                            SET option_value = %s
                                                                            WHERE option_name = %s", $lock_value, $lock_name) );
                        }
                    
                    
                    return $mysq_query;
                    
                }


            /**
            * Releases an upgrader lock.
            *
            * @param string $lock_name The name of this unique lock.
            * @return bool True if the lock was successfully released. False on failure.
            */
            function release_lock( $lock_name ) 
                {
                
                    global $wpdb;
                    
                    $lock_option = $lock_name . '.lock';
                    
                    if (    is_multisite()  )
                        {
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $mysq_query =   $wpdb->query( $wpdb->prepare( "DELETE FROM `". $wpdb->sitemeta ."` 
                                                                            WHERE meta_key = %s", $lock_option ) );
                        }
                        else
                        {
                            // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $mysq_query =   $wpdb->query( $wpdb->prepare( "DELETE FROM `". $wpdb->options ."` 
                                                                            WHERE option_name = %s", $lock_option ) );
                        }
                    
                    return $mysq_query;
                    
                }
                
                
                
            /**
            * Replace a filter / action from anonymous object
            * 
            * @param mixed $tag
            * @param mixed $class
            * @param mixed $method
            */
            function remove_anonymous_object_filter( $tag, $class, $method ) 
                {
                    $filters = false;

                    if ( isset( $GLOBALS['wp_filter'][$tag] ) )
                        $filters = $GLOBALS['wp_filter'][$tag];

                    if ( $filters )
                    foreach ( $filters as $priority => $filter ) 
                        {
                            foreach ( $filter as $identifier => $function ) 
                                {
                                    if ( ! is_array( $function ) )
                                        continue;
                                    
                                    if ( ! $function['function'][0] instanceof $class )
                                        continue;
                                    
                                    if ( $method == $function['function'][1] ) 
                                        {
                                            remove_filter($tag, array( $function['function'][0], $method ), $priority);
                                        }
                                }
                        }
                }
   
                  
        } 
    
    
    
?>