<?php
        
    defined( 'ABSPATH' ) || exit; 
      
    class SOLIW_front
        {
            public static $instance;
            var $functions;
            var $options;
            
            var $query_vars;
            
            
            /**
            * Run on class construct
            * 
            */
            function __construct( ) 
                {
                    self::$instance = $this;
                    
                    global $SOLIW;
                    
                    $this->functions    =   $SOLIW->functions;
                    
                    $this->options              =   SOLIW_functions::get_options();
                       
                    add_filter( 'woocommerce_my_account_my_orders_actions', array($this, 'woocommerce_my_account_my_orders_actions'), 10, 2 );
      
                    //enqueue required styles / scripts for licence page
                    add_filter( 'wp_enqueue_scripts', array($this, 'wp_enqueue_scripts'), 99 );
                       
                    //enqueue required styles / scripts for order page
                    add_filter( 'wp_enqueue_scripts', array($this, 'wp_enqueue_scripts_order_page'), 99 );
                    
                    //add the custom template for License Manager page
                    add_action( 'woocommerce_account_' . $this->functions->query_vars['license-manage'] . '_endpoint', array($this, 'woocommerce_account_license_manage_endpoint' ) );
                    add_action( 'woocommerce_account_' . $this->functions->query_vars['software_license'] . '_endpoint', array($this, 'woocommerce_account_view_license_endpoint' ) );
                    
                    //process the form generator submit
                    add_action( 'template_redirect', array( $this, 'actions_process' ) );
                    
                    //add license array data to order, instead reading from original product
                    add_action('woocommerce_checkout_order_processed',              array($this->functions, 'order_setup_licensing'), 99, 2);
                    add_action('woocommerce_store_api_checkout_order_processed',    array($this->functions, 'order_setup_licensing'), 99, 1);
                                        
                    //check to activate de-actiate license
                    add_action('woocommerce_order_status_changed',                  array($this->functions, 'woocommerce_order_status_changed'), 99, 3);
                    
                    //output keys to order received page & emails IF status completed
                    add_action( 'woocommerce_order_item_meta_end',                  array($this->functions, 'woocommerce_order_item_meta_end'), 99, 4 );
                    
                    //templates more html data
                    add_action('woo_sl/template/product/licence_data',              array($this, 'template_product_licence_data'), 10, 2);
                    
                    add_filter('woocommerce_cart_item_name',                        array($this, 'cart_item_name'), 1,  3);
                    add_filter('woocommerce_order_item_name',                       array($this, 'order_item_name'), 1,  3);
                    add_action('woocommerce_cart_item_quantity',                    array($this, 'woocommerce_cart_item_quantity'), 999,  3); 
                    
                    add_action('woocommerce_checkout_create_order_line_item',       array($this, 'woocommerce_checkout_create_order_line_item'), 1,  4); 
                    
                    //disable downloads for extends orders
                    add_filter('woocommerce_order_is_download_permitted',           array($this, 'woocommerce_order_is_download_permitted'), 999,  2);
                    
                    add_action('woocommerce_order_details_before_order_table',      array($this, 'woocommerce_order_details_before_order_table'), 1); 
                    
                    add_action('woocommerce_before_calculate_totals',               array($this, 'woocommerce_before_calculate_totals'), 999);
                    
                    //remove an downlaodable product permision for renewal orders
                    add_action( 'woocommerce_grant_product_download_permissions',   array($this, 'woocommerce_grant_product_download_permissions'), 999);
                    
                    add_action( 'woocommerce_get_query_vars',                       array($this->functions, 'woocommerce_get_query_vars') );
                    
                    // Inserting your new tab/page into the My Account page.
                    add_filter( 'woocommerce_account_menu_items',                   array( $this, 'add_menu_items' ) );
                    
                }
                
            
            /**
            * Get class instance.
            * 
            */
            public static function get_instance()
                {
                    if (self::$instance === null) 
                        {
                            self::$instance = new self($functions, $options);
                        }

                    return self::$instance;;    
                }
                
                
                   
            /**
            * Add a manage license button if the order contain at least one software license functionality
            * 
            * @param mixed $actions
            * @param mixed $order
            */
            function woocommerce_my_account_my_orders_actions ( $actions, $order )
                {
                    global $wpdb;

                    // $order          =   new WC_Order( $order_id );
                    $order_items    =   $order->get_items(); 
                     
                    if ( count( $order->get_items() ) < 1 )
                        return $actions;
                        
                    if( !   $this->functions->order_contain_licensed_item($order->get_id()))
                        return $actions;
                        
                    $class  =   'sl';
                    
                    $woocommerce_licensing_grant_access_after_payment   =   $this->functions->get_option('woocommerce_licensing_grant_access_after_payment');
                    if( $woocommerce_licensing_grant_access_after_payment ==  'yes' &&  ! SOLIW_functions::is_order_completed($order->get_id()))
                        $class  =   'disabled';
                    
                    $text   =   apply_filters('woo_sl/html/button/license_manage', __('License Manage', 'software-license-lite'));
                    
                    $new_action[$class]  =   array(
                                                'url'   =>  $this->functions->get_licence_manage_url($order->get_id()),
                                                'name'  =>  $text
                                            );   
                    
                    if( $woocommerce_licensing_grant_access_after_payment ==  'yes' &&  ! SOLIW_functions::is_order_completed($order->get_id()))
                        $new_action[$class]['url']  =   '#';
                                            
                    $actions                =   $new_action +   $actions;
                        
                    return $actions;
                }
                
            
            
            /**
            * put your comment there...
            * 
            * @param mixed $order_id
            */
            function woocommerce_account_license_manage_endpoint( $current_page = 1 )
                {
                    global $current_user;
                    
                    $all_order_ids      = $this->functions->get_user_licences( $current_user->ID );
                    $current_page       = empty( $current_page ) ? 1 : absint( $current_page );
                    $posts_per_page     = apply_filters( 'woo_sl/my-account/posts_per_page', get_option( 'posts_per_page' ) );
                    $max_num_pages      = ceil( count( $all_order_ids ) / $posts_per_page );
                    $licences           = array_slice( $all_order_ids, ( $current_page - 1 ) * $posts_per_page, $posts_per_page );
                         
                    wc_get_template(
                        'myaccount/my-licences.php',
                                                            array(
                                                                'licences'      => $licences,
                                                                'current_page'  => $current_page,
                                                                'max_num_pages' => $max_num_pages,
                                                                'paginate'      => true,
                                                            ),
                                                            '',
                                                            SOLIW_PATH . 'templates/'
                    );
                    
                }
            
                      
            /**
            * put your comment there...
            * 
            * @param mixed $order_id
            */
            function woocommerce_account_view_license_endpoint( $order_id )
                {
                    $woocommerce_licensing_grant_access_after_payment   =   $this->functions->get_option('woocommerce_licensing_grant_access_after_payment');                   
                    
                    $allowed    =   TRUE;
                    
                    $order_post  =   get_post( $order_id );
                    
                    if ( $this->functions->order_contain_licensed_item( $order_id ) ===   FALSE )
                        $allowed    =   FALSE;
                        
                    if ( $allowed   &&  $order_post )
                        {
                            if ( $order_post->post_type ==  'shop_subscription' )
                                {
                                    if ( ! current_user_can( 'view_order', $order_id ) ) 
                                        $allowed    =   FALSE;
                                }
                                else
                                {
                                    if ( ! current_user_can( 'view_order', $order_id ) ||
                                        ( $woocommerce_licensing_grant_access_after_payment ==  'yes' &&  ! SOLIW_functions::is_order_completed( $order_id ) ) 
                                        ) 
                                        {
                                            $allowed    =   FALSE;
                                        }
                                }
                        }
                        else
                        $allowed    =   FALSE;
                        
                    if ( ! $allowed ) 
                        { ?><div class="woocommerce-error"><?php __( 'Invalid Licence. Check ', 'software-license-lite' ) ?> <a href="<?php wc_get_page_permalink( 'myaccount' ) ?>" class="wc-forward"><?php __( 'My account', 'software-license-lite' ) ?></a></div><?php }
                    
                    if ( ! $allowed )
                        return;
                        

                    wp_enqueue_script(
                                        'soliw-front-my-account',
                                        SOLIW_URL . '/js/front-my-account.js' ,
                                        array( 'jquery' ),
                                        '1.0.0',
                                        true // footer
                                    );
                    
                    wc_get_template(
                        'myaccount/my-licence-manage.php',
                                                            array(
                                                                'current_page' => absint( $order_id )
                                                            ),
                                                            '',
                                                            SOLIW_PATH . 'templates/'
                    );
                    
                }
                  
            
            /**
            * put your comment there...
            * 
            */
            function wp_enqueue_scripts()
                {
                    if( $this->is_manage_license_page())
                        {
                    
                            wp_register_style( 'woo-sl-my-account', SOLIW_URL . '/css/my-account.css', array(), SOLIW_VERSION );
                            wp_enqueue_style( 'woo-sl-my-account' );
                            
                            wp_register_script( 'woo-sl-functions', SOLIW_URL . '/js/functions.js', array(), SOLIW_VERSION, false );
                            $argv = array(
                                            'plugin_url'    =>  SOLIW_URL,
                                            'ajaxurl'       =>  admin_url('admin-ajax.php')
                                        );
                            wp_localize_script( 'woo-sl-functions', 'soliw_vars', $argv );
                            wp_enqueue_script( 'woo-sl-functions' );
                        }
                        
                    //load the functions for myaccount order page
                    if ( is_account_page() ||   is_order_received_page())
                        {
                            wp_register_script( 'woo-sl-functions', SOLIW_URL . '/js/functions.js', array(), SOLIW_VERSION, false );
                            $argv = array(
                                            'plugin_url'    =>  SOLIW_URL,
                                            'ajaxurl'       =>  admin_url('admin-ajax.php')
                                        );
                            wp_localize_script( 'woo-sl-functions', 'soliw_vars', $argv );
                            wp_enqueue_script( 'woo-sl-functions' );    
                        }
                    
                }
      
            /**
            * put your comment there...
            *     
            */
            function wp_enqueue_scripts_order_page()
                {
                    global $wp;
                    
                    if ( (! isset( $wp->query_vars[  'view-order'   ] ) || empty($wp->query_vars[  'view-order'   ]))   &&
                        (! isset( $wp->query_vars[  'order-received'   ] ) || empty($wp->query_vars[  'order-received'   ])) &&
                        (! isset( $wp->query_vars[  'view-subscription'   ] ) || empty($wp->query_vars[  'view-subscription'   ]))
                        )
                        return FALSE;
                    
                    wp_register_style( 'woo-sl-order-details', SOLIW_URL . '/css/order-details.css', array(), SOLIW_VERSION );
                    wp_enqueue_style( 'woo-sl-order-details' );
                }
            
            
            /**
            * Check if the current page is manage license
            * 
            */
            function is_manage_license_page()
                {
                    global $wp;
                    
                    $slug   =   $this->functions->query_vars['software_license'];
                    
                    if ( ! isset( $wp->query_vars[  $slug   ] ) || empty($wp->query_vars[  $slug   ]))
                        return FALSE;   
                        
                    return TRUE;
                }
            
         
            
            
            /**
            * Call the API if any woo_sl_action set
            * 
            */
            function actions_process()
                {
                    // phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.NonceVerification.Missing, WordPress.Security.NonceVerification.Recommended   
                    if ( empty( $_GET[ 'woo_sl_action' ] )  &&  empty( $_POST[ 'woo_sl_action' ] ) )
                        return;
                    
                    //run API module
                    $SOLIW_API    =   WooSLApiFactory::createApiInstance();
                    $SOLIW_API->init();
                    
                    
                }
   
            
            /**
            * put your comment there...
            * 
            * @param mixed $order_id
            * @param mixed $order_item_id
            */
            function template_product_licence_data( $order_id, $order_item_id )
                {
   
                    if ( SOLIW_functions::order_item_using_licence_expire ( $order_id, $order_item_id ) )
                            {
                                ?>
                                    <p class="woo-sl-label"><?php esc_html_e( 'License Availability', 'software-license-lite' )  ?></p>
                                    <div class="licence_expire">
             
                                        <p><?php esc_html_e( 'Status', 'software-license-lite' ) ?> : <span><b><mark>&nbsp;<?php
                                        
                                            $status         =    SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_status',  TRUE);
                                            $ucf_status     =    ucfirst( $status);
                                            esc_html ( $ucf_status );
                                            
                                        ?>&nbsp;</mark></b></span><?php
                                        
                                        $_soliw_licensing_using_expire     =   SOLIW_functions::get_order_item_meta( $order_item_id,  '_woo_sl_licensing_using_expire',  TRUE);
                                        $expiration_timestamp               =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_expire_at',  TRUE);
                                        
                                        if ( empty ( $expiration_timestamp )    &&  $status == 'not-activated' )
                                        {
                                            ?><br /><?php
                                            esc_html_e('Licence Expiration not set, as the key has not activated.', 'software-license-lite');
                                        }
                                        else if ( ! empty ( $expiration_timestamp ) )
                                        {   
                                            
                                            if ( $_soliw_licensing_using_expire  == 'yes' )
                                                {
                                        
                                        ?><br />
                                        <?php esc_html_e( 'Start Date', 'software-license-lite' ) ?> : <span><?php
                                        
                                            $start_at    =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_start',  TRUE);
                                            echo esc_html ( date_i18n( get_option( 'date_format' ), $start_at) );
                                        
                                        ?></span><?php } ?><br />
                                        <?php esc_html_e( 'Expire Date', 'software-license-lite' ) ?>: <span><?php
                                        
                                            $expire_at    =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_expire_at',  TRUE);
                                            echo esc_html ( date_i18n( get_option( 'date_format' ), $expire_at) );
                                        
                                        ?></span><br />
                                        
                                        <?php 
                                        }
                                        
                                        if ( $_soliw_licensing_using_expire  == 'yes' )
                                            {
                                                $allowed_tags = array(
                                                                'a'   => array(
                                                                    'href'      => array(),
                                                                    'onclick'   => array(),
                                                                    'class'     => array()
                                                                ),
                                                                'span'      => array(
                                                                    'class'     => array(),
                                                                        ),
                                                                'bdi'      => array(),
                                                            );
                                                echo wp_kses ( SOLIW_functions::show_extend_button( $order_id, $order_item_id ), $allowed_tags );
                                            }
                                        
                                        ?></p>
                                                                   
                                    </div>
                                <?php   
                                
                            }
   
                }
                
                
            /**
            * Store custom data for saving later within order
            *    
            * @param mixed $cart_item_meta
            * @param mixed $product_id
            */
            static public function add_cart_item_data( $cart_item_data, $product_id )
                {
                    
                    $new_values =   array(
                                            '_woo_sl_extend'        =>  true,
                                            '_woo_sl_extend_for'    =>  $GLOBALS['_woo_sl_extend_initial_order_item_id'],
                                            );
                    
                    
                    return array_merge($cart_item_data, $new_values);
                    
                }
                
                   
            /**
            * Cart Item Name
            *     
            */
            function cart_item_name( $product_name, $values, $cart_item_key )
                {
                    $return_string  =   $product_name;
                        
                    //check if fabric creator product
                    $cart_products = WC()->cart->get_cart();
                    
                    if(empty($cart_products))
                        return $return_string;
                    
                    $cart_item_data =   $cart_products[ $cart_item_key ];
                    
                    //check if is an extend
                    if( !   isset($cart_item_data['_woo_sl_extend'])    )
                        return $return_string;
                    
                    $return_string  .= '<br /><small>(' . __('License Extend', 'software-license-lite') . ')</small>';
        
                    return $return_string;    
                    
                }
                
                
            /**
            * Cart Item Name
            *     
            */
            function order_item_name( $product_name, $cart_item_data, $bool_var )
                {
                    $return_string  =   $product_name;
                        
                    //check if is an extend
                    if( !   isset($cart_item_data['soliw_extend'])    )
                        return $return_string;
                    
                    $return_string  .= ' <small>(' . __('License Extend', 'software-license-lite') . ')</small>';
        
                    return $return_string;    
                    
                }
                
         
            
            /**
            * No need for quantity on extend
            * 
            * @param mixed $html
            * @param mixed $cart_item
            * @param mixed $cart_item_key
            */
            function woocommerce_cart_item_quantity( $product_quantity, $cart_item_key, $cart_item_data )
                {
                    
                    //check if is an extend
                    if( !   isset($cart_item_data['_woo_sl_extend'])    )
                        return $product_quantity;
                     
                    return '';
                        
                }
                
            /**
            * Add additional details on Checkout Completed / Order Received Page
            * Add additional details within Admin Order Page for this Order
            *     
            * @param mixed $item_id
            * @param mixed $values
            */    
            function woocommerce_checkout_create_order_line_item( $item, $cart_item_key, $values, $order )
                {
                    
                    if( !   isset($values['_woo_sl_extend'])    )
                        return;
       
                    //add the fields
                    $item->add_meta_data('_woo_sl_extend', TRUE);
                    $item->add_meta_data('_woo_sl_extend_for', $values['_woo_sl_extend_for']);   
                }
                
                
            /**
            * put your comment there...
            *     
            * @param mixed $allow_download
            * @param mixed $order
            */
            function woocommerce_order_is_download_permitted( $allow_download, $order )
                {
                                            
                    $found_extend   =   $this->functions->order_is_extend( $order->get_ID() );
                        
                    if ( $found_extend  === TRUE )
                        $allow_download =   FALSE;
                    
                    return $allow_download;    
                }
                
            
            
            /**
            * put your comment there...
            *     
            * @param mixed $order
            */
            function woocommerce_order_details_before_order_table( $order )
                {
                    
                    $found_extend   =   $this->functions->order_is_extend( $order->get_ID() );
                    
                    if ( $found_extend  === FALSE )
                        return;
                    
                    $order_products         =   $order->get_items();
                    reset($order_products);
                    $order_product           =   current($order_products);
                        
                    $_soliw_extend_for     =   wc_get_order_item_meta( $order_product->get_ID() , '_woo_sl_extend_for', TRUE);
                    $order_id               =   $this->functions->get_order_by_item_id( $_soliw_extend_for );
                    $order_data             =   new WC_Order($order_id);
                                    
                    ?>
                    <h4 class="woocommerce-notice"><?php esc_html_e( 'This is a renewal for', 'software-license-lite' ) ?> <a href="<?php
                                         
                                         
                                         $view_order_url        =   wc_get_endpoint_url( 'view-order', $order_data->get_id(), wc_get_page_permalink( 'myaccount' ) );

                                         echo esc_url ( apply_filters( 'woocommerce_get_view_order_url', $view_order_url, $order_data ) );
                                         
                                         
                                         ?>" class="button small"><?php esc_html_e('Order', 'software-license-lite') ?></a></p>
                    <?php
                    
                }
                
            
            
            /**
            * put your comment there...
            *     
            * @param mixed $cart
            */
            function woocommerce_before_calculate_totals( $cart )
                {
                    if ( is_admin() && ! defined( 'DOING_AJAX' ) )
                        return;

                    foreach ( $cart->get_cart() as $cart_item ) 
                        {
                            if (    !isset($cart_item['_woo_sl_extend'])    ||  $cart_item['_woo_sl_extend']    !== TRUE    )
                                continue;
                                         
                            // get the product id (or the variation id)
                            $id = $cart_item['data']->get_id(); 

                            $_soliw    =   SOLIW_functions::get_order_item_meta( $cart_item['_woo_sl_extend_for'],  '_woo_sl',  TRUE);
                            reset($_soliw['product_expire_renew_price']);
                            $new_price  =   wc_format_decimal ( current($_soliw['product_expire_renew_price']) );

                            // Updated cart item price
                            if ( $new_price !=  '' )
                                $cart_item['data']->set_price( $new_price ); 
                        }
                    
                }
                
                
                
            /**
            * Prevent renewall orderser to include a downloadable
            * 
            * @param mixed $download
            * @param mixed $product
            * @param mixed $order
            * @param mixed $qty
            */
            function woocommerce_grant_product_download_permissions( $order_id )
                {
                  
                    //check if is extend
                    if ( $this->functions->order_is_extend( $order_id  )  === FALSE  ) 
                        return;
                        
                    $data_store = WC_Data_Store::load( 'customer-download' );
                    $data_store->delete_by_order_id( $order_id ); 
                }
                
   
            /**
            * Insert the new endpoint into the My Account menu.
            * 
            * @param mixed $menu_items
            */
            public function add_menu_items( $menu_items ) 
                {

                    if ( empty( get_option( 'woocommerce_myaccount_license_manage_endpoint', 'license-manage' ) ) )
                        return $menu_items;
      
                    $text   =   apply_filters('woo_sl/html/menu/licence_manage', __('License Manage', 'software-license-lite'));
      
                    if ( isset ( $menu_items['orders']) )
                        {
                            $menu_items_keys        =   array_keys( $menu_items );
                            $menu_items_key_idex    =   array_search( 'orders', $menu_items_keys );
                            
                            $menu_items =   array_slice( $menu_items, 0, $menu_items_key_idex + 1 , true ) +
                                            array( get_option( 'woocommerce_myaccount_license_manage_endpoint', 'license-manage' ) => $text ) +
                                            array_slice( $menu_items, $menu_items_key_idex + 1 , count( $menu_items ) - 1, true ) ;   
                        }
                        else
                        $menu_items['license-manage'] = $text;

                    return $menu_items;
                }
   
        } 

    global $SOLIW_front;    
    $SOLIW_front    =   new SOLIW_front();
?>