<?php
    
    defined( 'ABSPATH' ) || exit;
    
    class SOLIW_AJAX 
        {
            
            public function __construct() 
                {

                    //AJAX
                    add_action( 'wp_ajax_soliw_key_generate',                  array( $this, 'AJAX_key_generate' ) );
                    add_action( 'wp_ajax_soliw_key_assign',                    array( $this, 'AJAX_key_assign' ) );
                    add_action( 'wp_ajax_soliw_key_deactivate',                array( $this, 'AJAX_key_deactivate' ) );
                    add_action( 'wp_ajax_soliw_key_delete',                    array( $this, 'AJAX_key_delete' ) );
                    
                    add_action( 'wp_ajax_woo_sl_licence_extend',                array( $this, 'AJAX_licence_extend' ) );
                    
                    //variations allow to chose licence group
                    add_action('woocommerce_product_after_variable_attributes', array($this, 'woocommerce_product_after_variable_attributes'), 10, 3);
                    add_action('woocommerce_save_product_variation',            array($this, 'woocommerce_save_product_variation'), 10, 2);
                                        
                }
           
            
            /**
            * Generate a new license key fro the required product.
            * 
            */
            function AJAX_key_generate()
                {                   
                    $response = array();
                    
                    $nonce = isset( $_POST['wpnonce'] ) ? sanitize_text_field( wp_unslash( $_POST['wpnonce'] ) )  : '';
                    if ( ! wp_verify_nonce( $nonce, 'woo_sl/key-generator') )
                        {
                            $response['status']      =  'error';
                            $response['message']     =  __( 'Invalid security code', 'software-license-lite' );
                            echo wp_json_encode( $response);
                            
                            die();
                        }
                    
                    $sl_product =   isset ( $_POST['sl_product'] ) ?    preg_replace("/[^0-9,]/i", "", sanitize_text_field( wp_unslash( $_POST['sl_product'] ) ) )   :   '';
                    if(empty($sl_product))
                        {
                            $response['status']     =   'error';
                            $response['message']    =   __( 'Invalid product, please select one.', 'software-license-lite' );
                            
                            echo wp_json_encode($response);
                            
                            die();
                        }

                    list($order_id, $order_item_id, $license_group_id) = explode(",", $sl_product);
                    
                    $user_id = get_current_user_id();
                    
                    //check user capability over this purchase
                    $order_data =   new WC_Order($order_id);
                    if(
                        $order_data->get_user_id()   !=  $user_id   
                        //allow for admin
                        && (is_user_logged_in() && (  !current_user_can( 'edit_shop_order' )  &&  !current_user_can( 'install_plugins' )     ))
                        )
                        {
                            $response['status']      =  'error';
                            $response['message']     =  __( 'No capabilities over this order', 'software-license-lite' );
                            echo wp_json_encode($response);
                            
                            die();
                        } 
                    
                    //check if available keys
                    $order_licence_details  =   SOLIW_functions::get_order_licence_details($order_id);
                    
                    $order_item_licence_details =   isset($order_licence_details[$order_item_id])   ?   $order_licence_details[$order_item_id]  :   array();
                    foreach ($order_item_licence_details as $product_licence_data)
                        {
                            if($product_licence_data->order_item_id !=  $order_item_id)
                                continue;
                                
                            if($product_licence_data->group_id !=  $license_group_id)
                                continue;
                            
                            $licence_status         =   SOLIW_functions::get_licence_status( $product_licence_data->order_item_id );
                            if ( !in_array( $licence_status, array('active', 'not-activated') ) )
                                {
                                    $response['status']      =  'error';
                                    $response['message']     =  __( 'Order status not allowed the operation', 'software-license-lite' );
                                    echo wp_json_encode($response);
                                    
                                    die();
                                }
                            
                            $max_keys   =   $product_licence_data->license_data['max_keys'];
                            if( $max_keys   >   0 )
                                {
                                    $order_product_data = SOLIW_functions::get_order_product_data($product_licence_data->order_id, $product_licence_data->order_item_id);
                                    $max_keys   =   $max_keys   *      $order_product_data->get_quantity();
                                    $max_keys   =   apply_filters( 'woo_sl/max_keys/applied_order_quantity', $max_keys, $order_product_data );
                                }
                                
                            if (  $max_keys != '' &&  $max_keys > 0 && ($max_keys - $product_licence_data->generated_keys)  < 1 )
                                {
                                    $response['status']     =   'error';
                                    $response['message']    =   __( 'Sorry maximum number of generated Licence Keys reached! Please upgrade if available.', 'software-license-lite' );
                                }
                                else
                                {
                                                                        
                                    //create a new key
                                    $new_licence_keys = SOLIW_functions::generate_license_key($order_id, $order_item_id, $license_group_id, 1);
                                    
                                    $response['data_order_item_id'] =   $product_licence_data->order_item_id;
                                    $response['data_group_id']      =   $product_licence_data->group_id;
                                    
                                    if(!empty($new_licence_keys) && is_array($new_licence_keys) && count($new_licence_keys) > 0)
                                        {
                                            $response['status']             =   'success';
                                            $response['message']            =   __( 'A new License Keys has been generated', 'software-license-lite' ) . ': <b>'. implode(", ", $new_licence_keys) .'</b>';
                                                                              
                                            reset($new_licence_keys);
                                            $first_licence_key              =   current($new_licence_keys);
                                            $new_licence_data               =   SOLIW_functions::get_licence_key_data_by_licence_key($first_licence_key);
                                            
                                            $response['html']               =   SOLIW_functions::interface_get_licence_row($new_licence_data->id);
                                        }
                                        else
                                        {
                                            $response['status']     =   'error';
                                            $response['message']    =   __( 'There was a problem generating a new licence key. Please contact system administrator.', 'software-license-lite' );
                           
                                            $response['html']       =   '';
                                        }

                                    //update the $order_licence_details var
                                    $_order_licence_details  =   SOLIW_functions::get_order_licence_details($order_id);
                                    
                                    $response['sl_product_html']    =   SOLIW_functions::interface_get_sl_product_select($_order_licence_details);
                                }
                            
                        }
                        
                    
                    echo wp_json_encode($response);
                    die();
                    
                }
       
       
            
            /**
            * Assign a license key to a give product in the order.
            * 
            */
            function AJAX_key_assign()
                {                   
                    $response = array();
                    
                    $nonce = isset( $_POST['wpnonce'] ) ? sanitize_text_field( wp_unslash( $_POST['wpnonce'] ) ) : '';
                    if ( ! wp_verify_nonce( $nonce, 'woo_sl/key-assign') )
                        {
                            $response['status']      =  'error';
                            $response['message']     =  __( 'Invalid security code', 'software-license-lite' );
                            echo wp_json_encode($response);
                            
                            die();
                        }
                    
                    $sl_product =   isset ( $_POST['sl_product'] ) ?    preg_replace("/[^0-9,]/i", "", sanitize_text_field ( wp_unslash( $_POST['sl_product'] ) ) )    :   '';
                    if(empty($sl_product))
                        {
                            $response['status']     =   'error';
                            $response['message']    =   __( 'Invalid product, please select one.', 'software-license-lite' );
                            
                            echo wp_json_encode($response);
                            
                            die();
                        }

                    list( $order_id, $order_item_id, $license_group_id ) = explode(",", $sl_product);
                    
                    $new_licence_key =   isset ( $_POST['key_assign'] ) ?    preg_replace("/[^a-zA-Z0-9.\-\_\: ]/i", "", sanitize_text_field ( wp_unslash( $_POST['key_assign'] ) ) )    :   '';
                    
                    if ( ! isset ( $_POST['key_assign'] )   ||  empty ( $_POST['key_assign'] ) )
                        {
                            $response['status']     =   'error';
                            $response['message']    =   __( 'Empty license key.', 'software-license-lite' );
                            
                            echo wp_json_encode($response);
                            
                            die();   
                        }
                    
                    if ( $new_licence_key    !=  $_POST['key_assign'] )
                        {
                            $response['status']     =   'error';
                            $response['message']    =   __( 'The provided key contains invalid characters. Please use only alphanumeric.', 'software-license-lite' );
                            
                            echo wp_json_encode($response);
                            
                            die();
                        }
                    
                    $user_id = get_current_user_id();
                    
                    //check user capability over this purchase
                    $order_data =   new WC_Order($order_id);
                    if(
                        $order_data->get_user_id()   !=  $user_id   
                        //allow for admin
                        && (is_user_logged_in() && (  !current_user_can( 'edit_shop_order' )  &&  !current_user_can( 'install_plugins' )     ))
                        )
                        {
                            $response['status']      =  'error';
                            $response['message']     =  __( 'No capabilities over this order', 'software-license-lite' );
                            echo wp_json_encode($response);
                            
                            die();
                        } 
                    
                    //check if available keys
                    $order_licence_details  =   SOLIW_functions::get_order_licence_details($order_id);
                    
                    $order_item_licence_details =   isset($order_licence_details[$order_item_id])   ?   $order_licence_details[$order_item_id]  :   array();
                    foreach ($order_item_licence_details as $product_licence_data)
                        {
                            if($product_licence_data->order_item_id !=  $order_item_id)
                                continue;
                                
                            if($product_licence_data->group_id !=  $license_group_id)
                                continue;
                            
                            $licence_status         =   SOLIW_functions::get_licence_status( $product_licence_data->order_item_id );
                            if ( !in_array( $licence_status, array('active', 'not-activated') ) )
                                {
                                    $response['status']      =  'error';
                                    $response['message']     =  __( 'Order status not allowed the operation', 'software-license-lite' );
                                    echo wp_json_encode($response);
                                    
                                    die();
                                }
                            
                            $max_keys   =   $product_licence_data->license_data['max_keys'];
                            if( $max_keys   >   0 )
                                {
                                    $order_product_data = SOLIW_functions::get_order_product_data($product_licence_data->order_id, $product_licence_data->order_item_id);
                                    $max_keys   =   $max_keys   *      $order_product_data->get_quantity();
                                    $max_keys   =   apply_filters( 'woo_sl/max_keys/applied_order_quantity', $max_keys, $order_product_data );
                                }
                                
                            if (  $max_keys != '' &&  $max_keys > 0 && ($max_keys - $product_licence_data->generated_keys)  < 1 )
                                {
                                    $response['status']     =   'error';
                                    $response['message']    =   __( 'Sorry maximum number of generated Licence Keys reached! Please upgrade if available.', 'software-license-lite' );
                                }
                                else
                                {
                                    
                                    SOLIW_functions::set_license_key( $order_id, $order_item_id, $license_group_id, $new_licence_key );
                                    
                                    $response['data_order_item_id'] =   $product_licence_data->order_item_id;
                                    $response['data_group_id']      =   $product_licence_data->group_id;

                                    $response['status']             =   'success';
                                    $response['message']            =   __( 'A new License Key has been assigned', 'software-license-lite' ) . ': <b>'. $new_licence_key .'</b>';

                                    $new_licence_data               =   SOLIW_functions::get_licence_key_data_by_licence_key( $new_licence_key );
                                    
                                    $response['html']               =   SOLIW_functions::interface_get_licence_row($new_licence_data->id);

                                    //update the $order_licence_details var
                                    $_order_licence_details  =   SOLIW_functions::get_order_licence_details($order_id);
                                    
                                    $response['sl_product_html']    =   SOLIW_functions::interface_get_sl_product_select($_order_licence_details);
                                }
                            
                        }
                        
                    
                    echo wp_json_encode($response);
                    die();
                    
                }
       
       
            /**
            * put your comment there...
            * 
            */
            function AJAX_key_deactivate()
                {
                    $response_data = array();
                    
                    $licence_id     =   isset ( $_POST['license_id'] ) ?    intval( $_POST['license_id'] )  :   '';
                    
                    //check nonce
                    $nonce = isset( $_POST['wpnonce'] ) ? sanitize_text_field( wp_unslash( $_POST['wpnonce'] ) ) : '';
                    if ( ! wp_verify_nonce( $nonce, 'woo_sl/actions/deactivate/' . $licence_id ) )
                        {
                            $response_data['status']      =  'error';
                            $response_data['message']     =  __( 'Invalid security code', 'software-license-lite' );
                            echo wp_json_encode($response_data);
                            
                            die();
                        }
                    
                    $licence_data = SOLIW_functions::get_licence_key_data_by_licence_id($licence_id);
                    
                    if(!is_object($licence_data))
                        {
                            $response_data['status']      =  'error';
                            $response_data['message']     =  __( 'Invalid data', 'software-license-lite' );
                            echo wp_json_encode($response_data);
                            
                            die();
                        }
                        
                    $user_id = get_current_user_id();
                    
                    //check user capability over this purchase
                    $order_data =   new WC_Order( $licence_data->order_id );
                    if(
                        $order_data->get_user_id()   !=  $user_id   
                        && ( is_user_logged_in() && (  !current_user_can( 'edit_shop_order' )  &&  !current_user_can( 'install_plugins' )     ) )
                        )
                        {
                            $response['status']      =  'error';
                            $response['message']     =  __( 'No capabilities over this order', 'software-license-lite' );
                            echo wp_json_encode($response);
                            
                            die();
                        }
                        
                    $licence_status         =   SOLIW_functions::get_licence_status( $licence_data->order_item_id );
                    if ( !in_array( $licence_status, array('active', 'not-activated') ) )
                        {
                            $response['status']      =  'error';
                            $response['message']     =  __( 'Order status not allowed the operation', 'software-license-lite' );
                            echo wp_json_encode($response);
                            
                            die();
                        }
                    
                    $product_id                     =   SOLIW_functions::get_product_id_from_order_item_id($licence_data->order_item_id);
                    //check the product ID
                    $local_product_unique_id        =   get_post_meta($product_id, '_sl_software_unique_title', TRUE);
                    
                    $this->ping_origin_domain( $licence_data, $local_product_unique_id, array ( $licence_data ) );
                    
                    //prepare the API call
                    global $SOLIW_API;
                    
                    $args       =   array(
                                            'licence_key'       =>  $licence_data->licence,
                                                  
                                            );
                    
                    $args['woo_sl_action']          =   'deactivate';
                    $args['licence_key']            =   $licence_data->licence;
                    $args['domain']                 =   $licence_data->active_domain;
                                        
                    $args['product_unique_id']      =   $local_product_unique_id;
                    
                    $response   = $SOLIW_API->API_call($args);
                    $response   =   json_decode($response);
                    
                    end($response);
                    $response_data = current($response);
                    
                    //return data for other elements
                    $key_instances                   =   SOLIW_functions::get_license_key_instances($licence_data->licence, $licence_data->order_id, $licence_data->order_item_id);
                    $args =     array();
                    $response_data->html[$licence_id]   =   '';
                    foreach($key_instances as  $key    =>  $key_instance)
                        {
                            $show_key   =   ($key < 1)  ?   TRUE    :   FALSE;
                            
                            $args['show_key']       =   $show_key;
                            $args['domain']         =   $key_instance->active_domain;
                            
                            $response_data->html[$key_instance->id]             =  SOLIW_functions::interface_get_licence_row($key_instance->id, $args);
                        }
                                        
                    echo wp_json_encode($response_data);
                    die();
                                        
                }
                
            
            /**
            * put your comment there...
            *     
            */
            function AJAX_key_delete()
                {
                    
                    $response_data = array();
                    $licence_id     =   isset ( $_POST['license_id'] )  ?   intval( $_POST['license_id'] )  :   '';
                    
                    //check nonce
                    $nonce = isset( $_POST['wpnonce'] ) ? sanitize_text_field( wp_unslash( $_POST['wpnonce'] ) ) : '';
                    if ( ! wp_verify_nonce( $nonce, 'woo_sl/actions/delete/' . $licence_id ) )
                        {
                            $response_data['status']      =  'error';
                            $response_data['message']     =  __( 'Invalid security code', 'software-license-lite' );
                            echo wp_json_encode($response_data);
                            
                            die();
                        }
                    
                    $licence_data = SOLIW_functions::get_licence_key_data_by_licence_id($licence_id);
                    
                    if(!is_object($licence_data))
                        {
                            $response_data['status']      =  'error';
                            $response_data['message']     =  __( 'Invalid data', 'software-license-lite' );
                            echo wp_json_encode($response_data);
                            
                            die();
                        }
                        
                    $order_id   =   $licence_data->order_id;   
                        
                    $user_id = get_current_user_id();
                    
                    //check user capability over this purchase
                    $order_data =   new WC_Order($order_id);
                    if(
                        $order_data->get_user_id()   !=  $user_id   
                        && (is_user_logged_in() && (  !current_user_can( 'edit_shop_order' )  &&  !current_user_can( 'install_plugins' )     ))
                        )
                        {
                            $response['status']      =  'error';
                            $response['message']     =  __( 'No capabilities over this order', 'software-license-lite' );
                            echo wp_json_encode($response);
                            
                            die();
                        }
                        
                        
                    $licence_status         =   SOLIW_functions::get_licence_status( $licence_data->order_item_id );
                    if ( !in_array( $licence_status, array('active', 'not-activated') ) )
                        {
                            $response['status']      =  'error';
                            $response['message']     =  __( 'Order status not allowed the operation', 'software-license-lite' );
                            echo wp_json_encode($response);
                            
                            die();
                        } 
                    
                    //check for ignore actions
                    $ignore_actions                 =   apply_filters_deprecated( 'woo_sl/get_licence_actions', array( array(), $licence_data->id, "" ), '3.2.1', 'woo_sl/license_manage/get_disabled_actions' );
                    
                    $ignore_actions                 =   apply_filters('woo_sl/license_manage/disabled_actions', array(), $licence_data->id, "" );
                    
                    if ( is_array ( $ignore_actions )   &&   isset ( $ignore_actions['delete'] )    &&  $ignore_actions['delete']   === TRUE )
                        {
                            $response['status']      =  'error';
                            $response['message']     =  __( 'Method not allowed', 'software-license-lite' );
                            echo wp_json_encode($response);
                            
                            die();
                        }
                    
                    $product_id =   SOLIW_functions::get_product_id_from_order_item_id($licence_data->order_item_id);
                    //check the product ID
                    $local_product_unique_id        = get_post_meta($product_id, '_sl_software_unique_title', TRUE);
                    
                    $key_instances                   =   SOLIW_functions::get_license_key_instances($licence_data->licence, $licence_data->order_id, $licence_data->order_item_id);
                                        
                    $this->ping_origin_domain( $licence_data, $local_product_unique_id, $key_instances );
                    
                    //prepare the API call
                    global $SOLIW_API;    
                        
                    $args['woo_sl_action']          =   'key_delete';
                    $args['licence_key']            =   $licence_data->licence;
                                        
                    $args['product_unique_id']      =   $local_product_unique_id;
                    
                    $response   =   $SOLIW_API->API_call( $args );
                    $response   =   json_decode($response);
                    
                    end($response);
                    $response_data = current($response);
                    
                    //update the $order_licence_details var
                    $order_licence_details  =   SOLIW_functions::get_order_licence_details($licence_data->order_id);
                    
                    $response_data->sl_product_html    =   SOLIW_functions::interface_get_sl_product_select($order_licence_details);
                    
                    
                    foreach($key_instances as  $key    =>  $key_instance)
                        {
                            
                            $response_data->html[$key_instance->id]             =  '';
                        }
                    
                    echo wp_json_encode($response_data);
                    
                    die();    
                }
                
            
            /**
            * put your comment there...
            *     
            */
            function AJAX_licence_extend()
                {
                    
                    $response_data = array();
                    
                    $order_item_id      =   isset ( $_POST['order_item_id'] )   ?   intval ( $_POST['order_item_id'] )  :   '' ;
                   
                    //check nonce
                    $nonce = isset( $_POST['wpnonce'] ) ? sanitize_text_field( wp_unslash( $_POST['wpnonce'] ) ) : '';
                    if ( ! wp_verify_nonce( $nonce, 'woo_sl/actions/extend/' . $order_item_id ) )
                        {
                            $response_data['status']      =  'error';
                            $response_data['message']     =  __( 'Invalid security code', 'software-license-lite' );
                            echo wp_json_encode($response_data);
                            
                            die();
                        }

                    //retrieve the order by $order_item_id
                    $order_id   =   SOLIW_functions::get_order_by_item_id( $order_item_id );
                    if( $order_id < 1)
                        {
                            $response_data['status']      =  'error';
                            $response_data['message']     =  __( 'Invalid Order', 'software-license-lite' );
                            echo wp_json_encode($response_data);
                            
                            die();
                        }
                        
                    //check if this order_itme use licensing and can be extended
                    if( !   SOLIW_functions::order_item_using_licence_expire($order_id, $order_item_id))
                        {
                            $response_data['status']      =  'error';
                            $response_data['message']     =  __( 'This order item can\'t be extended', 'software-license-lite' );
                            echo wp_json_encode($response_data);
                            
                            die();
                        }
                    
                    $order_data     = new WC_Order($order_id);
                    $order_products =   $order_data->get_items();
                    
                    $order_item_data    =   '';
                    
                    foreach($order_products as  $__order_item_id => $item_data)
                        {
                            if($order_item_id   ==  $__order_item_id)   
                                {
                                    $order_item_data    =   $item_data;
                                    break;
                                }
                        }
                        
                    //check if extend is allowed
                    $woocommerce_licensing_show_extend_button_days_after    =   get_option('woocommerce_licensing_show_extend_button_days_after', 0);    
                    $today              =   time();
                    $expired_at         =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_expired_at',  TRUE);
                    $soliw_licensing_using_expire  =   SOLIW_functions::get_order_item_meta( $order_item_id,  '_woo_sl_licensing_using_expire',  TRUE);
                    
                    if ( $soliw_licensing_using_expire == 'yes' &&  ! empty ( $expired_at )  )
                        {
                            //check if disabled
                            if( $woocommerce_licensing_show_extend_button_days_after < 0    )
                                {
                                    $response_data['status']      =  'error';
                                    $response_data['message']     =  __( 'The extending is disabled for expired licenses.', 'software-license-lite' );
                                    echo wp_json_encode($response_data);
                                    
                                    die();   
                                }
                                else if( $woocommerce_licensing_show_extend_button_days_after > 0    )
                                {
                                    $reference_time     =   strtotime("+ " . (int)$woocommerce_licensing_show_extend_button_days_after ." days", $expired_at);
                                    if ( $reference_time    <  $today )
                                        {
                                            $response_data['status']      =  'error';
                                            $response_data['message']     =  __( 'The extending is disabled for expired licenses.', 'software-license-lite' );
                                            echo wp_json_encode($response_data);
                                            
                                            die();
                                        }   
                                } 
                        }
                    
                        
                    if (empty( $order_item_data ))
                        {
                            $response_data['status']      =  'error';
                            $response_data['message']     =  __( 'Unable to retrieve order item details', 'software-license-lite' );
                            echo wp_json_encode($response_data);
                            
                            die();   
                        }
                    
                    $found_in_cart  =   FALSE;
                    
                    //check if already in the cart
                    if ( WC()->cart   &&  sizeof( WC()->cart->get_cart() ) > 0 ) 
                        {
                            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item_data ) 
                                {
                                    
                                    //check for specific fields
                                    if( !   isset($cart_item_data['_woo_sl_extend'])    )
                                        continue;
                                        
                                    if( $cart_item_data['_woo_sl_extend_for']   ==  $order_item_id )
                                        {
                                            $found_in_cart  =   TRUE;
                                            break;
                                        }
                                }
                        }
                    
                    if( $found_in_cart  === FALSE)
                        {
                            add_filter('woocommerce_add_cart_item_data',                array('SOLIW_front', 'add_cart_item_data'), 99, 2);
                            
                            $GLOBALS['_woo_sl_extend_initial_order_item_id']    =   $order_item_id;
                                               
                            //add the product coreponding to the order item id, but not variablle to prevent issues if they are deleted later
                            WC()->cart->add_to_cart( $order_item_data->get_product_id(), $order_item_data->get_quantity(), $order_item_data->get_variation_id());
                            
                            remove_filter('woocommerce_add_cart_item_data',             array('SOLIW_front', 'add_cart_item_data'), 99, 2);
                        }
                        
                    $product_data   =   get_post( $order_item_data['product_id'] );                   
                    
                    $response['status']         =   'success';
                    $response['message']        =   '"' . $product_data->post_title . '" ' . __( 'have been added to your cart.', 'software-license-lite' );
                    
                    
                    $shop_page_url              = get_permalink( wc_get_page_id( 'cart' ) );
                    
                    $response['redirect_url']   =   $shop_page_url;

                    echo wp_json_encode($response);
                    
                    die();
                    
                }
                
          
                
            /**
            * Output the license group selection for the product variation
            *     
            * @param mixed $loop
            * @param mixed $variation_data
            * @param mixed $variation
            */
            function woocommerce_product_after_variable_attributes($loop, $variation_data, $variation)
                {                   
                    $variation_license_group_id =   get_post_meta($variation->ID, '_sl_license_group_id', TRUE);
                   
                    $_sl_groups     =   SOLIW_functions::get_product_licensing_groups( $variation->post_parent )
                    
                    ?>
                    <div style="" class="show_if_sl">
                        <p class="form-row">
                            <label>Licence Group:</label>
                            <select name="variation_licence_group[<?php echo esc_html ( $loop ) ?>]">
                                <option <?php selected( $variation_license_group_id, "" ); ?> value=""></option>
                                <?php
                                
                                    foreach ($_sl_groups    as  $license_group_id   =>  $group_data)
                                        {
                                            ?><option <?php selected( $variation_license_group_id, $license_group_id ); ?> value="<?php echo esc_html ( $license_group_id ) ?>"><?php echo esc_html ( $group_data['group_title'] ) ?></option><?php
                                        }
                                
                                ?>                  
                            </select>
                        </p>
                    </div>
                    <?php   
                }
            
            /**
            * put your comment there...
            *     
            * @param mixed $variation_id
            * @param mixed $i
            */
            function woocommerce_save_product_variation( $variation_id, $i )
                {
                    //check for licence group
                    // phpcs:ignore WordPress.Security.NonceVerification.Missing 
                    $variation_licence_group   = isset( $_POST['variation_licence_group'] ) ? array_map('intval', $_POST['variation_licence_group'] ) : array();
                    
                    $current_variation_licence_group    =   isset($variation_licence_group[$i]) ?   $variation_licence_group[$i]    :   '';
                    
                    update_post_meta($variation_id, '_sl_license_group_id', $current_variation_licence_group);
                }
                
          
            
            /**
            * 
            * Attempt to ping the origin domain
            * 
            */
            function ping_origin_domain( $licence_data, $local_product_unique_id, $licence_instances )
                {
                    
                    $woocommerce_licensing_on_deactivate_ping_domain_origin     =   get_option('woocommerce_licensing_on_deactivate_ping_domain_origin');
                    if ( $woocommerce_licensing_on_deactivate_ping_domain_origin != 'yes' )
                        return;
                    
                    if ( empty ( $licence_instances ) )   
                        return;
                                                
                    //check if is a valid domain
                    $pattern = '/^(?:[-A-Za-z0-9]+\.)+[A-Za-z]{2,6}$/';
                    foreach ( $licence_instances as   $licence_instance )
                        {
                            if ( empty ( $licence_instance->active_domain ) )
                                continue;
                                
                            if ( preg_match ( $pattern, $licence_instance->active_domain ) ) 
                                {
                                    $request_uri    =   'https://' . $licence_instance->active_domain . '/?woo_sl_action=ping-deactivation&product_unique_id=' . $local_product_unique_id . '&licence_key=' . $licence_instance->licence ;
                                
                                    wp_remote_get( $request_uri, array(
                                                                        'sslverify'     => FALSE,
                                                                        'timeout'       => 3,
                                                                        'user-agent'    => 'WordPress/WOOSL',
                                                                        ) );
                                }
                        }
                }
                
        }
        
    new SOLIW_AJAX();
        
?>