<?php
    
    defined( 'ABSPATH' ) || exit;
    
    class SOLIW_admin_product 
        {
             /**
             * @var array
             */
            public $product_fields;

            /**
             * __construct function.
             *
             * @access public
             * @return void
             */
            public function __construct() {
                                                                                  
                // Hooks
                add_action( 'woocommerce_product_write_panel_tabs',     array( $this, 'product_write_panel_tab' ) );
                add_action( 'woocommerce_product_data_panels',          array( $this, 'product_write_panel' ) );
                add_filter( 'woocommerce_admin_process_product_object',         array( $this, 'product_save_data' ) );

                add_filter( 'product_type_options',                     array( $this, 'product_type_options' ) );
                
                //enqueue css & js for product post type
                add_action( 'admin_enqueue_scripts',                    array($this, 'add_admin_product_scripts'), 10, 1);

            }
                
            function add_admin_product_scripts($hook)
                {
                   
                    $screen = get_current_screen();

                    if(!is_object($screen) || $screen->id != 'product')
                        return;
                    
                    $myFile = SOLIW_URL . '/css/admin-product.css';
                    wp_register_style('soliw-admin-product.css', $myFile, array(), SOLIW_VERSION);
                    wp_enqueue_style( 'soliw-admin-product.css');
                    
                    $myJavascriptFile = SOLIW_URL . '/js/admin-product.js';
                    wp_register_script('soliw-admin-product.js', $myJavascriptFile, array(), SOLIW_VERSION, false);
                    wp_enqueue_script( 'soliw-admin-product.js'); 
                    
                    wp_register_style('flatpickr.css', SOLIW_URL . '/css/flatpickr.css', array(), SOLIW_VERSION);
                    wp_enqueue_style( 'flatpickr.css');
                    
                    wp_register_script('flatpickr.js', SOLIW_URL . '/js/flatpickr.js', array(), SOLIW_VERSION, false);
                    wp_enqueue_script( 'flatpickr.js');
                                         
                }
            
            
            public function product_type_options( $options ) 
                {

                    $options['sl_enabled'] = array(
                                                'id'                    => '_sl_enabled',
                                                'wrapper_class'         => 'show_if_simple show_if_variable',
                                                'label'                 => __("Licence", 'software-license-lite'),
                                                'description'           => __("Licence allow keys to be created and allow API software update access.", 'software-license-lite')
                                            );
                    
                    return $options;
                }


            
            /**
            * Define the custom new fields
            * 
            */
            public function define_fields() 
                {
                    global $post;

                    if ( $this->product_fields ) return;

                    // Fields
                    $this->product_fields = array(
                                                    'start_group',
                                                    array(
                                                        'id'                => '_sl_section_general',
                                                        'label'             => __( 'General', 'software-license-lite' ),
                                                        'type'              => 'section_title'
                                                    ),
                                                    array(
                                                        'id'                => '_sl_software_title',
                                                        'label'             => '<strong>' . __( 'Title', 'software-license-lite' ) . '</strong>',
                                                        'class'             =>  '',
                                                        'description'       => __( 'This software title.', 'software-license-lite' ),
                                                        'placeholder'       => __( 'e.g. Custom Plugin', 'software-license-lite' ),
                                                        'value'             =>  get_post_meta( $post->ID, '_sl_software_title', true ),
                                                        'type'              => 'text'
                                                    ),
                                                    array(
                                                        'id'                => '_sl_software_unique_title',
                                                        'label'             => __( 'Unique ID', 'software-license-lite' ),
                                                        'class'             =>  '',
                                                        'description'       => __( 'This unique ID/Name is used by the API to identify the software. Allowed alphanumeric, underscore, comma chars.', 'software-license-lite' ),
                                                        'placeholder'       => __( 'e.g. WP-PLG-38', 'software-license-lite' ),
                                                        'value'             =>  get_post_meta( $post->ID, '_sl_software_unique_title', true ),
                                                        'type'              => 'text'
                                                    ),
                                                    array(
                                                        'id'                => '_sl_new_version',
                                                        'label'             => __( 'Version', 'software-license-lite' ),
                                                        'class'             =>  '',
                                                        'description'       => __( 'The software version number.', 'software-license-lite' ),
                                                        'placeholder'       => __( 'e.g. 2.1', 'software-license-lite' ),
                                                        'value'             =>  get_post_meta( $post->ID, '_sl_new_version', true ),
                                                        'type'              => 'text'
                                                    ),
                                                    array(
                                                        'id'                => '_sl_author',
                                                        'label'             => __( 'Author', 'software-license-lite' ),
                                                        'class'             =>  '',
                                                        'description'       => __( 'The author of the software.', 'software-license-lite' ),
                                                        'placeholder'       => __( 'Nsp Code', 'software-license-lite' ),
                                                        'value'             =>  get_post_meta( $post->ID, '_sl_author', true ),
                                                        'type'              => 'text'
                                                    ),
                                                    array(
                                                        'id'                => '_sl_plugin_url',
                                                        'label'             => __( 'Homepage URL', 'software-license-lite'),
                                                        'class'             =>  '',
                                                        'description'       => __( 'The software page URL.', 'software-license-lite' ),
                                                        'placeholder'       => __( 'http://custom-plugin.com', 'software-license-lite' ),
                                                        'value'             =>  get_post_meta( $post->ID, '_sl_plugin_url', true ),
                                                        'type'              => 'text'
                                                    ),
                                                    'end_group',
                                                  
                                                    'start_group',
                                                    
                                                    array(
                                                        'id'                => '_sl_section_general',
                                                        'label'             => __( 'WordPress API', 'software-license-lite' ),
                                                        'type'              => 'section_title'
                                                    ),
                                                    array(
                                                        'id'                => '_sl_version_required',
                                                        'label'             => __( 'WP Version Required', 'software-license-lite' ),
                                                        'class'             =>  '',
                                                        'description'       => __( 'Minimum WordpPress version which is requires.', 'software-license-lite' ),
                                                        'placeholder'       => __( 'e.g. 3.2', 'software-license-lite' ),
                                                        'value'             =>  get_post_meta( $post->ID, '_sl_version_required', true ),
                                                        'type'              => 'text'
                                                    ),
                                                    array(
                                                        'id'                => '_sl_tested_up_to',
                                                        'label'             => __( 'WP Version Tested Up To', 'software-license-lite' ),
                                                        'class'             =>  '',
                                                        'description'       => __( 'Highest version of WordPress software was tested on.', 'software-license-lite' ),
                                                        'placeholder'       => __( 'e.g. 4.0', 'software-license-lite' ),
                                                        'value'             =>  get_post_meta( $post->ID, '_sl_tested_up_to', true ),
                                                        'type'              => 'text'
                                                    ),
                                                    array(
                                                        'id'                => '_sl_last_updated',
                                                        'label'             => __( 'Software Last Updated', 'software-license-lite' ),
                                                        'class'             =>  'flatpickr flatpickr-input',
                                                        'description'       => __( 'When the software was last updated.', 'software-license-lite'),
                                                        'placeholder'       => __( 'YYYY-MM-DD', 'software-license-lite' ),
                                                        'value'             =>  get_post_meta( $post->ID, '_sl_last_updated', true ),
                                                        'type'              => 'text'
                                                    ),
                                                    array(
                                                        'id'                => '_sl_update_nottice',
                                                        'label'             => __( 'WP Update notice', 'software-license-lite' ),
                                                        'class'             =>  '',
                                                        'description'       => __( 'WP Update notice.', 'software-license-lite' ),
                                                        'placeholder'       => __( 'e.g. Update Available', 'software-license-lite' ),
                                                        'value'             =>  get_post_meta( $post->ID, '_sl_update_nottice', true ),
                                                        'type'              => 'text'
                                                    ),
                                                    'end_group',
                                                    'start_group',
                                                    array(
                                                        'id'                => '_sl_section_general',
                                                        'label'             => __( 'Meta', 'software-license-lite' ),
                                                        'type'              => 'section_title'
                                                    ),
                                                    array(    
                                                           'id'                     =>  '_sl_description',
                                                           'class'                  =>  '_sl_description_field',
                                                           'label'                  =>  __('Description', 'software-license-lite'),
                                                           'description'            =>  __('A description of the software', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'class'                  =>  'chosen_select',
                                                           'selected'               =>  absint( get_post_meta( $post->ID, '_sl_description', true ) ),
                                                           'type'                   =>  'woo_custom_select'
                                                           ),
                                                           
                                                           
                                                    array(    
                                                           'id'                     =>  '_sl_installation',
                                                           'class'                  =>  '_sl_installation_field',
                                                           'label'                  =>  __('Installation', 'software-license-lite'),
                                                           'description'            =>  __('This section describes how to install the software and get it working.', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'class'                  =>  'chosen_select',
                                                           'selected'               =>  absint( get_post_meta( $post->ID, '_sl_installation', true ) ),
                                                           'type'                   =>  'woo_custom_select'
                                                           ),
                                                           
                                                    array(    
                                                           'id'                     =>  '_sl_faq',
                                                           'class'                  =>  '_sl_faq_field',
                                                           'label'                  =>  __('FAQ', 'software-license-lite'),
                                                           'description'            =>  __('Frequently Asked Questions.', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'class'                  =>  'chosen_select',
                                                           'selected'               =>  absint( get_post_meta( $post->ID, '_sl_faq', true ) ),
                                                           'type'                   =>  'woo_custom_select'
                                                           ),

                                                    array(    
                                                           'id'                     =>  '_sl_screenshots',
                                                           'class'                  =>  '_sl_screenshots_field',
                                                           'label'                  =>  __('Screenshots', 'software-license-lite'),
                                                           'description'            =>  __('Screenshots.', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'class'                  =>  'chosen_select',
                                                           'selected'               =>  absint( get_post_meta( $post->ID, '_sl_screenshots', true ) ),
                                                           'type'                   =>  'woo_custom_select'
                                                           ),          

                                                    array(    
                                                           'id'                     =>  '_sl_changelog',
                                                           'class'                  =>  '_sl_changelog_field',
                                                           'label'                  =>  __('Changelog', 'software-license-lite'),
                                                           'description'            =>  __('Changes in the software.', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'class'                  =>  'chosen_select',
                                                           'selected'               =>  absint( get_post_meta( $post->ID, '_sl_changelog', true ) ),
                                                           'type'                   =>  'woo_custom_select'
                                                           ),
                                                    array(    
                                                           'id'                     =>  '_sl_reviews',
                                                           'class'                  =>  '_sl_reviews_field',
                                                           'label'                  =>  __('Reviews', 'software-license-lite'),
                                                           'description'            =>  __('Software reviews.', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'class'                  =>  'chosen_select',
                                                           'selected'               =>  absint( get_post_meta( $post->ID, '_sl_reviews', true ) ),
                                                           'type'                   =>  'woo_custom_select'
                                                           ),
                                                           
                                                    array(    
                                                           'id'                     =>  '_sl_other_notes',
                                                           'class'                  =>  '_sl_other_notes_field',
                                                           'label'                  =>  __('Other Notes', 'software-license-lite'),
                                                           'description'            =>  __('Other Notes of the software.', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'class'                  =>  'chosen_select',
                                                           'selected'               =>  absint( get_post_meta( $post->ID, '_sl_additional_details', true ) ),
                                                           'type'                   =>  'woo_custom_select'
                                                           ),
                                                    
                                                    array(    
                                                           'id'                     =>  '_sl_screenshots_low',
                                                           'class'                  =>  '_sl_screenshots_low',
                                                           'label'                  =>  __('Screenshot 1', 'software-license-lite'),
                                                           'description'            =>  __('Low resolution banner 772x250 px', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'value'                  =>  get_post_meta( $post->ID, '_sl_screenshots_low', true ),
                                                           'type'                   =>  'text'
                                                           ),
                                                           
                                                    array(    
                                                           'id'                     =>  '_sl_screenshots_high',
                                                           'class'                  =>  '_sl_screenshots_high',
                                                           'label'                  =>  __('Screenshot 2', 'software-license-lite'),
                                                           'description'            =>  __('High resolution banner 1544x500 px', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'value'                  =>  get_post_meta( $post->ID, '_sl_screenshots_high', true ),
                                                           'type'                   =>  'text'
                                                           ),
                                                    
              
                                                    array(    
                                                           'id'                     =>  '_sl_icons_svg',
                                                           'class'                  =>  '_sl_icons_svg',
                                                           'label'                  =>  __('Icon SVG', 'software-license-lite'),
                                                           'description'            =>  __('SVG icon', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'value'                  =>  get_post_meta( $post->ID, '_sl_icons_svg', true ),
                                                           'type'                   =>  'text'
                                                           ),
                                                    array(    
                                                           'id'                     =>  '_sl_icons_1x',
                                                           'class'                  =>  '_sl_icons_1x',
                                                           'label'                  =>  __('Icon 1X', 'software-license-lite'),
                                                           'description'            =>  __('Low resolution PNG/JPG icon 128x128 px', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'value'                  =>  get_post_meta( $post->ID, '_sl_icons_1x', true ),
                                                           'type'                   =>  'text'
                                                           ),
                                                    array(    
                                                           'id'                     =>  '_sl_icons_2x',
                                                           'class'                  =>  '_sl_icons_2x',
                                                           'label'                  =>  __('Icon 2X', 'software-license-lite'),
                                                           'description'            =>  __('High resolution PNG/JPG icon 256x256 px', 'software-license-lite'),
                                                           'sort_column'            =>  'menu_order',
                                                           'sort_order'             =>  'ASC',
                                                           'value'                  =>  get_post_meta( $post->ID, '_sl_icons_2x', true ),
                                                           'type'                   =>  'text'
                                                           ),

                                                           
                                                    'end_group',
                                                    'start_group',
                                                    array(
                                                        'function'                  => 'SOLIW_admin_product::html_license_keys',
                                                        'type'                      => 'custom_function'
                                                    ),
                                                    'end_group',
                                                );

                    $this->product_fields       =   apply_filters('woo_sl/admin/product_fields', $this->product_fields);                            
                    
                }

            /**
            * adds Licence tab to the product interface
            */
            public function product_write_panel_tab() 
                {

                    ?>
                    <li class="sl_tab show_if_sl"><a href="#sl_data"><span><?php esc_html_e( 'Licence', 'software-license-lite'); ?></span></a></li>
                    <?php
                }

                   
            /**
             * adds the panel to the product interface
             */
            public function product_write_panel() 
                {
                    global $post, $woocommerce;

                    $this->define_fields();

                    $data = get_post_meta( $post->ID, 'product_data', true );

                    ?>

                    <div id="sl_data" class="panel woocommerce_options_panel">
                                    
                        <?php
                        
                        wp_nonce_field( 'woo_sl/product-license-details', '_nonce_product_license_details' );

                        foreach ( $this->product_fields as $field ) 
                            {

                                if ( ! is_array( $field ) ) 
                                    {
                                        if ( $field == 'start_group' ) 
                                            {
                                                echo '<div class="options_group">';
                                            } 
                                        elseif ( $field == 'end_group' ) 
                                            {
                        
                                                echo '</div>';
                                            }

                                        continue;    
                                    } 
                                
                                switch($field['type'])
                                    {
                                        case 'custom_function'      :
                                                                        call_user_func($field['function'], $field);
                                                                        
                                                                        break;
                                        
                                        case 'section_title'    :
                                        
                                        
                                                                    ?><h4<?php  if( isset($field['style']) ) { ?> style="<?php echo esc_html ( $field['style'] ) ?>"<?php }  ?>><?php echo esc_html ( $field['label'] ) ?></h4><?php
                                                                    
                                                                    if(isset($field['description']) && !empty($field['description'])) 
                                                                        {
                                                                            ?><span class="description spaced"><?php echo esc_html (  $field['description'] ) ?></span><?php   
                                                                        }
                                                                    break;
                                        
                                        
                                        case  'header'   :
                                                    ?>
                                                        <p class="form-field <?php echo esc_html ( $field['class'] ) ?>"<?php  if( isset($field['style']) ) { ?> style="<?php echo esc_html ( $field['style'] ) ?>"<?php }  ?>>
                                                            <strong><label><?php echo esc_html ( $field['label'] ) ?></label></strong>
                                                            <span class="description"><?php echo esc_html ( $field['description'] ) ?></span>
                                                         </p>
                                                    <?php
                                                    break;
                                                    
                                                    
                                        case  'text'   :
                                                    $field['placeholder']   = isset( $field['placeholder'] ) ? $field['placeholder'] : '';
                                                    $field['class']         = isset( $field['class'] ) ? $field['class'] : 'short';
                                                    $field['style']         = isset( $field['style'] ) ? $field['style'] : '';
                                                    $field['wrapper_class'] = isset( $field['wrapper_class'] ) ? $field['wrapper_class'] : '';
                                                    $field['value']         = isset( $field['value'] ) ? $field['value'] : '';
                                                    $field['name']          = isset( $field['name'] ) ? $field['name'] : $field['id'];
                                                    $field['type']          = isset( $field['type'] ) ? $field['type'] : 'text';
                                                    $field['desc_tip']      = isset( $field['desc_tip'] ) ? $field['desc_tip'] : false;
                                                    $data_type              = empty( $field['data_type'] ) ? '' : $field['data_type'];

                                                    switch ( $data_type ) {
                                                        case 'price' :
                                                            $field['class'] .= ' wc_input_price';
                                                            $field['value']  = wc_format_localized_price( $field['value'] );
                                                            break;
                                                        case 'decimal' :
                                                            $field['class'] .= ' wc_input_decimal';
                                                            $field['value']  = wc_format_localized_decimal( $field['value'] );
                                                            break;
                                                        case 'stock' :
                                                            $field['class'] .= ' wc_input_stock';
                                                            $field['value']  = wc_stock_amount( $field['value'] );
                                                            break;
                                                        case 'url' :
                                                            $field['class'] .= ' wc_input_url';
                                                            $field['value']  = esc_url( $field['value'] );
                                                            break;

                                                        default :
                                                            break;
                                                    }

                                                    // Custom attribute handling
                                                    $custom_attributes = array();

                                                    if ( ! empty( $field['custom_attributes'] ) && is_array( $field['custom_attributes'] ) ) {

                                                        foreach ( $field['custom_attributes'] as $attribute => $value ) {
                                                            $custom_attributes[] = esc_attr( $attribute ) . '="' . esc_attr( $value ) . '"';
                                                        }
                                                    }

                                                    echo '<p class="form-field ' . esc_attr( $field['id'] ) . '_field ' . esc_attr( $field['wrapper_class'] ) . '" style="'. esc_attr( $field['style'] )  .'">
                                                        <label for="' . esc_attr( $field['id'] ) . '">' . wp_kses_post( $field['label'] ) . '</label>';

                                                    if ( ! empty( $field['description'] ) && false !== $field['desc_tip'] ) {
                                                        echo wp_kses_post ( wc_help_tip( $field['description'] ) );
                                                    }

                                                    echo '<input type="' . esc_attr( $field['type'] ) . '" class="' . esc_attr( $field['class'] ) . '" name="' . esc_attr( $field['name'] ) . '" id="' . esc_attr( $field['id'] ) . '" value="' . esc_attr( $field['value'] ) . '" placeholder="' . esc_attr( $field['placeholder'] ) . '" ' . esc_html ( implode( ' ', $custom_attributes ) ) . ' /> ';

                                                    if ( ! empty( $field['description'] ) && false === $field['desc_tip'] ) {
                                                        echo '<span class="description">' . wp_kses_post( $field['description'] ) . '</span>';
                                                    }

                                                    echo '</p>';
                                                    break; 
                                        
                                        case  'woo_custom_select'   :
                                                    ?>
                                                        <p class="form-field <?php echo esc_html (  $field['class'] ) ?>"<?php  if( isset($field['style']) ) { ?> style="<?php echo esc_html ( $field['style'] ) ?>"<?php }  ?>>
                                                            <label for="<?php echo esc_html (  $field['id'] ) ?>"><?php echo esc_html (  $field['label'] ) ?></label>
                                                    
                                                    <?php
                                                        
                                                        $output_post_types   =   apply_filters('woo_sl/admin_product/woo_custom_select/post_type', array('page', 'post' ));
                                                        if  ( ! is_array( $output_post_types )   && !    empty ($output_post_types ))
                                                            $output_post_types   =   (array)$output_post_types;
                                                        
                                                        $output_html    =   '';
                                                            
                                                        foreach ( $output_post_types as  $output_post_type )
                                                            {
                                                                $post_type_data =   get_post_type_object( $output_post_type );   
                                                                if ( ! is_object($post_type_data) )
                                                                    continue;
                                                                
                                                                $option_list    =   '';    
                                                                if  ( $post_type_data->hierarchical  === TRUE )
                                                                    {
                                                                        $html_array_data    =   array_merge( $field , array('post_status' => array('publish', 'draft'), 'echo' =>  FALSE, 'name'   => $field['id'], 'show_option_none'     => ' ', 'post_type' => $output_post_type, 'number' =>  999  ) );
                                                                        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                                                                        $html_select    =   wp_dropdown_pages( $html_array_data );
                                                                        preg_match_all( "/(<option.*?>.*<\/option>)/im",$html_select, $matches );
                                                                        if  ( isset ( $matches['1'] ) )
                                                                            {
                                                                                foreach ( $matches['1'] as  $option )    
                                                                                    {
                                                                                        preg_match('/value="([0-9]+)"/im', $option, $option_value);
                                                                                        if ( isset($option_value[1])    &&  ! empty ($option_value[1] ))  
                                                                                            $option_list    .=  $option;
                                                                                    }
                                                                            }
                                                                    }
                                                                    else
                                                                    {
                                                                        $args   =   array(
                                                                                            'post_type'         =>  $output_post_type,
                                                                                            'posts_per_page'    =>  -1
                                                                                            );
                                                                        $posts              =   get_posts( $args );
                                                                        foreach ( $posts    as  $object_post )
                                                                            {
                                                                                $selected   =   "";
                                                                                if ( isset($field['selected'])   &&  $field['selected']  ==  $object_post->ID )
                                                                                    $selected   =   ' selected="selected" ';
                                                                                $option_list    .=  '<option '.$selected.'class="level-0" value="'. $object_post->ID .'">'. $object_post->post_title .'</option>';   
                                                                            }
                                                                        
                                                                    }
                                                                
                                                                if ( empty($option_list))
                                                                    continue;
                                                                
                                                                if ( count ( $output_post_types ) > 1 )    
                                                                    $output_html    .=  '<optgroup label="'.  $post_type_data->label  .'">'    .   $option_list    .'</optgroup>';
                                                                    else
                                                                    $output_html    .=  $option_list;
                                                                
                                                            }
                                                            
                                                        if  ( ! empty ($output_html))
                                                            {
                                                                ?><select name='<?php echo esc_html ( $field['id'] ) ?>' class='wc-enhanced-select-nostd wc_sl_chosen' data-placeholder='<?php esc_html_e ( 'Select a page', 'software-license-lite' ) ?>' id='<?php echo esc_html ( $field['id'] ) ?>'>
                                                                            <option value=''></option>
                                                                            <?php 
                                                                            
                                                                            $allowed_tags = array(
                                                                                                    'br'     => array(),
                                                                                                    'optgroup'   => array(
                                                                                                        'label' => array(),
                                                                                                        'id'    => array(),
                                                                                                    ),
                                                                                                    'b'      => array(),
                                                                                                    'option' => array(
                                                                                                        'class' => array(),
                                                                                                        'value' => array(),
                                                                                                        'selected' => array(),
                                                                                                    ),
                                                                                                );
                                                                            
                                                                            echo wp_kses ( $output_html, $allowed_tags ) ?>
                                                                       </select>
                                                                       <span class='description'><?php echo esc_html ( $field['description'] ) ?></span>   
                                                                        <?php
                                                                
                                                            }
                                         
                                                    ?>
                                                        </p>
                                                    <?php
                                                    break; 
                                                    
                                        case  'woo_select'   :
                                        
                                                    $defaults   = array (
                                                                            'style'         =>  '',
                                                                            'description'   =>  ''
                                                                        );
                                                                        
                                                    // Parse incoming $args into an array and merge it with $defaults
                                                    $field   =   wp_parse_args( $field, $defaults );
                                        
                                                    // Custom attribute handling
                                                    $custom_attributes = array();

                                                    if ( ! empty( $field['custom_attributes'] ) && is_array( $field['custom_attributes'] ) ) {

                                                        foreach ( $field['custom_attributes'] as $attribute => $value ){
                                                            $custom_attributes[] = esc_attr( $attribute ) . '="' . esc_attr( $value ) . '"';
                                                        }
                                                    }
                                        
                                                    ?>
                                                        <p class="form-field <?php echo esc_html ( $field['class'] ) ?>"<?php  if( isset($field['style']) ) { ?> style="<?php echo esc_html ( $field['style'] ) ?>"<?php }  ?>>
                                                            <label for="<?php echo esc_html ( $field['id'] ) ?>"><?php echo esc_html ( $field['label'] ) ?></label>
                                                    
                                                        <select id="<?php echo esc_attr( $field['id'] ) ?>" name="<?php echo esc_attr( $field['id'] ) ?>" class="<?php echo esc_attr( $field['class'] ) ?>" style="<?php echo esc_attr( $field['style'] ) ?>" <?php echo esc_html ( implode( ' ', $custom_attributes ) ) ?>><?php

                                                        foreach ( $field['options'] as $key => $value ) {
                                                            ?><option value="<?php echo esc_attr( $key ) ?>" <?php selected( esc_attr( $field['value'] ), esc_attr( $key ), false ) ?>><?php echo esc_html( $value ) ?></option><?php
                                                        }

                                                        ?></select><?php
                                                    
                                                    if  ( ! empty ( $field['description']) )
                                                        {
                                                            ?><span class="description"><?php echo esc_html ( $field['description'] ) ?></span><?php   
                                                        }

                                                    ?>
                                                        </p>
                                                    <?php
                                                    break; 
                                                    
                                        case 'checkbox':
                                                    
                                                    $value  =   get_post_meta( $post->ID, '_sl_allow_instances_per_key_change', true );
                                                    
                                                    ?>
                                                        <p class="form-field <?php echo esc_html ( $field['class'] ) ?><?php  if( isset($field['style']) ) { ?> style="<?php echo esc_html ( $field['style'] ) ?>"<?php }  ?>">
                                                            <label for="<?php echo esc_html ( $field['id'] ) ?>"><?php echo esc_html ( $field['label'] ) ?></label>
                                                            <input type="checkbox" class="<?php echo esc_html ( $field['class'] ) ?>" name="<?php echo esc_html ( $field['id'] ) ?>" id="<?php echo esc_html ( $field['id'] ) ?>" value="yes" <?php checked( 'yes', $value) ?> />

                                                            
                                                            <?php
                                                            
                                                                if ( isset( $field['desc_tip'] ) && false !== $field['desc_tip'] ) 
                                                                    {
                                                                        echo '<img class="help_tip" data-tip="' . esc_attr( $field['desc_tip'] ) . '" src="' . esc_url( WC()->plugin_url() ) . '/assets/images/help.png" height="16" width="16" />';
                                                                    }
                                                            
                                                            ?>
                                                            <span class="description"><?php echo wp_kses_post( $field['description'] ) ?></span>
                                                        </p>
                                                    <?php
                                                    break;
                                        
                                        default:
                                                                    
                                                    $func = 'woocommerce_wp_' . $field['type'] . '_input';

                                                    if ( function_exists( $func ) )
                                                        $func( $field );
                                                    break;
                                        
                                    }

                            }
                        
                    ?>
                    
                    </div>
                    
                    <?php

                }

            /**
             * Saves the data for the SL Tab product writepanel input boxes
             */
            public function product_save_data( $product_object ) 
                {
                    
                    if ( ! isset ( $_POST['_nonce_product_license_details'] ) )
                        return;
                        
                    $nonce = isset( $_POST['_nonce_product_license_details'] ) ? sanitize_text_field( wp_unslash( $_POST['_nonce_product_license_details'] ) ) : '';
                    if ( ! wp_verify_nonce( $nonce, 'woo_sl/product-license-details') )
                        return;

                    $product_id =   $product_object->get_id();  
                        
                    // phpcs:ignore WordPress.Security.NonceVerification.Missing 
                    if ( ! empty( $_POST[ '_sl_enabled' ] ) ) 
                        update_post_meta( $product_id, '_sl_enabled', 'yes' ); 
                        else 
                        update_post_meta( $product_id, '_sl_enabled', 'no' );
                        
                    $sl_enabled =   get_post_meta ( $product_id, '_sl_enabled', TRUE );
                    if ( $sl_enabled    === 'no' )
                        return;
  
                    // Create the product_fields variable array
                    $this->define_fields();

                    //Writepanel text fields
                    foreach ( $this->product_fields as $field ) 
                        {
                            if ( is_array( $field ) ) 
                                {
                                    if(in_array($field['type'],     array('header', 'section_title')))
                                        continue;
                                    
                                    if($field['type']   ==  'custom_function')
                                        {
                                            call_user_func($field['function'] . '_save', $product_id);      
                                        }
                                        else
                                        {
                                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                                            $data = isset( $_POST[ $field['id'] ] ) ? trim( sanitize_text_field ( wp_unslash( $_POST[ $field['id'] ] ) ) ) : '';
                                            update_post_meta( $product_id, $field['id'], $data );
                                        }
                                }
                        }

                }
       
       
            public function html_license_keys()
                {
                    global $post;
                   
                    $_sl_groups     =   SOLIW_functions::get_product_licensing_groups($post->ID);
                                            
                    ?>
                        <h4>Licences</h4>
                        <div id="soliw_keys_root">
                        
                            <h2 id="soliw_keys_menu" class="nav-tab-wrapper wp-clearfix">
                                <?php 
                                
                                $first = TRUE;
                                foreach($_sl_groups as  $_sl_group) { ?>
                                <a href="javascript: void(0);" class="nav-tab <?php  
                                        if ( $first === TRUE ) 
                                            {
                                                $first  =   FALSE;
                                                echo 'nav-tab-active';
                                            }
                                        ?>"><?php echo esc_html ( $_sl_group['group_title'] ) ?></a>
                                <?php } ?>
                                <a href="javascript: void(0);" title="<?php esc_html_e( 'Add licence', 'software-license-lite' ) ?>" id="add_license_group_type" class="nav-tab nav-tab-active" onClick="return false;">+</a>
                            </h2>
                            
                            <div class="soliw_keys_groups">
                            <?php  
                            
                            $first = TRUE;
                            
                            foreach($_sl_groups as  $_sl_group)
                                {        
                                    ?>
                                    <div class="wc-metaboxes-wrapper wc-metabox soliw_keys_box" <?php  
                                        if ( $first === TRUE ) 
                                            $first  =   FALSE;
                                            else
                                            echo 'style="display: none"';
                                        ?>>
                                        
                                        <p class="form-field _sl_group_title_field ">
                                            <label for="_sl_group_title"><?php esc_html_e("Group title", 'software-license-lite') ?></label><input class="_sl_group_title_field" name="_sl_group_title[]" id="_sl_group_title" value="<?php echo esc_html ( $_sl_group['group_title'] ) ?>" type="text" /> 
                                            <span class="description"><?php esc_html_e("The license group title. Required to be unique per product.", 'software-license-lite') ?></span>
                                        </p>
                                        
                                        <p class="form-field _sl_licence_prefix_field _sl_licence_generate">
                                            <label for="_sl_licence_prefix"><?php esc_html_e("Licence Prefix", 'software-license-lite') ?></label><input class="_sl_licence_prefix_field" name="_sl_licence_prefix[]" id="_sl_licence_prefix" value="<?php echo esc_html ( $_sl_group['licence_prefix'] ) ?>" type="text"> 
                                            <span class="description"><?php esc_html_e("A prefix for generated keys.", 'software-license-lite') ?></span>
                                        </p>
                                        
                                        <p class="form-field _sl_max_keys_field ">
                                            <label for="_sl_max_keys"><?php esc_html_e("Maximum Licence Keys", 'software-license-lite') ?></label><input class="_sl_max_keys_field" name="_sl_max_keys[]" id="_sl_max_keys" value="<?php echo esc_html ( $_sl_group['max_keys'] ) ?>" type="text"> 
                                            <span class="description"><?php esc_html_e("The maximum number of licence keys which can generate.", 'software-license-lite') ?></span>
                                        </p>
                                        
                                        <p class="form-field _sl_max_instances_per_key_field ">
                                            <label for="_sl_max_instances_per_key"><?php esc_html_e("Instances per Key", 'software-license-lite') ?></label>
                                            <input class="_sl_max_instances_per_key" name="_sl_max_instances_per_key[]" id="_sl_max_instances_per_key" value="<?php echo esc_html ( $_sl_group['max_instances_per_key'] ) ?>" type="text"> 
                                            <span class="description"><?php esc_html_e("The maximum activations a key can be used along.", 'software-license-lite') ?></span>
                                        </p> 
                                        
                                        <p class="form-field _sl_max_instances_per_key_field ">
                                            <label for="_sl_use_predefined_keys"><?php esc_html_e("Use Predefined Keys", 'software-license-lite') ?></label>
                                            <select id="_sl_use_predefined_keys" name="_sl_use_predefined_keys[]" class="sl_use_predefined_keys" >
                                                <option <?php selected($_sl_group['use_predefined_keys'], 'no') ?> value="no"><?php esc_html_e("No", 'software-license-lite') ?></option>
                                                <option <?php selected($_sl_group['use_predefined_keys'], 'yes') ?> value="yes"><?php esc_html_e("Yes", 'software-license-lite') ?></option>
                                            </select>
                                            <span class="description"><?php esc_html_e("Enable the use of predefined license keys instead of automatically generating new ones during product activation.", 'software-license-lite') ?></span>
                                        </p>
                                        
                                        <p class="form-field _sl_max_instances_per_key_field _sl_licence_predefined">
                                            <label for="_sl_predefined_keys"><?php esc_html_e("Predefined Keys", 'software-license-lite') ?></label>
                                            <textarea name="_sl_predefined_keys[]" rows="30" cols="50" id="_sl_predefined_keys" class="large-text code"><?php echo esc_html( $_sl_group['predefined_keys'] ) ?></textarea>
                                            <span class="description"><?php esc_html_e("Single key per line. If use large list of keys, the Save may depend on server environment variables.", 'software-license-lite') ?> <?php esc_html_e("Allowed alphanumeric, underscore, comma chars.", 'software-license-lite') ?></span>
                                        </p>
                                        
                                        
                                        <p class="form-field _sl_use_expire">
                                            <label for="_sl_use_expire"><?php esc_html_e("Use Expire/Subscription", 'software-license-lite') ?> <span style="background-color: red;  color: white;  font-weight: bold;  padding: 0px 5px;">PRO</span></label>
                                            <select id="_sl_use_expire" name="_sl_use_expire[]" class="sl_use_expire">
                                                <option <?php selected($_sl_group['product_use_expire'], 'no') ?> value="no"><?php esc_html_e("No", 'software-license-lite') ?></option>
                                                <option disabled="disabled" value="yes"><?php esc_html_e("Yes - Default Expire", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                                <option disabled="disabled" value="woocommerce-subscriptions"><?php esc_html_e("WooCommerce Subscriptions", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                                <option disabled="disabled" value="yith-subscriptions"><?php esc_html_e("YITH WooCommerce Subscription", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                                <option disabled="disabled" value="wpsubscription"><?php esc_html_e("WP Subscription", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                            </select>
                                            <span class="description"><?php esc_html_e("Synchronize product licenses with subscription plugins to automatically manage license expirations, renewals, and validity based on active subscriptions.", 'software-license-lite') ?></span>
                                        </p>
                                    
                                                                        
                                        <p class="toolbar">                        
                                            <button class="remove_row button" type="button"><?php esc_html_e("Remove", 'software-license-lite') ?></button>
                                        </p>
                                        
                                    </div><?php
                                      
                                } ?>
                            </div>    
                            
                        </div>
                                   
                                       
                        
                        <div id="soliw_group_root" style="display: none">
              
                            <div class="wc-metaboxes-wrapper wc-metabox soliw_keys_box">
                                
                                <p class="form-field _sl_group_title_field ">
                                    <label for="_sl_group_title"><?php esc_html_e("Group title", 'software-license-lite') ?></label><input class="_sl_group_title_field" name="_sl_group_title[]" id="_sl_group_title" value="" type="text"> 
                                    <span class="description"><?php esc_html_e("The license group title. Required to be unique per product.", 'software-license-lite') ?></span>
                                </p>
                                
                                <p class="form-field _sl_licence_prefix_field _sl_licence_generate">
                                    <label for="_sl_licence_prefix"><?php esc_html_e("Licence Prefix", 'software-license-lite') ?></label><input class="_sl_licence_prefix_field" name="_sl_licence_prefix[]" id="_sl_licence_prefix" value="" type="text"> 
                                    <span class="description"><?php esc_html_e("A prefix for generated keys.", 'software-license-lite') ?></span>
                                </p>
                                
                                <p class="form-field _sl_max_keys_field ">
                                    <label for="_sl_max_keys"><?php esc_html_e("Maximum Licence Keys", 'software-license-lite') ?></label><input class="_sl_max_keys_field" name="_sl_max_keys[]" id="_sl_max_keys" value="" type="text"> 
                                    <span class="description"><?php esc_html_e("The maximum number of licence keys which can generate.", 'software-license-lite') ?></span>
                                </p>
                                
                                <p class="form-field _sl_max_instances_per_key_field ">
                                    <label for="_sl_max_instances_per_key"><?php esc_html_e("Instances per Key", 'software-license-lite') ?></label>
                                    <input class="_sl_max_instances_per_key" name="_sl_max_instances_per_key[]" id="_sl_max_instances_per_key" value="" type="text"> 
                                    <span class="description"><?php esc_html_e("The maximum activations a key can be used along.", 'software-license-lite') ?></span>
                                </p> 
                                
                                <p class="form-field _sl_max_instances_per_key_field ">
                                    <label for="_sl_use_predefined_keys"><?php esc_html_e("Use Predefined Keys", 'software-license-lite') ?></label>
                                    <select id="_sl_use_predefined_keys" name="_sl_use_predefined_keys[]" class="sl_use_predefined_keys" >
                                        <option value="no"><?php esc_html_e('No', 'software-license-lite')?></option>
                                        <option value="yes"><?php esc_html_e('Yes', 'software-license-lite') ?></option>
                                    </select>
                                    <span class="description"><?php esc_html_e("Enable the use of predefined license keys instead of automatically generating new ones during product activation.", 'software-license-lite') ?></span>
                                </p>
                                
                                <p class="form-field _sl_max_instances_per_key_field _sl_licence_predefined" style="display: none">
                                    <label for="_sl_predefined_keys"><?php esc_html_e("Predefined Keys", 'software-license-lite') ?></label>
                                    <textarea name="_sl_predefined_keys[]" rows="30" cols="50" id="_sl_predefined_keys" class="large-text code"></textarea>
                                    <span class="description"><?php esc_html_e("Single key per line. Large lists save may depend on server environment variables.", 'software-license-lite') ?></span>
                                </p>
                                
                                <p class="form-field _sl_use_expire">
                                    <label for="_sl_use_expire"><?php esc_html_e("Use Expire", 'software-license-lite') ?> <span style="background-color: red;  color: white;  font-weight: bold;  padding: 0px 5px;">PRO</span></label>
                                    <select id="_sl_use_expire" name="_sl_use_expire[]" class="sl_use_expire">
                                    
                                        <option selected="selected" value="no"><?php esc_html_e("No", 'software-license-lite') ?></option>
                                        <option disabled="disabled" value="yes"><?php esc_html_e("Yes - Default Expire", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                        <option disabled="disabled" value="woocommerce-subscriptions"><?php esc_html_e("WooCommerce Subscriptions", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                        <option disabled="disabled" value="yith-subscriptions"><?php esc_html_e("YITH WooCommerce Subscription", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                        <option disabled="disabled" value="wpsubscription"><?php esc_html_e("WP Subscription", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                    </select>
                                    <span class="description"><?php esc_html_e("Synchronize product licenses with subscription plugins to automatically manage license expirations, renewals, and validity based on active subscriptions.", 'software-license-lite') ?></span>
                                </p>
                              
                                <p class="toolbar">                        
                                    <button class="remove_row button" type="button"><?php esc_html_e("Remove", 'software-license-lite') ?></button>
                                </p>
       
                            </div>
                        </div>
                        
                    <?php   
                }
                
            public function html_license_keys_save( $product_id )
                {
                    
                    if ( ! isset ( $_POST['_nonce_product_license_details'] ) )
                        return;
                        
                    $nonce = isset( $_POST['_nonce_product_license_details'] ) ? sanitize_text_field( wp_unslash( $_POST['_nonce_product_license_details'] ) ) : '';
                    if ( ! wp_verify_nonce( $nonce, 'woo_sl/product-license-details') )
                        return;
                        
                    $_sl_groups =   array();
                    // phpcs:ignore WordPress.Security.NonceVerification.Missing, WordPress.Security.ValidatedSanitizedInput.InputNotValidated, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
                    $_sl_group_title    =   wc_clean ( wp_unslash( $_POST[ '_sl_group_title' ] ) );
                    foreach( $_sl_group_title as  $key    =>  $value )
                        {
                            $value  =   trim($value);
                            if($value   ==  '')
                                continue;
                            
                            $group_data =   array();
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['group_title']              =   isset ( $_POST[ '_sl_group_title' ][$key] ) ?   trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_group_title' ][$key] ) ) )  :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['licence_prefix']           =   isset ( $_POST[ '_sl_licence_prefix' ][$key] ) ?   trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_licence_prefix' ][$key] ) ) )  :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['max_keys']                 =   isset ( $_POST[ '_sl_max_keys' ][$key] ) ?  trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_max_keys' ][$key] ) ) )   :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['max_instances_per_key']    =   isset ( $_POST[ '_sl_max_instances_per_key' ][$key] ) ?  trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_max_instances_per_key' ][$key] ) ) ) :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['use_predefined_keys']      =   isset ( $_POST[ '_sl_use_predefined_keys' ][$key] ) ? trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_use_predefined_keys' ][$key] ) ) ) : '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['predefined_keys']          =   isset ( $_POST[ '_sl_predefined_keys' ][$key] ) ? sanitize_textarea_field ( wp_unslash ($_POST[ '_sl_predefined_keys' ][$key] ) ) : '';
                            
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['product_use_expire']                   =   isset ( $_POST[ '_sl_use_expire' ][$key] ) ?   trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_use_expire' ][$key] ) ) )    :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['product_expire_renew_price']           =   isset ( $_POST[ '_sl_product_expire_renew_price' ][$key] ) ?    wc_format_decimal ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_product_expire_renew_price' ][$key] ) ) )  :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['product_expire_units']                 =   isset ( $_POST[ '_sl_product_expire_units' ][$key] ) ? trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_product_expire_units' ][$key] ) ) )    :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['product_expire_time']                  =   isset ( $_POST[ '_sl_product_expire_time' ][$key] ) ? trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_product_expire_time' ][$key] ) ) ) :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['product_expire_starts_on_activate']    =   isset ( $_POST[ '_sl_product_expire_starts_on_activate' ][$key] ) ? trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_product_expire_starts_on_activate' ][$key] ) ) )   :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['product_expire_disable_update_link']   =   isset ( $_POST[ '_sl_product_expire_disable_update_link' ][$key] ) ? trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_product_expire_disable_update_link' ][$key] ) ) )  :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['product_expire_limit_api_usage']       =   isset ( $_POST[ '_sl_product_expire_limit_api_usage' ][$key] ) ? trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_product_expire_limit_api_usage' ][$key] ) ) )  :   '';
                            // phpcs:ignore WordPress.Security.NonceVerification.Missing
                            $group_data['product_expire_notice']                =   isset ( $_POST[ '_sl_product_expire_notice' ][$key] ) ? trim ( sanitize_text_field ( wp_unslash ( $_POST[ '_sl_product_expire_notice' ][$key]) ) )    :   '';
                            
                            $product = wc_get_product( $product_id );
                            //ensure the product type is the required one
                            if ( $group_data['product_use_expire'] == 'woocommerce-subscriptions' )
                                {
                                    if (    ! in_array ( $product->get_type(), array ( 'subscription', 'variable-subscription' ) ) )
                                        $group_data['product_use_expire']   =   'yes';
                                }
                                
                            if ( $group_data['product_use_expire'] !== 'no' )
                                {
                                    if (  in_array ( $product->get_type(), array ( 'subscription', 'variable-subscription' ) ) )
                                        $group_data['product_use_expire']   =   'woocommerce-subscriptions';
                                }
                            
                            $_sl_groups[]   =   $group_data;
                        }
                    
                    if ( count ( $_sl_groups ) > 0 )
                        update_post_meta( $product_id, '_sl_groups', $_sl_groups );
                    
                }
                
            
        }
        
?>