<?php
    
    defined( 'ABSPATH' ) || exit;
     
    class SOLIW_admin_order 
        {
            var $functions;
            var $options;
            
            function __construct() 
                {
                    
                    global $SOLIW;
                    
                    $this->functions            =   $SOLIW->functions;
                    
                    $this->options              =   SOLIW_functions::get_options();
                    
                    //enqueue css & js for product post type
                    add_action( 'admin_enqueue_scripts',                                array($this, 'add_admin_product_scripts'), 10, 1);
                    
                    //Hooks
                    add_action( 'add_meta_boxes',                                       array( $this, 'add_meta_boxes' ), 31, 2 );
                    // phpcs:disable WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing
                    if ( isset ( $_POST['original_post_status'] )   &&  $_POST['original_post_status']  ==  'auto-draft'  )                    
                        add_action( 'woocommerce_saved_order_items',                        array($this->functions, 'order_setup_licensing'), 60 , 2 );
                    
                    add_action( 'save_post',                                            array( $this, 'saved_order_meta' ), 60 , 1 );
                    if ( $this->functions->is_HPOS_active() )
                        {
                            add_action( 'woocommerce_process_shop_order_meta',                  array( $this, 'saved_order_meta'), 60 );
                        }
                                                            
                    //output keys to order received page & emails IF status completed
                    //add_action( 'woocommerce_order_item_meta_end',                      array($this->functions, 'woocommerce_order_item_meta_end'), 99, 4 );
                    
                    add_filter('woocommerce_order_actions',                             array( $this, 'woocommerce_order_actions'), 10, 2 );
                    add_action('woocommerce_order_action_regenerate_licensing_data',    array( $this, 'woocommerce_order_action_regenerate_licensing_data') );
                    
                }

            function add_admin_product_scripts($hook)
                {
                   
                    $screen = get_current_screen();

                    if( ! is_object ( $screen ) || !in_array ( $screen->id, array ( 'woocommerce_page_wc-orders', 'woocommerce_page_wc-orders--shop_subscription', 'shop_order', 'shop_subscription' ) ) )
                        return;
                    
                    wp_enqueue_script( 'jquery');

                    wp_register_style('soliw-admin-order.css', SOLIW_URL . '/css/admin-order.css', array(), SOLIW_VERSION);
                    wp_enqueue_style( 'soliw-admin-order.css');
                    
                    wp_register_script('soliw-woo-admin-order', SOLIW_URL . '/js/admin-order.js', array(), SOLIW_VERSION, false );
                    wp_enqueue_script( 'soliw-woo-admin-order');
                                        
                    wp_register_script('soliw-woo-sl-functions', SOLIW_URL . '/js/functions.js', array(), SOLIW_VERSION, false );

                    $argv = array(
                                    'plugin_url'    =>  SOLIW_URL,
                                    'ajaxurl'       =>  admin_url('admin-ajax.php')
                                );
                    wp_localize_script( 'soliw-woo-sl-functions', 'soliw_vars', $argv );        
                    wp_enqueue_script( 'soliw-woo-sl-functions');
                    
                    
                    wp_register_style('flatpickr.css', SOLIW_URL . '/css/flatpickr.css', array(), SOLIW_VERSION );
                    wp_enqueue_style( 'flatpickr.css');
                    
                    wp_register_script('flatpickr.js', SOLIW_URL . '/js/flatpickr.js', array(), SOLIW_VERSION, false );
                    wp_enqueue_script( 'flatpickr.js');

                }     
                
            public function add_meta_boxes( $post_type, $post ) 
                {
                    
                    if ( is_numeric( $post ) )
                        $post_ID    =   $post;
                        else
                        if (  is_object( $post ) )
                        $post_ID    =   $post->get_id() ;
                        
                    // phpcs:disable WordPress.Security.NonceVerification.Recommended
                    if ( empty ( $post_ID ) &&  isset ( $_GET['id'] ) )
                        {
                            // phpcs:disable WordPress.Security.NonceVerification.Recommended
                            $post_ID    =   (int)$_GET['id'];
                        }
                               
                    if($this->functions->order_contain_licensed_item( $post_ID )    === FALSE)
                        return;

                    add_meta_box( 'soliw_old', __( 'Order License Details', 'software-license-lite' ),  array( $this, 'order_license_details_meta_box' ),               array ( 'woocommerce_page_wc-orders', 'shop_order', 'shop_subscription' ), 'normal', 'core' );
                    add_meta_box( 'soliw_lk', __( 'License Keys', 'software-license-lite' ),            array( $this, 'license_keys_meta_box' ),                        array ( 'woocommerce_page_wc-orders', 'shop_order', 'shop_subscription' ), 'normal', 'core' );
                    add_meta_box( 'soliw_lg', __( 'Key Manager', 'software-license-lite' ),             array( $this, 'license_generator_meta_box' ),                   array ( 'woocommerce_page_wc-orders', 'shop_order', 'shop_subscription' ), 'normal', 'core' );
                    
                    add_meta_box( 'soliw_old', __( 'Order License Details', 'software-license-lite' ),  array( $this, 'order_license_details_meta_box' ),               array ( 'woocommerce_page_wc-orders--shop_subscription', 'shop_order', 'shop_subscription' ), 'normal', 'core' );
                    add_meta_box( 'soliw_lk', __( 'License Keys', 'software-license-lite' ),            array( $this, 'license_keys_meta_box' ),                        array ( 'woocommerce_page_wc-orders--shop_subscription', 'shop_order', 'shop_subscription' ), 'normal', 'core' );
                    add_meta_box( 'soliw_lg', __( 'Key Generator', 'software-license-lite' ),           array( $this, 'license_generator_meta_box' ),                   array ( 'woocommerce_page_wc-orders--shop_subscription', 'shop_order', 'shop_subscription' ), 'normal', 'core' );
                }
           
            
            /**
            * Show order license details and allow changes
            * 
            * @param mixed $order_data
            */
            function order_license_details_meta_box(    $order_data   )
                {
                    global $wpdb, $woocommerce;
                    
                    if ( $order_data instanceof WP_Post )
                        $order_data =   new WC_Order ( $order_data->ID );
                            
                    $order_products =   $order_data->get_items();
                    
                    wp_nonce_field( 'woo_sl/order-license-details', '_nonce_order_license_details' );
                            
                    foreach ( $order_products as $order_item_id     =>  $order_product ) 
                        {
                            //check if the product use licensed software
                            if(! SOLIW_functions::is_product_licensed($order_product->get_product_id()))
                                continue;
                            
                            if ( SOLIW_functions::order_item_is_woocommerce_subscription( $order_item_id ) )
                                continue;
                            
                            ?>
                                <table class="widefat fixed striped soliw_licence_general">
                                    <tbody>
                                        <tr class="even">
                                            <td class=""><h4><?php esc_html_e( 'Product name', 'software-license-lite' ) ?></h4></td>
                                            <td class="comment"><b><?php echo esc_html ( $order_product['name'] ) ?></b></td>
                                        </tr>
                                        
                                        <tr class="odd">
                                            <td><?php esc_html_e( 'Status', 'software-license-lite' ) ?></td>
                                            <td><select name="order_item_licence_status[<?php echo esc_html ( $order_item_id ) ?>]">
                                                <?php
                                                
                                                    $status    =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_status',  TRUE);
                                                    
                                                    foreach ( $this->functions->get_licence_statuses()  as  $licence_status =>  $licence_status_name)
                                                        {
                                                            ?><option value="<?php echo esc_html ( $licence_status ) ?>"  <?php selected( $status, $licence_status) ?>><?php echo esc_html ( $licence_status_name ); ?></option><?php
                                                        }
                                                ?>
                                                </select>
                                            </td>
                                        </tr>
                            <?php
                            
                            if(SOLIW_functions::order_item_using_licence_expire( $order_data->get_id(), $order_item_id))
                                {
                                    
                                    $_soliw_licensing_using_expire   =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_using_expire',  TRUE);
                                    
                                    ?>
                                    
                                        <tr class="even">
                                            <td><?php esc_html_e( 'Using License Expire', 'software-license-lite' ) ?></td>
                                            <td><b><?php 
                                        
                                                if ( $_soliw_licensing_using_expire == 'yes' )
                                                    esc_html_e( 'Yes', 'software-license-lite' );
                                                    else if ( $_soliw_licensing_using_expire == 'woocommerce-subscriptions' )
                                                    esc_html_e( 'WooCommerce Subscription', 'software-license-lite' );
                                                    else if ( $_soliw_licensing_using_expire == 'yith-subscriptions' )
                                                    esc_html_e( 'YITH Subscription', 'software-license-lite' );
                                                    else if ( $_soliw_licensing_using_expire == 'wpsubscription' )
                                                    esc_html_e( 'WP Subscription', 'software-license-lite' );
                                                    
                                                ?></b>
                                            </td>
                                        </tr>
                                        
                                        <tr class="odd">
                                        <?php 
                                            
                                            if ( $status    !=  'not-activated' ) 
                                                { 
                                                    if ( $_soliw_licensing_using_expire == 'yes' )
                                                        {
                                                            ?>
                                                            
                                                                    <td><?php esc_html_e( 'Start Date', 'software-license-lite' ) ?></td>
                                                                    <td><span class="soliw_licensing_start" data-type="date"><?php
                                                                    
                                                                        $start_at    =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_start',  TRUE);
                                                                        if ( ! empty ( $start_at ) )
                                                                            {
                                                                                $datetime = new WC_DateTime( "@{$start_at}", new DateTimeZone( 'UTC' ) );
                                                                                if ( get_option( 'timezone_string' ) ) {
                                                                                    $datetime->setTimezone( new DateTimeZone( wc_timezone_string() ) );
                                                                                } else {
                                                                                    $datetime->set_utc_offset( wc_timezone_offset() );
                                                                                }
                                                                                
                                                                                $start_at  =   $datetime->getOffsetTimestamp();
                                                                                
                                                                                ?><input class="flatpickr flatpickr-input" type="text" placeholder="Select Date.." data-id="datetime" readonly="readonly" name="order_item_expire_start[<?php echo esc_html ( $order_item_id ) ?>]" value="<?php echo esc_html ( gmdate ( "Y-m-d H:i", $start_at ) ) ?>" /><?php
                                                                            }
                                                                            else
                                                                            esc_html_e ( 'Not Set', 'software-license-lite' );
                                                                    
                                                                    ?></span>
                                                                    
                                                                    </td>
                                                                </tr>
                                                                
                                                                <tr class="odd">
                                                                <?php 
                                                                
                                                                $expire_at    =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_expire_at',  TRUE);
                                                                $expired_at    =   SOLIW_functions::get_order_item_meta($order_item_id,  '_woo_sl_licensing_expired_at',  TRUE);
                                                                
                                                                if ( ! empty ( $expire_at ) ) 
                                                                    { 
                                                                    
                                                                    $datetime = new WC_DateTime( "@{$expire_at}", new DateTimeZone( 'UTC' ) );
                                                                    if ( get_option( 'timezone_string' ) ) {
                                                                        $datetime->setTimezone( new DateTimeZone( wc_timezone_string() ) );
                                                                    } else {
                                                                        $datetime->set_utc_offset( wc_timezone_offset() );
                                                                    }
                                                                    
                                                                    $expire_at  =   $datetime->getOffsetTimestamp();
                                                                    
                                                                    ?>
                                                                <td><?php esc_html_e( 'Expire Date', 'software-license-lite' ) ?></td> 
                                                                <td><span class="soliw_licensing_expire" data-type="date"><?php
                                                                
                                                                    if ( ! empty ( $expire_at ) )
                                                                        { 
                                                                            ?><input class="flatpickr flatpickr-input" type="text" placeholder="Select Date.." data-id="datetime" readonly="readonly" name="order_item_expire_at[<?php echo esc_html ( $order_item_id ) ?>]" value="<?php echo esc_html ( gmdate ( "Y-m-d H:i", $expire_at ) ) ?>" /><?php 
                                                                        }
                                                                        else
                                                                        esc_html_e ( 'Not Set', 'software-license-lite' );
                                                                
                                                                ?></span></td>
                                                                <?php } else 
                                                                {
                                                                
                                                                    if ( ! empty ( $expired_at ) ) { ?>
                                                                <td><?php esc_html_e( 'Expired Date', 'software-license-lite' ) ?></td>
                                                                <td><span class="soliw_licensing_expired" data-type="date"><?php
                                                                
                                                                    //echo date_i18n( get_option( 'date_format' ), $expired_at);
                                                                    ?><input class="flatpickr flatpickr-input" type="text" placeholder="Select Date.." data-id="datetime" readonly="readonly" name="order_item_expired_at[<?php echo esc_html ( $order_item_id ) ?>]" value="<?php echo esc_html ( gmdate ( "Y-m-d H:i", $expired_at ) ) ?>" /><?php 
                                                                
                                                                ?></span></td>
                                                                <?php }
                                                                } ?>
                                                            <?php  
                                                        } 
                                            }
                                            else
                                            {
                                                ?><td colspan="2"><?php esc_html_e('Licence Expiration not set, as the key has not activated.', 'software-license-lite'); ?></td><?php   
                                                
                                            }
                                    
                                    ?></tr><?php
                                }
                                
                            ?>
                                </tbody>
                                </table>
                            
                            <?php
                            
                            $_soliw        =   SOLIW_functions::get_order_item_licensing_groups( $order_item_id );
                            
                            if ( is_array ( $_soliw ) )
                                {
                                    $group_count    =   count($_soliw['group_title']);
                         
                                    for($i = 0; $i< $group_count;  $i++) 
                                        {
                                            ?>
                                                <div class="soliw_licence_settings">
                                                    <table style="" class="widefat fixed striped">
                                                        <tbody>
                                                            
                                                            <tr class="even">
                                                                <td class=""><label for="_sl_group_title_<?php echo esc_html ( $order_item_id ) ?>_<?php echo esc_html ( $i ) ?>"><?php esc_html_e("Group title", 'software-license-lite') ?></label><br /><span class="description"><?php esc_html_e("The license group title.", 'software-license-lite') ?></span></td>
                                                                <td class="comment">
                                                                    <input class="_sl_group_title_field" name="order_item[<?php echo esc_html ( $order_item_id ) ?>][group_title][]" id="_sl_group_title_<?php echo esc_html ( $order_item_id ) ?>_<?php echo esc_html ( $i ) ?>" value="<?php echo esc_html ( $_soliw['group_title'][$i] ) ?>" type="text"> 
                                                                    
                                                                </td>
                                                            
                                                            </tr>
                                                            
                                                            <tr class="odd">
                                                                <td class=""><label for="_sl_licence_prefix_<?php echo esc_html ( $order_item_id ) ?>_<?php echo esc_html ( $i ) ?>"><?php esc_html_e("Licence Prefix", 'software-license-lite') ?></label><br /><span class="description"><?php esc_html_e("A prefix for generated keys.", 'software-license-lite') ?></span></td>
                                                                <td class="comment">
                                                                    <input class="_sl_licence_prefix_field" name="order_item[<?php echo esc_html ( $order_item_id ) ?>][licence_prefix][]" id="_sl_licence_prefix_<?php echo esc_html ( $order_item_id ) ?>_<?php echo esc_html ( $i ) ?>" value="<?php echo esc_html ( $_soliw['licence_prefix'][$i] ) ?>" type="text"> 
                                                                    
                                                                </td>
                                                            
                                                            </tr>
                                                            
                                                            <tr class="even">
                                                                <td class=""><label for="_sl_max_keys_<?php echo esc_html ( $order_item_id ) ?>_<?php echo esc_html ( $i ) ?>"><?php esc_html_e("Maximum Licence Keys", 'software-license-lite') ?></label><br /><span class="description"><?php esc_html_e("The maximum number of licence keys which can generate.", 'software-license-lite') ?></span></td>
                                                                <td class="comment">
                                                                    <input class="_sl_max_keys_field" name="order_item[<?php echo esc_html ( $order_item_id ) ?>][max_keys][]" id="_sl_max_keys_<?php echo esc_html ( $order_item_id ) ?>_<?php echo esc_html ( $i ) ?>" value="<?php echo esc_html ( $_soliw['max_keys'][$i] ) ?>" type="text"> 
                                                                </td>
                                                            
                                                            </tr>
                                                            
                                                            <tr class="odd">
                                                                <td class=""><label for="_sl_max_instances_per_key_<?php echo esc_html ( $order_item_id ) ?>_<?php echo esc_html ( $i ) ?>"><?php esc_html_e("Instances per Key", 'software-license-lite') ?></label><br /><span class="description"><?php esc_html_e("The maximum activations a key can be used along.", 'software-license-lite') ?></span></td>
                                                                <td class="comment">
                                                                    <input class="_sl_max_instances_per_key" name="order_item[<?php echo esc_html ( $order_item_id ) ?>][max_instances_per_key][]" id="_sl_max_instances_per_key_<?php echo esc_html ( $order_item_id ) ?>_<?php echo esc_html ( $i ) ?>" value="<?php echo esc_html ( $_soliw['max_instances_per_key'][$i] ) ?>" type="text"> 
                                                                </td>
                                                            
                                                            </tr>
                                                            
                                                            <tr class="even">
                                                                <td class=""><label for="_sl_use_predefined_keys_<?php echo esc_html ( $order_item_id ) ?>_<?php echo esc_html ( $i ) ?>"><?php esc_html_e("Use Predefined Keys", 'software-license-lite') ?></label><br /><span class="description"><?php esc_html_e("Predefined keys will be used instead generated. Keys are provided through Product page", 'software-license-lite') ?></span></td>
                                                                <td class="comment">
                                                                    <select id="_sl_use_predefined_keys" name="order_item[<?php echo esc_html ( $order_item_id ) ?>][use_predefined_keys][]" class="sl_use_predefined_keys" >
                                                                        <option <?php selected($_soliw['use_predefined_keys'][$i], 'no') ?> value="no"><?php esc_html_e('No', 'software-license-lite') ?></option>
                                                                        <option <?php selected($_soliw['use_predefined_keys'][$i], 'yes') ?> value="yes"><?php esc_html_e('Yes', 'software-license-lite') ?></option>
                                                                    </select>
                                                                </td>
                                                            
                                                            </tr>
                                                            
                                                            <tr class="odd">
                                                                <td class=""><label for="_sl_use_expire_<?php echo esc_html ( $order_item_id ) ?>_<?php echo esc_html ( $i ) ?>"><?php esc_html_e("Use Expire", 'software-license-lite') ?> <span style="background-color: red;  color: white;  font-weight: bold;  padding: 0px 5px;">PRO</span></label><br /><span class="description"><?php esc_html_e("Synchronize product licenses with subscription plugins to automatically manage license expirations, renewals, and validity based on active subscriptions.", 'software-license-lite') ?></span></td>
                                                                <td class="comment">
                                                                    <select id="_sl_use_expire" name="order_item[<?php echo esc_html ( $order_item_id ) ?>][product_use_expire][]" class="sl_use_expire" >
                                                                        
                                                                        <option <?php selected($_soliw['product_use_expire'][$i], 'no') ?> value="no"><?php esc_html_e("No", 'software-license-lite') ?></option>
                                                                        <option disabled="disabled" value="yes"><?php esc_html_e("Yes - Default Expire", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                                                        <option disabled="disabled" value="woocommerce-subscriptions"><?php esc_html_e("WooCommerce Subscriptions", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                                                        <option disabled="disabled" value="yith-subscriptions"><?php esc_html_e("YITH WooCommerce Subscription", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>
                                                                        <option disabled="disabled" value="wpsubscription"><?php esc_html_e("WP Subscription", 'software-license-lite') ?> ( <?php esc_html_e("available in PRO", 'software-license-lite') ?> )</option>

                                                                    </select>
                                                                </td>
                                                            
                                                            </tr>
                                                           
                                                            
                                                        </tbody>
                                                    </table>
                                                    
                                                </div>
                                            <?php  
                                        }
                                }
                                else
                                {
                                    //check if is WooCommerce Subscription?
                                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                                    $order_id       =   $wpdb->get_var( $wpdb->prepare ( "SELECT ID FROM {$wpdb->posts} WHERE post_parent = %d AND post_type = 'shop_subscription'", $order_data->get_id() ) );
                                    
                                    //check if is a renewal
                                    if ( empty ( $order_id ) )
                                        {
                                            $_subscription_renewal  =   get_post_meta( $order_data->get_id(), '_subscription_renewal', TRUE );
                                            if ( $_subscription_renewal > 0 )
                                                $order_id   =   $_subscription_renewal;
                                        }
                                    
                                    //check if is a switch
                                    if ( empty ( $order_id ) )
                                        {
                                            $_subscription_switch  =   get_post_meta( $order_data->get_id(), '_subscription_switch', TRUE );
                                            if ( $_subscription_switch > 0 )
                                                $order_id   =   $_subscription_switch;
                                        }
                                    
                                    if ( empty ( $order_id ) )
                                        {
                                            ?><p><span class="dashicons dashicons-flag"></span> <b><?php esc_html_e('Invalid Licensing Data', 'software-license-lite') ?></b> <?php esc_html_e('Use the Regenerate Licensing Data action to re-create the licensing set-up.', 'software-license-lite') ?></p><?php                                    
                                        }
                                }
  
                                
                        }   
                    
                    
                }
            

            /**
            * License Keys Metabox code
            * 
            * @param mixed $order_data
            */
            public function license_keys_meta_box(  $order_data   ) 
                {
                    global $wpdb, $woocommerce;
                    
                    if ( $order_data instanceof WP_Post )
                        $order_data =   new WC_Order ( $order_data->ID );
                        
                    $order_products =   $order_data->get_items();
                    
                    ?>
                    <div id="system_messages"></div>
                    <?php
                            
                    foreach ( $order_products as $order_item_id     =>  $order_product ) 
                        {
                            //check if the product use licensed software
                            if(! SOLIW_functions::is_product_licensed($order_product->get_product_id()))
                                continue;
                                
                            if ( SOLIW_functions::order_item_is_woocommerce_subscription( $order_item_id ) )
                                continue;
                            
                            ?>
                                <h4><?php echo esc_html ( $order_product['name'] ) ?></h4>
                                

                                <?php
                                
                                    $order_licence_details =   SOLIW_functions::get_order_licence_details( $order_data->get_id() );
                                    $order_item_licence_details =   isset($order_licence_details[$order_item_id])   ?   $order_licence_details[$order_item_id]  :   array();
                                    foreach ($order_item_licence_details as $licence_group_id   => $product_licence_data)
                                        {
                                            if($order_item_id   !=  $product_licence_data->order_item_id)
                                                continue;
                                                
                                            ?>
                                                <p class="woo-sl-label"><?php echo esc_html ( $product_licence_data->license_data['group_title'] );
                                                
                                                $max_instances_per_key =   $product_licence_data->license_data['max_instances_per_key'];
                                                
                                                if ( $max_instances_per_key < 0 )
                                                    $max_instances_per_key  =   __( 'Unlimited', 'software-license-lite' );
                                    
                                                $instances      =   ' - ';
                                                $instances     .=   sprintf(
                                                                                /* translators: %s: The number of domains. */
                                                                                _n(
                                                                                    '%s domain',
                                                                                    '%s domains',
                                                                                    $max_instances_per_key === 1 ? 1 : 2,
                                                                                    'software-license-lite'
                                                                                ),
                                                                                $max_instances_per_key
                                                                            );
                                                $instances     .=   ' ' . __( 'per key', 'software-license-lite' );
                                                
                                                
                                                echo esc_html ( apply_filters('woo_sl/html/max_instances_per_key', $instances, $product_licence_data->order_item_id, $licence_group_id) );
                                                
                                                ?></p>
                                                <table id="woo-sl-keys_<?php echo esc_html ( $product_licence_data->order_item_id ) ?>_<?php echo esc_html ( $product_licence_data->group_id ) ?>" data-order_item_id="<?php echo esc_html ( $product_licence_data->order_item_id ) ?>" data-group_id="<?php echo esc_html ( $product_licence_data->group_id ) ?>" class="shop_table my_account_software_license my_account_orders software_license_keys">
                                                <thead>
                                                    <tr>
                                                        <th class="woo-sl-key header"><span class="nobr"><?php esc_html_e( 'License Key', 'software-license-lite' ); ?></span></th>
                                                        <th class="woo-sl-status header"><span class="nobr"><?php esc_html_e( 'Status', 'software-license-lite' ); ?></span></th>
                                                        <th class="woo-sl-domain header"><span class="nobr"><?php esc_html_e( 'Domain', 'software-license-lite' ); ?></span></th>
                                                        <th class="woo-sl-action header"><span class="nobr"><?php esc_html_e( 'Action', 'software-license-lite' ); ?></span></th>
                                                        <?php do_action( 'woo_sl/admin_order/license_keys_meta_box/th', $order_data->get_id(), $order_item_id, $product_licence_data->group_id ) ?>
                                                    </tr>
                                                </thead>
                                                
                                                <tbody>
                                                    <?php
                                                    
                                                        $license_keys   =   SOLIW_functions::get_order_product_generated_keys ( $order_data->get_id(), $order_item_id, $product_licence_data->group_id );
                                                        SOLIW_functions::interface_licence_block( $license_keys );
                                                    
                                                    ?>
                                                </tbody>
                                                </table>
                                              <?php   
                                        }
                        }
     
                }

                
                

            /**
             * License Key Generator Metabox code
             *
             * @since 1.0
             * @param object $order_data
             * @return void
             */
            public function license_generator_meta_box( $order_data ) 
                {
                    global $wpdb, $woocommerce;
                    
                    if ( $order_data instanceof WP_Post )
                        $order_data =   new WC_Order ( $order_data->ID );
                    
                    $order_licence_details =   SOLIW_functions::get_order_licence_details( $order_data->get_id() );
                    
                    ?>
                    <div id="system_messages"></div>
                    <?php
                    
                    ?>    
                        
                        <table id="woo-sl-key-generator" class="my_account_software_license my_account_orders software_license_key_generator">
                            <tbody>  
                                <tr>
                                    <td align="left">
                                        <ul id="sl_generator_desc" class="order_details">
                                            <li class="group">
                                                <?php esc_html_e("Group", 'software-license-lite') ?>:<strong></strong>
                                            </li>
                                            <li class="max_keys">
                                                <?php esc_html_e("Max Keys", 'software-license-lite') ?>:<strong></strong>
                                            </li>
                                            <li class="instances_per_key">
                                                <?php esc_html_e("Instances per key", 'software-license-lite') ?>:<strong></strong>
                                            </li>
                                            <li class="in_use_keys">
                                                <?php esc_html_e("In use keys", 'software-license-lite') ?>:<strong></strong>
                                            </li>
                                        </ul>
                                        
                                        <p><?php esc_html_e("Product / License group", 'software-license-lite') ?></p>
                                        <p><?php 
                                            $allowed_tags = array(
                                                                'select'   => array(
                                                                    'onchange'      => array(),
                                                                    'name'   => array(),
                                                                    'id'     => array()
                                                                ),
                                                                'option'      => array(
                                                                    'data-description-group'     => array(),
                                                                    'data-description-max-keys'     => array(),
                                                                    'data-description-instances-per-keys'     => array(),
                                                                    'data-description-in-use-keys'     => array(),
                                                                    'disabled'     => array(),
                                                                    'value'     => array(),
                                                                        ),
                                                                'b'      => array(),
                                                            );
                                            
                                            echo wp_kses ( SOLIW_functions::interface_get_sl_product_select($order_licence_details), $allowed_tags);
                                            
                                        ?></p>
                                  
                                        <br />
                                        <a href="javascript: void(0)" onClick="soliw.keyGenerate('<?php echo esc_html ( wp_create_nonce( 'woo_sl/key-generator') ) ?>')" name="submit" class="button button_generate"><?php esc_html_e("Generate Licence Key", 'software-license-lite') ?></a>
                                        
                                        <p><?php esc_html_e("or", 'software-license-lite') ?></p>
                                        
                                        <a href="javascript: void(0)" onClick="soliw.keyAssign('<?php echo esc_html ( wp_create_nonce( 'woo_sl/key-assign') ) ?>')" name="submit" class="button button_generate"><?php esc_html_e("Assign Licence Key", 'software-license-lite') ?></a>
                                        <input type="text" placeholder="e.g. APP10-XJEU-JFU4-EJE9" id="woo-sl-key-assign" >
  
                                        
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </form>
                    <?php

                }
                
            
            function saved_order_meta( $order_id )
                {
                    global $SOLIW;  
                    
                    // no need to run when doing  wc_order_action
                    if  ( isset( $_POST['wc_order_action'] ) && ! empty ( $_POST['wc_order_action']  ) )
                        return;   
                    
                    if ( wp_is_post_revision( $order_id ) )
                        return;
                    
                    $post_data =    get_post($order_id);    
                    if( ! in_array( $post_data->post_type, array ( 'shop_order_placehold', 'shop_order', 'shop_subscription' ) ) )
                        return;
                    
                    if ( ! isset ( $_POST['_nonce_order_license_details'] ) )
                        return;
                    
                    $nonce = isset( $_POST['_nonce_order_license_details'] ) ? sanitize_text_field( wp_unslash( $_POST['_nonce_order_license_details'] ) ) : '';
                    if ( ! wp_verify_nonce( $nonce, 'woo_sl/order-license-details') )
                        return;
                    
                    // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash WordPress.Security.ValidatedSanitizedInput.InputNotSanitized, WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized  
                    $order_items    =   isset($_POST['order_item']) ? wc_clean ( $_POST['order_item'] )  :   array();  
                    if(!is_array($order_items)  ||  count($order_items) <   1)
                        return;
                        
                    foreach($order_items    as  $order_itme_id  =>  $order_item )
                        {
                            $order_itme_id  =   intval ( $order_itme_id );
                            if (isset ( $order_item['product_expire_renew_price'] ) )
                                {
                                    foreach ( $order_item['product_expire_renew_price'] as $key   =>  $value )
                                        {
                                            $key    =   intval ( $key );
                                            $order_item['product_expire_renew_price'][$key] =   wc_format_decimal( $value );
                                        }
                                }
                                
                            wc_update_order_item_meta( $order_itme_id, '_woo_sl', $order_item);
                        }                    
                        
                    //check for expire changes
                    $product_use_expire =   FALSE;
                    foreach($order_items    as  $order_itme_id  =>  $order_item)
                        {
                            $order_itme_id  =   intval ( $order_itme_id );
                            //check if expire has changed
                            reset($order_item['product_use_expire']);
                            $product_use_expire =   current($order_item['product_use_expire']);
                            $_soliw_licensing_using_expire   =   wc_get_order_item_meta( $order_itme_id,  '_woo_sl_licensing_using_expire',  TRUE);
                            switch ($product_use_expire)
                                {

                                                    
                                    case 'no'   :
                                                    //check if there are already expire fileds for the order item
                                                    if ( ! empty ($_soliw_licensing_using_expire) )
                                                        {
                                                            //delete the fields
                                                            wc_delete_order_item_meta( $order_itme_id, '_woo_sl_licensing_start');
                                                            wc_delete_order_item_meta( $order_itme_id, '_woo_sl_licensing_expire_at');
                                                            wc_delete_order_item_meta( $order_itme_id, '_woo_sl_licensing_expired_at');

                                                        }
                                                    
                                                    break;
                                                    
                                    default:
                                                    
                                                    break;
                                }
                                
                            wc_update_order_item_meta( $order_itme_id, '_woo_sl_licensing_using_expire', $product_use_expire); 
                            
                        }
                    
            
                        
                    //check for expire data
                    $order_data     = new WC_Order( $order_id  );
    
                    $order_products =   $order_data->get_items();
                    
                    $order_item_licence_status  =   isset($_POST['order_item_licence_status'])  ?  array_map('sanitize_key', $_POST['order_item_licence_status'] )      :   array(); 
                    $order_item_expire_start    =   isset($_POST['order_item_expire_start'])    ?  array_map('sanitize_key', $_POST['order_item_expire_start'] )        :   array();
                    $order_item_expire_at       =   isset($_POST['order_item_expire_at'])       ?  array_map('sanitize_key', $_POST['order_item_expire_at'] )           :   array();
                    $order_item_expired_at      =   isset($_POST['order_item_expired_at'])       ?  array_map('sanitize_key', $_POST['order_item_expired_at'] )           :   array();
                                                
                    foreach ( $order_products as $order_item_id     =>  $order_product )    
                        {
                            //ensure it loop only the licensed items
                            
                            if(! SOLIW_functions::is_order_item_licensed ( $order_id, $order_item_id ) )
                                continue;
                                
                            $permission_expire_at   =   '';
                            
                            $previous_license_status =   wc_get_order_item_meta( $order_item_id, '_woo_sl_licensing_status', TRUE );
                            
                            $_order_item_licence_status =   isset($order_item_licence_status[$order_item_id]) ?   $order_item_licence_status[$order_item_id]    :   '';
                            
                            $_order_item_expire_start   =   isset($order_item_expire_start[$order_item_id]) ?   $order_item_expire_start[$order_item_id]    :   '';
                            $_order_item_expire_at      =   isset($order_item_expire_at[$order_item_id])    ?   $order_item_expire_at[$order_item_id]       :   '';
                            $_order_item_expired_at     =   isset($order_item_expired_at[$order_item_id])    ?   $order_item_expired_at[$order_item_id]       :   '';
                            
                            //Check if status has changed
                            if ( $_order_item_licence_status !== $previous_license_status && $SOLIW->order_status_changed !== TRUE )
                                wc_update_order_item_meta ( $order_item_id, '_woo_sl_licensing_status', $_order_item_licence_status );
                            
                            if ( ! empty ( $_order_item_expire_start )  )
                                {
                                    $datetime = wc_string_to_datetime ( $_order_item_expire_start  );
                                    
                                    wc_update_order_item_meta ( $order_item_id, '_woo_sl_licensing_start', $datetime->getTimestamp() );
                                }
                                
                            if ( ! empty ( $_order_item_expire_at )  )
                                {
                                    $datetime = wc_string_to_datetime ( $_order_item_expire_at  );
                                    
                                    if ( $datetime->getTimestamp() < time() )
                                        {
                                            //set as expired
                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_expire_at', '' );
                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_expired_at', $datetime->getTimestamp() );
                                            
                                            $_order_item_expired_at =   '';
                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_status', 'expired' );
                                            
                                            $_order_item_licence_status =   'expired';
                                            $permission_expire_at       =   $datetime;
                                        }
                                        else
                                        {
                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_expire_at', $datetime->getTimestamp() );
                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_status', 'active' );
                                            
                                            $_order_item_licence_status =   'active';
                                            $permission_expire_at       =   $datetime;
                                        }
                                    
                                }
                                
                            
                            if ( ! empty ( $_order_item_expired_at )  )
                                {
                                    $datetime = wc_string_to_datetime ( $_order_item_expired_at  );
                                    
                                    if ( $datetime->getTimestamp() > time() )
                                        {
                                            //set as expired
                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_expire_at', $datetime->getTimestamp() );
                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_expired_at', '' );
                                            
                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_status', 'active' );
                                            $_order_item_licence_status =   'active';
                                            $permission_expire_at       =   $datetime;
                                        }
                                        else
                                        {
                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_expired_at', $datetime->getTimestamp() );
                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_status', 'expired' );
                                            
                                            $_order_item_licence_status =   'expired';
                                            $permission_expire_at       =   $datetime;
                                        }
                                }
                                
                                           
                            if ( !isset($SOLIW->order_status_changed)    ||    ( isset($SOLIW->order_status_changed) && $SOLIW->order_status_changed   !== TRUE  ))
                                {
                                        
                                    if( ! SOLIW_functions::order_item_using_licence_expire($order_id, $order_item_id))
                                        continue;
                                    
                                    $order_item_product     =   new WC_Order_Item_Product( $order_item_id );
                                    $product                =   $order_item_product->get_product();
                                    $product_id             =   $product->get_ID();
                                    
                                    $permission_id                  =   $this->functions->get_permission_id_from_order_id_product_id( $order_id, $product_id );
                                    
                                    if ( isset ( $_POST['permission_id'] ) &&   is_array ( $_POST['permission_id'] ) )
                                        {
                                            $submitted_permission_id_key    =   array_search($permission_id, array_map( 'sanitize_key', $_POST['permission_id'] ) );
                                            
                                            if ( empty ( $permission_expire_at ) )
                                                {
                                                    $permission_expire_at           =   isset($_POST['order_item_expire_at'][$order_item_id])       ?  wc_string_to_datetime ( sanitize_text_field ( wp_unslash( $_POST['order_item_expire_at'][$order_item_id] ) ) )   :   '';
                                                    if (  empty($permission_expire_at)  &&  ! empty( $_POST['access_expires'][$submitted_permission_id_key] ) )
                                                        $permission_expire_at   =   wc_string_to_datetime ( sanitize_text_field ( wp_unslash( $_POST['access_expires'][$submitted_permission_id_key] ) ) );
                                                        
                                                    if (  empty( $permission_expire_at ) )
                                                        $permission_expire_at   =   new DateTime("now", new DateTimeZone("UTC"));       
                                                }
                                            
                                            switch (strtolower( $_order_item_licence_status) )
                                                {
                                                    case 'active'   :
                                                                        $expire_date    =   '';
                                                                        if ( ! empty ( $permission_expire_at ) )
                                                                            {
                                                                                $expire_date    =   $permission_expire_at->getTimestamp();
                                                                                $expire_date    =   gmdate( "Y-m-d H:i:s", $expire_date );
                                                                            }
                                                                        $this->functions->update_expiration_for_permission($permission_id, $expire_date);
                                                                        
                                                                        //check if subscription and statuc updated to canceled
                                                                        if ( $product instanceof WC_Product_Subscription    &&  $order_data->get_status()   ==  'cancelled' )
                                                                            wc_update_order_item_meta($order_item_id, '_woo_sl_licensing_status', 'cancelled' );
                                                                        
                                                                        break;   
                                                    
                                                    default:
                                                                        if ( $permission_expire_at->getTimestamp()  <   time () )
                                                                            {
                                                                                $expired_date    =   $permission_expire_at->getTimestamp();
                                                                                $expired_date    =   gmdate( "Y-m-d H:i:s", $expired_date );
                                                                                $this->functions->update_expiration_for_permission($permission_id, $expired_date);
                                                                            }
                                                                            else
                                                                            $this->functions->update_expiration_for_permission($permission_id, gmdate("Y-m-d H:i:s", strtotime("-1 day", time() )));
                                                                        break;
                                                    
                                                }
                                        }
                                }
                            
                        }
                    
                }
                
                
                
            /**
            * Add additional action to re-generate licensing data
            * 
            * @param mixed $order_actions
            */
            function woocommerce_order_actions( $order_actions, $order )
                {
                    if ( is_numeric( $order ) )
                        $order_id    =   $order;
                        else
                        if (  is_object( $order ) )
                        $order_id    =   $order->get_id() ;
                    
                    if ( ! apply_filters('woo_sl/order/woocommerce_order_actions', TRUE, $order_id ) )
                        return $order_actions;
                    
                    $order_actions['regenerate_licensing_data']    =   __( 'Regenerate Licensing Data', 'software-license-lite' );
                    
                    return $order_actions;
                    
                }
                
            
            /**
            * Process the action for specified order
            *     
            * @param mixed $order
            */
            function woocommerce_order_action_regenerate_licensing_data( $order )
                {
                    
                    $order_products = $order->get_items();
                    $found_licensed_product = FALSE;
                    foreach($order_products as $key => $order_product)
                        {
                            if ( SOLIW_functions::is_product_licensed( $order_product['product_id'] ) )
                                {
                                    $found_licensed_product = TRUE;
                                    break;
                                }
                        }
                 
                    // the order need at least one licensed item
                 
                    if (!$found_licensed_product)
                        return;
                                  
                    foreach($order_products as $order_item_key => $order_item_product)
                        {
                            if ( !  SOLIW_functions::is_product_licensed( $order_item_product['product_id'] ) ) 
                                continue;
                                
                            if ( SOLIW_functions::order_item_is_woocommerce_subscription( $order_item_key ) )
                                continue;
                             
                            $product_sl_groups =   SOLIW_functions::get_product_licensing_groups( $order_item_product['product_id'] );
                            
                            //if variation, filter out the licence groups
                            if($order_item_product->get_variation_id()   >   0)
                                {
                                    
                                    $variation_license_group_id =   get_post_meta($order_item_product->get_variation_id(), '_sl_license_group_id', TRUE);
                                    
                                    if(isset($product_sl_groups[$variation_license_group_id]))
                                        {
                                            $_product_sl_groups                             =   $product_sl_groups;
                                            $product_sl_groups                              =   array(); 
                                            $product_sl_groups[$variation_license_group_id] =   $_product_sl_groups[$variation_license_group_id];
                                        }
                                        else
                                        $product_sl_groups  =   array();
                                }
                                
                            $_group_title                           =   array();
                            $_licence_prefix                        =   array();
                            $_max_keys                              =   array();
                            $_max_instances_per_key                 =   array();
                            $_use_predefined_keys                   =   array();
                            
                            $_product_use_expire                    =   array();
                            $_product_expire_renew_price            =   array();
                            $_product_expire_units                  =   array();
                            $_product_expire_time                   =   array();
                            $_product_expire_starts_on_activate     =   array();
                            $_product_expire_disable_update_link    =   array();
                            $_product_expire_limit_api_usage        =   array();
                            $_product_expire_notice                 =   array();
                            
                            foreach($product_sl_groups  as  $product_sl_group)
                                {
                                    $_group_title[]             =   $product_sl_group['group_title'];
                                    $_licence_prefix[]          =   $product_sl_group['licence_prefix'];
                                    $_max_keys[]                =   $product_sl_group['max_keys'];
                                    $_max_instances_per_key[]   =   $product_sl_group['max_instances_per_key'];
                                    $_use_predefined_keys[]     =   $product_sl_group['use_predefined_keys'];
                                    
                                    $_product_use_expire[]                    =     $product_sl_group['product_use_expire'];
                                    $_product_expire_renew_price[]            =     wc_format_decimal ( $product_sl_group['product_expire_renew_price'] );
                                    $_product_expire_units[]                  =     $product_sl_group['product_expire_units'];
                                    $_product_expire_time[]                   =     $product_sl_group['product_expire_time'];
                                    $_product_expire_starts_on_activate[]     =     $product_sl_group['product_expire_starts_on_activate'];      
                                    $_product_expire_disable_update_link[]    =     $product_sl_group['product_expire_disable_update_link'];
                                    $_product_expire_limit_api_usage[]        =     $product_sl_group['product_expire_limit_api_usage'];
                                    $_product_expire_notice[]                 =     $product_sl_group['product_expire_notice'];
                                }
                            
                            $data['group_title']                    =   $_group_title;
                            $data['licence_prefix']                 =   $_licence_prefix;
                            $data['max_keys']                       =   $_max_keys;
                            $data['max_instances_per_key']          =   $_max_instances_per_key;
                            $data['use_predefined_keys']            =   $_use_predefined_keys;
                            
                            $data['product_use_expire']                 =   $_product_use_expire;
                            $data['product_expire_renew_price']         =   $_product_expire_renew_price;
                            $data['product_expire_units']               =   $_product_expire_units;
                            $data['product_expire_time']                =   $_product_expire_time;
                            $data['product_expire_starts_on_activate']  =   $_product_expire_starts_on_activate;
                            $data['product_expire_disable_update_link'] =   $_product_expire_disable_update_link;
                            $data['product_expire_limit_api_usage']     =   $_product_expire_limit_api_usage;
                            $data['product_expire_notice']              =   $_product_expire_notice;
                            
                            $data   =   apply_filters('woo_sl/order_processed/product_sl', $data, $order_item_product, $order->get_ID()); 
                                              
                            wc_update_order_item_meta ( $order_item_key, '_woo_sl', $data );
                            
                            
                            reset($data['product_use_expire']);
                            $product_use_expire =   current( $data['product_use_expire'] );
                            $_soliw_licensing_using_expire   =   wc_get_order_item_meta( $order_item_key,  '_woo_sl_licensing_using_expire',  TRUE);
                            switch ($product_use_expire)
                                {
                                    case 'no'   :
                                                    //check if there are already expire fileds for the order item
                                                    if ( ! empty ($_soliw_licensing_using_expire) )
                                                        {
                                                            //delete the fields
                                                            //wc_delete_order_item_meta( $order_item_key, '_woo_sl_licensing_using_expire');
                                                            wc_delete_order_item_meta( $order_item_key, '_woo_sl_licensing_start');
                                                            wc_delete_order_item_meta( $order_item_key, '_woo_sl_licensing_expire_at');
                                                            wc_delete_order_item_meta( $order_item_key, '_woo_sl_licensing_expired_at');
                                                        }
                                                        
                                                    wc_update_order_item_meta( $order_item_key, '_woo_sl_licensing_status', 'active');
                                                    
                                                    break;
                                                    
                                    default  :
                                                    //check if there are already expire fileds for the order item
                                                    if ( empty ($_soliw_licensing_using_expire) )
                                                        {
                                                            //generate the requried fields
                                                            wc_update_order_item_meta( $order_item_key, '_woo_sl_licensing_using_expire', $product_use_expire);
                                                            
                                                            if ( $product_use_expire == 'yes' )
                                                                { 
                                                                    $start_at   =   time();
                                                                    wc_update_order_item_meta($order_item_key, '_woo_sl_licensing_start', $start_at);
                                                                    
                                                                    reset($data['product_expire_units']);                                                            
                                                                    $_sl_product_expire_units   =   current($data['product_expire_units']);
                                                                    reset($data['product_expire_time']);
                                                                    $_sl_product_expire_time    =   current($data['product_expire_time']);
                                                                    
                                                                    $expire_at  =   strtotime( " + " . $_sl_product_expire_units . " " . $_sl_product_expire_time,  $start_at);
                                                                      
                                                                    wc_update_order_item_meta($order_item_key, '_woo_sl_licensing_expire_at', $expire_at);
                                                                    
                                                                    if  ( $expire_at < time() ) 
                                                                        wc_update_order_item_meta( $order_item_key, '_woo_sl_licensing_status', 'expired');
                                                                        else
                                                                        wc_update_order_item_meta( $order_item_key, '_woo_sl_licensing_status', 'active');
                                                                }
                                                            
                                                        }
                                                        else
                                                        {
                                                            wc_update_order_item_meta( $order_item_key, '_woo_sl_licensing_status', 'active');   
                                                        }
                                                    
                                                    break;
                                                    
                                    
                                }
                            
                        }
                        
                    //unregister save meta
                    remove_action( 'save_post',                                            array( $this, 'saved_order_meta' ), 60 , 1 );
                
                }    

             
        }
        
?>