<?php
    
    defined( 'ABSPATH' ) || exit;
    
    class SOLIW_admin_licences 
        {
            
            var $functions;
            var $options;
            
            var $url;
            
            public function __construct() 
                {
                    
                    global $SOLIW;
                    
                    $this->functions            =   $SOLIW->functions;
                    
                    $this->options              =   SOLIW_functions::get_options();
                    
                    $this->url                  =   'admin.php?page=soliw-sl-licences';
                                                
                    add_action( 'admin_menu', array($this, 'admin_menu') );
                                      
                    add_filter('set-screen-option', array($this, 'set_screen_options'), 10, 3);
                    
                }
                         
            function admin_menu()
                {
                    global $admin_page_hooks;
                    $page_hook = isset ( $admin_page_hooks['software-license-lite'] ) ?   $admin_page_hooks['software-license-lite']    :   'woocommerce';
                    
                    //interface columns
                    add_filter('manage_'. $page_hook .'_page_soliw-sl-licences_columns',     array($this, 'manage_woocommerce_page_sl_licences_columns'));
                    
                    
                    $menus_hook    =   add_submenu_page( 'woocommerce', __( 'WooCommerce extensions', 'software-license-lite' ),  __( 'Licences', 'software-license-lite' ) , 'manage_woocommerce', 'soliw-sl-licences', array( $this, 'licences_interface' ) );

                    add_action('load-' . $menus_hook , array($this, 'load_dependencies'));
                    add_action('load-' . $menus_hook , array($this, 'admin_notices'));
                    add_action('load-' . $menus_hook , array($this, 'screen_options'));
                    
                    add_action('admin_print_styles-' . $menus_hook , array($this, 'admin_print_styles'));
                    add_action('admin_print_scripts-' . $menus_hook , array($this, 'admin_print_scripts'));
                    
                }
           
            
            function load_dependencies()
                {
                    
                    
                }
                
            function admin_notices()
                {
                    global $SOLIW_messages;
            
                    if(!is_array($SOLIW_messages) || count($SOLIW_messages) < 1)
                        return;
                    
                    foreach($SOLIW_messages    as $message_data) 
                        {
                            ?><div id='notice' class='<?php echo esc_html ( $message_data['status'] ) ?> fade'><p><?php echo esc_html ( $message_data['message'] ) ?></p></div><?php
                        }

                }
                  
            function admin_print_styles()
                {
                    wp_register_style( 'woocommerce_admin_styles', WC()->plugin_url() . '/assets/css/admin.css', array(), WC_VERSION );
                    wp_enqueue_style( 'woocommerce_admin_styles' );
                    
                    wp_register_style( 'soliw-admin_licences', SOLIW_URL . '/css/admin-licences.css', array(), SOLIW_VERSION);
                    wp_enqueue_style( 'soliw-admin_licences' );
                }
                
            function admin_print_scripts()
                {
                    $suffix       = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
                    
                    wp_register_script( 'select2', WC()->plugin_url() . '/assets/js/select2/select2.full' . $suffix . '.js', array( 'jquery' ), '4.0.3', false );
                    wp_register_script( 'soliw-enhanced-select', WC()->plugin_url() . '/assets/js/admin/wc-enhanced-select' . $suffix . '.js', array( 'jquery', 'select2' ), WC_VERSION, false );
                    wp_localize_script( 'soliw-enhanced-select', 'wc_enhanced_select_params', array(
                            'i18n_no_matches'           => _x( 'No matches found', 'enhanced select', 'software-license-lite' ),
                            'i18n_ajax_error'           => _x( 'Loading failed', 'enhanced select', 'software-license-lite' ),
                            'i18n_input_too_short_1'    => _x( 'Please enter 1 or more characters', 'enhanced select', 'software-license-lite' ),
                            'i18n_input_too_short_n'    => _x( 'Please enter %qty% or more characters', 'enhanced select', 'software-license-lite' ),
                            'i18n_input_too_long_1'     => _x( 'Please delete 1 character', 'enhanced select', 'software-license-lite' ),
                            'i18n_input_too_long_n'     => _x( 'Please delete %qty% characters', 'enhanced select', 'software-license-lite' ),
                            'i18n_selection_too_long_1' => _x( 'You can only select 1 item', 'enhanced select', 'software-license-lite' ),
                            'i18n_selection_too_long_n' => _x( 'You can only select %qty% items', 'enhanced select', 'software-license-lite' ),
                            'i18n_load_more'            => _x( 'Loading more results&hellip;', 'enhanced select', 'software-license-lite' ),
                            'i18n_searching'            => _x( 'Searching&hellip;', 'enhanced select', 'software-license-lite' ),
                            'ajax_url'                  => admin_url( 'admin-ajax.php' ),
                            'search_products_nonce'     => wp_create_nonce( 'search-products' ),
                            'search_customers_nonce'    => wp_create_nonce( 'search-customers' ),
                        ) );
                        
                    wp_enqueue_script( 'wc-enhanced-select' );
                }
              

            function screen_options()
                {
 
                    $screen = get_current_screen();
                 
                    if(is_object($screen) && $screen->id == 'woocommerce_page_soliw-sl-licences')
                        {
                            $args = array(
                                'label'     => __('Orders per Page', 'software-license-lite'),
                                'default'   => 10,
                                'option'    => 'sl_licences_per_page'
                            );
                            add_screen_option( 'per_page', $args );    
                        }
                 
                }
                
            function set_screen_options($status, $option, $value) 
                {
                    if ( 'sl_licences_per_page' == $option ) 
                        return $value;
                }
  
       
            function licences_interface()
                {
                    
                    include_once ( SOLIW_PATH . '/include/admin/class-licences-list-table.php' );
                    
                    $wp_list_table = new SOLIW_Licences_List_Table();
                    $pagenum = $wp_list_table->get_pagenum();
                  
                    $wp_list_table->prepare_items();
                
                    ?>
                    <div class="wrap">
                        <h1 class="wp-heading-inline"><?php esc_html_e( 'Licences', 'software-license-lite' ) ?></h1>

                        <?php
                        // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized 
                        $search_term = isset($_REQUEST['s']) ? wc_clean( wp_unslash( $_REQUEST['s'] ) ) : '';
                        if ( strlen ( $search_term )    >   0 ) {
                            /* translators: %s: search keywords */
                            printf( ' <span class="subtitle">' . esc_html__( 'Search results for', 'software-license-lite' ) . ' &#8220;%s&#8221;</span>', get_search_query() );
                        }
                        ?>

                        <hr class="wp-header-end">
           
                        <?php 
                        $wp_list_table->views(); ?>

                        <form id="posts-filter" method="get">

                            <?php $wp_list_table->search_box( esc_html__( 'Search Licence', 'software-license-lite' ), 'post' ); ?>

               
                            <input type="hidden" name="page" class="post_type_page" value="soliw-sl-licences" />
                    
                            <?php 
                  
                            $wp_list_table->display(); ?>

                        </form>
                
                        <div id="ajax-response"></div>
                        <br class="clear" />
                    </div>
                    <?php
                    
     
                }
                
                
            function manage_woocommerce_page_sl_licences_columns( $columns )
                {
                    
                    $new_columns    =   array(
                                                'order_id'          =>  __('Order ID', 'software-license-lite'),
                                                'order_status'      =>  __('Status', 'software-license-lite'),
                                                'order_item_id'     =>  __('Product', 'software-license-lite'),
                                                'user_id'           =>  __('Customer', 'software-license-lite'),
                                                'licence_group_id'  =>  __('Licence Group', 'software-license-lite'),
                                                'licence_key'       =>  __('Licence Key', 'software-license-lite'),
                                                'licence_expire'    =>  __('Expire', 'software-license-lite'),
                                                'created'           =>  __('Key Date', 'software-license-lite'),
                                                'active_domain'     =>  __('Active Domain', 'software-license-lite'),
                                                'order_actions'     =>  __('Actions', 'software-license-lite'),
                                                );
                     
                    return array_merge( $columns,   $new_columns    ); 

                }
               
        }
        
        
    new SOLIW_admin_licences();
        
?>