<?php
    
    defined( 'ABSPATH' ) || exit;
    
    class SOLIW_admin 
        {
            public static $instance;
            
            var $product_interface;
            var $order_interface;
            
            var $functions;
            var $options;
            
            /**
            * 
            * Run on class construct
            * 
            */
            function __construct( ) 
                {
                    self::$instance = $this;
                    
                    global $SOLIW;
                    
                    $this->functions            =   $SOLIW->functions;
                    
                    $this->options              =   SOLIW_functions::get_options();
                    
                    //include the licences interface
                    include(SOLIW_PATH . '/include/class.sl.admin.licences.php');
                    
                    //trigger on order statuc changed
                    add_action( 'woocommerce_order_status_changed', array($this->functions, 'woocommerce_order_status_changed'), 99, 3);
                    
                    
                    add_action('load-post.php',                          array($this, 'init'));
                    //or
                    add_action('load-post-new.php',                      array($this, 'init'));
                    
                    //HPOS
                    add_action( 'load-woocommerce_page_wc-orders',       array ( $this, 'HPOS_init') );
                    add_action( 'load-woocommerce_page_wc-orders--shop_subscription',       array ( $this, 'HPOS_init') );
                        
                    add_filter('manage_shop_order_posts_custom_column',     array($this, 'manage_shop_order_posts_custom_column'), 999, 2); 
                                         
                }
            
            static function get_instance()
                {
                    return self::$instance;    
                }
                
                
            function init()
                {
                    global $pagenow;
                    
                    $current_screen             =   get_current_screen();
                     
                    //add product fields
                    if(is_object($current_screen)   &&  $current_screen->post_type  ==  'product')
                        $this->product_interface    =   new SOLIW_admin_product();
                    
                    if ( $pagenow != 'post-new.php'   &&  is_object($current_screen)   &&  ( $current_screen->post_type  ==  'shop_order'    ||  $current_screen->post_type == 'shop_subscription' ) )
                        $this->order_interface      =   new SOLIW_admin_order();   
                    
                }
                
            function HPOS_init()
                {
                    $this->order_interface      =   new SOLIW_admin_order();                     
                }
         
 
                
                
                
            function manage_shop_order_posts_custom_column( $column_name, $order_id )
                {
                    
                    if ( $column_name != 'order_number' ) 
                        return;
                    
                    if ( $this->functions->order_is_extend( $order_id  )  === FALSE  ) 
                        return;
                    
                    $order_data =   new WC_Order( $order_id );
                    
                    $order_products          =   $order_data->get_items();
                    reset($order_products);
                    $order_product           =   current($order_products);
                        
                    $_soliw_extend_for     =   wc_get_order_item_meta( $order_product->get_ID() , '_woo_sl_extend_for', TRUE);
                    $parent_order_id        =   $this->functions->get_order_by_item_id( $_soliw_extend_for );
                            
                    ?><br /> &#8212; <?php  esc_html_e( 'Renewal for order', 'software-license-lite' ) ?> <a href="post.php?post=<?php echo esc_html ( $parent_order_id ) ?>&action=edit">#<?php echo esc_html ( $parent_order_id ) ?></a><?php
                }    
            
        } 
    
    
    
?>