<?php

    defined( 'ABSPATH' ) || exit;
    
    class SOLIW_Settings_licence 
        {
            
            function __construct()
                {
                    
                    add_filter( 'woocommerce_get_sections_products',            array($this,    'woocommerce_get_sections_products'));
                    add_filter( 'woocommerce_get_settings_products',            array($this,    'woocommerce_get_settings_products'), 10, 2 );
                    
                    //add an email class
                    add_filter( 'woocommerce_email_classes',                    array($this,    'woocommerce_email_classes'));
                    //add a custom action to email system to trigger on licence expire
                    add_action( 'woocommerce_email_actions',                    array($this,    'woocommerce_email_actions' ) );
                                        
                    //overwrite the core template location to plugin within admin settings
                    add_action( 'woocommerce_locate_core_template',             array($this,    'woocommerce_locate_core_template' ), 99, 3 );
                    //overwrite the core template location for front side
                    add_action( 'woocommerce_locate_template',                  array($this,    'woocommerce_locate_template' ), 99, 3 );
                    
                                        
                }
                
                
            
            function woocommerce_get_sections_products( $sections )
                {

                    $sections['licence'] =  __( 'License Products', 'software-license-lite' );
                    
                    return $sections;
                    
                }
                
                
            
            function woocommerce_get_settings_products( $settings, $current_section ) 
                {
                    
                    if ( $current_section != 'licence' )
                        return $settings;

                    
                    $settings = array();
                    
                    // Add Title to the Settings
                    $settings[] = array( 
                                                    'name'      =>  __( 'License Products', 'software-license-lite' ), 
                                                    'type'      =>  'title', 
                                                    'desc'      =>   __( 'The following options are used to configure general settings regarding Licensed Products', 'software-license-lite' ), 
                                                    'id'        =>  'licence' 
                                                    );
                    
                    $settings[] =   array(
                                                    'title'             => __( 'General', 'software-license-lite' ),
                                                    'desc'          => __( 'Grant access to licence key when Order Completed', 'software-license-lite' ),
                                                    'id'            => 'woocommerce_licensing_grant_access_after_payment',
                                                    'type'          => 'checkbox',
                                                    'default'       => 'no',
                                                    'desc_tip'      => __( 'Enable this option to grant access to keys when orders are "completed", rather than "processing".', 'software-license-lite' ),
                                                    'autoload'      => false
                                                );
                    
                    $settings[] =   array(
                                                    
                                                    'desc'              => __( 'On license key deactivate or removal, ping the assigned domain.', 'software-license-lite' ),
                                                    'id'                => 'woocommerce_licensing_on_deactivate_ping_domain_origin',
                                                    'type'              => 'checkbox',
                                                    'default'           => 'no',
                                                    'desc_tip'          => __( 'When de-activating or remove a license key, if assigned to a domain, the system pings the domain and informs about the key assignment.', 'software-license-lite' ),
                                                    'autoload'          => false,
                                                    
                                                );
    
                                                
                    
                                                
                    $settings[] =   array(
                                                    'title'         => __( 'API', 'software-license-lite' ),
                                                    'desc'          => __( 'Use Cache Module for API interactions <span style="background-color: red;  color: white;  font-weight: bold;  padding: 0px 5px;">PRO</span>', 'software-license-lite' ),
                                                    'id'            => 'woocommerce_licensing_use_cache_module',
                                                    'type'          => 'checkbox',
                                                    'default'       => 'no',
                                                    'desc_tip'      => __("The cache module significantly boosts the processing speed of all API calls, resulting in minimal CPU and memory consumption while ensuring faster and more efficient performance. More details about Cache Module usage can be found at", 'software-license-lite') . ' <a target="_blank" href="https://wpsoftwarelicense.com/documentation/use-the-cache-module-for-api-interactions/">' .  __("More Details", 'software-license-lite') . '</a>',
                                                    'autoload'      => false,
                                                    'custom_attributes' => array(
                                                                                    'disabled' => 'disabled'
                                                                                )
                                                );
                    
                    $settings[] =   array(
                                                    
                                                    'desc'          => __( 'Assign domain to key on <b>status-check</b> method', 'software-license-lite' ),
                                                    'id'            => 'woocommerce_licensing_assign_domain_to_key_on_status_check',
                                                    'type'          => 'checkbox',
                                                    'default'       => 'no',
                                                    'desc_tip'      => __("On <b>status-check</b> API method call, if a key is not assigned to the domain, create an entry for it. This prevent disconnecting licensing, when migrating site instance to another domain.", 'software-license-lite') . ' <a target="_blank" href="https://wpsoftwarelicense.com/licence-key-get-deactivated-site/">' .  __("More Details", 'software-license-lite') . '</a>',
                                                    'autoload'      => false
                                                    
                                                );
          
                    $settings[] = array( 
                                                    'type'      => 'sectionend', 
                                                    'id'        => 'licence' );
                    
                    return $settings;
                  
                }
                                       
                
            function woocommerce_email_classes( $emails )
                {
                    
                    $emails['WC_Email_Customer_Licence_Expire']                         = include_once(SOLIW_PATH .  '/include/emails/class-wc-email-customer-licence-expire.php' );
                    $emails['WC_Email_Customer_Licence_Expired']                        = include_once(SOLIW_PATH .  '/include/emails/class-wc-email-customer-licence-expired.php' );
                    
                    return $emails;
                        
                }
            
            function woocommerce_email_actions( $email_actions )
                {
                    
                    $email_actions[]    =   'woocommerce_licence_pre_expire';
                    $email_actions[]    =   'woocommerce_licence_expired';
                    
                    return $email_actions;
                       
                }
                
            
            function woocommerce_locate_core_template( $template_file, $template, $template_base )
                {
                    
                    if( !in_array($template, WC_Email_Customer_Licence_Expire::get_templates() )    &&  !in_array($template, WC_Email_Customer_Licence_Expired::get_templates() ) )
                        return $template_file;
                        
                    $template_file  =   SOLIW_PATH .   'templates/' . $template;
                       
                    return $template_file;
                        
                }
            
            
            function woocommerce_locate_template( $template_file, $template, $template_base )
                {
                    $specific_templates =   array(
                                                    'emails/licence-expire.php',
                                                    'emails/plain/licence-expire.php',
                                                    'emails/licence-expired.php',
                                                    'emails/plain/licence-expired.php'
                                                    );
                        
                    if( !in_array($template, $specific_templates ) )
                        return $template_file;
                        
                    //check if returned $template_file is pointing to theme file
                    if ( strpos( $template_file, get_stylesheet_directory() ) !== FALSE   ||  strpos( $template_file, get_stylesheet_directory() ) !== FALSE) 
                        return $template_file;
                    
                    $template_file  =   SOLIW_PATH .   'templates/' . $template;
                       
                    return $template_file;    

                }
         
        }

?>