<?php

    defined( 'ABSPATH' ) || exit;
    
    /**
     * List Table API: Licences_List_Table class
     *
     * @package WooCommerce Software License
     * @subpackage Administration
     * @since 1.3.9.7
     */

    /**
     * Core class used to implement displaying posts in a list table.
     *
     * @since 1.4
     * @access private
     *
     * @see WP_List_Table
     */
    class SOLIW_Licences_List_Table extends WP_List_Table {

          
        private $licence_statuses   =   array();

	    /**
	     * Constructor.
	     *
	     * @since 3.1.0
	     * @access public
	     *
	     * @see WP_List_Table::__construct() for more information on default arguments.
	     *
	     * @global WP_Post_Type $post_type_object
	     * @global wpdb         $wpdb
	     *
	     * @param array $args An associative array of arguments.
	     */
	    public function __construct( $args = array() ) {
		    global $post_type_object, $wpdb;

		    parent::__construct( array(
			    'plural' => 'posts',
			    'screen' => isset( $args['screen'] ) ? $args['screen'] : null,
		    ) );
            
            $this->set_licence_statuses();
	    }
        
        private function set_licence_statuses()
            {
                
                global $SOLIW;
                
                $this->licence_statuses     =   $SOLIW->functions->get_licence_statuses();
                
            }
        
	    /**
	     *
	     * @global array    $avail_post_stati
	     * @global WP_Query $wp_query
	     * @global int      $per_page
	     * @global string   $mode
	     */
	    public function prepare_items() 
            {
		        global  $avail_post_stati, $wp_query, $per_page, $SOLIW;
                
                $avail_post_stati   =   wp_edit_posts_query();
                            
                $per_page           = intval ( $this->get_items_per_page( 'sl_licences_per_page' ) );
                
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                $filter_post_status =   isset( $_GET['licence_status'] ) ? preg_replace( "/[^a-zA-Z_-]/i", "", sanitize_text_field( wp_unslash( $_GET['licence_status'] ) ) ) : '';
                if($filter_post_status  ==  'all')
                    $filter_post_status =   '';
                
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended    
                $filter_search      =   isset( $_GET['s'] ) ? preg_replace( "/[^a-zA-Z0-9.\-\_\:\@ ]/i", "", sanitize_text_field( wp_unslash( $_GET['s'] ) ) ) : '';
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                $_customer_user     =   isset( $_GET['_customer_user'] ) ? (int) $_GET['_customer_user'] : '';
                
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                $orderby            =   isset( $_GET['orderby'] )   ?   preg_replace( "/[^a-zA-Z]/i", "", sanitize_text_field( wp_unslash( $_GET['orderby'] ) ) )    : '';
                
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                $order              =   isset( $_GET['order'] )     ?   preg_replace( "/[^a-zA-Z]/i", "", sanitize_text_field( wp_unslash( $_GET['order'] ) ) )      : '';

                $args   =   array(
                                    'per_page'          =>  $per_page,
                                    'paged'             =>  intval ( $this->get_pagenum() ),
                                    'post_status'       =>  $filter_post_status,
                                    '_customer_user'    =>  $_customer_user,
                                    'filter_search'     =>  $filter_search,

                                    'orderby'           =>  $orderby,
                                    'order'             =>  $order
                                    );
                
                $licences_data   =   $this->get_all_licences( $args );

                $this->set_pagination_args( array(
                                                    'total_items'   => $licences_data['total_records'],
                                                    'per_page'      => $per_page
                                                ) );
                                                
                $this->items                   =   $licences_data['results'];
	        }

	    /**
	     *
	     * @return bool
	     */
	    public function has_items() {
		    if( count ( $this->items ) > 0 )
                return TRUE;
                
            return FALSE;
	    }

	    /**
	     * @access public
	     */
	    public function no_items() {
		    
            esc_html_e( 'Nothing Found', 'software-license-lite' );
	    }


	    /**
	     * Helper to create links to edit.php with params.
	     *
	     * @since 4.4.0
	     * @access protected
	     *
	     * @param array  $args  URL parameters for the link.
	     * @param string $label Link text.
	     * @param string $class Optional. Class attribute. Default empty string.
	     * @return string The formatted link string.
	     */
	    protected function get_edit_link( $args, $label, $class = '' ) {
		    $url = add_query_arg( $args, 'admin.php?page=soliw-sl-licences' );

		    $class_html = '';
		    if ( ! empty( $class ) ) {
			     $class_html = sprintf(
				    ' class="%s"',
				    esc_attr( $class )
			    );
		    }

		    return sprintf(
			    '<a href="%s"%s>%s</a>',
			    esc_url( $url ),
			    $class_html,
			    $label
		    );
	    }

	    /**
	     *
	     * @global array $locked_post_status This seems to be deprecated.
	     * @global array $avail_post_stati
	     * @return array
	     */
	    protected function get_views() 
            {
		        global $locked_post_status;

                $post_type = $this->screen->post_type;

                if ( !empty($locked_post_status) )
                    return array();

                $status_links   =   array();
                $num_posts      =   new stdClass();
                
                $orders_statuses    =   $this->get_all_licences_orders_statuses();
                foreach($this->licence_statuses as $status =>  $label)
                    {
                        $num_posts->$status =   isset($orders_statuses[$status])    ?   $orders_statuses[$status]   :   0;   
                    }
                
                $total_posts = array_sum( (array) $num_posts );
                $class = '';

                $all_args = array( );
                $mine = '';
         
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                if ( !isset( $_REQUEST['licence_status'] )  ||  $_REQUEST['licence_status'] ==  'all') 
                    {
                        $class = 'current';
                    }
                
                $all_inner_html = sprintf(
                                                /* translators: %s: Number of plugins. */
                                                _nx(
                                                    'All <span class="count">(%s)</span>',
                                                    'All <span class="count">(%s)</span>',
                                                    $total_posts,
                                                    'posts',
                                                    'software-license-lite'
                                                ),
                                                number_format_i18n( $total_posts )
                                            );

                $status_links['all'] = $this->get_edit_link( $all_args, $all_inner_html, $class );
                if ( $mine ) 
                    {
                        $status_links['mine'] = $mine;
                    }

                $nonce = wp_create_nonce( 'soliw-licences-list-links' );
                    
                foreach ( $this->licence_statuses as $status =>  $label ) 
                    {
                        $class = '';
                        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                        if ( isset($_REQUEST['licence_status']) && $status === $_REQUEST['licence_status'] ) 
                            {
                                $class = 'current';
                            }

                        $status_args = array(
                            'licence_status'    => $status,
                            'nonce'             =>  $nonce  
                        );

                        $label_count    =   array(
                                                    0           =>  $label . ' <span class="count">(%s)</span>',
                                                    1           =>  $label . ' <span class="count">(%s)</span>',
                                                    'singular'  =>  $label . ' <span class="count">(%s)</span>',
                                                    'plural'    =>  $label . ' <span class="count">(%s)</span>',
                                                    'context'   =>  '',
                                                    'domain'    =>  ''
                                                        );
                        
                        $status_label = sprintf(
                            translate_nooped_plural( $label_count, $num_posts->$status, 'software-license-lite' ),
                            number_format_i18n( $num_posts->$status )
                        );

                        $status_links[ $status ] = $this->get_edit_link( $status_args, $status_label, $class );
                    }
                
                
           
                return $status_links;
	        }
            
        function get_2nd_views()
            {
                global $wpdb;
                
                $status_links   =   array();
                
                //add using expire 
                // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching               
                $result     =   $wpdb->get_var( $wpdb->prepare ( '
                
                                        SELECT  
                                                COUNT( DISTINCT SL.order_id ) AS COUNT
                                            FROM
                                                '. $wpdb->prefix .'woocommerce_software_licence AS SL
                                            JOIN '. $wpdb->prefix .'woocommerce_order_itemmeta AS OI1 ON OI1.order_item_id = SL.order_item_id
                                            JOIN '. $wpdb->prefix .'woocommerce_order_itemmeta AS OI2 ON OI2.order_item_id = SL.order_item_id
                                                WHERE
                                                    OI1.meta_key = "_soliw_licensing_using_expire" AND OI1.meta_value IN ( "yes", "yith-subscriptions", "woocommerce-subscriptions", "wpsubscription" ) AND SL.order_item_id NOT IN(
                                                    SELECT
                                                        order_item_id
                                                    FROM
                                                        '. $wpdb->prefix .'woocommerce_order_itemmeta
                                                    WHERE
                                                        meta_key = "_soliw_licensing_expired_at" AND meta_value > 0
                                                )
                                                and OI2.meta_key  =   "_soliw_licensing_status" AND OI2.meta_value   IN ( %s )
                                                ORDER BY SL.order_id DESC
                                        ', 'active') );
                
                $status     =   '__using_expire__';
                $label      =   "Active ( Using Expire )";
                $class = '';
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                if ( isset($_REQUEST['licence_status']) && $status === $_REQUEST['licence_status'] ) 
                    {
                        $class = 'current';
                    }

                $status_args = array(
                    'licence_status' => $status
                );

                $label_count    =   array(
                                            0           =>  $label . ' <span class="count">(%s)</span>',
                                            1           =>  $label . ' <span class="count">(%s)</span>',
                                            'singular'  =>  $label . ' <span class="count">(%s)</span>',
                                            'plural'    =>  $label . ' <span class="count">(%s)</span>',
                                            'context'   =>  '',
                                            'domain'    =>  ''
                                                );
                
                $status_label = sprintf(
                    translate_nooped_plural( $label_count, $result, 'software-license-lite' ),
                    number_format_i18n( $result )
                );

                $status_links[ $status ] = $this->get_edit_link( $status_args, $status_label, $class );
            
                
                //add using expire
                // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching                               
                $result     =   $wpdb->get_var( $wpdb->prepare ( '
                
                                    SELECT  
                                            COUNT( DISTINCT SL.order_id ) AS COUNT
                                        FROM
                                            '. $wpdb->prefix .'woocommerce_software_licence AS SL
                                        JOIN '. $wpdb->prefix .'woocommerce_order_itemmeta AS OI1 ON OI1.order_item_id = SL.order_item_id
                                        JOIN '. $wpdb->prefix .'woocommerce_order_itemmeta AS OI2 ON OI2.order_item_id = SL.order_item_id
                                            WHERE
                                                OI1.meta_key = "_soliw_licensing_using_expire" AND OI1.meta_value IN ( "yes", "yith-subscriptions", "woocommerce-subscriptions", "wpsubscription" ) AND SL.order_item_id NOT IN(
                                                SELECT
                                                    order_item_id
                                                FROM
                                                    '. $wpdb->prefix .'woocommerce_order_itemmeta
                                                WHERE
                                                    meta_key = "_soliw_licensing_expired_at" AND meta_value > 0
                                            )
                                            and OI2.meta_key  =   "_soliw_licensing_status" AND OI2.meta_value  NOT IN ( %s )
                                            ORDER BY SL.order_id DESC
                                    ', 'active') );
                
                $status     =   '__using_expire_not_active__';
                $label      =   "Not Active ( Using Expire )";
                $class = '';
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                if ( isset($_REQUEST['licence_status']) && $status === $_REQUEST['licence_status'] ) 
                    {
                        $class = 'current';
                    }

                $status_args = array(
                    'licence_status' => $status
                );

                $label_count    =   array(
                                            0           =>  $label . ' <span class="count">(%s)</span>',
                                            1           =>  $label . ' <span class="count">(%s)</span>',
                                            'singular'  =>  $label . ' <span class="count">(%s)</span>',
                                            'plural'    =>  $label . ' <span class="count">(%s)</span>',
                                            'context'   =>  '',
                                            'domain'    =>  ''
                                                );
                
                $status_label = sprintf(
                    translate_nooped_plural( $label_count, $result, 'software-license-lite' ),
                    number_format_i18n( $result )
                );

                $status_links[ $status ] = $this->get_edit_link( $status_args, $status_label, $class );
            
                return $status_links;
                
            }
  
            
         /**
         * Displays the list of views available on this table.
         *
         * @since 3.1.0
         */
        public function views() {
            $views = $this->get_views();
            /**
             * Filters the list of available list table views.
             *
             * The dynamic portion of the hook name, `$this->screen->id`, refers
             * to the ID of the current screen.
             *
             * @since 3.1.0
             *
             * @param string[] $views An array of available list table views.
             */
            $views = apply_filters( "views_{$this->screen->id}", $views );

            if ( empty( $views ) ) {
                return;
            }

            $this->screen->render_screen_reader_content( 'heading_views' );

            ?><ul class='subsubsub'>
            <?php
            foreach ( $views as $class => $view ) {
                $views[ $class ] = "\t<li class='$class'>$view";
            }
            
            $output =   implode( " |</li>\n", $views );
            
            $allowed_tags = array(
                    'a'   => array(
                        'href' => array(),
                        'class'    => array(),
                    ),
                    'span'   => array(
                        'href' => array(),
                        'class'    => array(),
                    ),
                    'b'      => array(),
                    'li' => array(
                        'class' => array(),
                    ),
                );
            
            echo wp_kses ( $output, $allowed_tags );
            
            ?></li></ul><?php
            
            $views  =   array();
            $views  = $this->get_2nd_views();
            
            ?><ul class='subsubsub'>
            &nbsp;<li> <span class="dashicons dashicons-shortcode"></span></li>
            <?php
            
            foreach ( $views as $class => $view ) {
                $views[ $class ] = "\t<li class='$class'>$view";
            }
            
            $output =   implode( " |</li>\n", $views );
            
            $allowed_tags = array(
                    'a'   => array(
                        'href' => array(),
                        'class'    => array(),
                    ),
                    'span'   => array(
                        'href' => array(),
                        'class'    => array(),
                    ),
                    'b'      => array(),
                    'li' => array(
                        'class' => array(),
                    ),
                );
            
            echo wp_kses ( $output, $allowed_tags );
            
            ?></li></ul><?php
            
        }

        
        /**
         * Generate the table navigation above or below the table
         *
         * @since 3.1.0
         * @access protected
         * @param string $which
         */
        protected function display_tablenav( $which ) {
            if ( 'top' === $which ) {
                wp_nonce_field( 'bulk-' . $this->_args['plural'] );
            }
            ?>
        <div class="tablenav <?php echo esc_attr( $which ); ?>"><?php

            $this->extra_tablenav( $which );
            $this->pagination( $which );
    ?>

            <br class="clear" />
        </div>
    <?php
        }
        
	    /**
	     * @param string $which
	     */
	    protected function extra_tablenav( $which ) {
    ?>
		    <div class="alignleft actions">
    <?php
		    if ( 'top' === $which && !is_singular() ) {
			    ob_start();
     
			    $user_string = '';
                $user_id     = '';
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                if ( ! empty( $_GET['_customer_user'] ) &&  check_admin_referer( 'bulk-' . $this->_args['plural'] ) ) {
                    // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                    $user_id     = absint( $_GET['_customer_user'] );
                    $user        = get_user_by( 'id', $user_id );
                    
                    $user_string = sprintf(
                        /* translators: %1$s is the user display name, %2$s is the user ID, %3$s is the user email. */
                        esc_html__( '%1$s (#%2$s &ndash; %3$s)', 'software-license-lite' ),
                        $user->display_name,
                        absint( $user->ID ),
                        $user->user_email
                    );
                }
                ?>
                <select class="wc-customer-search" name="_customer_user" data-placeholder="<?php esc_attr_e( 'Search for a customer&hellip;', 'software-license-lite' ); ?>" data-allow_clear="true">
                    <option value="<?php echo esc_attr( $user_id ); ?>" selected="selected"><?php echo esc_html ( $user_string ); ?><option>
                </select>
                <?php

			    $output = ob_get_clean();

			    if ( ! empty( $output ) ) 
                    {
				        $allowed_tags = array(
                                'select'   => array(
                                    'name' => array(),
                                    'class'    => array(),
                                    'data-placeholder'    => array(),
                                    'data-allow_clear'    => array(),
                                ),
                                'option'   => array(
                                    'value' => array(),
                                    'selected'    => array(),
                                )
                            );
                        
                        echo wp_kses ( $output, $allowed_tags );
				        submit_button( __( 'Filter', 'software-license-lite' ), '', 'filter_action', false, array( 'id' => 'post-query-submit' ) );
			        }
		    }
    ?>
		    </div>
    <?php
		    /**
		     * Fires immediately following the closing "actions" div in the tablenav for the posts
		     * list table.
		     *
		     * @since 4.4.0
		     *
		     * @param string $which The location of the extra table nav markup: 'top' or 'bottom'.
		     */
		    do_action( 'manage_posts_extra_tablenav', $which );
	    }

	    /**
	     *
	     * @return string
	     */
	    public function current_action() {
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended
		    if ( isset( $_REQUEST['delete_all'] ) || isset( $_REQUEST['delete_all2'] ) )
			    return 'delete_all';

		    return parent::current_action();
	    }

	    /**
	     *
	     * @return array
	     */
	    protected function get_table_classes() {
		    return array( 'widefat', 'fixed', 'striped', is_post_type_hierarchical( $this->screen->post_type ) ? 'pages' : 'posts' );
	    }

	    /**
	     *
	     * @return array
	     */
	    public function get_columns() {

		    $posts_columns = array();

		    $posts_columns['cb'] = '<input type="checkbox" />';
            
            global $admin_page_hooks;
            $page_hook = isset ( $admin_page_hooks['woocommerce'] ) ?   $admin_page_hooks['woocommerce']    :   'woocommerce';
          
		    /**
		     * Filters the columns displayed in the Posts list table for a specific post type.
		     *
		     * The dynamic portion of the hook name, `$post_type`, refers to the post type slug.
		     *
		     * @since 3.0.0
		     *
		     * @param array $post_columns An array of column names.
		     */
		    return apply_filters( "manage_" . $page_hook . "_page_soliw-sl-licences_general_columns", $posts_columns );
	    }

	    /**
	     *
	     * @return array
	     */
	    protected function get_sortable_columns() 
            {
	                
                $sortable_columns    =   array(
                                                        'order_id'      =>  'order_id',
                                                        'licence_key'   =>  'licence_key',
                                                        'created'       =>  'created',
                                                        'order_status'  =>  'status',
                                                        );
                             
                return $sortable_columns; 
	        }

	    /**
	     * @global WP_Query $wp_query
	     * @global int $per_page
	     * @param array $posts
	     * @param int $level
	     */
	    public function display_rows( $posts = array(), $level = 0 ) {
		    global $wp_query, $per_page;
            
		    if ( empty( $posts ) )
			    $posts = $this->items;

		    add_filter( 'the_title', 'esc_html' );

		    $this->_display_rows( $posts, $level );
	    }

	    /**
	     * @param array $posts
	     * @param int $level
	     */
	    private function _display_rows( $posts, $level = 0 ) {

		    foreach ( $posts as $post )
			    $this->single_row( $post, $level );
	    }

	    

	    /**
	     * Given a top level page ID, display the nested hierarchy of sub-pages
	     * together with paging support
	     *
	     * @since 3.1.0 (Standalone function exists since 2.6.0)
	     * @since 4.2.0 Added the `$to_display` parameter.
	     *
	     * @param array $children_pages
	     * @param int $count
	     * @param int $parent
	     * @param int $level
	     * @param int $pagenum
	     * @param int $per_page
	     * @param array $to_display List of pages to be displayed. Passed by reference.
	     */
	    private function _page_rows( &$children_pages, &$count, $parent, $level, $pagenum, $per_page, &$to_display ) {
		    if ( ! isset( $children_pages[$parent] ) )
			    return;

		    $start = ( $pagenum - 1 ) * $per_page;
		    $end = $start + $per_page;

		    foreach ( $children_pages[$parent] as $page ) {
			    if ( $count >= $end )
				    break;

			    // If the page starts in a subtree, print the parents.
			    if ( $count == $start && $page->post_parent > 0 ) {
				    $my_parents = array();
				    $my_parent = $page->post_parent;
				    while ( $my_parent ) {
					    // Get the ID from the list or the attribute if my_parent is an object
					    $parent_id = $my_parent;
					    if ( is_object( $my_parent ) ) {
						    $parent_id = $my_parent->ID;
					    }

					    $my_parent = get_post( $parent_id );
					    $my_parents[] = $my_parent;
					    if ( !$my_parent->post_parent )
						    break;
					    $my_parent = $my_parent->post_parent;
				    }
				    $num_parents = count( $my_parents );
				    while ( $my_parent = array_pop( $my_parents ) ) {
					    $to_display[$my_parent->ID] = $level - $num_parents;
					    $num_parents--;
				    }
			    }

			    if ( $count >= $start ) {
				    $to_display[$page->ID] = $level;
			    }

			    $count++;

			    $this->_page_rows( $children_pages, $count, $page->ID, $level + 1, $pagenum, $per_page, $to_display );
		    }

		    unset( $children_pages[$parent] ); //required in order to keep track of orphans
	    }
        
        
        /**
         * Print column headers, accounting for hidden and sortable columns.
         *
         * @since 3.1.0
         * @access public
         *
         * @staticvar int $cb_counter
         *
         * @param bool $with_id Whether to set the id attribute or not
         */
        public function print_column_headers( $with_id = true ) {
            list( $columns, $hidden, $sortable, $primary ) = $this->get_column_info();
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $http_host      =   isset ( $_SERVER['HTTP_HOST'] ) ?   sanitize_text_field ( wp_unslash( $_SERVER['HTTP_HOST'] ) ) :   "";
            // phpcs:ignore WordPress.Security.NonceVerification.Recommended
            $request_uri    =   isset ( $_SERVER['REQUEST_URI'] ) ?   sanitize_text_field ( wp_unslash( $_SERVER['REQUEST_URI'] ) ) :   "";
            
            $current_url = set_url_scheme( 'http://' . $http_host  . $request_uri );
            $current_url = remove_query_arg( 'paged', $current_url );

            // phpcs:ignore WordPress.Security.NonceVerification.Recommended
            if ( isset( $_GET['orderby'] ) ) {
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended
                $current_orderby = preg_replace( "/[^a-zA-Z]/i", "", sanitize_text_field ( wp_unslash( $_GET['orderby'] ) ) );
            } else {
                $current_orderby = '';
            }

            // phpcs:ignore WordPress.Security.NonceVerification.Recommended
            if ( isset( $_GET['order'] ) && 'desc' === $_GET['order'] ) {
                $current_order = 'desc';
            } else {
                $current_order = 'asc';
            }

            if ( ! empty( $columns['cb'] ) ) {
                static $cb_counter = 1;
                $columns['cb'] = '<label class="screen-reader-text" for="cb-select-all-' . $cb_counter . '">' . __( 'Select All', 'software-license-lite' ) . '</label>'
                    . '<input id="cb-select-all-' . $cb_counter . '" type="checkbox" />';
                $cb_counter++;
            }

            foreach ( $columns as $column_key => $column_display_name ) {
                $class = array( 'manage-column', "column-$column_key" );

                if ( in_array( $column_key, $hidden ) ) {
                    $class[] = 'hidden';
                }

                if ( 'cb' === $column_key )
                    $class[] = 'check-column';
                elseif ( in_array( $column_key, array( 'posts', 'comments', 'links' ) ) )
                    $class[] = 'num';

                if ( $column_key === $primary ) {
                    $class[] = 'column-primary';
                }

                if ( isset( $sortable[$column_key] ) ) {
                    list( $orderby, $desc_first ) = $sortable[$column_key];

                    if ( $current_orderby === $orderby ) {
                        $order = 'asc' === $current_order ? 'desc' : 'asc';
                        $class[] = 'sorted';
                        $class[] = $current_order;
                    } else {
                        $order = $desc_first ? 'desc' : 'asc';
                        $class[] = 'sortable';
                        $class[] = $desc_first ? 'asc' : 'desc';
                    }

                    $column_display_name = '<a href="' . esc_url( add_query_arg( compact( 'orderby', 'order' ), $current_url ) ) . '"><span>' . $column_display_name . '</span><span class="sorting-indicator"></span></a>';
                }

                $tag = ( 'cb' === $column_key ) ? 'td' : 'th';
                $scope = ( 'th' === $tag ) ? 'scope="col"' : '';
                $id = $with_id ? "id='$column_key'" : '';

                if ( !empty( $class ) )
                    $class = "class='" . join( ' ', $class ) . "'";

                $allowed_tags = array(
                        'th'   => array(
                            'scope' => array(),
                            'class'    => array(),
                            'id'    => array(),
                            'data-allow_clear'    => array(),
                        ),
                        'a'   => array(
                            'href' => array(),
                        ),
                        'span'   => array(
                            'class' => array(),
                        )
                    );
                
                echo wp_kses ( "<$tag $scope $id $class>$column_display_name</$tag>", $allowed_tags );
            }
        }
     
        
        
        protected function column_default( $item, $column_name ) {
            
            global $admin_page_hooks;
            $page_hook = isset ( $admin_page_hooks['woocommerce'] ) ?   $admin_page_hooks['woocommerce']    :   'woocommerce';
            
            //allow other to run on custom columns
            do_action('manage_' . $page_hook . '_page_soliw-sl-licences_column_' .  $column_name , $item );
               
        }

        
        
	    /**
	     * Handles the checkbox column output.
	     *
	     * @since 4.3.0
	     * @access public
	     *
	     * @param WP_Post $post The current WP_Post object.
	     */
	    public function column_order_id( $post ) {
		    ?><strong><?php echo esc_html ( $post->order_id ); ?></strong><?php
            
	    }

	    public function column_order_item_id( $post ) {
            
            $order      =   new WC_Order( $post->order_id );
            $order_item =   $order->get_item( $post->order_item_id );
            $product    =   $order_item->get_product();
            
            if  ( ! $product )
                return;
            
            ?>
            <a href="<?php echo  esc_url ( get_edit_post_link ( $product->get_id() ) ) ?>" class="wc-order-item-name"><?php echo esc_html ( $product->get_title() ) ?></a>
            <?php
            
                $sku    =   $product->get_sku();
                if( $sku != '') {
            ?>
            <div class="wc-order-item-sku"><strong><?php esc_html_e( 'SKU', 'software-license-lite' ) ?>:</strong> <?php echo esc_html ( $sku ) ?></div>
            <?php }
        }
        
        public function column_licence_group_id( $post ) {
            
            $licence_groups =   unserialize( $post->licence_groups );
            
            $title  =   isset($licence_groups['group_title'][$post->group_id])  ?   $licence_groups['group_title'][$post->group_id] :   '';
            
            ?><i><?php echo esc_html ( $title ) ?></i><?php        
        }
        
        public function column_user_id( $post ) {
            
            $order      =   new WC_Order( $post->order_id );
            
            if( $order->get_customer_id() >   0)
                {
                    $userdata = get_userdata( $post->customer_id );
                    ?><a href="<?php echo esc_url ( get_edit_user_link( $post->customer_id ) ); ?>"><?php echo esc_html ( $order->get_formatted_billing_full_name() ) ?></a><?php
                }
                else
                {
                    echo esc_html ( $order->get_formatted_billing_full_name() );
                }
            
            ?><small class="meta email"><a href="mailto:<?php echo esc_html ( $order->get_billing_email() ) ?>"><?php echo esc_html ( $order->get_billing_email() ) ?></a></small><?php
        }
        
        public function column_licence_key( $post ) {
            ?><strong><?php echo esc_html ( $post->licence ); ?></strong><?php        
        }

	    /**
	     * Handles the post date column output.
	     *
	     * @since 4.3.0
	     * @access public
	     *
	     * @global string $mode List table view mode.
	     *
	     * @param WP_Post $post The current WP_Post object.
	     */
	    public function column_created( $post ) {
		    global $mode;

		    if ( '0000-00-00 00:00:00' === $post->created ) {

			    $time_diff = 0;
		    } else {

			    $m_time = $post->created;
			    $time = get_post_time( 'G', true, $post );

			    $time_diff = time() - $time;

			    if ( $time_diff > 0 && $time_diff < DAY_IN_SECONDS ) {
				    /* translators: %s: Human-readable time difference (e.g., "5 minutes"). */
                    $h_time = sprintf( __( '%s ago', 'software-license-lite' ), human_time_diff( $time ) );
			    } else {
				    $h_time = mysql2date( __( 'Y/m/d', 'software-license-lite' ), $m_time );
			    }
		    }
        

		    echo '<abbr>' . esc_html ( apply_filters( 'post_date_column_time', $h_time, $post, 'date', $mode ) ) . '</abbr>';
	    }
        
        
        public function column_licence_expire( $post ) {
            global $SOLIW;

            $order_item_soliw          =   $SOLIW->functions->get_order_item_meta( $post->order_item_id, '_woo_sl');
            //use the first group
            reset($order_item_soliw['group_title']);
            $use_key    =   key( $order_item_soliw['group_title'] );
            
            if  ( $order_item_soliw['product_use_expire'][$use_key] == 'no' )
                {
                    echo '<i>' . esc_html__( 'No Expire', 'software-license-lite' ) .'</i>';
                    return;
                }
                
            $status    =   SOLIW_functions::get_order_item_meta( $post->order_item_id,  '_woo_sl_licensing_status',  TRUE);
            
            $_using_expire  =   SOLIW_functions::get_order_item_meta( $post->order_item_id,  '_woo_sl_licensing_using_expire',  TRUE);
            if ( ! empty ( $_using_expire ) && $_using_expire   != 'no ')
                {
                    if ( $_using_expire == 'yes' )
                        esc_html_e( 'Using Expire', 'software-license-lite' );
                        else if ( $_using_expire == 'woocommerce-subscriptions' )
                        esc_html_e( 'Subscription - WooCommerce Subscription', 'software-license-lite' );
                        else if ( $_using_expire == 'yith-subscriptions' )
                        esc_html_e( 'Subscription - YITH Subscription', 'software-license-lite' );
                        else if ( $_using_expire == 'wpsubscription' )
                        esc_html_e( 'Subscription - WP Subscription', 'software-license-lite' );
                    
                    echo '<br />';
                }
            
            if ( $status    !=  'not-activated' ) 
                { 
                
                    $_soliw_licensing_start        =   $SOLIW->functions->get_order_item_meta ( $post->order_item_id, '_woo_sl_licensing_start', TRUE );
                    if ( ! empty ( $_soliw_licensing_start ) )
                        {
                            $soliw_licensing_start         =   gmdate("Y-m-d", $_soliw_licensing_start );
                            echo esc_html__( 'Start', 'software-license-lite' ) . ' - ' . esc_html ( $soliw_licensing_start )  . ' ';
                        }

                    $_soliw_licensing_expire_at    =  $SOLIW->functions->get_order_item_meta ( $post->order_item_id, '_woo_sl_licensing_expire_at', TRUE );
                    if ( ! empty ( $_soliw_licensing_expire_at ) )
                        {
                            $soliw_licensing_expire_at     =   gmdate("Y-m-d", $_soliw_licensing_expire_at );
                            echo esc_html__( 'Expire', 'software-license-lite' ) .' - <b>' . esc_html ( $soliw_licensing_expire_at ) . '</b>';
                        }
                        
                    $_soliw_licensing_expired_at    =  $SOLIW->functions->get_order_item_meta ( $post->order_item_id, '_woo_sl_licensing_expired_at', TRUE );
                    if ( ! empty ( $_soliw_licensing_expired_at ) )
                        {
                            $soliw_licensing_expired_at     =   gmdate("Y-m-d", $_soliw_licensing_expired_at );
                            echo esc_html__( 'Expired at', 'software-license-lite' ) .' - <b>' . esc_html ( $soliw_licensing_expired_at ) . '</b>';
                        }

                }
                else
                {
                    esc_html_e( 'Using Expire - <b>Key not activated</b>', 'software-license-lite' );
                }
            
        }
        
        public function column_active_domain( $post ) {
            echo esc_html ( $post->active_domain );
        }

        
        public function column_order_status( $post ) {
            
            global $SOLIW;
            
            $licence_status =   $SOLIW->functions->get_licence_status( $post->order_item_id );
            
            switch ( $licence_status )
                {
                    case 'active'   :   
                                        ?><mark title="Active" class="order-status status-completed"><span><?php esc_html_e( 'Active', 'software-license-lite' ) ?></span></mark><?php
                                        break;   
                    
                    case 'inactive'   :   
                                        ?><mark title="Inactive" class="order-status status-inactive"><span><?php esc_html_e( 'Inactive', 'software-license-lite' ) ?></span></mark><?php
                                        break;
                    
                    case 'expired'   :   
                                        ?><mark title="Expired" class="order-status status-expired"><span><?php esc_html_e( 'Expired', 'software-license-lite' ) ?></span></mark><?php
                                        break;
                    
                    case 'not-activated'   :   
                                        ?><mark title="Expired" class="order-status status-non-activated"><span><?php esc_html_e( 'Not Activated', 'software-license-lite' ) ?></span></mark><?php
                                        break;
                                        
                    case 'cancelled'   :   
                                        ?><mark title="Cancelled" class="order-status status-cancelled"><span><?php esc_html_e( 'Cancelled', 'software-license-lite' ) ?></span></mark><?php
                                        break;
                    
                }
        }
        
        public function column_order_actions( $post ) {
            
            ?><p class="column-wc_actions">
                        <a class="button wc-action-button wc-action-button-view view" href="post.php?post=<?php echo esc_html ( $post->order_id ) ?>&action=edit"><?php esc_html_e( 'View', 'software-license-lite' ) ?></a>                </p><?php
        }
        
                
	    /**
	     * @global WP_Post $post
	     *
	     * @param int|WP_Post $post
	     * @param int         $level
	     */
	    public function single_row( $post, $level = 0 ) {

		    $classes = 'iedit';

	    ?>
		    <tr class="">
			    <?php $this->single_row_columns( $post ); ?>
		    </tr>
	    <?php

	    }

	    /**
	     * Gets the name of the default primary column.
	     *
	     * @since 4.3.0
	     * @access protected
	     *
	     * @return string Name of the default primary column, in this case, 'title'.
	     */
	    protected function get_default_primary_column_name() {
		    return 'order_id';
	    }
        
        /**
         * Generates and displays row action links.
         *
         * @since 4.3.0
         * @access protected
         *
         * @param object $post        Post being acted upon.
         * @param string $column_name Current column name.
         * @param string $primary     Primary column name.
         * @return string Row actions output for posts.
         */
        protected function handle_row_actions( $post, $column_name, $primary ) {
            if ( $primary !== $column_name ) {
                return '';
            }

            $actions['edit'] = sprintf(
                    '<a href="%s" aria-label="%s">%s</a>',
                    'post.php?post='. $post->order_id .'&action=edit',
                    /* translators: %s: post title */
                    esc_attr( __( 'Edit &#8220;%s&#8221;', 'software-license-lite' ) ),
                    __( 'Edit', 'software-license-lite' )
                );

            return $this->row_actions( $actions );
        }
        
        
        
        /**
        * Return orders statuses across all shops
        * 
        */
        function get_all_licences_orders_statuses()
            {
                global $wpdb;
                // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching               
                $results        =   $wpdb->get_results( $wpdb->prepare ( '
                
                    SELECT OI1.meta_value AS status, COUNT(*) as count FROM '. $wpdb->prefix .'woocommerce_software_licence as SL
                        JOIN '. $wpdb->prefix .'woocommerce_order_itemmeta as OI1 ON    OI1.order_item_id   =   SL.order_item_id
                        WHERE OI1.meta_key  =   %s
                        GROUP BY status
                    ', "_woo_sl_licensing_status"));
                
                $statuses   =   array();
                foreach ($results   as  $result)
                    {
                        if(!isset($statuses[$result->status]))
                            $statuses[$result->status] =   0;
                            
                        $statuses[$result->status] +=  $result->count;
                    }
                
                return $statuses;
            }
        
            
            /**
            * Return a list of orders from all sites
            * 
            * @param mixed $per_page
            * @param mixed $paged
            * @param mixed $post_status
            */
            function get_all_licences( $args )
                {
                    global $wpdb, $SOLIW;
                    
                    $defaults   = array (
                                            'per_page'          =>  10,
                                            'paged'             =>  1,
                                            'post_status'       =>  '',
                                            '_customer_user'    =>  '',
                                            'filter_search'     =>  '',
                                            
                                            'orderby'           =>  '',
                                            'order'             =>  ''
                                        );
                                        
                    // Parse incoming $args into an array and merge it with $defaults
                    $args   =   wp_parse_args( $args, $defaults );
                    
                    if ( $SOLIW->functions->is_HPOS_active() )
                        $sql_chunk  =   'PM1.customer_id';
                        else
                        $sql_chunk  =   'PM1.meta_value';
                    
                    $mysql_query    =   '
                    
                        SELECT SQL_CALC_FOUND_ROWS *, OI1.meta_value AS status, OI2.meta_value AS licence_groups, '. $sql_chunk .' AS customer_id FROM  '. $wpdb->prefix .'woocommerce_software_licence as SL
                        ';
                         
                    /**
                    * JOIN
                    */ 
                    
                    $mysql_query    .=  " JOIN " . $wpdb->prefix ."woocommerce_order_itemmeta as OI1 ON    OI1.order_item_id   =   SL.order_item_id 
                                            JOIN " . $wpdb->prefix ."woocommerce_order_itemmeta as OI2 ON    OI2.order_item_id   =   SL.order_item_id
                    ";
                    
                    if ( $SOLIW->functions->is_HPOS_active() )
                        $mysql_query    .=  " JOIN " . $wpdb->prefix ."wc_orders as PM1 ON    PM1.id   =   SL.order_id
                        ";
                        else
                        $mysql_query    .=  " JOIN " . $wpdb->postmeta ." as PM1 ON    PM1.post_id   =   SL.order_id
                        ";
                    
                    //search all meta for order
                    if( ! empty ( $args['filter_search'] )  &&  ! $SOLIW->functions->is_HPOS_active() )
                        {
                            $mysql_query    .=          " JOIN ". $wpdb->postmeta . " AS pm_s ON SL.order_id = pm_s.post_id";
                        }
                    
                    if ( ! empty ( $args['post_status'] ) && in_array ( $args['post_status'], array ( '__using_expire__', '__using_expire_not_active__' ) ) )
                        {
                            $mysql_query    .=          " JOIN " . $wpdb->prefix ."woocommerce_order_itemmeta as pm_ue ON    pm_ue.order_item_id   =   SL.order_item_id";
                        } 
                    
                    /**
                    * WHERE
                    *                             
                    * @var mixed
                    */
                    
                    if ( $SOLIW->functions->is_HPOS_active() )
                        $mysql_query    .=  " WHERE OI1.meta_key  =   '_woo_sl_licensing_status' AND OI2.meta_key  =   '_woo_sl'";
                        else
                        $mysql_query    .=  " WHERE OI1.meta_key  =   '_woo_sl_licensing_status' AND OI2.meta_key  =   '_woo_sl' AND PM1.meta_key    =   '_customer_user'";
                    
                    if ( ! empty ( $args['post_status'] ) && ! in_array ( $args['post_status'], array ( '__using_expire__', '__using_expire_not_active__' ) ) )
                        {
                            $mysql_query    .=  " AND OI1.meta_value   =   '". $args['post_status'] ."'";
                        }
                    if ( ! empty ( $args['post_status'] ) && in_array ( $args['post_status'], array ( '__using_expire__', '__using_expire_not_active__' ) ) )
                        {
                            $comparison =   $args['post_status']    ==  '__using_expire__'  ?   'IN'    :   'NOT IN';
                            
                            $mysql_query    .=  ' AND pm_ue.meta_key = "_soliw_licensing_using_expire" AND pm_ue.meta_value IN ( "yes", "yith-subscriptions", "woocommerce-subscriptions", "wpsubscription" ) AND OI1.meta_value   ' . $comparison . ' ( "active" ) 
                                                     AND SL.order_item_id NOT IN(
                                                        SELECT
                                                            order_item_id
                                                        FROM
                                                           '. $wpdb->prefix .'woocommerce_order_itemmeta
                                                        WHERE
                                                            meta_key = "_soliw_licensing_expired_at" AND meta_value > 0
                                                    )';  
                        }    
                    
                          
                    //custoer
                    if( ! empty ( $args['_customer_user'] ) )
                        {
                                       
                            if ( $SOLIW->functions->is_HPOS_active() )
                                $mysql_query        .=  " AND PM1.customer_id   =   '".$args['_customer_user']."'";
                                else
                                $mysql_query        .=  " AND PM1.meta_value   =   '".$args['_customer_user']."'";
                        }
                    
                    //search    
                    if( ! empty ( $args['filter_search'] ) )
                        {
                            if ( $SOLIW->functions->is_HPOS_active() )           
                                $mysql_query        .=  " AND ( OI1.meta_value LIKE '%". esc_sql($args['filter_search']) ."%' OR OI2.meta_value LIKE '%". esc_sql($args['filter_search']) ."%' OR SL.licence LIKE '%". esc_sql($args['filter_search']) ."%' OR SL.active_domain LIKE '%". esc_sql($args['filter_search']) ."%' )";
                                else
                                $mysql_query        .=  " AND ( pm_s.meta_value LIKE '%". esc_sql($args['filter_search']) ."%' OR OI1.meta_value LIKE '%". esc_sql($args['filter_search']) ."%' OR OI2.meta_value LIKE '%". esc_sql($args['filter_search']) ."%' OR SL.licence LIKE '%". esc_sql($args['filter_search']) ."%' OR SL.active_domain LIKE '%". esc_sql($args['filter_search']) ."%' )";
                        }
                    
                    
                    /**
                    * Group BY
                    * 
                    * @var mixed
                    */
                    if ( ! empty ( $args['post_status'] ) && in_array ( $args['post_status'], array ( '__using_expire__', '__using_expire_not_active__' ) ) )
                        {
                            //$mysql_query        .=  ' GROUP BY SL.order_id';               
                        }
                    else if( ! empty ( $args['filter_search'] ) )
                        {
                            
                            if ( $SOLIW->functions->is_HPOS_active() )
                                $mysql_query    .=              " GROUP BY PM1.id ";
                                else
                                $mysql_query    .=              " GROUP BY ID ";
                            
                        }
                    
                                                        
               
                    $mysql_query    .=   '  ORDER BY ';
                        
                    switch ($args['orderby'])
                        {
                            case "orderby"      :
                                                    $mysql_query    .= 'SL.order_id';
                                                    break;
                            case "licence_key"  :
                                                    $mysql_query    .= 'SL.licence';
                                                    break;
                            
                            case "created"  :
                                                    $mysql_query    .= 'SL.created';
                                                    break;
                                                    
                            case "status"  :
                                                    $mysql_query    .= 'OI1.meta_value';
                                                    break;
                                         
                                                    
                            default :
                                                    $mysql_query    .= 'SL.order_id';
                                                    break;
                        }
                    
                    $mysql_query    .= ' ';
                        
                    switch (strtolower($args['order']))
                        {
                            case "asc"    :
                                                    $mysql_query    .= 'ASC';
                                                    break;
                            case "desc"    :
                                                    $mysql_query    .= 'DESC';
                                                    break;
                            default :
                                                    $mysql_query    .= 'DESC';
                                                    break;   
                               
                        }
                        
                    $mysql_query    .= '   LIMIT ' . ( $args['per_page'] * ($args['paged'] - 1) ) . ', '. $args['per_page'] ;
                    //$results        =   $wpdb->get_results( $wpdb->prepare( $mysql_query . '/* %s */', ' ' ) );
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $results        =   $wpdb->get_results( $mysql_query );
                    // phpcs:ignore WordPress.DB.PreparedSQL.NotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching
                    $total_records  =   $wpdb->get_var("SELECT FOUND_ROWS()");
                    
                    $data = array(  
                                    'results'       =>  $results,
                                    'total_records' =>  $total_records
                                    );
                    
                    return $data;
                }
            
        
    }

?>