<?php
    
    defined( 'ABSPATH' ) || exit;
    
    class SOLIW_API 
        {
              var $functions;
              var $response =   array();
              var $is_remote_call;
              
              var $api_version  =   1.2;
            
            /**
            * 
            * Run on class construct
            * 
            */
            function __construct( ) 
                {
                                      
                    $this->functions = new SOLIW_functions();
                    $this->is_remote_call   =   FALSE;
                }
            
            function init()
                {
                    $args   =   array ();
                    // phpcs:ignore WordPress.Security.NonceVerification.Recommended 
                    if ( isset ( $_GET['woo_sl_action'] ) )
                        {
                            // phpcs:ignore WordPress.Security.NonceVerification.Recommended 
                            $args   =   $this->sanitize_args ( $_GET );
                        }
                        // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing 
                        else if ( isset ( $_POST['woo_sl_action'] ) )
                        {
                            // phpcs:ignore WordPress.Security.NonceVerification.Recommended, WordPress.Security.NonceVerification.Missing 
                            $args   =   $this->sanitize_args ( $_POST );
                        }
                                            
                    $this->is_remote_call   =   TRUE;
                    
                    $this->API_call( $args );
                }
                
                
            
            /**
            * API router
            *     
            * @param mixed $args
            */
            function API_call( $args   =   array() )
                {
                    
                    $args   =   $this->sanitize_args ( $args );
                     
                    $defaults   =   array(
                                            'responseType'      =>  'json',
                                            
                                            'woo_sl_action'     =>  '',
                                            
                                            'product_unique_id' =>  '',
                                            'licence_key'       =>  '',
                                            'domain'            =>  '',
                                            'version'           =>  '',
                                            '_get_product_meta' =>  '',
                                            
                                            'api_version'       =>  ''
                                            
                                            );
                    $args       = wp_parse_args( $args, $defaults ); 
                    
                    $args   =   apply_filters('WOOSL/API_call/arguments', $args, $this );
                    
                    //check for any API calls
                    $action = $args['woo_sl_action'];
                    if ( empty ( $action ) )
                        return;
                    
                    /**
                    * DEPRECATED
                    * 
                    * WOOSL/API_call/early_return
                    */
                    $this->response =   apply_filters('WOOSL/API_call/early_return', array(), $args, $this );
                    
                    //allow API early response
                    $this->response =   apply_filters('WOOSL/API_call/early_response', $this->response, $args, $this );
                    
                    // phpcs:ignore WordPress.PHP.DevelopmentFunctions.prevent_path_disclosure_error_reporting, QITStandard.PHP.DebugCode.ErrorReportingSuppressed 
                    error_reporting(0);
                                        
                    remove_all_filters( 'shutdown', 999);
                    
                    if ( apply_filters('WOOSL/API_call/do_action', TRUE, $this->response, $args, $this ) )
                        {                    
                            switch ($action)
                                {
                                    case 'activate'     :
                                                                $this->activate( $args );
                                                                break;
                                    
                                    case 'deactivate'   :
                                                                $this->deactivate( $args );
                                                                break;
                                                            
                                    case 'status-check'  :
                                                                $this->status_check( $args );
                                                                break;
                                                            
                                                            
                                    case 'plugin_update' :
                                    
                                                                $this->plugin_update( $args );    
                                                                break;
                                                            
                                    case 'theme_update' :
                                                            
                                                                $this->theme_update( $args );    
                                                                break; 
                    
                                    case 'plugin_information' :
                                                                
                                                                $this->plugin_information( $args );
                                                                break;
                                                                
                                    case 'code_version' :
                                                                
                                                                $this->code_information( $args );
                                                                break;
                                                                
                                    case 'key_delete'        :
                                                                
                                                                $this->key_delete( $args );
                                                                break;
                                    
                                }
                        }
                    
                    $this->response   =   apply_filters('WOOSL/API_call/response', $this->response, $args, $this );
                    
                    if( $this->is_remote_call )
                        {
                            $this->output_response( $args );
                            die();
                        }
                        else
                        return $this->return_response( $args );
                }
                
                
            function sanitize_args ( $args ) 
                {
                    $sanitized_args =   array();
                    
                    foreach ( $args as  $arg_title  =>  $arg_value )
                        {
                            switch ( $arg_title )
                                {
                                    case 'woo_sl_action'    :
                                                                    $sanitized_args['woo_sl_action'] =   preg_replace("/[^a-zA-Z0-9-_]/i", "", $arg_value );
                                                                    break;
                                    
                                    case 'product_unique_id'    :
                                                                    $sanitized_args['product_unique_id'] =   preg_replace("/[^a-zA-Z0-9.\-\_ ]/", "", $arg_value );
                                                                    break;    
                                    
                                    case 'licence_key'    :
                                                                    $sanitized_args['licence_key'] =   preg_replace("/[^a-zA-Z0-9.\-\_\: ]/", "", $arg_value );
                                                                    break;
                                    
                                    case 'domain'    :
                                                                    $sanitized_args['domain'] =   $this->clean_machine_hash( preg_replace("/[^a-zA-Z0-9.\-\_\/ ]/", "", $arg_value ) );
                                                                    break;
                                                                    
                                    case 'version'    :
                                                                    $sanitized_args['version'] =   preg_replace("/[^a-zA-Z0-9.\-\_ ]/", "",       $arg_value );
                                                                    break;
                                                                    
                                    case 'api_version'    :
                                                                    $sanitized_args['api_version'] =   preg_replace("/[^a-zA-Z0-9.]/", "",       $arg_value );
                                                                    break;
                                                                    
                                    case '_get_product_meta'    :
                                                                    $sanitized_args['_get_product_meta'] =   preg_replace("/[^a-zA-Z0-9.\,\-\_ ]/", "", $arg_value );
                                                                    break;

                                }
                        }
                        
                    return $sanitized_args;
                    
                }
                
                
            
            /**
            * Clean the domain name for unnecessarily characters
            * 
            * @param mixed $domain
            */
            function clean_machine_hash( $machine_hash )
                {
                    $machine_hash =   trim( $machine_hash );
                    
                    $filtered_machine_hash   =   apply_filters('WOOSL/API_call/clean_machine_hash', '', $machine_hash );
                    if ( ! empty ( $filtered_machine_hash )  )
                        return $filtered_machine_hash;
                    
                    //Evaluate if domain format
                    if ( preg_match( '/(http[s]?\:\/\/)?(?!\-)(?:[a-zA-Z\d\-]{0,62}[a-zA-Z\d]\.){1,126}(?!\d+)[a-zA-Z\d]{1,63}/', $machine_hash ) )
                        {
                            $machine_hash =   trim( $machine_hash, '/');
                            $machine_hash =   strtolower( $machine_hash );
                        }
                    
                    //case insensitive
                    $machine_hash =   strtolower( $machine_hash );
                    
                    return $machine_hash;
                       
                }
                
                
        }