<?php
    
    defined( 'ABSPATH' ) || exit;
    
    class SOLIW_API_v1_2  extends SOLIW_API 
        {
              var $functions;
              var $response =   array();
              var $is_remote_call;
              
              var $api_version  =   1.2;
                            
            /**
            * 
            * Activate a license key 
            *    
            */
            function activate( $args )
                {
                    $product_unique_id  = $args['product_unique_id'];
                    $licence_key        = $args['licence_key'];
                    $domain             = $args['domain'];
                         
                    $product_id = $this->product_validation( $licence_key, $product_unique_id );
                    if($product_id === FALSE)
                        return FALSE;
                    
                    if ( ! $this->order_status_validation ( $licence_key, $product_unique_id ) )
                        return FALSE;
                        
                    //check against the licence key validation
                    $licence_key_data = $this->functions->get_licence_key_data_by_licence_key( $licence_key, array ( 'product_unique_id'  =>  $product_unique_id ) );
                    
                    if (    !   isset($licence_key_data->id))
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e111',
                                                            'message'      => 'Invalid Data'
                                                                );
                            return FALSE;
                        }
                        
                    if ( empty ( $domain ) )
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e113',
                                                            'message'      => 'The machine ID / domain is required.'
                                                                );
                            return FALSE;
                        }
                    
                    $licence_status         =   $this->functions->get_licence_status( $licence_key_data->order_item_id );
                    
                    $order_item_soliw      =   $this->get_order_item_soliw( $licence_key_data->order_item_id, $args );
                    if ( empty ( $order_item_soliw ) )
                        {
                            $response   =   array(
                                                            'status'            => 'error',
                                                            'status_code'       => 'e316',
                                                            'message'           => 'Invalid licensing setup',
                                                            'licence_status'    => $licence_status
                                                                );
                        
                            $this->response[]   =   $response;
                            return FALSE; 
                            
                        }
                    
                    //use the first group
                    reset($order_item_soliw['group_title']);
                    $use_key    =   key( $order_item_soliw['group_title'] );
                    
                    if (  ! in_array( $licence_status, array('active', 'not-activated') ) )
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e312',
                                                            'message'      => 'Licence is not Active, current status is ' . ucfirst($licence_status),
                                                            'licence_status'    => $licence_status
                                                                );
                            return FALSE;   
                            
                        }
                    
                    global $wpdb;
                    
                    //get current number of instances for this key
                    $key_instances      =   $this->functions->get_license_key_active_instances( $licence_key_data->licence, $licence_key_data->order_item_id );
                    
                    //check if the domain already active
                    $existing_licence_data = $this->functions->get_licence_key_data_by_licence_key( $licence_key, array ( 'domain'  =>  $domain ) );
                    if (isset($existing_licence_data->id))
                        {
                            $response   =   array(
                                                    'status'       => 'success',
                                                    'status_code'  => 's101',
                                                    'message'      => 'The license key has already been activated for ' .$domain,
                                                    'licence_status'    =>  $licence_status
                                                        );
                                                                
                            $response   =   $this->get_order_item_expire_response_details( $licence_key_data->order_item_id, $response);
                        
                            $this->response[]   =   $response;
                            
                            return;
                        }
                    
                    //get the number of instances this key can be registered on
                    $max_instances_per_key  =  $order_item_soliw['max_instances_per_key'][$licence_key_data->group_id];
                    
                    $can_register_domain_to_license_key     =   ( ! empty ( $max_instances_per_key ) && $max_instances_per_key > 0 && count( $key_instances ) >= $max_instances_per_key ) ?   FALSE : TRUE;
                    $can_register_domain_to_license_key     =   apply_filters('WOOSL/API_call/activate/can_register_domain', $can_register_domain_to_license_key, $domain, $key_instances, $max_instances_per_key );
                    if ( ! $can_register_domain_to_license_key )
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e112',
                                                            'message'      => 'You had reached the maximum number of domains for this key'
                                                                );
                            return FALSE;
                        }
               
                    if(( count($key_instances) < 2    && isset ( $key_instances[0] )   &&  trim($key_instances[0]->active_domain) ==  '')
                        ||
                        (  count($key_instances) === 0 && empty ( $licence_key_data->active_domain ))
                    )
                        {
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching  
                            $result = $wpdb->get_results( $wpdb->prepare("UPDATE `" . $wpdb->prefix ."woocommerce_software_licence`
                                            SET `active_domain`    =   %s
                                            WHERE id = %d",
                                            $domain, $licence_key_data->id) );
                        }
                        else
                        {
                            $time           = gmdate("Y-m-d H:i:s", time()); 
                    
                            //create a new entry for this key and domain
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $results = $wpdb->get_results( $wpdb->prepare("INSERT INTO `" . $wpdb->prefix ."woocommerce_software_licence` 
                                            (`id`, `order_id`, `order_item_id`, `group_id`, `licence`, `created`, `active_domain`) 
                                            VALUES (NULL, %d, %d, %d, %s, %s, %s );", $licence_key_data->order_id, $licence_key_data->order_item_id, $licence_key_data->group_id, $licence_key_data->licence, $time, $domain) ); 
                        }
                        
                    //update the status of item id if necesarely
                    //This always use expire..
                    if (    $licence_status ==  'not-activated' )
                        {
                            $this->activate_licence( $licence_key_data, $product_id, $order_item_soliw, $use_key );
                            $licence_status =   'active';
                        }
                        
                    $response   =   array(
                                                    'status'            => 'success',
                                                    'status_code'       => 's100',
                                                    'message'           => 'Licence Key Successfully Activated for ' .$domain,
                                                    'licence_status'    =>  $licence_status
                                                        );
                                                        
                    $response   =   $this->get_order_item_expire_response_details( $licence_key_data->order_item_id, $response);
                        
                    $this->response[]   =   $response;
                                        
                    return TRUE;   
                }
                
            /**
            * 
            * Deactivate a license key 
            * 
            */
            function deactivate( $args )
                {
                    $product_unique_id  = $args['product_unique_id'];
                    $licence_key        = $args['licence_key'];
                    $domain             = $args['domain'];
                    
                    $product_id = $this->product_validation($licence_key, $product_unique_id);
                    if($product_id === FALSE)
                        return FALSE;
                        
                    if ( ! $this->order_status_validation ( $licence_key, $product_unique_id ) )
                        return FALSE;
                        
                    if ( empty ( $domain ) )
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e104',
                                                            'message'      => 'The machine ID / domain is required.'
                                                                );
                            return FALSE;
                        }
                        
                    //check against the licence key validation
                    $licence_key_data = $this->functions->get_licence_key_data_by_licence_key( $licence_key, array ( 'domain'  =>  $domain ) );
                    
                    if (    !   isset($licence_key_data->id))
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e110',
                                                            'message'      => 'Invalid Licence Key or Licence Key not Active for Domain'
                                                                );
                            return FALSE;
                        }
                                   
                    global $wpdb;
                    
                    $this->functions->key_domain_remove($licence_key_data);
                    $this->response[]   =   array(
                                                            'status'       => 'success',
                                                            'status_code'  => 's201',
                                                            'message'      => 'Licence Key Successfully Unassigned'
                                                                );
                    
                    return TRUE;
               
                }
            
            
            /**
            * 
            * Check the status of a licence 
            * 
            */
            function status_check( $args )
                {
                    $product_unique_id  = $args['product_unique_id'];
                    $licence_key        = $args['licence_key'];
                    $domain             = $args['domain'];
                    
                    $product_id = $this->product_validation($licence_key, $product_unique_id);
                    if($product_id === FALSE)
                        return FALSE;
                        
                    //check against the licence key validation
                    $licence_key_data   =   $this->functions->get_licence_key_data_by_licence_key( $licence_key, array ( 'product_unique_id'  =>  $product_unique_id ) );
                    
                    if (    !   isset($licence_key_data->id))
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e301',
                                                            'message'      => 'Licence Key does not match this product'
                                                                );
                            return FALSE;
                        }
                        
                    if (  empty ( $domain ) )
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e304',
                                                            'message'      => 'The machine ID / domain is required.'
                                                                );
                            return FALSE;
                        }
                        
                    $licence_status             =   $this->functions->get_licence_status( $licence_key_data->order_item_id );
                    $order_item_soliw           =   $this->get_order_item_soliw( $licence_key_data->order_item_id, $args );
                    
                    if ( empty ( $order_item_soliw ) )
                        {
                            $response   =   array(
                                                            'status'            => 'error',
                                                            'status_code'       => 'e316',
                                                            'message'           => 'Invalid licensing setup',
                                                            'licence_status'    => $licence_status
                                                                );
                        
                            $this->response[]   =   $response;
                            return FALSE; 
                            
                        }
                    
                    //use the first group
                    reset($order_item_soliw['group_title']);
                    $use_key    =   key( $order_item_soliw['group_title'] );
                                            
                    //get current number of instances for this key
                    $key_instances      =   $this->functions->get_license_key_active_instances( $licence_key_data->licence, $licence_key_data->order_item_id );
                    if( ( count($key_instances) < 1    ||  (   count($key_instances) < 2    && trim($key_instances[0]->active_domain) == '' ) ) )
                        {
                            
                            $woocommerce_licensing_assign_domain_to_key_on_status_check =   $this->functions->get_option('woocommerce_licensing_assign_domain_to_key_on_status_check');
                            if ( $woocommerce_licensing_assign_domain_to_key_on_status_check    ==  'yes' )
                                {
                                    $response   =   $this->activate( $args );
                                    if($response !==    FALSE)
                                        {
                                            $response   =   array(
                                                                    'status'       => 'success',
                                                                    'status_code'  => 's205',
                                                                    'message'      => 'Licence Key Is Active and Valid for Domain'
                                                                        );
                                            $response   =   $this->get_order_item_expire_response_details( $licence_key_data->order_item_id, $response);
                                            $response   =   $this->set_additional_response_data( $response, $args );
                        
                                            $this->response[]   =   $response;
                                            
                                            return TRUE;   
                                            
                                        }   
                                }
                            
                            $response   =   array(
                                                            'status'       => 'success',
                                                            'status_code'  => 's203',
                                                            'message'      => 'Licence Key Is not assigned to domain'
                                                                );
                            if (    $licence_status ==  'not-activated' )
                                {
                                    $response['licence_start']   =   'Not activated yet';
                                    $response['licence_expire']  =   'Unavailable';
                                }
                                else
                                {
                                    $response   =   $this->get_order_item_expire_response_details( $licence_key_data->order_item_id, $response);
                                }
                        
                            $response   =   $this->set_additional_response_data( $response, $args );
                        
                            $this->response[]   =   $response;
                            return FALSE;
                        }
                    
                    $found_instance = FALSE;    
                    foreach($key_instances  as  $key_instance)
                        {
                            if($domain  ==  $this->clean_machine_hash ( $key_instance->active_domain ))
                                {
                                    $found_instance =   TRUE;
                                    break;
                                }
                        }
                        
                    if($found_instance  === FALSE)
                        {
                            $woocommerce_licensing_assign_domain_to_key_on_status_check =   $this->functions->get_option('woocommerce_licensing_assign_domain_to_key_on_status_check');
                            if ( $woocommerce_licensing_assign_domain_to_key_on_status_check    ==  'yes' )
                                {
                                    $response   =   $this->activate( $args );
                                    if($response !==    FALSE)
                                        {
                                            $response   =   array(
                                                                    'status'       => 'success',
                                                                    'status_code'  => 's205',
                                                                    'message'      => 'Licence Key Is Active and Valid for Domain'
                                                                        );
                                            $response   =   $this->get_order_item_expire_response_details( $licence_key_data->order_item_id, $response);
                                            $response   =   $this->set_additional_response_data( $response, $args );
                        
                                            $this->response[]   =   $response;
                                            
                                            return TRUE;   
                                            
                                        }   
                                }
                            
                            $response   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e204',
                                                            'message'      => 'Licence key not active for current domain'
                                                                );
                            $response   =   $this->get_order_item_expire_response_details( $licence_key_data->order_item_id, $response);
                            $response   =   $this->set_additional_response_data( $response, $args );
                        
                            $this->response[]   =   $response;
                            return FALSE;  
                        }
                        
                        
                    $response   =   array(
                                                            'status'            =>  'success',
                                                            'status_code'       =>  's215',
                                                            'message'           =>  'Licence Key Is Active and Valid for Domain',
                                                            'licence_status'    =>  $licence_status
                                                                );   
                    $response   =   $this->get_order_item_expire_response_details( $licence_key_data->order_item_id, $response);
                    $response   =   $this->set_additional_response_data( $response, $args );
                        
                    $this->response[]   =   $response;

                    return TRUE;
                }
            
            
            /**
            * Return plugin update informations
            * 
            * @param mixed $args
            */
            function plugin_update( $args )
                {
                    $product_unique_id  = $args['product_unique_id'];
                    $licence_key        = $args['licence_key'];
                    $version            = $args['version'];
                    $domain             = $args['domain'];
                    
                    if ( empty ( $licence_key ) )
                        {
                            $this->code_information( $args );
                            
                            return TRUE;
                        }
                    
                    $licence_key_data = $this->functions->get_licence_key_data_by_licence_key( $licence_key, array ( 'product_unique_id'  =>  $product_unique_id ) );
                    if ( ! $licence_key_data )
                        {
                            $this->code_information( $args );
                            
                            return TRUE;
                        }
                    
                    $product_id = $this->product_validation( $licence_key, $product_unique_id );
                    if($product_id === FALSE)
                        return FALSE;
                    
                    $key_instances      =   $this->functions->get_license_key_active_instances( $licence_key_data->licence, $licence_key_data->order_item_id );
                             
                    $found_instance = FALSE;    
                    foreach($key_instances  as  $key_instance)
                        {
                            if($domain  ==  $this->clean_machine_hash ( $key_instance->active_domain) )
                                {
                                    $found_instance =   TRUE;
                                    break;
                                }
                        }
   
                                                
                    $licence_status             =   $this->functions->get_licence_status( $licence_key_data->order_item_id );
                    
                    $order_item_soliw          =   $this->get_order_item_soliw( $licence_key_data->order_item_id, $args );
                    if ( empty ( $order_item_soliw ) )
                        {
                            $response   =   array(
                                                            'status'            => 'error',
                                                            'status_code'       => 'e316',
                                                            'message'           => 'Invalid licensing setup',
                                                            'licence_status'    => $licence_status
                                                                );
                        
                            $this->response[]   =   $response;
                            return FALSE; 
                            
                        }
                    
                    
                    
                  
                    $data = new stdClass;
                    
                    if (version_compare($version, get_post_meta($product_id, '_sl_new_version', TRUE), '<')) 
                        {
                            //use the first group
                            reset($order_item_soliw['group_title']);
                            $use_key    =   key( $order_item_soliw['group_title'] );
                            
                            if ( $found_instance && in_array($licence_status, array('active')) ||  (   ! in_array($licence_status, array('active'))  ) )
                                {
                                    $download_url    = $this->get_product_download_link($licence_key_data);
                                }
                                else
                                $download_url    = '';
                            
                            $data->new_version          =  get_post_meta($product_id, '_sl_new_version', TRUE);
                            $data->date                 =  get_post_meta($product_id, '_sl_last_updated', TRUE);
                            $data->package              =  $download_url;
                            
                            if (   ! in_array($licence_status, array('active') ) )
                                $data->upgrade_notice       =  $order_item_soliw['product_expire_notice'][$use_key];
                                else
                                $data->upgrade_notice       =  get_post_meta($product_id, '_sl_update_nottice', TRUE);
                                
                            $data->author               =  get_post_meta($product_id, '_sl_author', TRUE);
                            $data->tested               =  get_post_meta($product_id, '_sl_tested_up_to', TRUE);
                            $data->homepage             =  get_post_meta($product_id, '_sl_plugin_url', TRUE);
                            

                            $data->icons = array(
                                                                'svg'   =>  get_post_meta( $product_id, '_sl_icons_svg', TRUE ),
                                                                '2x'    =>  get_post_meta( $product_id, '_sl_icons_2x', TRUE ),
                                                                '1x'    =>  get_post_meta( $product_id, '_sl_icons_1x', TRUE ),
                                                            );
                        }

                    if ( $found_instance )
                        $status_code    =   's401';
                        else
                        $status_code    =   's411';
                    
                    
                    $response   =   array(
                                                            'status'            => 'success',
                                                            'status_code'       => $status_code,
                                                            'licence_status'    => $licence_status,
                                                            
                                                            //deprecated, rely on update_data instead
                                                            'message'           => 'Plugin update check completed',
                                                            
                                                            'update_data'       => $data
                                                                );
                    
                    $response   =   $this->get_order_item_expire_response_details( $licence_key_data->order_item_id, $response );                    
                    $this->response[]   =   $response;

                        
                    return TRUE;
                    
                }
            
            
            /**
            * Return theme update informations
            * 
            * @param mixed $args
            */
            function theme_update( $args )
                {
                    $product_unique_id  = $args['product_unique_id'];
                    $licence_key        = $args['licence_key'];
                    $version            = $args['version'];
                    $domain             = $args['domain'];
                    
                    if ( empty ( $licence_key ) )
                        {
                            $this->code_information( $args );
                            
                            return TRUE;
                        }
                    
                    $product_id = $this->product_validation($licence_key, $product_unique_id);
                    if($product_id === FALSE)
                        return FALSE;
  
                    $licence_key_data = $this->functions->get_licence_key_data_by_licence_key( $licence_key, array ( 'product_unique_id'  =>  $product_unique_id ) );
                    
                    $key_instances      =   $this->functions->get_license_key_active_instances( $licence_key_data->licence, $licence_key_data->order_item_id );
                    
                    $found_instance = FALSE;    
                    foreach($key_instances  as  $key_instance)
                        {
                            if($domain  ==  $this->clean_machine_hash ( $key_instance->active_domain) )
                                {
                                    $found_instance =   TRUE;
                                    break;
                                }
                        }
 
                                  
                    $licence_status             =   $this->functions->get_licence_status( $licence_key_data->order_item_id );
                    
                    $order_item_soliw          =   $this->get_order_item_soliw( $licence_key_data->order_item_id, $args );
                    if ( empty ( $order_item_soliw ) )
                        {
                            $response   =   array(
                                                            'status'            => 'error',
                                                            'status_code'       => 'e316',
                                                            'message'           => 'Invalid licensing setup',
                                                            'licence_status'    => $licence_status
                                                                );
                        
                            $this->response[]   =   $response;
                            return FALSE; 
                            
                        }
                    
                    
                  
                    $data = new stdClass;

                    if (version_compare($version, get_post_meta( $product_id, '_sl_new_version', TRUE), '<' ) ) 
                        {
                            //use the first group
                            reset($order_item_soliw['group_title']);
                            $use_key    =   key( $order_item_soliw['group_title'] );
                            
                            if ( $found_instance    &&  in_array($licence_status, array('active')) )
                                {
                                    $download_url    = $this->get_product_download_link($licence_key_data);
                                }
                                else
                                $download_url    = '';
                            
                            $data->new_version          =  get_post_meta($product_id, '_sl_new_version', TRUE);
                            $data->date                 =  get_post_meta($product_id, '_sl_last_updated', TRUE);
                            $data->package              =  $download_url;
                            
                            if (   ! in_array($licence_status, array('active') ) )
                                $data->upgrade_notice       =  $order_item_soliw['product_expire_notice'][$use_key];
                                else
                                $data->upgrade_notice       =  get_post_meta($product_id, '_sl_update_nottice', TRUE);
                            
                            $data->author               =  get_post_meta($product_id, '_sl_author', TRUE);
                            $data->tested               =  get_post_meta($product_id, '_sl_tested_up_to', TRUE);
                            $data->url                  =  get_post_meta($product_id, '_sl_plugin_url', TRUE);
                        }
                    
                    if ( $found_instance )
                        $status_code    =   's401';
                        else
                        $status_code    =   's411';
                        
                        
                    $response   =   array(
                                                            'status'            => 'success',
                                                            'status_code'       => $status_code,
                                                            'licence_status'    => $licence_status,
                                                            
                                                            //deprecated, rely on update_data instead
                                                            'message'           => 'Theme update check completed',
                                                            
                                                            'update_data'       => $data
                                                                );
                    
                    $response   =   $this->get_order_item_expire_response_details( $licence_key_data->order_item_id, $response );                    
                    $this->response[]   =   $response;    
  
                    return TRUE;
                }    
            
            
            /**
            * Return plugi information
            * 
            * @param mixed $args
            */
            function plugin_information( $args )
                {
                    
                    $product_unique_id  = $args['product_unique_id'];
                    $licence_key        = $args['licence_key'];
                    $version            = $args['version'];
                    $domain             = $args['domain'];
                    
                    if ( empty ( $licence_key ) )
                        {
                            $this->code_information( $args );
                            
                            return TRUE;
                        }
                    
                    $product_id = $this->product_validation($licence_key, $product_unique_id);
                    if($product_id === FALSE)
                        return FALSE;
  
                    $licence_key_data = $this->functions->get_licence_key_data_by_licence_key( $licence_key, array ( 'product_unique_id'  =>  $product_unique_id ) );
                    
                    $key_instances      =   $this->functions->get_license_key_active_instances( $licence_key_data->licence, $licence_key_data->order_item_id );
                    
                    $found_instance = FALSE;    
                    foreach($key_instances  as  $key_instance)
                        {
                            if($domain  ==  $this->clean_machine_hash ( $key_instance->active_domain ))
                                {
                                    $found_instance =   TRUE;
                                    break;
                                }
                        }
           
                    $product_data = get_post($product_id);
                       
                    $licence_status             =   $this->functions->get_licence_status( $licence_key_data->order_item_id );
                    
                    $order_item_soliw           =   $this->get_order_item_soliw( $licence_key_data->order_item_id, $args );
                    if ( empty ( $order_item_soliw ) )
                        {
                            $response   =   array(
                                                            'status'            => 'error',
                                                            'status_code'       => 'e316',
                                                            'message'           => 'Invalid licensing setup',
                                                            'licence_status'    => $licence_status
                                                                );
                        
                            $this->response[]   =   $response;
                            return FALSE; 
                            
                        }
                        
                    //use the first group
                    reset($order_item_soliw['group_title']);
                    $use_key    =   key( $order_item_soliw['group_title'] );
                    
                    if ( $found_instance    &&   in_array($licence_status, array('active')) )
                        {
                            $download_url    = $this->get_product_download_link($licence_key_data);
                        }
                        else
                        $download_url    = '';
                  
                    $data = new stdClass;
                    $data->name                 =  get_post_meta($product_id, '_sl_software_title', TRUE);
                    $data->new_version          =  get_post_meta($product_id, '_sl_new_version', TRUE);
                    $data->version              =  get_post_meta($product_id, '_sl_new_version', TRUE);
                    $data->last_updated         =  get_post_meta($product_id, '_sl_last_updated', TRUE);
                    $data->package              =  $download_url;
                    $data->download_link        =  $download_url;
                    
                    if (   ! in_array($licence_status, array('active') ) )
                        $data->upgrade_notice       =  $order_item_soliw['product_expire_notice'][$use_key];
                        else
                        $data->upgrade_notice       =  get_post_meta($product_id, '_sl_update_nottice', TRUE);
                    
                    $data->author               =  get_post_meta($product_id, '_sl_author', TRUE);
                    $data->tested               =  get_post_meta($product_id, '_sl_tested_up_to', TRUE);
                    $data->requires             =  get_post_meta($product_id, '_sl_version_required', TRUE);
                    $data->homepage             =  get_post_meta($product_id, '_sl_plugin_url', TRUE);
                           
                    $data->sections             =  array();
                    
                    if ( ! function_exists( 'wp_kses' ) )
                        include_once( ABSPATH . 'wp-includes/kses.php');
                    
                    $allowed_html_tags   =   $this->get_allowed_html_tags();
                                        
                    if(get_post_meta($product_id, '_sl_description', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_description', TRUE))->post_content;
                            $data->sections['description']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_installation', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_installation', TRUE))->post_content;
                            $data->sections['installation']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_faq', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_faq', TRUE))->post_content;
                            $data->sections['faq']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_screenshots', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_screenshots', TRUE))->post_content;
                            $data->sections['screenshots']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_changelog', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_changelog', TRUE))->post_content;
                            $data->sections['changelog']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_reviews', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_reviews', TRUE))->post_content;
                            $data->sections['reviews']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_other_notes', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_other_notes', TRUE))->post_content;
                            $data->sections['other_notes']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }

                    
                    $data->banners             =  array(
                                                        'low'   =>  get_post_meta($product_id, '_sl_screenshots_high', TRUE),
                                                        'high'  =>  get_post_meta($product_id, '_sl_screenshots_low', TRUE)
                                                    );
                    
                    
                    $status_code    =   's402';
                    
                    $response   =   array(
                                                            'status'            => 'success',
                                                            'status_code'       => $status_code,
                                                            'licence_status'    => $licence_status,

                                                            'message'           => 'Plugin Information processed successfully',
                                                            
                                                            'update_data'       => $data
                                                                );
                    
                    $response   =   $this->get_order_item_expire_response_details( $licence_key_data->order_item_id, $response );                    
                    $this->response[]   =   $response;
                    
                    
      
                    return TRUE;
                   
                }
            
            
            /**
            * Return code information
            * 
            * @param mixed $args
            */
            function code_information( $args )
                {

                    $product_unique_id  = $args['product_unique_id'];
                    
                    if( empty( $product_unique_id ) )
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e419',
                                                            'message'      => 'Invalid Product Unique ID'
                                                                );
                            
                            return FALSE;    
                        }
                    
                    global $wpdb;
                    
                    //retrieve the product_id
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching                     
                    $product_id     = $wpdb->get_var( $wpdb->prepare( 
                                                            "   SELECT post_id FROM ".  $wpdb->prefix ."postmeta
                                                                    WHERE `meta_key`   =   '_sl_software_unique_title' AND `meta_value` = %s", 
                                                                array(
                                                                    $product_unique_id
                                                                )
                                                            ) );
                    
                    if( empty ( $product_id ) )
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e419',
                                                            'message'      => 'Invalid Product Unique ID'
                                                                );
                            
                            return FALSE;
                        }
                    
                    $data = new stdClass;
                    $data->name                 =  get_post_meta($product_id, '_sl_software_title', TRUE);
                    $data->new_version          =  get_post_meta($product_id, '_sl_new_version', TRUE);
                    $data->version              =  get_post_meta($product_id, '_sl_new_version', TRUE);
                    $data->last_updated         =  get_post_meta($product_id, '_sl_last_updated', TRUE);
                    $data->upgrade_notice       =  get_post_meta($product_id, '_sl_update_nottice', TRUE);
                    $data->author               =  get_post_meta($product_id, '_sl_author', TRUE);
                    $data->tested               =  get_post_meta($product_id, '_sl_tested_up_to', TRUE);
                    $data->requires             =  get_post_meta($product_id, '_sl_version_required', TRUE);
                    $data->homepage             =  get_post_meta($product_id, '_sl_plugin_url', TRUE);
                           
                    $data->sections             =  array();
                    
                    if ( ! function_exists( 'wp_kses' ) )
                        include_once( ABSPATH . 'wp-includes/kses.php');
                    
                    $allowed_html_tags   =   $this->get_allowed_html_tags();
                                        
                    if(get_post_meta($product_id, '_sl_description', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_description', TRUE))->post_content;
                            $data->sections['description']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_installation', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_installation', TRUE))->post_content;
                            $data->sections['installation']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_faq', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_faq', TRUE))->post_content;
                            $data->sections['faq']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_screenshots', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_screenshots', TRUE))->post_content;
                            $data->sections['screenshots']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_changelog', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_changelog', TRUE))->post_content;
                            $data->sections['changelog']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_reviews', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_reviews', TRUE))->post_content;
                            $data->sections['reviews']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }
                    if(get_post_meta($product_id, '_sl_other_notes', TRUE) != '')
                        {
                            $post_html_content   =   get_post( get_post_meta($product_id, '_sl_other_notes', TRUE))->post_content;
                            $data->sections['other_notes']  =   wp_kses( $post_html_content, $allowed_html_tags );
                        }

                    
                    $data->banners             =  array(
                                                        'low'   =>  get_post_meta($product_id, '_sl_screenshots_high', TRUE),
                                                        'high'  =>  get_post_meta($product_id, '_sl_screenshots_low', TRUE)
                                                    );
                    
                    
                    $status_code    =   's403';
                                                                
                    $response   =   array(
                                                            'status'            => 'success',
                                                            'status_code'       => $status_code,

                                                            'message'           => 'Code Information processed successfully',
                                                            
                                                            'update_data'       => $data
                                                                );
                                                                
                                                        
                    $this->response[]   =   $response;
                            
                    return TRUE;
                   
                }
            
                
                
            /**
            * Deactivate a license key 
            * 
            * @param mixed $args
            */
            function key_delete( $args )
                {
                    if ( $this->is_remote_call   === TRUE && ! defined ( 'WOOSL_API/ALLOW_KEY_DELETE' ) &&  WOOSL_API/ALLOW_KEY_DELETE    !==  TRUE )
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e620',
                                                            'message'      => 'API Method is disabled'
                                                                );
                    
                            return TRUE;
                        }
                    
                    
                    $product_unique_id  = $args['product_unique_id'];
                    $licence_key        = $args['licence_key'];
                    
                    $product_id = $this->product_validation($licence_key, $product_unique_id);
                    if($product_id === FALSE)
                        return FALSE;
                        
                    //check against the licence key validation
                    $licence_key_data = $this->functions->get_licence_key_data_by_licence_key( $licence_key, array ( 'product_unique_id'  =>  $product_unique_id ) );
                                  
                    global $wpdb;
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $result = $wpdb->get_results( $wpdb->prepare("DELETE FROM `" . $wpdb->prefix ."woocommerce_software_licence`
                                    WHERE licence = %s",
                                    $licence_key) );
                    
                    $this->response[]   =   array(
                                                            'status'       => 'success',
                                                            'status_code'  => 's610',
                                                            'message'      => 'Licence Key Successfully Deleted'
                                                                );
                    
                    return TRUE;
                }
                
                
            
            /**
            * Return order item exipre details
            *     
            * @param mixed $order_item_id
            * @param mixed $response
            */
            function get_order_item_expire_response_details( $order_item_id, $response )
                {

                    //Available in the PRO     
                    
                    return $response;
                    
                }
            
            
            /**
            * Get order raw data
            * 
            * @param mixed $order_id
            */
            function get_order_post_data( $order_id )
                {
                    global $wpdb;
                        
                    if ( ! $this->functions->is_HPOS_active() )
                        {
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $post_data    = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM ".  $wpdb->posts ."
                                                WHERE `ID`   =  %d", $order_id ) );
                            
                            $order_post_data    =   new stdClass();
                            $order_post_data->id        =   $post_data->ID;
                            $order_post_data->status    =   $post_data->post_status;
                            $order_post_data->type      =   $post_data->post_type;
                            $order_post_data->date_created_gmt      =   $post_data->post_date_gmt;
                            $order_post_data->date_updated_gmt      =   $post_data->post_modified_gmt;
                            
                        }
                        else
                        {
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $order_post_data    = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM ".  $wpdb->prefix ."wc_orders
                                                        WHERE `id`   =  %d", $order_id ) );
                        }
                        
                    return $order_post_data;   
                }
            
            
            /**
            * 
            * Common product validation
            * 
            */
            function product_validation( $licence_key, $product_unique_id )
                {
                    global $wpdb, $wp_query, $post;
                    
                    $licence_key_data = $this->functions->get_licence_key_data_by_licence_key ( $licence_key, array ( 'product_unique_id'  =>  $product_unique_id ) );
                                        
                    //check for invalid licence
                    if( ! isset( $licence_key_data->id ) )
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e002',
                                                            'message'      => 'Invalid licence key'
                                                                );
                            return FALSE;
                        }
                    
                    $order_id       =   $licence_key_data->order_id;
                    
                    //check if the order status is not refunded
                    $order_post_data    =   $this->get_order_post_data($order_id);
                    if(!is_object($order_post_data))
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e003',
                                                            'message'      => 'Order does not exist anymore'
                                                                );
                            return FALSE;   
                            
                        }
                    
                    $granted_statuses =     array(
                                                    'wc-completed'
                                                        );
                    //chekc the WooCommerce woocommerce_downloads_grant_access_after_payment setting to allow processing too
                    $grant_access_after_payment   =   $this->functions->get_option('woocommerce_licensing_grant_access_after_payment');
                    if($grant_access_after_payment    ==    'no')
                        $granted_statuses[] =   'wc-processing';
                    
                    $granted_statuses   =   apply_filters( 'WOOSL/API/product_validation/granted_statuses', $granted_statuses );
                        
                    if(!in_array($order_post_data->status, $granted_statuses))
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e004',
                                                            'message'      => 'Order status not allowed'
                                                                );
                            return FALSE;
                        }
                    
                    $order_item_id  =   $licence_key_data->order_item_id;
                    
                    //retirve the actual product id from order_item data
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $product_id     = $wpdb->get_var( $wpdb->prepare( "SELECT meta_value FROM ".  $wpdb->prefix ."woocommerce_order_itemmeta
                                                WHERE `order_item_id`   =   %d AND `meta_key` = '_product_id'", $order_item_id ) ); 
                    
                    //check the product ID
                    $local_product_unique_id         = get_post_meta($product_id, '_sl_software_unique_title', TRUE);
                    
                    if($product_unique_id != $local_product_unique_id)
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e001',
                                                            'message'      => 'Invalid provided data'
                                                                );
                            return FALSE;
                        }

                    return $product_id;
                }
                
                
                
            /**
            * 
            * Common product validation
            * 
            */
            function order_status_validation( $licence_key, $product_unique_id )
                {
                    global $wpdb, $wp_query, $post;
                    
                    $licence_key_data = $this->functions->get_licence_key_data_by_licence_key ( $licence_key, array ( 'product_unique_id'  =>  $product_unique_id ) );
                                        
                    //check for invalid licence
                    if(!isset($licence_key_data->id))
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e002',
                                                            'message'      => 'Invalid licence key'
                                                                );
                            return FALSE;
                        }
                    
                    $order_id       =   $licence_key_data->order_id;
                    
                    //check if the order status is not refunded
                    $order_post_data    =   $this->get_order_post_data($order_id);
                    if(!is_object($order_post_data))
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e003',
                                                            'message'      => 'Order does not exist anymore'
                                                                );
                            return FALSE;   
                            
                        }
                    
                    $granted_statuses =     $this->license_default_valid_order_status();                                        
                    $granted_statuses   =   apply_filters( 'WOOSL/API/product_validation/granted_statuses', $granted_statuses );
                        
                    if( ! in_array( $order_post_data->status, $granted_statuses ) )
                        {
                            $this->response[]   =   array(
                                                            'status'       => 'error',
                                                            'status_code'  => 'e004',
                                                            'message'      => 'Order status not allowed'
                                                                );
                            return FALSE;
                        }
                    
                    return TRUE;
                }
                
                
            /**
            * Return the defult Order status for a license to be valid
            */
            function license_default_valid_order_status()
                {
                    $granted_statuses =     array(
                                                    'wc-completed'
                                                        );
                                                        
                    //chekc the WooCommerce woocommerce_downloads_grant_access_after_payment setting to allow processing too
                    $grant_access_after_payment   =   $this->functions->get_option('woocommerce_licensing_grant_access_after_payment');
                    if($grant_access_after_payment    ==    'no')
                        $granted_statuses[] =   'wc-processing';
                    
                    return $granted_statuses;
                    
                }
                
                
                
            
            /**
            * Return product download link
            * 
            * @param mixed $licence_key_data
            */
            function get_product_download_link( $licence_key_data )
                {
                    global $wpdb;
                    
                    $download_url  =   '';
                    
                    if ( $this->functions->is_HPOS_active() )
                        {
                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                            $order_status       =   $wpdb->get_var( $wpdb->prepare( "SELECT status FROM {$wpdb->prefix}wc_orders WHERE id = %d", $licence_key_data->order_id  ) );
                        }
                        else
                        {
                            $order_data     =   get_post( $licence_key_data->order_id );
                            $order_status   =   $order_data->post_status;
                        }
                    
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $item_product_id  = $wpdb->get_var( $wpdb->prepare( 
                                                            "SELECT meta_value FROM {$wpdb->prefix}woocommerce_order_itemmeta 
                                                                WHERE order_item_id = %d AND meta_key = '_product_id'"
                                                            , $licence_key_data->order_item_id) );
                    
                    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                    $item_variation_id  = $wpdb->get_var( $wpdb->prepare( 
                                                            "SELECT meta_value FROM {$wpdb->prefix}woocommerce_order_itemmeta 
                                                                WHERE order_item_id = %d AND meta_key = '_variation_id'"
                                                            , $licence_key_data->order_item_id) );
                    
                    //check if downloadable
                    if($item_variation_id > 0)
                        $is_downloadable    =   (get_post_meta($item_variation_id, '_downloadable', TRUE )  ==  'yes')  ?  TRUE    :   FALSE;
                        else
                        $is_downloadable    =   (get_post_meta($item_product_id, '_downloadable', TRUE )  ==  'yes')  ?  TRUE    :   FALSE;

                    $granted_statuses   =   apply_filters( 'WOOSL/API/product_validation/granted_statuses', array( 'wc-completed' ) );
                    
                    if ( SOLIW_functions::is_woocommerce_subscription ( $licence_key_data->order_id ) )
                        {
                            $is_download_permitted  =   in_array ( $order_status, $granted_statuses   ) ?  TRUE    :   FALSE;
                        }
                        else
                        $is_download_permitted  =   ( in_array ( $order_status, $granted_statuses )  || ( get_option( 'woocommerce_downloads_grant_access_after_payment' ) == 'yes' && $order_status  ==  'wc-processing')   ) ?  TRUE    :   FALSE;
                    
                    if ( $is_downloadable  && $is_download_permitted ) 
                        {
                            if($item_variation_id > 0)
                                $download_files = $this->get_product_downloads( $licence_key_data->order_id, $item_variation_id );
                                else
                                $download_files = $this->get_product_downloads( $licence_key_data->order_id, $item_product_id );
                                
                            if(!is_array($download_files)   ||  count($download_files) < 1)
                                {}
                                else
                                {
                                    reset($download_files);
                                    $file   =   current($download_files);
                                    
                                    $download_url   =    $file['download_url'];
                                }
                        }
                    
                    
                    $download_url   =   apply_filters( 'WOOSL/API/get_product_download_link', $download_url, $licence_key_data );
                        
                    return $download_url;  
                    
                }
            
            
            /**
            * Return product downloadable files
            *     
            * @param mixed $order_id
            * @param mixed $item_product_id
            */
            function get_product_downloads( $order_id, $item_product_id )
                {
                    global $wpdb;
                    
                    $product_files  =   maybe_unserialize(get_post_meta($item_product_id, '_downloadable_files', TRUE));
      
                    $files = array();

                    foreach ( $product_files as $download_id => $product_file ) 
                        {
                            if ( isset($product_files[$download_id]) ) 
                                {
                                    $files[ $download_id ]                 = $product_file;
                                    $downloadable_product_permission    =   apply_filters( 'WOOSL/API/get_downloadable_product_permission', FALSE, $download_id, $order_id );  
                                    
                                    if  ( ! $downloadable_product_permission )
                                        {
                                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                                            $downloadable_product_permission = $wpdb->get_row( $wpdb->prepare("SELECT * FROM {$wpdb->prefix}woocommerce_downloadable_product_permissions
                                                                                            WHERE download_id = %s AND order_id = %d
                                                                                        ", $download_id, $order_id) );
                                        }
                                          
                                    if  ( empty ($downloadable_product_permission ))
                                        return FALSE;
                                    
                                    if ( $this->functions->is_HPOS_active() )
                                        {
                                            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching 
                                            $email_address = $wpdb->get_var( $wpdb->prepare("SELECT user_email FROM {$wpdb->prefix}woocommerce_downloadable_product_permissions
                                                                                            WHERE download_id = %s AND order_id = %d
                                                                                        ", $download_id, $order_id) );
                                        }
                                        else
                                        $email_address  =   get_post_meta( $downloadable_product_permission->order_id,  '_billing_email',  TRUE);
                                        
                                    $email_hash     =   function_exists( 'hash' ) ? hash( 'sha256', $email_address ) : sha1( $email_address );

                                    $download_url  =   trailingslashit( get_option( 'home' ))   .'?download_file='.$item_product_id.'&order='.    $downloadable_product_permission->order_key    .'&uid='.    $email_hash    .'&key='. $download_id;
                                        
                                    $files[ $download_id ]['download_url'] = apply_filters( 'WOOSL/API/product_downloads/download_url', $download_url, $order_id, $item_product_id );
                                }
                        }
                        
                    return $files; 
                    
                }
                
            
            /**
            * Activate a licence key
            * 
            * @param mixed $licence_key_data
            * @param mixed $product_id
            * @param mixed $order_item_soliw
            * @param mixed $use_key
            */
            function activate_licence( $licence_key_data, $product_id, $order_item_soliw, $use_key )
                {
                    $today  =   strtotime( gmdate("Y-m-d H:i:s"), time() );
                    $this->functions->update_order_item_meta( $licence_key_data->order_item_id, '_woo_sl_licensing_start', $today );
                    
                    $_sl_product_expire_units   =   $order_item_soliw['product_expire_units'][$use_key];
                    $_sl_product_expire_time    =   $order_item_soliw['product_expire_time'][$use_key];
   
                    $expire_at  =   strtotime( " + " . $_sl_product_expire_units . " " . $_sl_product_expire_time,  $today );
                        
                    //transorm to H:i:s only
                    $expire_at      =   strtotime( gmdate("Y-m-d H:i:s", $expire_at) );

                    $this->functions->update_order_item_meta( $licence_key_data->order_item_id, '_woo_sl_licensing_expire_at', $expire_at );  
                    
                    //make adjustments to the download expire
                    $permission_id                  =   $this->functions->get_permission_id_from_order_id_product_id( $licence_key_data->order_id, $product_id );
                    if ( ! empty ($permission_id ) )
                        $this->functions->update_expiration_for_permission($permission_id, gmdate ( "Y-m-d H:i:s", $expire_at ) );
                    
                    $licence_status =   'active';
                    $this->functions->update_order_item_meta( $licence_key_data->order_item_id, '_woo_sl_licensing_status', $licence_status );
                }
            
                
            
            /**
            * Add additioanl repose data
            *     
            * @param mixed $response
            * @param mixed $args
            */
            function set_additional_response_data( $response, $args )
                {
                    $get_product_meta   =   $args['_get_product_meta'];   
                    
                    $meta_keys          =   explode ( ",", $get_product_meta);
                    $meta_keys          =   array_map ("trim", $meta_keys );
                    $meta_keys          =   preg_replace("/[^a-zA-Z0-9.\-\_ ]/", "", $meta_keys );
                    $meta_keys          =   array_filter ( $meta_keys );
                    
                    if  (  empty ( $get_product_meta )  ||  count ( $meta_keys ) < 1    || ! defined ( 'WOOSL_API_ALLOW_META_KEYS' )    ||  count ( WOOSL_API_ALLOW_META_KEYS ) < 1 )
                        return  apply_filters('WOOSL/API_call/response_block', $response, $args );
                        
                    //Admin should set allowed meta through the code, using this filter
                    $meta_keys          =   array_intersect ( WOOSL_API_ALLOW_META_KEYS , $meta_keys ) ;
                    if ( count ( $meta_keys ) < 1 )
                        return  apply_filters('WOOSL/API_call/response_block', $response, $args );
                        
                    $product_unique_id  = $args['product_unique_id'];
                    $licence_key        = $args['licence_key'];
                    $domain             = $args['domain'];
                      
                    $product_id = $this->product_validation($licence_key, $product_unique_id);
                    if($product_id === FALSE)
                        return apply_filters('WOOSL/API_call/response_block', $response, $args );
                    
                    foreach  (  $meta_keys  as  $meta_key )
                        {
                            $response[ $meta_key ]     =  get_post_meta( $product_id, $meta_key, TRUE);
                        }
                        
                    return  apply_filters('WOOSL/API_call/response_block', $response, $args );
                    
                }
                
                
            function get_order_item_soliw( $order_item_id, $args )
                {
                    
                    $order_item_soliw          =   $this->functions->get_order_item_meta ( $order_item_id, '_woo_sl' );
                    
                    $order_item_soliw          =   apply_filters('WOOSL/API_call/order_item_soliw', $order_item_soliw, $args, $this );   
                    
                    return $order_item_soliw;
                }
                                           
            
            
            /**
            * Return a list of the allowed html tags which will be used with wp_kses
            *     
            */
            public static function get_allowed_html_tags()
                {
                    $allowed_html = array(
                                        'a'          => array(
                                            'href'   => array(),
                                            'title'  => array(),
                                            'target' => array(),
                                        ),
                                        'abbr'       => array( 'title' => array() ),
                                        'acronym'    => array( 'title' => array() ),
                                        'code'       => array(),
                                        'pre'        => array(),
                                        'em'         => array(),
                                        'strong'     => array(),
                                        'div'        => array( 'class' => array() ),
                                        'span'       => array( 'class' => array() ),
                                        'p'          => array(),
                                        'br'         => array(),
                                        'ul'         => array(),
                                        'ol'         => array(),
                                        'li'         => array(),
                                        'h1'         => array(),
                                        'h2'         => array(),
                                        'h3'         => array(),
                                        'h4'         => array(),
                                        'h5'         => array(),
                                        'h6'         => array(),
                                        'img'        => array(
                                            'src'   => array(),
                                            'class' => array(),
                                            'alt'   => array(),
                                        ),
                                        'blockquote' => array( 'cite' => true ),
                                    );
                                    
                                    
                    return $allowed_html;
                    
                }
            
            
                
            /**
            * 
            * Output response
            * 
            */
            function output_response( $args )
                {
                    switch( $args['responseType'] )
                        {
                            case 'json'     :
                                                echo wp_json_encode($this->response);  
                                                break;
                            
                        }
                }
                
            
            /**
            * Return response to called, as being a direct API call from a WordPress code
            * 
            * @param mixed $args
            */
            function return_response( $args )
                {
                    switch($args['responseType'])
                        {
                            case 'json'     :
                                                return wp_json_encode($this->response);  
                                                break;
                            
                        }
                }
                
        } 
    
    
    
?>