/*
 * Social Proof Generator Script
 * Copyright (C) 2025 Muhamad Dendi Purwanto
 * Licensed under the GNU General Public License v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */


jQuery(document).ready(function($) {
    // Initialize color picker
    $('.socproofgen-color-picker').wpColorPicker();

    // Media uploader
    $('.socproofgen_upload_image').on('click', function(e) {
        e.preventDefault();
        var button = $(this);
        var imageIdInput = $('#socproofgen_image_id');
        var imagePreview = $('#socproofgen_image_preview');

        var mediaUploader = wp.media({
            title: socproofgenAdmin.mediaTitle,
            button: {
                text: socproofgenAdmin.mediaButton
            },
            multiple: false
        });

        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            imageIdInput.val(attachment.id);
            imagePreview.html('<img src="' + attachment.url + '" style="max-width: 100px;" />');
            button.siblings('.socproofgen_remove_image').show();
        });

        mediaUploader.open();
    });

    // Remove image
    $('.socproofgen_remove_image').on('click', function(e) {
        e.preventDefault();
        var button = $(this);
        $('#socproofgen_image_id').val('');
        $('#socproofgen_image_preview').html('');
        button.hide();
    });
});