jQuery(document).ready(function ($) {

    function handleDynamicBannerLayout() {
        const titleEl = document.querySelector('.title_vasu');
        const featImgEl = document.querySelector('.feat_img');
        const contentEl = document.querySelector('.content_vasu');

        let hasTitle = titleEl && titleEl.textContent.trim() !== '';
        let hasFeatImg = featImgEl && featImgEl.querySelectorAll('img').length > 0;
        let hasContent = contentEl && contentEl.textContent.trim() !== '';

        if (!hasTitle && titleEl) titleEl.style.display = 'none';
        if (!hasFeatImg && featImgEl) featImgEl.style.display = 'none';
        if (!hasContent && contentEl) contentEl.style.display = 'none';

        let currentTop = 4;

        if (hasTitle && titleEl) {
            titleEl.style.top = currentTop + '%';
            currentTop += 20;
        }

        if (hasFeatImg && featImgEl) {
            featImgEl.style.top = currentTop + '%';
            currentTop += 34;
        }

        if (hasContent && contentEl) {
            contentEl.style.top = currentTop + '%';
        }
    }

    handleDynamicBannerLayout();

    // === Load saved values from localStorage on page load ===
    const savedName = localStorage.getItem('cbg_user_name');
    const savedPhoto = localStorage.getItem('cbg_user_photo');

    if (savedName) {
        $('#name').val(savedName);
        $('.text').text(savedName);
    }

    if (savedPhoto) {
        $('.pic').html('<img src="' + savedPhoto + '" class="user-photo" />');
    }

    // === Called when user types name or uploads photo ===
    function generatePreview() {
        let name = $("#name").val();
        let file = $("#photo").get(0).files[0];

        // Save name to localStorage
        localStorage.setItem('cbg_user_name', name);
        $(".text").text(name);

        if (file) {
            let reader = new FileReader();
            reader.onload = function (event) {
                const base64 = event.target.result;
                localStorage.setItem('cbg_user_photo', base64);
                $(".pic").html('<img src="' + base64 + '" class="user-photo" />');

                setTimeout(makeImage, 300);
                $("#downloader").fadeIn("normal");
            };
            reader.readAsDataURL(file);
        } else {
            setTimeout(makeImage, 300);
        }
    }

    $("#name").on("input", generatePreview);
    $("#photo").on("change", generatePreview);

    // === Create image from canvas ===
    function makeImage() {
        const img = $('.img-wrapper');
        html2canvas(img[0], {
            allowTaint: true,
            useCORS: true
        }).then(function (canvas) {
            const imgData = canvas.toDataURL('image/png');
            $("#downloader").attr("href", imgData).attr("download", "banner.png").fadeIn();
        });
    }

    // ✅ Generate image on page load (with saved data)
    makeImage();

    // ✅ Re-generate and download when button is clicked
    $("#downloader").on("click", function (e) {
        e.preventDefault();
        const img = $('.img-wrapper');
        html2canvas(img[0], {
            allowTaint: true,
            useCORS: true
        }).then(function (canvas) {
            const imgData = canvas.toDataURL('image/png');
            const a = document.createElement('a');
            a.href = imgData;
            a.download = 'banner.png';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        });
    });
});
