<?php
/**
 * Plugin Name: WP Post's to Social Media
 * Description: It helps to create personalized, mobile-responsive "Social Share Story Images" from WordPress posts.
 * Version: 1.0
 * Stable tag: 1.0
 * Author: Ved Gondaliya
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: social-custom-poster-banner-generator
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

// Start session
add_action('init', function () {
    if (!session_id()) {
        session_start();
    }
});

// Enqueue frontend assets
function socicupo_vasu_enqueue_assets() {
    $plugin_url = plugin_dir_url(__FILE__);

    wp_register_style('cbg-style', $plugin_url . 'css/style.css', [], '1.0.0');
    wp_enqueue_style('cbg-style');

    wp_register_style('cbg-bootstrap', $plugin_url . 'css/bootstrap.min.css', [], '5.2.0');
    wp_enqueue_style('cbg-bootstrap');

    wp_register_script('cbg-html2canvas', $plugin_url . 'js/html2canvas.min.js', [], '1.4.1', true);
    wp_enqueue_script('cbg-html2canvas');

    wp_register_script('cbg-jquery-local', $plugin_url . 'js/jquery.min.js', [], '3.7.1', true);
    wp_enqueue_script('cbg-jquery-local');

    wp_register_script('scpb_vasu-script', $plugin_url . 'js/main.js', ['jquery'], '1.0.0', true);
    wp_enqueue_script('scpb_vasu-script');

        wp_localize_script('scpb_vasu-script','scpb_vasu_ajax_object',[
        'ajax_url' => admin_url('admin-ajax.php')
        ]);
}
add_action('wp_enqueue_scripts', 'socicupo_vasu_enqueue_assets');

// Shortcode output
function socicupo_vasu_display_generator() {
    global $post;

    $post_title = get_the_title($post->ID);
    $featured_img = '';

    if (has_post_thumbnail($post->ID)) {
        $full_img_url = wp_get_attachment_image_url(get_post_thumbnail_id($post->ID), 'full');
        if ($full_img_url) {
            $featured_img = '<img src="' . esc_url($full_img_url) . '" class="featured-img-custom" style="border-radius:12px;border:2px solid white;height:300px;width:506px;" />';
        }
    }

   // $plain_content = wp_strip_all_tags(strip_shortcodes($post->post_content));
   
     $plain_content = wp_strip_all_tags(strip_shortcodes($post->post_content));
        $plain_content = mb_substr($plain_content, 0, 370);
            if (mb_strlen($plain_content) >= 370) {
            $plain_content .= '...';
        }

    $name = '';
    $photo = '';

    ob_start(); ?>
    <div class="wrapper p-4">
        <div class="img-wrapper shadow-lg rounded">
            <img src="<?php echo esc_url(get_option('scpb_vasu_banner_image', plugin_dir_url(__FILE__) . 'images/banner.png')); ?>" alt="Banner Background">
            <div class="title_vasu"><?php echo esc_html($post_title); ?></div>
            <div class="feat_img"><?php echo wp_kses_post($featured_img); ?></div>
            <div class="content_vasu"><?php echo esc_html($plain_content); ?></div>
            <div class="pic">
                <?php if (!empty($photo)) : ?>
                    <img src="<?php echo esc_url($photo); ?>" class="user-photo" />
                <?php endif; ?>
            </div>
            <div class="text"><?php echo esc_html($name); ?></div>
        </div>

        <form id="bannerForm" enctype="multipart/form-data" class="mt-4 w-100" style="max-width: 500px;">
            <div class="mb-3">
                <label for="name" class="form-label">Enter Your Name:</label>
                <input type="text" name="name" id="name" class="form-control" placeholder="e.g. Sanjay Bapu" value="<?php echo esc_attr($name); ?>">
            </div>
            <div class="mb-3">
                <label for="photo" class="form-label">Upload Your Photo:</label>
                <input type="file" name="photo" id="photo" class="form-control" accept="image/*">
            </div>
        </form>

        <a href="#" class="btn btn-success btn-lg mt-2" id="downloader">Download Your Banner</a>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('scpb_vasu_banner_generator', 'socicupo_vasu_display_generator');

// Admin menu
function socicupo_vasu_add_admin_menu() {
    add_menu_page(
        'Custom Banners',
        'Social Poster',
        'manage_options',
        'scpb_vasu-banner-settings',
        'socicupo_vasu_banner_settings_page',
        'dashicons-format-image',
        20
    );
}
add_action('admin_menu', 'socicupo_vasu_add_admin_menu');

// Register settings
function socicupo_vasu_register_settings() {
    register_setting('scpb_vasu_generator_settings_group', 'scpb_vasu_banner_image', [
        'sanitize_callback' => 'esc_url_raw',
    ]);
}
add_action('admin_init', 'socicupo_vasu_register_settings');

// Enqueue admin media uploader & inline script
function socicupo_vasu_enqueue_media_uploader($hook) {
    if ($hook === 'toplevel_page_scpb_vasu-banner-settings') {
        wp_enqueue_media();
        //Register dummy handle for inline script
        wp_register_script(
            'scpb_vasu-admin-media', 
            plugin_dir_url(__FILE__) . 'js/admin-media.js', // path to your JS file
            array('jquery'), // dependencies (use [] if none)
            '1.0.0', // version number
            true // load in footer
);
        wp_enqueue_script('scpb_vasu-admin-media');

        $inline_js = "
        jQuery(document).ready(function($){
            $('#upload-btn').click(function(e) {
                e.preventDefault();
                var image = wp.media({ 
                    title: 'Select Banner',
                    multiple: false
                }).open().on('select', function(){
                    var uploaded_image = image.state().get('selection').first();
                    var image_url = uploaded_image.toJSON().url;
                    $('#scpb_vasu_banner_image').val(image_url);
                    $('#cbg_preview').attr('src', image_url);
                });
            });
        });
        ";

        wp_add_inline_script('scpb_vasu-admin-media', $inline_js);
    }
}
add_action('admin_enqueue_scripts', 'socicupo_vasu_enqueue_media_uploader');

// Add shortcode meta box
add_action('add_meta_boxes', 'socicupo_vasu_add_shortcode_meta_box');
function socicupo_vasu_add_shortcode_meta_box() {
    add_meta_box(
        'cbg_shortcode_meta_box',
        'Insert Custom Banner Shortcode',
        'socicupo_vasu_shortcode_meta_box_callback',
        'post',
        'side',
        'high'
    );
}

function socicupo_vasu_shortcode_meta_box_callback() {
    echo '<button type="button" class="button button-primary" id="cbg-insert-shortcode">Insert Shortcode</button>';
}

// Enqueue admin post editor script
add_action('admin_enqueue_scripts', 'socicupo_vasu_enqueue_admin_script');
function socicupo_vasu_enqueue_admin_script($hook) {
    if ($hook === 'post-new.php' || $hook === 'post.php') {
        wp_enqueue_script('cbg-admin-shortcode-js', plugin_dir_url(__FILE__) . 'js/cbg-admin-shortcode.js', array('jquery'), '1.0', true);
    }
}

// Admin settings page
function socicupo_vasu_banner_settings_page() {
    ?>
    <div class="wrap">
        <h1>Setting</h1>
        <h2>Shortcode - [scpb_vasu_banner_generator]</h2>
        <h3>Use The Given Size (Width x Height)</h3>
        <h4>540px x 960px ("Pixels")</h4>
        <h4>1.8in x 3.2in ("inch")</h4>
        <h4>4.5cm x 8.1cm ("centimeter")</h4>
        <p>*Contact to make your customize banner only whatsapp messages (+91 88498 99500)</p>
        <form method="post" action="options.php">
            <?php settings_fields('scpb_vasu_generator_settings_group'); ?>
            <?php do_settings_sections('scpb_vasu_generator_settings_group'); ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Select Banner Image</th>
                    <td>
                        <input type="text" name="scpb_vasu_banner_image" id="scpb_vasu_banner_image" value="<?php echo esc_attr(get_option('scpb_vasu_banner_image')); ?>" style="width:60%;" />
                        <input type="button" class="button" name="upload-btn" id="upload-btn" value="Upload Image" />
                        <div style="margin-top:10px;">
                            <img id="cbg_preview" src="<?php echo esc_url(get_option('scpb_vasu_banner_image')); ?>" style="margin-top:10px;" />
                        </div>
                    </td>
                </tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}

