<?php
namespace SMTP2GO\App;
/**
 * Fired during plugin activation
 *
 * @link       https://www.smtp2go.com
 * @since      1.0.1
 *
 * @package    SMTP2GO\WordpressPlugin
 * @subpackage SMTP2GO\WordpressPlugin/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.0.1
 * @package    SMTP2GO\WordpressPlugin
 * @subpackage SMTP2GO\WordpressPlugin/includes
 * @author     SMTP2GO <ticket@smtp2go.com>
 */
class WordpressPluginActivator
{
    /**
     * Short Description. (use period)
     *
     * Long Description.
     *
     * @since    1.0.1
     */
    public static function activate()
    {
        // Create the API logs table
        require_once plugin_dir_path(__FILE__) . 'migrations/CreateApiLogsTable.php';
        \SMTP2GO\App\Migrations\CreateApiLogsTable::run();
    }
}
