// Smoove Debug - Version 4.3.6
console.log('🚀 Smoove: editor.js loaded - Version 4.3.6 - UPDATED WITH NEW DESIGN');
console.log('🎨 Popup color: #451889 (purple)');

jQuery(window).on('elementor:init', function () {
	console.log('🔵 Smoove: Editor initialized');
	
	// Generate field mapping inputs dynamically
	elementor.hooks.addAction('panel/open_editor/widget/form', function( panel, model, view ){
		function handleMutation( mutationsList ) {
			mutationsList.forEach( function( mutation ) {
				if( mutation.type === 'childList' ){
					mutation.addedNodes.forEach( function( node ){
						if ( jQuery(node).is('.elementor-control-smoove_fields_map_input_template:visible') || jQuery(node).find('.elementor-control-smoove_fields_map_input_template:visible').length) {
							generate_field_map_inputs( panel, model );
						}
					});

					mutation.removedNodes.forEach( function( node ){
						if ( jQuery(node).is('.elementor-control-smoove_fields_map_input_template_clone') ) {
							panel.$el.find('.elementor-control-smoove_fields_map_input').remove();
						}
					});
				}
			});
		}

		const observer = new MutationObserver( handleMutation );
		const targetNode = panel.$el.find('#elementor-panel-page-editor')[0];
		const config = { childList: true, subtree: true };

		if (targetNode) {
			observer.observe(targetNode, config);
		}
	});

	function generate_field_map_inputs( panel, model ){
		let settings = model.get('settings');
		let form_fields = model.getSetting('form_fields').toJSON();

		let input_template = panel.$el.find('.elementor-control-smoove_fields_map_input_template');

		if( input_template.length ){
			input_template.removeClass('elementor-control-smoove_fields_map_input_template');
			input_template.addClass('elementor-control-smoove_fields_map_input_template_clone');
		}else{
			input_template = panel.$el.find('.elementor-control-smoove_fields_map_input_template_clone');
		}

		panel.$el.find('.elementor-control-smoove_fields_map_input').remove();

		if( form_fields.length && input_template.length ){
			let prev_field_input;
			let field_input;

			form_fields = form_fields.filter( field => field.field_type != 'upload' );

			form_fields.forEach((field) => {
				let field_id = field.custom_id;
				let field_setting_name = 'smoove_fields_map_input_' + field_id;
				let field_label = ( field.field_label != '' ) ? field.field_label : field.placeholder;
				let field_value = settings.attributes[field_setting_name];

				field_input = input_template.clone();
			
				let field_input_select = field_input.find('select');

				field_input.removeClass('elementor-control-smoove_fields_map_input_template_clone');
				field_input.addClass('elementor-control-smoove_fields_map_input');
				field_input.addClass('elementor-control-smoove_fields_map_input_' + field.custom_id);
				field_input.find('.elementor-control-title').text( field_label );
				field_input_select.attr( 'data-setting', field_setting_name ).data( 'setting', field_setting_name );
				field_input.find('[id]').removeAttr('id');

				field_input.removeClass('elementor-control-type-select');
				field_input.addClass('elementor-control-type-select2');

				if( field_value ){
					field_input_select.val( field_value );
				}

				if( prev_field_input ){
					field_input.insertAfter( prev_field_input );
				}else{
					field_input.insertAfter( input_template );
				}

				prev_field_input = field_input;
		
				field_input_select.select2({
					placeholder: field_input_select.find('option[value="0"]').first().text(),
					allowClear: true
				});

				field_input_select.on( 'change', function(){
					let select = jQuery(this);
					model.setSetting( select.data('setting'), select.val() );
					input_template.find('select').trigger('change');
				})
			});
		}
	}
	
	// Catch button clicks and run validation
	jQuery(document).on('click', 'button', function(e) {
		var btn = jQuery(this);
		var text = btn.text().trim();
		var ariaLabel = btn.attr('aria-label') || '';
		var classes = btn.attr('class') || '';
		var isInButtonGroup = btn.closest('.MuiButtonGroup-root').length > 0;
		
		console.log('🔍 Button clicked:', {text: text, ariaLabel: ariaLabel, inButtonGroup: isInButtonGroup});
		
		// Check if it's a save-related button
		var isSaveButton = false;
		
		// Method 1: Text-based detection
		if (text === 'Publish' || text === 'Update' || text === 'פרסם' || text === 'עדכן') {
			isSaveButton = true;
		}
		
		// Method 2: Aria-label detection (for arrow button)
		if (ariaLabel === 'Save Options' || ariaLabel.includes('שמור')) {
			isSaveButton = true;
		}
		
		// Method 3: ButtonGroup detection (catches Publish even when disabled was clicked)
		if (isInButtonGroup && classes.includes('MuiButton-containedPrimary')) {
			isSaveButton = true;
		}
		
		if (isSaveButton) {
			console.log('🟢 Save button detected! Running validation in 1.5 seconds...');
			setTimeout(function() {
				validate_all_forms_before_save();
			}, 1500);
		}
	});
	
	function validate_all_forms_before_save() {
		console.log('🔍 Smoove: validate_all_forms_before_save called');
		var validationErrors = [];
		
		try {
			// Get all elements from the current document - try multiple methods
			var allElements = [];
			console.log('🔍 Smoove: Looking for elements...');
			
			// Method 1: Try via elements
			if (elementor && elementor.elements) {
				collectAllElements(elementor.elements.models, allElements);
			}
			
			// Method 2: Try via sections (if Method 1 didn't work)
			if (allElements.length === 0 && elementor && elementor.sections) {
				collectAllElements(elementor.sections.models, allElements);
			}
			
			// Method 3: Try via document container
			if (allElements.length === 0 && elementor && elementor.documents && elementor.documents.getCurrent()) {
				var currentDocument = elementor.documents.getCurrent();
				if (currentDocument.container && currentDocument.container.children) {
					collectAllElements(currentDocument.container.children.models, allElements);
				}
			}
			
			console.log('🔍 Smoove: Found ' + allElements.length + ' elements');
			
			// Check each form widget
			var formIndex = 0;
			allElements.forEach(function(element) {
				var widgetType = element.get('widgetType');
				
				if (widgetType === 'form') {
					formIndex++;
					console.log('📝 Smoove: Found form #' + formIndex);
					var settings = element.get('settings').attributes;
					var validation = validateFormSettings(settings, formIndex);
					
					if (validation.hasError) {
						console.log('❌ Smoove: Form #' + formIndex + ' has validation errors');
						validationErrors.push(validation);
					} else {
						console.log('✅ Smoove: Form #' + formIndex + ' is valid');
					}
				}
			});
			
		} catch (error) {
			console.error('🔴 Smoove: Validation error:', error);
		}
		
		console.log('🔍 Smoove: Total validation errors: ' + validationErrors.length);
		
		// Show popup if validation fails (warning only - page already saved)
		if (validationErrors.length > 0) {
			console.log('🚨 Smoove: Showing validation popup');
			show_detailed_validation_popup(validationErrors, false);
		} else {
			console.log('✅ Smoove: No validation errors, popup not needed');
		}
		
		return true;
	}
	
	function collectAllElements(elements, allElements) {
		if (!elements || !Array.isArray(elements)) return;
		
		elements.forEach(function(element) {
			allElements.push(element);
			
			var elType = element.get('elType');
			
			// Recursively check child elements - support container, section, column
			if (elType === 'container' || elType === 'section' || elType === 'column') {
				var children = null;
				
				// Try multiple ways to access children
				if (element.children && element.children.models) {
					children = element.children.models;
				} else if (element.model && element.model.get('elements')) {
					children = element.model.get('elements').models;
				} else if (element.get('elements')) {
					children = element.get('elements').models;
				}
				
				if (children) {
					collectAllElements(children, allElements);
				}
			}
		});
	}
	
	function validateFormSettings(settings, formIndex) {
		console.log('🔍 Smoove: Validating form #' + formIndex, settings.submit_actions);
		
		// Check if smoove action is enabled
		if (!settings.submit_actions || !Array.isArray(settings.submit_actions) || 
			!settings.submit_actions.includes('smoove')) {
			console.log('⚪ Smoove: Form #' + formIndex + ' does not have smoove action');
			return { hasError: false };
		}
		
		console.log('✅ Smoove: Form #' + formIndex + ' has smoove action enabled');
		
		// Check for mailing field mapping
		var has_email_mapping = false;
		var has_sms_mapping = false;
		var mapped_fields = [];
		
		for (var key in settings) {
			if (key.startsWith('smoove_fields_map_input_') && settings[key]) {
				// Only count non-empty values (not "0" or empty string)
				if (settings[key] && settings[key] !== '0' && settings[key] !== 0) {
					mapped_fields.push(settings[key]);
					if (settings[key] === 'canReceiveEmails') {
						has_email_mapping = true;
					}
					if (settings[key] === 'canReceiveSmsMessages') {
						has_sms_mapping = true;
					}
				}
			}
		}
		
		console.log('🔍 Smoove: Form #' + formIndex + ' mapping check:', {
			has_email_mapping: has_email_mapping,
			has_sms_mapping: has_sms_mapping,
			mapped_fields: mapped_fields
		});
		
		// RULE: Show error if BOTH required fields are missing
		// This will trigger even if there's no mapping at all
		if (!has_email_mapping && !has_sms_mapping) {
			console.log('❌ Smoove: Form #' + formIndex + ' is missing required fields');
			var locale = document.documentElement.lang || 'en';
			var missing_fields = ['canReceiveEmails', 'canReceiveSmsMessages'];
			var instructions = '';
			
			// Check if there are any mapped fields at all
			var hasAnyMapping = mapped_fields.length > 0;
			
			if (locale.includes('he')) {
				instructions = '<div class="smef-instructions">' +
					'<h4>איך לתקן:</h4>';
				
				if (!hasAnyMapping) {
					instructions += '<p style="background: #fff3cd; padding: 10px; border-radius: 4px; margin: 10px 0;"><strong>⚠️ שים לב:</strong> לא נמצא מיפוי שדות כלל. ייתכן שיש בעיה בטעינת השדות מ-smoove (בדוק חיבור API או רישיון).</p>';
				}
				
				instructions += '<ol>' +
					'<li>לחץ על הטופס בעמוד</li>' +
					'<li>עבור לטאב "תוכן" בפאנל השמאלי</li>' +
					'<li>גלול למטה ל"פעולות לאחר שליחה"</li>' +
					'<li>פתח את הגדרות "smoove"</li>' +
					'<li>במיפוי השדות, קשר שדה לאחד מהשדות הבאים (לא חובה שניהם):</li>' +
				'</ol>' +
				'</div>';
			} else {
				instructions = '<div class="smef-instructions">' +
					'<h4>How to Fix:</h4>';
				
				if (!hasAnyMapping) {
					instructions += '<p style="background: #fff3cd; padding: 10px; border-radius: 4px; margin: 10px 0;"><strong>⚠️ Notice:</strong> No field mapping found. There might be an issue loading fields from smoove (check API connection or license).</p>';
				}
				
				instructions += '<ol>' +
					'<li>Click on the form in the page</li>' +
					'<li>Go to "Content" tab in the left panel</li>' +
					'<li>Scroll down to "Actions After Submit"</li>' +
					'<li>Open "smoove" settings</li>' +
					'<li>In field mapping, connect a form field to at least one of these fields:</li>' +
				'</ol>' +
				'</div>';
			}
			
			return { 
				hasError: true, 
				formIndex: formIndex,
				missing_fields: missing_fields,
				mapped_fields: mapped_fields,
				instructions: instructions
			};
		}
		
		return { hasError: false };
	}

	elementor.hooks.addAction('panel/open_editor/widget/form', function( panel, model, view ){
		function handleMutation( mutationsList ) {
			mutationsList.forEach( function( mutation ) {
				if( mutation.type === 'childList' ){
					mutation.addedNodes.forEach( function( node ){
						if ( jQuery(node).is('.elementor-control-smoove_fields_map_input_template:visible') || jQuery(node).find('.elementor-control-smoove_fields_map_input_template:visible').length) {
							generate_field_map_inputs( panel, model );
						}
					});

					mutation.removedNodes.forEach( function( node ){
						if ( jQuery(node).is('.elementor-control-smoove_fields_map_input_template_clone') ) {
							panel.$el.find('.elementor-control-smoove_fields_map_input').remove();
						}
					});
				}
			});
		}

		const observer = new MutationObserver( handleMutation );

		const targetNode = panel.$el.find('#elementor-panel-page-editor')[0];
		const config = { childList: true, subtree: true };

		if (targetNode) {
			observer.observe(targetNode, config);
		}
		
		// Validation removed from edit mode - only validates on save
	});

	function generate_field_map_inputs( panel, model ){
		let settings = model.get('settings');
		let form_fields = model.getSetting('form_fields').toJSON();

		let input_template = panel.$el.find('.elementor-control-smoove_fields_map_input_template');

		if( input_template.length ){
			input_template.removeClass('elementor-control-smoove_fields_map_input_template');
			input_template.addClass('elementor-control-smoove_fields_map_input_template_clone');
		}else{
			input_template = panel.$el.find('.elementor-control-smoove_fields_map_input_template_clone');
		}

		panel.$el.find('.elementor-control-smoove_fields_map_input').remove();

		if( form_fields.length && input_template.length ){
			let prev_field_input;
			let field_input;

			form_fields = form_fields.filter( field => field.field_type != 'upload' );

			form_fields.forEach((field) => {
				let field_id = field.custom_id;
				let field_setting_name = 'smoove_fields_map_input_' + field_id;
				let field_label = ( field.field_label != '' ) ? field.field_label : field.placeholder;
				let field_value = settings.attributes[field_setting_name];

				field_input = input_template.clone();
			
				let field_input_select = field_input.find('select');

				field_input.removeClass('elementor-control-smoove_fields_map_input_template_clone');
				field_input.addClass('elementor-control-smoove_fields_map_input');
				field_input.addClass('elementor-control-smoove_fields_map_input_' + field.custom_id);
				field_input.find('.elementor-control-title').text( field_label );
				field_input_select.attr( 'data-setting', field_setting_name ).data( 'setting', field_setting_name );
				field_input.find('[id]').removeAttr('id');

				field_input.removeClass('elementor-control-type-select');
				field_input.addClass('elementor-control-type-select2');

				if( field_value ){
					field_input_select.val( field_value );
				}

				if( prev_field_input ){
					field_input.insertAfter( prev_field_input );
				}else{
					field_input.insertAfter( input_template );
				}

				prev_field_input = field_input;
		
				field_input_select.select2({
					placeholder: field_input_select.find('option[value="0"]').first().text(),
					allowClear: true
				});

				field_input_select.on( 'change', function(){
					let select = jQuery(this);
					model.setSetting( select.data('setting'), select.val() );
					input_template.find('select').trigger('change');
					// Validation removed - only validates on save
				})
			});
		}
	}

	function insert_form_field_options_OLD( panel, model ){
		let settings = model.get('settings');
		let form_fields = model.getSetting('form_fields').toJSON();

		let fields_map_items = panel.$el.find('[class*="elementor-control-smoove_fields_map_input_"]:not(.elementor-control-smoove_fields_map_input_template):visible');

		if( fields_map_items.length && form_fields.length ){
			let options_html;

			form_fields = form_fields.filter( field => field.field_type != 'upload' );

			fields_map_items.each( function(){
				let select = jQuery(this).find('select');

				if( select.length ){
					let field_name = select.data('setting');
					let field_value = settings.attributes[field_name];
					
					options_html = '<option value="">' + smef_localize.select_placeholder + '</option>';

					form_fields.forEach((field) => {
						let selected = ( field_value == field.custom_id ) ? ' selected' : '';

						options_html += '<option value="' + field.custom_id + '"' + selected + '>';
							options_html += ( field.field_label != '' ) ? field.field_label : field.placeholder;
						options_html += '</option>';
					});

					select.html( options_html );
				}
			});
		}
	}
	
	/**
	 * Validate smoove mailing fields mapping.
	 * NOTE: This function is currently NOT USED during editing - validation only happens on save.
	 *
	 * @since 4.2.0
	 * @param {Object} panel Elementor panel object.
	 * @param {Object} model Elementor model object.
	 */
	function validate_smoove_mailing_fields( panel, model ) {
		return; // Disabled - validation only on save
		let settings = model.get('settings').attributes;
		
		// Check if smoove action is enabled
		if( !settings.submit_actions || !Array.isArray(settings.submit_actions) || 
			!settings.submit_actions.includes('smoove') ) {
			clear_validation_notices( panel );
			return;
		}
		
		// Check for mailing field mapping
		let has_email_mapping = false;
		let has_sms_mapping = false;
		
		for( let key in settings ) {
			if( key.startsWith('smoove_fields_map_input_') && settings[key] ) {
				if( settings[key] === 'canReceiveEmails' ) {
					has_email_mapping = true;
				}
				if( settings[key] === 'canReceiveSmsMessages' ) {
					has_sms_mapping = true;
				}
			}
		}
		
		// Show inline notice only (no popup during editing)
		if( !has_email_mapping && !has_sms_mapping ) {
			show_validation_warning( panel, 'critical', false ); // false = no popup
		} else if( !has_email_mapping || !has_sms_mapping ) {
			show_validation_warning( panel, 'warning', false ); // false = no popup
		} else {
			clear_validation_notices( panel );
		}
	}
	
	/**
	 * Show validation warning.
	 *
	 * @since 4.2.0
	 * @param {Object} panel Elementor panel object.
	 * @param {string} type Warning type ('critical' or 'warning').
	 * @param {boolean} showPopup Whether to show popup (default: false).
	 */
	function show_validation_warning( panel, type, showPopup ) {
		// Remove existing notices
		clear_validation_notices( panel );
		
		let notice_class = type === 'critical' ? 'elementor-panel-alert-danger' : 'elementor-panel-alert-warning';
		let locale = document.documentElement.lang || 'en';
		let message = '';
		
		if( type === 'critical' ) {
			if( locale.includes('he') ) {
				message = '<strong>שגיאת וולידציה:</strong> חסרים שדות אישור דיוור! יש להוסיף מיפוי לשדות canReceiveEmails ו/או canReceiveSmsMessages כדי לוודא שאנשי הקשר יקבלו הרשאות דיוור נכונות.';
			} else {
				message = '<strong>Validation Error:</strong> Missing mailing approval fields! Please add mapping for canReceiveEmails and/or canReceiveSmsMessages fields to ensure contacts receive proper mailing permissions.';
			}
		} else {
			if( locale.includes('he') ) {
				message = '<strong>המלצת וולידציה:</strong> מומלץ להוסיף מיפוי גם לשדות canReceiveEmails וגם ל-canReceiveSmsMessages לכיסוי מלא של הרשאות דיוור.';
			} else {
				message = '<strong>Validation Recommendation:</strong> It is recommended to add mapping for both canReceiveEmails and canReceiveSmsMessages fields for complete mailing permissions coverage.';
			}
		}
		
		let notice_html = '<div class="smef-validation-notice elementor-panel-alert ' + notice_class + '">' +
			'<div class="elementor-panel-alert-title">' + message + '</div>' +
			'</div>';
		
		// Insert notice after smoove section header
		let smoove_section = panel.$el.find('.elementor-control-section_smoove');
		if( smoove_section.length ) {
			smoove_section.after( notice_html );
		}
		
		// Don't show popup during editing - only show inline notice
	}
	
	/**
	 * Clear validation notices.
	 *
	 * @since 4.2.0
	 * @param {Object} panel Elementor panel object.
	 */
	function clear_validation_notices( panel ) {
		panel.$el.find('.smef-validation-notice').remove();
	}
	
	/**
	 * Show detailed validation popup with missing fields and instructions.
	 *
	 * @since 4.2.0
	 * @param {Array} validationErrors Array of validation error objects.
	 * @param {boolean} blockSave Whether to block saving (default: false).
	 */
	function show_detailed_validation_popup( validationErrors, blockSave ) {
		console.log('🚨 Smoove: show_detailed_validation_popup called', validationErrors);
		blockSave = blockSave === true; // Default to false (allow save)
		// Remove existing popup
		jQuery('#smef-validation-popup').remove();
		console.log('🚨 Smoove: Building popup HTML...');
		
		var locale = document.documentElement.lang || 'en';
		var isHebrew = locale.includes('he');
		
		// Build popup content
		var title = isHebrew ? 'אזהרה חמורה - Smoove' : 'Critical Warning - Smoove';
		var subtitle = isHebrew ? 
			'<div style="background: #fee; padding: 12px; border-radius: 6px; margin-bottom: 16px; border-right: 4px solid #d63638;"><strong>העמוד נשמר, אך יש בעיה!</strong> הטפסים הבאים חסרים מיפוי שדות אישור דיוור. <strong>אנשי קשר לא יקבלו הרשאות דיוור!</strong> יש לתקן זאת בהקדם:</div>' : 
			'<div style="background: #fee; padding: 12px; border-radius: 6px; margin-bottom: 16px; border-left: 4px solid #d63638;"><strong>Page saved, but there\'s an issue!</strong> The following forms are missing mailing approval field mapping. <strong>Contacts will NOT receive mailing permissions!</strong> Please fix this ASAP:</div>'
		
		var content = subtitle;
		
		// Add details for each form with errors
		validationErrors.forEach(function(error, index) {
			var formTitle = isHebrew ? 'טופס #' + error.formIndex : 'Form #' + error.formIndex;
			
			content += '<div class="smef-form-error">';
			content += '<h4 class="smef-form-title">' + formTitle + '</h4>';
			
			// Missing fields list
			var missingTitle = isHebrew ? 'שדות חסרים:' : 'Missing Fields:';
			content += '<div class="smef-missing-fields">';
			content += '<strong>' + missingTitle + '</strong>';
			content += '<ul class="smef-field-list">';
			error.missing_fields.forEach(function(field) {
				var fieldDisplay = field === 'canReceiveEmails' ? 
					(isHebrew ? 'אישור קבלת אימיילים' : 'Email Permission') : 
					(isHebrew ? 'אישור קבלת SMS' : 'SMS Permission');
				content += '<li class="smef-missing-field">' + fieldDisplay + ' <code>' + field + '</code></li>';
			});
			content += '</ul>';
			content += '</div>';
			
			// Currently mapped fields removed per user request
			
			// Instructions
			content += error.instructions;
			content += '</div>';
		});
		
		// Create popup
		let popup_html = '<div id="smef-validation-popup" class="smef-popup-overlay" style="display: flex;">' +
			'<div class="smef-popup-content">' +
				'<div class="smef-popup-header">' +
					'<h3 class="smef-popup-title">' +
						title +
					'</h3>' +
					'<button class="smef-popup-close">&times;</button>' +
				'</div>' +
				'<div class="smef-popup-body">' + content + '</div>' +
				'<div class="smef-popup-footer">' +
					'<button class="smef-popup-ok button button-primary">' + (isHebrew ? 'הבנתי, אתקן את זה עכשיו' : 'Understood, I Will Fix This Now') + '</button>' +
				'</div>' +
			'</div>' +
		'</div>';
		
		console.log('🚨 Smoove: Appending popup to body');
		jQuery('body').append( popup_html );
		console.log('🚨 Smoove: Popup appended, checking if visible:', jQuery('#smef-validation-popup').length);
		
		// Add enhanced popup styles
		add_enhanced_popup_styles();
		console.log('🚨 Smoove: Popup styles added');
		
		// Add event handlers
		jQuery('#smef-validation-popup .smef-popup-close, #smef-validation-popup .smef-popup-ok').on('click', function() {
			jQuery('#smef-validation-popup').remove();
		});
		
		jQuery('#smef-validation-popup .smef-popup-overlay').on('click', function(e) {
			if( e.target === this ) {
				jQuery('#smef-validation-popup').remove();
			}
		});
	}
	
	/**
	 * Add enhanced popup styles.
	 *
	 * @since 4.2.0
	 */
	function add_enhanced_popup_styles() {
		if( jQuery('#smef-popup-styles').length ) {
			return;
		}
		
		let popup_styles = '<style id="smef-popup-styles">' +
			'.smef-popup-overlay { position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.85); z-index: 999999; display: flex; align-items: center; justify-content: center; animation: smef-fade-in 0.3s ease; }' +
			'.smef-popup-content { background: white; border-radius: 12px; max-width: 600px; width: 95%; max-height: 80vh; overflow-y: auto; box-shadow: 0 20px 60px rgba(0,0,0,0.4); animation: smef-slide-up 0.3s ease; }' +
			'.smef-popup-header { padding: 24px 24px 16px; border-bottom: 2px solid #f0f0f0; display: flex; justify-content: space-between; align-items: center; background: linear-gradient(135deg, #451889 0%, #341366 100%); color: white; border-radius: 12px 12px 0 0; }' +
			'.smef-popup-title { margin: 0; font-size: 18px; font-weight: 600; display: flex; align-items: center; gap: 10px; }' +
			'.smef-icon { font-size: 22px; }' +
			'.smef-popup-close { background: rgba(255,255,255,0.2); border: none; font-size: 20px; cursor: pointer; color: white; padding: 8px; width: 36px; height: 36px; border-radius: 50%; transition: all 0.2s ease; }' +
			'.smef-popup-close:hover { background: rgba(255,255,255,0.3); transform: rotate(90deg); }' +
			'.smef-popup-body { padding: 24px; line-height: 1.7; color: #333; }' +
			'.smef-popup-subtitle { font-size: 16px; margin-bottom: 20px; color: #555; font-weight: 500; }' +
			'.smef-form-error { background: #fef9f9; border: 1px solid #fee; border-radius: 8px; padding: 20px; margin-bottom: 20px; }' +
			'.smef-form-title { margin: 0 0 16px 0; color: #d63638; font-size: 18px; font-weight: 600; border-bottom: 1px solid #fee; padding-bottom: 8px; }' +
			'.smef-missing-fields, .smef-mapped-fields { margin-bottom: 16px; }' +
			'.smef-field-list { margin: 8px 0 0 0; padding-left: 20px; }' +
			'.smef-missing-field { color: #d63638; margin-bottom: 8px; font-weight: 500; }' +
			'.smef-mapped-field { color: #00a32a; margin-bottom: 8px; }' +
			'.smef-field-list code { background: #f8f9fa; padding: 2px 6px; border-radius: 4px; font-family: Monaco, Consolas, monospace; font-size: 13px; color: #495057; border: 1px solid #e9ecef; }' +
			'.smef-instructions { background: #f8f9fa; border: 1px solid #e9ecef; border-radius: 6px; padding: 16px; margin-top: 16px; }' +
			'.smef-instructions h4 { margin: 0 0 12px 0; color: #495057; font-size: 16px; }' +
			'.smef-instructions ol { margin: 8px 0 0 0; padding-left: 20px; }' +
			'.smef-instructions li { margin-bottom: 8px; color: #6c757d; }' +
			'.smef-popup-footer { padding: 16px 24px 24px; text-align: right; background: #fafbfc; border-radius: 0 0 12px 12px; }' +
			'.smef-popup-ok { cursor: pointer; padding: 12px 24px; font-size: 14px; font-weight: 600; border-radius: 6px; transition: all 0.2s ease; background: #451889 !important; border-color: #451889 !important; color: #ffffff !important; }' +
			'.smef-popup-ok:hover { transform: translateY(-1px); box-shadow: 0 4px 12px rgba(0,123,255,0.3); }' +
			'@keyframes smef-fade-in { from { opacity: 0; } to { opacity: 1; } }' +
			'@keyframes smef-slide-up { from { transform: translateY(50px); opacity: 0; } to { transform: translateY(0); opacity: 1; } }' +
		'</style>';
		
		jQuery('head').append( popup_styles );
	}
	
	/**
	 * Show simple validation popup (fallback).
	 *
	 * @since 4.2.0
	 * @param {string} message Message to display.
	 */
	function show_validation_popup( message ) {
		show_detailed_validation_popup([{
			formIndex: 1,
			missing_fields: ['canReceiveEmails', 'canReceiveSmsMessages'],
			mapped_fields: [],
			instructions: message
		}]);
	}
	
	// Debug function - can be called from console
	window.smef_test_popup = function() {
		var testErrors = [{
			formIndex: 1,
			missing_fields: ['canReceiveEmails', 'canReceiveSmsMessages'],
			mapped_fields: ['firstName', 'email'],
			instructions: '<div class="smef-instructions"><h4>Test Instructions:</h4><ol><li>This is a test popup</li><li>Click on the form</li><li>Go to smoove settings</li><li>Map the missing fields</li></ol></div>'
		}];
		show_detailed_validation_popup(testErrors);
	};
	
	// Debug function to test validation
	window.smef_test_validation = function() {
		var result = validate_all_forms_before_save();
		console.log('Validation result:', result);
		return result;
	};
});
