jQuery(document).ready(function($) {
    let autoRefreshInterval = null;
    
    // Refresh log
    function refreshLog() {
        $.ajax({
            url: smefDebug.ajax_url,
            type: 'POST',
            data: {
                action: 'smef_get_debug_log',
                nonce: smefDebug.nonce
            },
            success: function(response) {
                if (response.success) {
                    renderLog(response.data.log);
                    updateStats(response.data.stats);
                }
            }
        });
    }
    
    // Render log entries
    function renderLog(entries) {
        const container = $('#smef-log-container');
        
        if (entries.length === 0) {
            container.html('<p class="smef-no-logs">אין רשומות לוג עדיין. הלוג יתחיל להתמלא כשתבצע פעולות בעורך.</p>');
            return;
        }
        
        let html = '';
        entries.forEach(function(entry) {
            const date = new Date(entry.timestamp * 1000);
            const timeStr = date.toLocaleTimeString('he-IL') + ' ' + date.toLocaleDateString('he-IL');
            
            html += '<div class="smef-log-entry type-' + entry.type + '">';
            html += '<div class="smef-log-header">';
            html += '<span class="smef-log-type type-' + entry.type + '">' + getTypeLabel(entry.type) + '</span>';
            html += '<span class="smef-log-time">' + timeStr + '</span>';
            html += '</div>';
            html += '<div class="smef-log-message">' + escapeHtml(entry.message) + '</div>';
            
            if (entry.data && Object.keys(entry.data).length > 0) {
                html += '<div class="smef-log-data">';
                html += '<pre>' + JSON.stringify(entry.data, null, 2) + '</pre>';
                html += '</div>';
            }
            
            if (entry.url) {
                html += '<div class="smef-log-data">';
                html += '<strong>URL:</strong> ' + escapeHtml(entry.url);
                if (entry.is_editor) {
                    html += ' <span style="color: #00a32a;">✓ בעורך</span>';
                }
                html += '</div>';
            }
            
            html += '</div>';
        });
        
        container.html(html);
        
        // Auto-scroll to bottom
        container.scrollTop(container[0].scrollHeight);
    }
    
    // Update stats
    function updateStats(stats) {
        $('#smef-api-count').text(stats.api_requests);
        $('#smef-editor-count').text(stats.editor_loads);
        $('#smef-validation-count').text(stats.validation_errors);
    }
    
    // Get type label in Hebrew
    function getTypeLabel(type) {
        const labels = {
            'api_request': 'בקשת API',
            'editor_load': 'טעינת עורך',
            'validation_error': 'שגיאת וולידציה',
            'warning': 'אזהרה',
            'info': 'מידע'
        };
        return labels[type] || type;
    }
    
    // Escape HTML
    function escapeHtml(text) {
        const div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
    }
    
    // Refresh button
    $('#smef-refresh-log').on('click', function() {
        refreshLog();
    });
    
    // Clear log button
    $('#smef-clear-log').on('click', function() {
        if (!confirm('האם אתה בטוח שברצונך למחוק את כל הלוג?')) {
            return;
        }
        
        $.ajax({
            url: smefDebug.ajax_url,
            type: 'POST',
            data: {
                action: 'smef_clear_debug_log',
                nonce: smefDebug.nonce
            },
            success: function(response) {
                if (response.success) {
                    refreshLog();
                    alert('הלוג נוקה בהצלחה');
                }
            }
        });
    });
    
    // Auto-refresh toggle
    $('#smef-auto-refresh').on('change', function() {
        if ($(this).is(':checked')) {
            autoRefreshInterval = setInterval(refreshLog, 3000);
        } else {
            if (autoRefreshInterval) {
                clearInterval(autoRefreshInterval);
            }
        }
    });
    
    // Initial load
    refreshLog();
    
    // Start auto-refresh
    autoRefreshInterval = setInterval(refreshLog, 3000);
});
