<?php
/**
 * Template for displaying AI search results.
 *
 * @package smarter-search-products-posts
 */
defined('ABSPATH') || exit;

get_header();
?>

<div class="ai-search-results-wrapper">
    <?php if (have_posts()) : ?>
        <h2 class="ai-search-results-title">
            <?php
            $crsh_search_query = get_search_query();
            $title = sprintf(
                /* translators: %s: search query term */
                esc_html__('Search Results for "%s"', 'smarter-search-products-posts'),
                esc_html($crsh_search_query)
            );
            echo esc_html($title);
            ?>
        </h2>

        <?php woocommerce_product_loop_start(); ?>
        <?php while (have_posts()) : the_post(); ?>
            <?php wc_get_template_part('content', 'product'); ?>
        <?php endwhile; ?>
        <?php woocommerce_product_loop_end(); ?>

    <?php else : ?>
        <p class="ai-search-no-results">
            <?php esc_html_e('No results found for your query.', 'smarter-search-products-posts'); ?>
        </p>
        <?php
        // Optionally show search form
        echo do_shortcode('[crsh_search]');
        ?>
    <?php endif; ?>
</div>

<?php get_footer(); ?>