<?php
/**
 * The template for displaying AI search results.
 */

if (!defined('ABSPATH')) {
    exit;
}

get_header();
?>

<div id="primary" class="content-area">
    <main id="main" class="site-main">

        <?php
        // phpcs:disable WordPress.Security.NonceVerification.Recommended
        $crsh_search_term   = get_search_query();
        $crsh_product_s     = isset($_GET['product_s']) ? sanitize_text_field(wp_unslash($_GET['product_s'])) : $crsh_search_term;
        $crsh_product_cat   = isset($_GET['product_cat']) ? sanitize_text_field(wp_unslash($_GET['product_cat'])) : null;
        $crsh_min_price_raw = isset($_GET['min_price']) ? wp_unslash($_GET['min_price']) : null; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
        $crsh_max_price_raw = isset($_GET['max_price']) ? wp_unslash($_GET['max_price']) : null; // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
        // phpcs:enable WordPress.Security.NonceVerification.Recommended

        // Sanitize prices safely
        $crsh_min_price = is_numeric($crsh_min_price_raw) ? max(0, floatval($crsh_min_price_raw)) : 0;
        $crsh_max_price = is_numeric($crsh_max_price_raw) ? floatval($crsh_max_price_raw) : PHP_INT_MAX;
        if ($crsh_max_price < $crsh_min_price) {
            $crsh_max_price = $crsh_min_price;
        }

        // Build product query args
        $crsh_product_args = [
            'post_type'      => 'product',
            'posts_per_page' => 12,
            'post_status'    => 'publish',
            's'              => $crsh_product_s,
        ];

        if ($crsh_product_cat) {
            $crsh_product_args['tax_query'] = [[
                'taxonomy' => 'product_cat',
                'field'    => 'slug',
                'terms'    => $crsh_product_cat,
            ]];
        }

        if ($crsh_min_price > 0 || $crsh_max_price < PHP_INT_MAX) {
            $crsh_product_args['meta_query'] = [[
                'key'     => '_price',
                'value'   => [$crsh_min_price, $crsh_max_price],
                'compare' => 'BETWEEN',
                'type'    => 'DECIMAL',
            ]];
        }

        $crsh_product_query = new WP_Query($crsh_product_args);

        if ($crsh_product_query->have_posts()) {
            echo '<h2 class="search-section-title">' . esc_html__('Products', 'smarter-search-products-posts') . '</h2>';
            woocommerce_product_loop_start();
            while ($crsh_product_query->have_posts()) {
                $crsh_product_query->the_post();
                wc_get_template_part('content', 'product');
            }
            woocommerce_product_loop_end();
            wp_reset_postdata();
        } else {
            echo '<p class="woocommerce-info">' . esc_html__('No products were found matching your selection.', 'smarter-search-products-posts') . '</p>';
        }

        // === SECTION 2: PAGE RESULTS ===
        $crsh_page_args = [
            'post_type'      => 'page',
            'posts_per_page' => 10,
            'post_status'    => 'publish',
            's'              => $crsh_search_term, // Reuse sanitized term — no new $_GET access
            'search_columns' => ['post_title'],
        ];

        $crsh_page_query = new WP_Query($crsh_page_args);

        if ($crsh_page_query->have_posts()) {
            echo '<div class="page-results-container">';
            echo '<h2 class="search-section-title">' . esc_html__('Related Pages', 'smarter-search-products-posts') . '</h2>';
            echo '<ul class="search-page-list">';
            while ($crsh_page_query->have_posts()) {
                $crsh_page_query->the_post();
                echo '<li><a href="' . esc_url(get_permalink()) . '">' . esc_html(get_the_title()) . '</a></li>';
            }
            echo '</ul>';
            echo '</div>';
            wp_reset_postdata();
        }
        ?>

    </main><!-- #main -->
</div><!-- #primary -->

<?php
get_footer();