<?php
/**
 * Custom Search Results Template for Mixed Content
 */

if (!defined('ABSPATH')) {
    exit;
}

get_header();
?>

<main id="main" class="site-main">
    <?php if (have_posts()) : ?>
        <header class="page-header">
            <h1 class="page-title">
                <?php
                /* translators: %s: search query */
                $crsh_search_results_text = __( 'Search Results for: %s', 'smarter-search-products-posts' );
                echo esc_html(
                    sprintf(
                        $crsh_search_results_text,
                        get_search_query()
                    )
                );
                ?>
            </h1>
            <div class="search-results-count">
                <?php
                global $wp_query;
                /* translators: %d: number of search results */
                $crsh_results_count_text = _n(
                    'Found %d result',
                    'Found %d results',
                    $wp_query->found_posts,
                    'smarter-search-products-posts'
                );
                echo esc_html(
                    sprintf(
                        $crsh_results_count_text,
                        intval($wp_query->found_posts)
                    )
                );
                ?>
            </div>
        </header>

        <div class="ai-search-mixed-results">
            <?php
            while (have_posts()) :
                the_post();
                if ('product' === get_post_type() && class_exists('WooCommerce')) {
                    include dirname(__FILE__) . '/search-result-product.php';
                } else {
                    include dirname(__FILE__) . '/search-result-post.php';
                }
            endwhile;
            ?>
        </div>

        <?php
        the_posts_pagination([
            'mid_size'  => 2,
            'prev_text' => esc_html__('« Previous', 'smarter-search-products-posts'),
            'next_text' => esc_html__('Next »', 'smarter-search-products-posts'),
        ]);
        ?>

    <?php else : ?>
        <section class="no-results not-found">
            <header class="page-header">
                <h1 class="page-title">
                    <?php esc_html_e('Nothing Found', 'smarter-search-products-posts'); ?>
                </h1>
            </header>
            <div class="page-content">
                <p>
                    <?php esc_html_e('Sorry, but nothing matched your search terms. Please try again with different keywords.', 'smarter-search-products-posts'); ?>
                </p>
                <?php get_search_form(); ?>
            </div>
        </section>
    <?php endif; ?>
</main>

<?php get_footer(); ?>