<?php
/**
 * Template part for displaying a WooCommerce product
 * inside mixed search results
 */

if (!defined('ABSPATH')) {
    exit;
}

global $crsh_product;
if (!$crsh_product) {
    $crsh_product = wc_get_product(get_the_ID());
}

if (!$crsh_product || !$crsh_product->is_visible()) {
    return;
}
?>

<div class="search-result-product">
    <a href="<?php echo esc_url(get_permalink()); ?>" class="woocommerce-LoopProduct-link">
        <div class="product-image">
            <?php echo wp_kses_post($crsh_product->get_image()); ?>
        </div>
        <div class="product-details">
            <h3 class="woocommerce-loop-product__title">
                <?php echo esc_html(get_the_title()); ?>
            </h3>
            <div class="price">
                <?php echo wp_kses_post($crsh_product->get_price_html()); ?>
            </div>
            <?php if ($crsh_product->get_short_description()) : ?>
                <div class="product-excerpt">
                    <?php echo esc_html(wp_trim_words($crsh_product->get_short_description(), 15)); ?>
                </div>
            <?php endif; ?>
        </div>
    </a>
</div>