<?php
/**
 * Template part for displaying a Post or Page
 * inside mixed search results
 */

if (!defined('ABSPATH')) exit;
?>

<article class="search-result-post">
    <header class="entry-header">
        <h2 class="entry-title">
            <a href="<?php echo esc_url( get_permalink() ); ?>">
                <?php echo esc_html( get_the_title() ); ?>
            </a>
        </h2>
        <div class="entry-meta">
            <span class="post-type">
                <?php echo esc_html( get_post_type_object( get_post_type() )->labels->singular_name ); ?>
            </span>
            <span class="post-date"><?php echo esc_html( get_the_date() ); ?></span>
        </div>
    </header>

    <div class="entry-content">
        <?php echo wp_kses_post( get_the_excerpt() ); ?>
    </div>

    <footer class="entry-footer">
        <a href="<?php echo esc_url( get_permalink() ); ?>" class="read-more">
            <?php esc_html_e('Read More', 'smarter-search-products-posts'); ?>
        </a>
    </footer>
</article>