<?php
/**
 * Template Name: AI Search Results
 */

if (!defined('ABSPATH')) {
    exit;
}

get_header();
?>

<div class="ai-search-results-page">
    <div class="container">
        <?php
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended
        $crsh_search_query = isset($_GET['s']) ? sanitize_text_field(wp_unslash($_GET['s'])) : '';

        if (!empty($crsh_search_query)) {
           
            echo '<h1>' . sprintf(
                 /* translators: %s: search query */
                esc_html__('Search Results for "%s"', 'smarter-search-products-posts'),
                esc_html($crsh_search_query)
            ) . '</h1>';

            // ⚠️ Only proceed if WooCommerce exists
            if (class_exists('WooCommerce')) {
                // Simulate a product search query
                $crsh_args = [
                    's'              => $crsh_search_query,
                    'post_type'      => 'product',
                    'posts_per_page' => 12,
                    'post_status'    => 'publish',
                ];

                $crsh_query = new WP_Query($crsh_args);

                if ($crsh_query->have_posts()) {
                    woocommerce_product_loop_start();
                    while ($crsh_query->have_posts()) {
                        $crsh_query->the_post();
                        wc_get_template_part('content', 'product');
                    }
                    woocommerce_product_loop_end();
                    wp_reset_postdata();
                } else {
                    echo '<p class="woocommerce-info">' . esc_html__('No products match your search criteria.', 'smarter-search-products-posts') . '</p>';
                }
            } else {
                echo '<p class="woocommerce-error">' . esc_html__('WooCommerce is not active.', 'smarter-search-products-posts') . '</p>';
            }
        } else {
            echo '<p class="woocommerce-info">' . esc_html__('No search query provided.', 'smarter-search-products-posts') . '</p>';
            echo do_shortcode('[crsh_search]');
        }
        ?>
    </div>
</div>

<?php get_footer(); ?>