document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('ai-search-form');
    
    if (form) {
        form.addEventListener('submit', function(e) {
            // 1. Stop the form from submitting immediately
            e.preventDefault();

            // 2. Find elements
            const icon = form.querySelector('.ai-search-icon');
            const spinner = form.querySelector('.ai-search-spinner');
            const button = form.querySelector('button');

            // 3. Show the spinner and hide the icon
            if (icon) icon.style.display = 'none';
            if (spinner) spinner.style.display = 'inline-block';

            // 4. Optional: Disable button so they don't click twice
            if (button) button.disabled = true;

            // 5. Wait 100ms (0.1 seconds) so the eye can see the spinner...
            setTimeout(function() {
                // ...THEN submit the form.
                form.submit();
            }, 100);
        });
    }
});