jQuery(document).ready(function($) {
    // Handle search form submission
    $('#ai-search-form').on('submit', function(e) {
        e.preventDefault();
        
        var searchTerm = $('#ai-search-input').val().trim();
        var $results = $('#ai-search-results');
        
        if (searchTerm === '') {
            alert('Please enter a search term.');
            return;
        }
        
        // Show loading message
        $results.html('<div class="ai-search-loading">Searching products...</div>');
        
        // Perform AJAX request
        $.ajax({
            url: ai_search_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'ai_search_products',
                ai_query: searchTerm,
                nonce: ai_search_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $results.html(response.data.html);
                    
                    // Show results count
                    if (response.data.count > 0) {
                        $results.prepend('<p><strong>Found ' + response.data.count + ' product(s)</strong></p>');
                    }
                } else {
                    $results.html('<div class="ai-search-error">Error: ' + response.data.message + '</div>');
                }
            },
            error: function(xhr, status, error) {
                $results.html('<div class="ai-search-error">Connection error. Please try again.</div>');
                console.error('AJAX Error:', error);
            }
        });
    });
    
    // Optional: Trigger search on Enter key
    $('#ai-search-input').on('keypress', function(e) {
        if (e.which === 13) {
            $('#ai-search-form').submit();
        }
    });
});