// file name: public.js
jQuery(document).ready(function ($) {
    $('#ai-search-form').on('submit', function (e) {
        e.preventDefault();

        var query = $(this).find('input[name="ai_query"]').val();

        $.ajax({
            url: '<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>',
            type: 'POST',
            data: {
                action: 'ai_search_results', // same handler as before
                query: query
            },
            beforeSend: function () {
                $('#ai-search-results').html('<p>Searching…</p>');
            },
            success: function () {
                // Build the URL of the search‑results page
                var resultsPage = '<?php echo esc_url( get_permalink( get_page_by_path( 'search-results' ) ) ); ?>';
                // Redirect, passing the query in the query string
                window.location.href = resultsPage + '?ai_query=' + encodeURIComponent( query );
            },
            error: function (xhr, status, err) {
                $('#ai-search-results').html('<p class="woocommerce-error">Error: ' + err + '</p>');
            }
        });
    });
});