jQuery(document).ready(function($) {
    // Handle Generate AI Prompt button
    $('#generate-ai-prompt').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $promptField = $('#smarter_wp_wc_search_prompt');
        
        // Show loading state
        $button.prop('disabled', true).text('Generating...');
        
        $.ajax({
            url: smarterWpWcSearchAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'generate_ai_prompt',
                nonce: smarterWpWcSearchAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $promptField.val(response.data.prompt);
                    $button.prop('disabled', false).text('Generate AI Prompt');
                } else {
                    alert('Failed to generate prompt. Please try again.');
                    $button.prop('disabled', false).text('Generate AI Prompt');
                }
            },
            error: function() {
                alert('Error generating prompt. Please try again.');
                $button.prop('disabled', false).text('Generate AI Prompt');
            }
        });
    });
});