<?php
/**
 * Smart Support Plugin Configuration
 *
 * This file contains configuration constants for the Smart Support plugin.
 * Update the domain here if it changes in the future.
 *
 * Configuration options:
 * - Set SMARTSUPPORT_BASE_URL environment variable in docker-compose.yml to override
 * - Default options:
 *   1. Container name (if on same Docker network): 'http://ai_agent_nginx_container:80'
 *   2. Host access (if port is mapped): 'http://localhost:8005' or 'http://host.docker.internal:8005'
 *   3. Gateway IP (if containers are on different networks): Use host's gateway IP
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

if (!defined('SMARTSUPPORT_BASE_URL')) {
    // Check for environment variable first
    define('SMARTSUPPORT_BASE_URL', 'https://smartsupport.pro');
}

/**
 * Get Smart Support base URL
 *
 * @return string Base URL
 */
function smartsupport_get_base_url() {
    return SMARTSUPPORT_BASE_URL;
}

