<?php

/**
 * Plugin Name:         Smart Prefetch: Unlock Lightning-Fast Navigation
 * Plugin URI:          https://smartprefetch.link
 * Author:              SmartPrefetch
 * Author URI:          https://profiles.wordpress.org/sanspf/profile/
 * Description:         Smart Prefetch Plugin predicts user navigation and prefetches the next page, delivering a seamless, instant browsing experience.
 * Requires at least:   5.2
 * Requires PHP:        7.2
 * Version:             1.4.1
 * Text Domain:         smart-prefetch
 * License:             GPLv2 or later
 */
/*
SmartPrefetch is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 2 of the License, or any later version. */

defined('ABSPATH') or die('ABSPATH not defined');

$plug_dir = dirname(__FILE__) . '/';
include_once($plug_dir . 'autoload.php');

if (is_admin()) {
    register_deactivation_hook(__FILE__, 'SmartPrefetch_21_Admin::plugin_deactivate');
    add_filter('plugin_action_links_smart-prefetch/smart-prefetch.php', 'SmartPrefetch_21_Admin::settings_link');

    if (!defined('SMART_PREFETCH_UNINSTALL_MODE')) {
        SmartPrefetch_21_Admin::addActions();
    }
} else {
    SmartPrefetch_21_Public::addActions();
}
