<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
class SmartPrefetch_21_Tab_Init extends SmartPrefetch_21_Admin
{
    public static function echoPluginPage()
    {
        if (!current_user_can('manage_options')) {
            #the use is not authorized to manage options
            return;
        }

        // Call wordpress-admin endpoint to register the WordPress site with Smart Prefetch backend
        self::registerWordPressSite();

?>

        <div class="wrap">
            <div id="smart_prefetch_root"></div>
            <?php
            wp_enqueue_script('smartprefetch-react', 'https://unpkg.com/react@18/umd/react.production.min.js', [], null, ['strategy' => 'defer', 'in_footer' => true]);
            wp_enqueue_script('smartprefetch-react-dom', 'https://unpkg.com/react-dom@18/umd/react-dom.production.min.js', [], null, ['strategy' => 'defer', 'in_footer' => true]);
            wp_enqueue_script('smartprefetch-report', SMART_PREFETCH_PLUG_URL . 'admin/js/index.umd.js', ['smartprefetch-react', 'smartprefetch-react-dom'], SMART_PREFETCH_PLUG_VERSION, ['strategy' => 'defer', 'in_footer' => true]);

            $props = [
                'host' => preg_replace('#^https?://#', '', rtrim(get_site_url(), '/')),
                'jwt' => ''
            ];

            wp_add_inline_script(
                'smartprefetch-report',
                "if (typeof window !== 'undefined') {
                    if (document.readyState === 'loading') {
                        window.addEventListener('load', function() {
                            SmartPrefetchWordPress.Init(" . json_encode($props) . ");
                        });
                    } else {
                        // Document already loaded
                        SmartPrefetchWordPress.Init(" . json_encode($props) . ");
                    }
                }",
                'after'
            );
            ?>
        </div>
<?php
    }

    /**
     * Register WordPress site with Smart Prefetch backend
     * Called only once in 24 hours as per requirements
     */
    private static function registerWordPressSite()
    {
        // Check if we've already called this API in the last 24 hours
        $last_registration = get_transient('smartprefetch_last_registration');
        if ($last_registration !== false) {
            // Already registered in the last 24 hours, skip
            return;
        }

        // Get current user data
        $current_user = wp_get_current_user();
        if (!$current_user || !$current_user->user_email) {
            // No valid user, skip registration
            return;
        }

        // Prepare API call data
        $payload = [
            'host' => preg_replace('#^https?://#', '', rtrim(get_site_url(), '/')),
            'email' => $current_user->user_email,
            'nonce' => SmartPrefetch_21_Core::generateApiToken()
        ];

        // Call the Smart Prefetch backend API
        $apiError = false;
        $apiMessage = '';
        $response = SmartPrefetch_21_Core::callPOSTAPI('/prefetch/v1/wordpress-admin', $payload, $apiError, $apiMessage);

        // Set transient to prevent calling again for 24 hours
        // We set this regardless of success/failure to avoid hammering the API
        set_transient('smartprefetch_last_registration', time(), 24 * HOUR_IN_SECONDS);

        // Log any errors for debugging (optional)
        if ($apiError && defined('WP_DEBUG') && WP_DEBUG) {
            error_log('SmartPrefetch WordPress Admin API call failed: ' . $apiMessage);
        }
    }
}
?>