<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
if (class_exists('SmartPrefetch_21_Tab_Home')) {
    #it seems we have a conflict
    return;
}

final class SmartPrefetch_21_Tab_Home extends SmartPrefetch_21_Tab_Init
{

    public static function init()
    {
        add_settings_section(
            'smartprefetch_section_home',
            '',
            __CLASS__ . '::echoTopSectionContent',
            'smartprefetch-home'
        );
    }

    public static function echoTopSectionContent($args)
    {
        $showConnectionMessage = false;

        $overview = self::getOverviewData($apiError, $apiMessage);
        if ($apiError) {
            $showConnectionMessage = true;
        } else {
        }

        if ($apiMessage == 'AUTH_REQUIRED' || $apiMessage == 'INVALID_DOMAIN') {
            $apiMessage = 'Authentication failed. Please try to reconnect the plugin from Settings tab.';
        } else if ($apiError) {
            $apiMessage = 'Could not connect to SmartPrefetch server. This may happen because of a temporary network issues. Please try again in while.' . ($apiMessage ? ' (' . $apiMessage . ')' : '');
        }

?>

        <div class="" style="max-width: 1160px; margin:40px auto;">

            <?php

            self::echoCardWithImage(
                'prefetch-logo-512.svg',
                'Data Collection in Progress',
                'SmartPrefetch is actively monitoring visitor navigation patterns on your website. This continuous process refines prediction models and dynamically creates Speculation Rules to enhance navigation speed.',
                '<a class="button button-secondary" href="' . SmartPrefetch_21_Core::getRLBaseDomain() . '" target="_blank">' . __('Learn More', 'smart-prefetch') . '</a>'
            );

            ?>
            <h3><?php esc_html_e('Most Popular Patterns', 'smart-prefetch'); ?></h3>
            <p>
                <?php esc_html_e('This table shows the prediction rules that the SmartPrefetch plugin is currently using to accelerate navigation on your website. If you have just installed the plugin, please allow some time for data collection and rule generation.', 'smart-prefetch'); ?>
            </p>
            <table id="popular-navigation-table" class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php esc_html_e('Source Page', 'smart-prefetch'); ?></th>
                        <th><?php esc_html_e('Destination', 'smart-prefetch'); ?></th>
                        <th><?php esc_html_e('Prefetch Prediction', 'smart-prefetch'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($overview['popular_navigation'] as $item) : ?>
                        <tr>
                            <td><?php echo esc_html($item['fromPath'] ?? ''); ?></td>
                            <td><?php echo esc_html($item['toPath'] ?? ''); ?></td>
                            <td data-popularity="<?php echo floatval($item['probability']); ?>">
                                <?php echo esc_html($item['probability'] . '%' ?? ''); ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <div id="pagination-controls" style="margin-top:16px;"></div>
            <?php
            wp_enqueue_script('smartprefetch-pagination', SMART_PREFETCH_PLUG_URL . 'admin/js/pagination.js', [], SMART_PREFETCH_PLUG_VERSION, ['strategy' => 'async', 'in_footer' => true]);
            ?>

            <?php
            if ($showConnectionMessage) {
                self::echoCardWithImage(
                    '',
                    'Reporting Server Busy',
                    $apiMessage,
                    '<a class="button button-secondary" href="javascript:window.location.reload();">' . __('Reload', 'smart-prefetch') . '</a>'
                );
            }
            ?>
        </div>
<?php
    }

    public static function echoMainContent()
    {
        do_settings_sections('smartprefetch-home');
    }
}
?>