<?php
if (! defined('ABSPATH')) exit; // Exit if accessed directly
class SmartPrefetch_21_Admin
{
    public static $admin_notice_shown = false;

    public static function addActions()
    {
        add_action('admin_menu', 'SmartPrefetch_21_Admin::leftMenuOption');
    }

    public static function init() {}

    public static function leftMenuOption()
    {
        add_menu_page(
            'Smart Prefetch',
            'Smart Prefetch',
            'manage_options',
            SMART_PREFETCH_PLUG_SLUG,
            'SmartPrefetch_21_Tab_Init::echoPluginPage',
            "data:image/svg+xml;base64," . base64_encode('<svg xmlns="http://www.w3.org/2000/svg" width="512" height="512" viewBox="0 0 64 64"><circle cx="24" cy="32" r="20" stroke="#ffffff" stroke-width="4" fill="none"/><path d="M24 14 L36 32 L24 51" stroke="#ffffff" stroke-width="4" fill="none" stroke-linecap="round" stroke-linejoin="round"/><path d="M37 32 L59 32" stroke="#ffffff" stroke-width="4" stroke-linecap="round"/></svg>'),
            //'',
            20
        );

        if (SmartPrefetch_21_Util_Core::isCurrentPluginPage()) {
            wp_enqueue_style('smart-prefetch-admin-style', SMART_PREFETCH_PLUG_URL . 'admin/css/style.css?v=' . SMART_PREFETCH_PLUG_VERSION, [], SMART_PREFETCH_PLUG_VERSION);
        }
    }

    public static function plugin_deactivate()
    {
        //clear any transient data if needed
    }

    public static function plugin_uninstall()
    {
        self::plugin_deactivate();
    }

    public static function settings_link($links)
    {
        $url_settings = esc_url(add_query_arg(
            'page',
            SMART_PREFETCH_PLUG_SLUG,
            get_admin_url() . 'admin.php'
        ));
        $link = "<a href='$url_settings'>" . __('Settings', 'smart-prefetch') . '</a>';
        array_push($links, $link);
        $url_kb = esc_url('https://smartprefetch/kb/');
        $link = "<a target='_blank' href='$url_kb'>" . __('Knowledge Base', 'smart-prefetch') . '</a>';
        array_push($links, $link);
        return $links;
    }
}
