// This script handles the pagination and sorting of the popular navigation tbody
const makePaginatedTable = function () {
    const table = document.getElementById('popular-navigation-table');
    if (!table) {
        console.warn('Table with ID "popular-navigation-table" not found.');
        return;
    }
    const tbody = table.getElementsByTagName('tbody')[0];
    const rows = Array.from(tbody.rows);
    // Sort rows by Popularity (descending)
    rows.sort((a, b) => {
        const aVal = parseFloat(a.cells[2].getAttribute('data-popularity')) || 0;
        const bVal = parseFloat(b.cells[2].getAttribute('data-popularity')) || 0;
        return bVal - aVal;
    });

    // Pagination
    const rowsPerPage = 10;
    let currentPage = 1;
    const totalPages = Math.ceil(rows.length / rowsPerPage);
    const paginationControls = document.getElementById('pagination-controls');

    function renderTable() {
        // Clear tbody
        tbody.innerHTML = '';
        // Add rows for current page
        const start = (currentPage - 1) * rowsPerPage;
        const end = start + rowsPerPage;
        rows.slice(start, end).forEach(row => tbody.appendChild(row));
    }

    function renderPagination() {
        paginationControls.innerHTML = '';
        if (totalPages <= 1) return;
        for (let i = 1; i <= totalPages; i++) {
            const btn = document.createElement('button');
            btn.textContent = i;
            btn.className = 'button' + (i === currentPage ? ' button-primary' : '');
            btn.style.marginRight = '4px';
            btn.onclick = function () {
                currentPage = i;
                renderTable();
                renderPagination();
            };
            paginationControls.appendChild(btn);
        }
    }

    renderTable();
    renderPagination();
};


const docReady = (/p/).test(document?.readyState);
if (docReady) {
    makePaginatedTable();
} else {
    window.addEventListener('load', makePaginatedTable);
}