<?php
/**
 * Plugin uninstall script for Smart Order Notifier
 * Cleans up options, transients, user meta, roles, and scheduled tasks.
 * Includes an optional "preserve data on uninstall" setting.
 */

defined('WP_UNINSTALL_PLUGIN') || exit;

/**
 * Cleanup function
 */
function smarorno_cleanup() {
    global $wpdb;

    $option_name = 'smarorno_settings';

    // Get plugin settings before deletion
    $settings = get_option($option_name);

    // If user has enabled "preserve data", exit cleanup
    if (!empty($settings['preserve_data'])) {
        return;
    }

    // Delete plugin options
    delete_option($option_name);

    // Delete transients related to plugin
    $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_smarorno_%'");
    $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_site_transient_smarorno_%'");

    // Remove user meta (if used)
    $users = get_users();
    foreach ($users as $user) {
        delete_user_meta($user->ID, 'smartorder_token'); // Adjust if custom meta exists
    }

    // Remove any custom roles/capabilities
    remove_role('smartorder_admin'); // Remove only if added by plugin
    if ($role = get_role('administrator')) {
        $role->remove_cap('manage_smartorder'); // Remove if added by plugin
    }

    // Clear scheduled cron events
    wp_clear_scheduled_hook('smartorder_cron_hook'); // Replace with your cron hook if used

    // Drop custom database tables (uncomment if applicable)
    // $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}smartorder_logs");
}

/**
 * Multisite-aware uninstall logic
 */
if (is_multisite()) {
    $site_ids = get_sites(['fields' => 'ids']);
    foreach ($site_ids as $site_id) {
        switch_to_blog($site_id);
        smarorno_cleanup();
        restore_current_blog();
    }
} else {
    smarorno_cleanup();
}
