<?php
// customer-notifier.php
if (!defined('ABSPATH')) exit;

class SmartOrderNotifier_Customer_Notifier {
    private $options;

    public function __construct($options) {
        $this->options = $options;
    }

    public function send_alert($order_id, $status_note) {
        if (empty($this->options)) return;
        if (empty($this->options['enable_customer'])) return;

        $order = wc_get_order($order_id);
        if (!$order) return;

        $phone = $order->get_billing_phone();
        if (!$phone) return;

        $accessToken = trim($this->options['access_token'] ?? '');
        $phoneNumberId = trim($this->options['phone_number_id'] ?? '');
        $templateName = trim($this->options['customer_template_name'] ?? '');
        $templateLanguage = trim($this->options['customer_template_language'] ?? 'en_US');

        if (!$accessToken || !$phoneNumberId || !$templateName) return;

        $item_count = $order->get_item_count();
        $url = "https://graph.facebook.com/v18.0/{$phoneNumberId}/messages";

        $payload = [
            'messaging_product' => 'whatsapp',
            'to' => $phone,
            'type' => 'template',
            'template' => [
                'name' => $templateName,
                'language' => ['code' => $templateLanguage],
                'components' => [
                    [
                        'type' => 'body',
                        'parameters' => [
                            ['type' => 'text', 'text' => (string)$order_id],
                            ['type' => 'text', 'text' => (string)$item_count],
                            ['type' => 'text', 'text' => $status_note],
                        ],
                    ],
                ],
            ],
        ];

        $args = [
            'headers' => [
                'Authorization' => 'Bearer ' . $accessToken,
                'Content-Type' => 'application/json',
            ],
            'body' => wp_json_encode($payload),
            'timeout' => 60,
        ];

        $response = wp_remote_post($url, $args);

        if (defined('WP_DEBUG') && WP_DEBUG && is_wp_error($response)) {
            error_log('[Smart Order Notifier] Customer Error: ' . $response->get_error_message());
        }
    }
}
