<?php
// admin-notifier.php
if (!defined('ABSPATH')) exit;

class SmartOrderNotifier_Admin_Notifier {
    private $options;

    public function __construct($options) {
        $this->options = $options;
    }

    public function send_alert($order_id, $status_note) {
        if (empty($this->options)) return;

        $order = wc_get_order($order_id);
        if (!$order) return;

        $accessToken = trim($this->options['access_token'] ?? '');
        $phoneNumberId = trim($this->options['phone_number_id'] ?? '');
        $templateName = trim($this->options['template_name'] ?? '');
        $templateLanguage = trim($this->options['template_language'] ?? 'en_US');
        $adminNumbers = explode(',', trim($this->options['admin_numbers'] ?? ''));
        $buttonUrlTemplate = trim($this->options['button_url'] ?? '');

        if (!$accessToken || !$phoneNumberId || !$templateName || empty($adminNumbers)) return;

        $url = "https://graph.facebook.com/v18.0/{$phoneNumberId}/messages";
        $orderUrl = str_replace('{order_id}', $order_id, $buttonUrlTemplate);

        foreach ($adminNumbers as $number) {
            $number = trim($number);
            if (!$number) continue;

            $payload = [
                'messaging_product' => 'whatsapp',
                'to' => $number,
                'type' => 'template',
                'template' => [
                    'name' => $templateName,
                    'language' => ['code' => $templateLanguage],
                    'components' => [
                        [
                            'type' => 'body',
                            'parameters' => [
                                ['type' => 'text', 'text' => 'Admin'],
                                ['type' => 'text', 'text' => (string)$order_id],
                                ['type' => 'text', 'text' => $status_note]
                            ]
                        ],
                        [
                            'type' => 'button',
                            'sub_type' => 'url',
                            'index' => 0,
                            'parameters' => [
                                ['type' => 'text', 'text' => esc_url_raw($orderUrl)]
                            ]
                        ]
                    ]
                ]
            ];

            $args = [
                'headers' => [
                    'Authorization' => 'Bearer ' . $accessToken,
                    'Content-Type' => 'application/json',
                ],
                'body' => wp_json_encode($payload),
                'timeout' => 60,
            ];

            $response = wp_remote_post($url, $args);

            if (defined('WP_DEBUG') && WP_DEBUG && is_wp_error($response)) {
                error_log('[Smart Order Notifier] Admin Error: ' . $response->get_error_message());
            }
        }
    }
}
