<?php
/**
 * Uninstall handler
 *
 * @package Smart_Instalments_Manager_For_Woocommerce
 */
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Security: Only admins can uninstall plugins
if ( ! current_user_can( 'manage_options' ) ) {
    return;
}

$wcsim_meta_keys = [
    '_wcsim_instalments_total',
    '_wcsim_instalments_completed',
    '_wcsim_instalment_number',
    '_wcsim_instalment_type',
    '_wcsim_parent_order_id'
];

global $wpdb;

foreach ( $wcsim_meta_keys as $wcsim_key ) {
    $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->postmeta} WHERE meta_key = %s",
            $wcsim_key
        )
    );
}