<?php
/**
 * Plugin Name: Smart Instalments Manager for Woocommerce
 * Description: Adds smart instalment billing to WooCommerce Subscriptions. Automatically tracks instalment totals, marks each renewal with instalment numbers, adds custom order statuses, and shows instalment progress inside WooCommerce admin.
 * Version: 1.0.1
 * Author: SmartWebAgency
 * Author URI: https://smartwebagency.co.uk/
 * Text Domain: smart-instalments-manager-for-woocommerce
 * Domain Path: /languages  
 * Requires at least: 6.7
 * Tested up to: 6.9
 * Requires PHP: 7.4
 * WC requires at least: 6.0
 * WC tested up to: 9.2
 * License: GPL-2.0+
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires Plugins: woocommerce
 *
 * @package Smart_Instalments_Manager_For_Woocommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'WCSIM_FILE', __FILE__ );
define( 'WCSIM_PATH', plugin_dir_path( WCSIM_FILE  ) );
define( 'WCSIM_URL', plugin_dir_url( WCSIM_FILE  ) );
define( 'WCSIM_VERSION', '1.0.0' );

function wcsim_missing_dependencies_notice() {
    echo '<div class="notice notice-error"><p><strong>' . esc_html__( 'Smart Instalments Manager For Woocommerce', 'smart-instalments-manager-for-woocommerce' ) . '</strong> ' . esc_html__( 'requires WooCommerce and WooCommerce Subscriptions plugins to function.', 'smart-instalments-manager-for-woocommerce' ) . '</p></div>';
}

function wcsim_mismatch_php_version_notice() {
    echo '<div class="notice notice-error"><p><strong>' . esc_html__( 'Smart Instalments Manager For Woocommerce', 'smart-instalments-manager-for-woocommerce' ) . '</strong> ' . esc_html__( 'requires PHP 7.4 or later.', 'smart-instalments-manager-for-woocommerce' ) . '</p></div>';
}

add_action( 'plugins_loaded', function () {
    if ( version_compare( PHP_VERSION, '7.4', '<' ) ) {
        add_action('admin_notices', 'wcsim_mismatch_php_version_notice' );
        return;
    }

    if ( ! class_exists( 'WooCommerce' ) || ! class_exists( 'WC_Subscriptions' ) ) {
        add_action( 'admin_notices', 'wcsim_missing_dependencies_notice' );
        return;
    }

    require_once WCSIM_PATH . 'includes/class-wcsim-plugin.php';

    WCSIM_Plugin::instance();
});

/**
 * Plugin activation.
 */
function wcsim_activate() {
    flush_rewrite_rules();
}
register_activation_hook( WCSIM_FILE, 'wcsim_activate');

/**
 * Plugin deactivation.
 */
function wcsim_deactivate() {
    flush_rewrite_rules();
}
register_deactivation_hook( WCSIM_FILE , 'wcsim_deactivate');