<?php
/**
 * Display Product Price and Instalment Info to Customers
 *
 * @package Smart_Instalments_Manager_For_Woocommerce
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if ( ! class_exists( 'WCSIM_Product_Price_Display' ) ) {

    class WCSIM_Product_Price_Display {

        /**
         * Constructor
         */
        public function __construct() {
            // Simple products
            add_action( 'woocommerce_single_product_summary', array( $this, 'wcsim_display_simple_price' ), 6 );
            add_action( 'woocommerce_single_product_summary', array( $this, 'wcsim_variable_price_placeholder' ), 6 );
            
            add_filter( 'woocommerce_available_variation', array( $this, 'wcsim_add_full_price_to_variations' ) );
            add_action( 'wp_enqueue_scripts', array( $this, 'wcsim_enqueue_assets' ) );
        }

        /**
         * Enqueue JS & CSS for frontend
         */
        public function wcsim_enqueue_assets() {
            if ( ! is_product() ) {
                return;
            }

            wp_enqueue_script( 'wcsim-variable-price', WCSIM_URL . 'assets/js/wcsim-variable-price.js', array( 'jquery' ), WCSIM_VERSION, true );
            wp_enqueue_style( 'wcsim-product-price-style', WCSIM_URL . 'assets/css/wcsim-product-price.css', array(), WCSIM_VERSION );
        }

        /**
         * Display full price for simple products if instalments exist
         */
        public function wcsim_display_simple_price() {
            global $product;

            if ( ! $product->is_type( 'subscription' ) ) {
                return;
            }

            $instalments_total          = $product->get_meta( '_wcsim_instalments_total' );
            $wcsim_product_full_price   = $product->get_meta( '_wcsim_product_full_price' );

            if ( ! empty( $wcsim_product_full_price ) ) {
                printf(
                    '<p class="wcsim-product-full-price" id="wcsim-variable-full-price">%s %s, payable in %d instalments</p>',
                    esc_html__( 'Full Price:', 'smart-instalments-manager-for-woocommerce' ),
                    wp_kses_post( wc_price( $wcsim_product_full_price ) ),
                    absint( $instalments_total )
                );
            };
        }

        /**
         * Placeholder div for variable product full price
         */
        public function wcsim_variable_price_placeholder() {
            global $product;
            if ( $product->is_type( 'variable-subscription' ) ) {
                echo '<p class="wcsim-product-full-price" id="wcsim-variable-full-price" style="display:none;"></p>';
            }
        }

        /**
         * Add full price HTML to variable product variations
         *
         * @param array $variation Variation data.
         * @return array
         */
        public function wcsim_add_full_price_to_variations( $variation ) {
            $instalments_total          = get_post_meta( $variation['variation_id'], '_wcsim_instalments_total', true );
            $wcsim_product_full_price   = get_post_meta( $variation['variation_id'], '_wcsim_product_full_price', true );

            if ( ! empty( $wcsim_product_full_price ) ) {
                $variation['wcsim_full_price_html'] = 'Full Price: ' . wc_price( $wcsim_product_full_price ) . ', payable in ' . absint( $instalments_total ) . ' instalments';
            }

            return $variation;
        }
    }
}
