<?php
/**
 * Main Plugin Loader Class
 *
 * @package Smart_Instalments_Manager_For_Woocommerce
 */
if ( ! defined('ABSPATH') ) {
    exit;
}

if ( ! class_exists( 'WCSIM_Plugin' ) ) {
    class WCSIM_Plugin {
        private static $instance = null;

        /**
         * Get instance (singleton)
         *
         * @return WCSIM_Plugin
         */
        public static function instance() {
            if (self::$instance === null) self::$instance = new self();
            return self::$instance;
        }

        /**
         * Constructor
         */
        private function __construct() {
            $this->load_dependencies();
            $this->load_components();
        }

        /**
         * Load required PHP files
         */
        private function load_dependencies() {
            require_once WCSIM_PATH . 'includes/class-wcsim-order-status.php';
            require_once WCSIM_PATH . 'includes/class-wcsim-instalments.php';
            require_once WCSIM_PATH . 'includes/class-wcsim-admin-columns.php';
            require_once WCSIM_PATH . 'includes/class-wcsim-product-meta.php';
            require_once WCSIM_PATH . 'includes/class-wcsim-product-price-display.php';
        }

        /**
         * Initialize plugin components
         */
        private function load_components() {
            new WCSIM_Order_Status();
            new WCSIM_Instalments();
            new WCSIM_Admin_Columns();
            new WCSIM_Product_Meta();
            new WCSIM_Product_Price_Display();
        }
    }
}