<?php
/**
 * Handles custom WooCommerce order status.
 *
 * @package Smart_Instalments_Manager_For_Woocommerce
 */

if ( ! defined('ABSPATH') ) {
    exit;
}

if ( ! class_exists( 'WCSIM_Order_Status' ) ) {
    class WCSIM_Order_Status {
        private $logger;
        
        /**
         * Constructor
         */
        public function __construct() {
            $this->logger = wc_get_logger();
            
            add_action( 'init', array( $this, 'wcsim_register_order_status' ) );
            add_filter( 'wc_order_statuses', array( $this, 'wcsim_add_order_status' ) );
        }

        /**
         * Register custom WooCommerce order status.
         */
        public function wcsim_register_order_status() {
            $wcsim_order_status_slug        = 'wc-balance-payable';
            $wcsim_order_status_label       = esc_html( apply_filters( 'wcsim_custom_order_status_label', 'Balance Payable' ) );

            register_post_status( $wcsim_order_status_slug, array(
                'label'                     => $wcsim_order_status_label,
                'public'                    => true,
                'exclude_from_search'       => false,
                'show_in_admin_all_list'    => true,
                'show_in_admin_status_list' => true,
                'label_count'               => 
                /* translators: 1: Order status label, 2: Number of orders */
                _n_noop( 
                    '%1$s (%2$s)', 
                    '%1$s (%2$s)', 
                    'smart-instalments-manager-for-woocommerce' 
                ),
            ));
        }

        /**
         * Add the custom order status to WooCommerce order status list.
         * 
         * @param array $order_statuses Order status list.
         * @return array
         */
        public function wcsim_add_order_status( $order_statuses ) {
            $wcsim_order_status_slug        = 'wc-balance-payable';
            $wcsim_order_status_label       = esc_html( apply_filters( 'wcsim_custom_order_status_label', 'Balance Payable' ) );
            
            $new                            = array();

            foreach ( $order_statuses as $key => $label ) {
                $new[ $key ] = $label;

                if ( 'wc-processing' === $key ) {
                    $new[$wcsim_order_status_slug] = $wcsim_order_status_label;
                }
            }

            if ( ! isset( $new[$wcsim_order_status_slug] ) ) {
                $new[$wcsim_order_status_slug] = $wcsim_order_status_label;
            }

            return $new;
        }
    }
}