<?php
/**
 * Handle Custom "Order Info" column for WooCommerce Orders.
 *
 * @package WC_Smart_Instalments_Manager
 */

if (!defined('ABSPATH')) {
    exit;
}

if ( ! class_exists( 'WCSIM_Admin_Columns' ) ) {
    class WCSIM_Admin_Columns {
        private $logger;

        /**
         * Constructor
         */
        public function __construct() {
            $this->logger = wc_get_logger();

            add_filter( 'manage_edit-shop_order_columns', array( $this, 'wcsim_add_column' ) );
            add_filter( 'manage_woocommerce_page_wc-orders_columns', array( $this, 'wcsim_add_column' ) );

            add_action( 'manage_shop_order_posts_custom_column', array( $this, 'wcsim_legacy_render_column' ), 20, 2 );
            add_action( 'manage_woocommerce_page_wc-orders_custom_column', array( $this, 'wcsim_hpos_render_column' ), 20, 2);
        }

        /**
         * Add custom instalment column.
         *
         * @param array $columns Existing columns.
         * @return array
         */
        public function wcsim_add_column( $columns ) {
            $new = array();
            foreach ( $columns as $key => $label ) {
                $new[ $key ] = $label;

                if ( 'order_total' === $key ) {
                    $new['instalment'] = esc_html__( 'Order Info', 'smart-instalments-manager-for-woocommerce' );
                }
            }
            return $new;
        }

        public function wcsim_legacy_render_column( $column_name, $post_id ) {
            if ( 'instalment' !== $column_name ) {
                return;
            }

            $order = wc_get_order( $post_id );
            $this->wcsim_render_content( $order );
        }

        /**
         * Render instalment column data.
         *
         * @param string    $column_name
         * @param WC_Order  $order
         */
        public function wcsim_hpos_render_column( $column_name, $order ) {
            if ( 'instalment' !== $column_name ) {
                return;
            }

            $order = wc_get_order( $order->get_id() );
            $this->wcsim_render_content( $order );
        }

            

        private function wcsim_render_content( $order ){
            if ( ! $order ) {
                echo esc_html__( '—', 'smart-instalments-manager-for-woocommerce' );
                return;
            }

            $instalment_number = $order->get_meta( '_wcsim_instalment_number', true );
            $instalment_type   = $order->get_meta( '_wcsim_instalment_type', true );

            if ( ! $instalment_type ) {
                echo esc_html__( '—', 'smart-instalments-manager-for-woocommerce' );
                return;
            }

            if ( intval( $instalment_number ) === 0 ) {
                echo '<b>' . esc_html__( 'Relationship:', 'smart-instalments-manager-for-woocommerce' ) . '</b> ' . esc_html__( 'Parent Order', 'smart-instalments-manager-for-woocommerce' );
                return;
            }

            $label_type     = ( $instalment_type === 'parent' ) ? __( 'Parent Order', 'smart-instalments-manager-for-woocommerce' ) : __( 'Instalment', 'smart-instalments-manager-for-woocommerce' );
            $ordinal        = self::wcsim_ordinal_suffix( intval( $instalment_number ) );
            printf(
                '<b>%s</b> %s <br><b>%s</b> %s',
                esc_html__( 'Relationship:', 'smart-instalments-manager-for-woocommerce' ),
                esc_html( $label_type ),
                esc_html__( 'Instalment:', 'smart-instalments-manager-for-woocommerce' ),
                esc_html( $ordinal )
            );
        }

        /**
         * Convert number to ordinal suffix (e.g., 1st, 2nd).
         *
         * @param int $num
         * @return string
         */
        public static function wcsim_ordinal_suffix( $num ) {
            $num = intval( $num );
            if ( $num <= 0 ) {
                return '';
            }

            $tens = $num % 100;
            
            if ( $tens >= 11 && $tens <= 13 ) {
                return $num . 'th';
            }

            $suffix = [ 'th','st','nd','rd','th','th','th','th','th','th' ];

            return $num . $suffix[ $num % 10 ];
        }
    }
}