(function () {
    const { registerPlugin } = wp.plugins;
    const { PluginMoreMenuItem } = wp.editPost;
    const { select } = wp.data;
    const { createElement: el } = wp.element;
    const { __ } = wp.i18n;

    const handleClick = () => {
        const postId = select('core/editor').getCurrentPostId();
        if (!postId) return;
        const url = `${sdpData.adminUrl}?action=sdp_duplicate_post_as_draft&post=${postId}&sdp_nonce=${sdpData.nonce}`;
        window.location = url;
    };

    const DuplicateMoreMenuItem = () =>
        el(
            PluginMoreMenuItem,
            { onClick: handleClick, role: 'menuitem' },
            sdpData.labels.menu || __('Duplicate this item', 'smart-duplicate-post-page')
        );

    registerPlugin('sdp-duplicate-more-menu', { render: DuplicateMoreMenuItem });
})();
