<?php
/**
 * Template for the download countdown page
 */

// Prevent direct access to this file
if (!defined('ABSPATH')) {
    exit;
}

// Ensure URL is set and valid
if (!isset($url) || !smartdr_validate_redirect_url($url)) {
    return;
}

// Get countdown time and display settings from options
$countdown_time = absint(get_option('smartdr_countdown_time', 10));
$show_manual_link = get_option('smartdr_show_manual_link', true);
$show_title = get_option('smartdr_show_title', true);
$redirect_delay = absint(get_option('smartdr_redirect_delay', 3));
$custom_heading_original = get_option('smartdr_custom_heading', esc_html__('Preparing Your Download', 'smart-download-redirector'));
$custom_heading = smartdr_get_wpml_string('Custom Heading', $custom_heading_original);

// Get manual link text
$manual_link_text_original = get_option('smartdr_manual_link_text', esc_html__('Click here if not redirected automatically', 'smart-download-redirector'));
$manual_link_text = smartdr_get_wpml_string('Manual Link Text', $manual_link_text_original);

// Get layout style setting
$layout_style = get_option('smartdr_layout_style', 'standard');
?>

<div class="smartdr-content smartdr-layout-<?php echo esc_attr($layout_style); ?>">
    <?php if ($layout_style === 'compact'): ?>
        <!-- Compact Layout (Horizontal) -->
        <div class="smartdr-compact-container">
            <div class="smartdr-text-section">
                <?php if ($show_title): ?>
                <h2 class="smartdr-heading"><?php echo esc_html($custom_heading); ?></h2>
                <?php endif; ?>
                
                <div class="smartdr-manual-redirect" style="display: none;">
                    <a href="<?php echo esc_url($url); ?>" class="smartdr-manual-link">
                        <?php echo esc_html($manual_link_text); ?>
                    </a>
                </div>
            </div>
            
            <div class="smartdr-countdown-section">
                <div class="smartdr-countdown">
                    <svg class="smartdr-progress-ring" width="120" height="120">
                        <circle class="smartdr-progress-ring-circle" stroke-width="4" fill="transparent" r="52" cx="60" cy="60"/>
                    </svg>
                    <div id="smartdr-countdown-number"><?php echo esc_html($countdown_time); ?></div>
                </div>
            </div>
        </div>
    <?php elseif ($layout_style === 'progressbar'): ?>
        <!-- Progressbar Layout (Vertical with horizontal progress bar) -->
        <?php if ($show_title): ?>
        <h2 class="smartdr-heading"><?php echo esc_html($custom_heading); ?></h2>
        <?php endif; ?>
        
        <div class="smartdr-progress-container">
            <div class="smartdr-progress-text">
                <span id="smartdr-countdown-text"><?php echo esc_html($countdown_time); ?> <?php esc_html_e('seconds remaining', 'smart-download-redirector'); ?></span>
            </div>
            <div class="smartdr-progress-bar-wrapper">
                <div class="smartdr-progress-bar" id="smartdr-progress-bar"></div>
            </div>
        </div>

        <div class="smartdr-manual-redirect" style="display: none;">
            <a href="<?php echo esc_url($url); ?>" class="smartdr-manual-link">
                <?php echo esc_html($manual_link_text); ?>
            </a>
        </div>
    <?php else: ?>
        <!-- Standard Layout (Vertical) -->
        <?php if ($show_title): ?>
        <h2 class="smartdr-heading"><?php echo esc_html($custom_heading); ?></h2>
        <?php endif; ?>
        
        <div class="smartdr-countdown">
            <svg class="smartdr-progress-ring" width="120" height="120">
                <circle class="smartdr-progress-ring-circle" stroke-width="4" fill="transparent" r="52" cx="60" cy="60"/>
            </svg>
            <div id="smartdr-countdown-number"><?php echo esc_html($countdown_time); ?></div>
        </div>

        <div class="smartdr-manual-redirect" style="display: none;">
            <a href="<?php echo esc_url($url); ?>" class="smartdr-manual-link">
                <?php echo esc_html($manual_link_text); ?>
            </a>
        </div>
    <?php endif; ?>
</div>

<?php
// CSS Custom Properties are now handled in the main plugin file
// to ensure proper timing and availability
?>

 